/*
 *
 * hiatus - 64k by calodox
 *
 * 3dfct.h - 3d functions from 3d.c
 *
 * dake
 *
 */

 #ifndef _3DFCT_H_
 #define _3DFCT_H_

  #include <main/main.h>

  #define  myalloc       halloc

  extern float MAX_PYRAMIDE_RENDERING; 

  void H3D_allocate_obj(Object_Data *o, int nbfaces, int nbvtx);
  void H3D_rotate_translate_obj(Object_Data *o, Matrix m, Vect *t);
  void H3D_test_dots_obj(Object_Data *o, uchar *surface);
  void H3D_show_obj(Object_Data *o, uchar *surface,
                    uchar rendering, uchar *texture, float fov);

  void H3D_intersection(TRIG_vtx *v0, TRIG_vtx *v1, TRIG_vtx *res);
  int H3D_zclipping (Object_Data *o, TRIG_face *face, float fov);    //retourne combien de

  void TEST3D();
  void TEST3D_loop(uchar *dest, int c);
  void TEST_triangle(uchar *dest);

  extern long H3D_zbuffer[512*257];                

  /*-----( RENDERING FUNCTIONS )-----*/

  #define        CCX     512
  #define        CCY     255
  #define        CLIPZ   0

  void H3D_clear_zbuffer(int limit);
  void H3D_PK_SIGNED_GRD(TRIG_face *t, uchar *dest, uchar rendering); //ID=1
  void H3D_AFF_SIGNED_GRD(TRIG_face *t, uchar *dest, uchar rendering); //ID=2
  void H3D_WIREFRAME_NOZBUFFER(TRIG_face *t, uchar *dest, long color);

  /*-----( SPHERE FUNCTIONS )-----*/

  extern        Object_Data SCN_Sphere256;
  extern        Object_Data SCN_Sphere1024;
  extern        Object_Data SCN_SphereLow;
  extern        Object_Data SCN_SphereHuge;


 void SCN_BlobbyBlah(uchar *bf,  int c);


  void          SPHERE3D_calc(Object_Data *SCN, float scale, uchar iter);
  long          SPHERE3D_create(int iterations);
  void          SPHERE3D_setup();


 #endif

