import java.lang.System;
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;

import FrameGrafico;
import Efecto;
import EfectoClear;
import Roto;

/** Prueba para la utilizacion del Interfaz Efecto y y un FrameGrafico en una
 * aplicacion de consola.
 * @author Unai Landa{@link unai_landa@eresmas.com}
 * @since 23/05/2000
 * @version .99a
 */
public class AplicacionGrafica    implements Runnable, WindowListener
{
  ////  Datos
  FrameGrafico  frameDestino;
  Efecto        efectoActivo;
  ////  Gestin
  boolean  bOk;
  boolean  bEstoyParado;
  int      iTicksPerSecond;
  boolean  bAvanzaTick;
  Thread   thrdEjecutor;
  int      iNumRuns;
  //// Frame Rate
  long	   lLastTime;
  int      iFrames;
  float    fFrameRate;

//////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////
  /**
  *  Constructor de la aplicacion
  */
  public AplicacionGrafica()
  {
    bOk = false;
  }

  /** Mtodo de inicializacin.
   * @param _iAncho      
   * @param _iAlto
   * @param _iTicksPerSecond Numero de veces por segundo que se ejecuta.
   */
  public void init(int _iAncho, int _iAlto, int _iTicksPerSecond)
  {
    end();

    iNumRuns        = 0;
    iTicksPerSecond = _iTicksPerSecond;
    frameDestino    = new FrameGrafico();
    thrdEjecutor    = new Thread(this);
    bEstoyParado    = false;
    bAvanzaTick     = false;
    frameDestino.init(_iAncho, _iAlto, BufferedImage.TYPE_USHORT_565_RGB);

    //////
    Roto etmp = new Roto();
//    EfectoClear etmp = new EfectoClear();
    etmp.init();
    efectoActivo = etmp;
    //////

    if(frameDestino!=null && thrdEjecutor!=null && frameDestino.isOk())
    {
      frameDestino.addWindowListener(this);
      bOk = true;
    }
  }

  /**
  *  Destruccin de la aplicacin.
  */
  public void end()
  {
    if(isOk())
    {
      thrdEjecutor = null;
      frameDestino.end();
      frameDestino = null;
      bOk          = false;
    }
  }

  /** Test de inicializacin.
   * @return
   */
  public boolean isOk()
  {
    return(bOk);
  }

  /**
  *
  */
  public void pause()
  {
    if(isOk())
    {
      bEstoyParado = true;
      bAvanzaTick  = false;
    }
  }

  /**
  *
  */
  public void play()
  {
    if(isOk())
    {
      bEstoyParado = false;
    }
  }

  /**
  *  Ejecuta la aplicacin y retorna cuando se cierra.
  */
  public void arranca()
  {
    if(isOk())
    {
      thrdEjecutor.start();
      thrdEjecutor.setPriority(Thread.MIN_PRIORITY);
      Thread.currentThread().setPriority(Thread.NORM_PRIORITY);
      go();
    }
    end();
  }
  

  /**
  *  Bucle de ejecucion, que "despierta" al ritmo del thread
  */
  public void go()
  {
    while(isOk() && thrdEjecutor!=null)
    {
      if(isOk() && !bEstoyParado && bAvanzaTick)
      {
        //  Ejecuta el efecto
        efectoActivo.run(frameDestino, iNumRuns++);
        frameDestino.update(frameDestino.getGraphics());
        bAvanzaTick = false;
        //  Calcula el frame rate y lo imprime.
        iFrames++;
        long  lCurentTime = System.currentTimeMillis();
        if(lCurentTime-lLastTime>=2500)
        {
          fFrameRate = iFrames / ((lCurentTime-lLastTime)/1000.0f);
          iFrames    = 0;
          lLastTime  = lCurentTime;
        }
        int l_iFRate = (int)(fFrameRate*100.0f);
        if(iFrames==0)
        {
          System.out.println("FPS:(" + (float)(l_iFRate/100.0f) + ")   " + iNumRuns);
          System.gc();
        }
      }
      else
      if(thrdEjecutor!=null)
      {
        try 
        { 
          Thread.sleep(1);
        } catch(InterruptedException _ex) { }
      }
    }
    System.out.println("final go()");
  }

//////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////
  /*
  *  Interfaz de Runnable
  *  Ejecucion del thread, nos marca el "ritmo".
  */
  public void run()
  {
    while(isOk() && thrdEjecutor!=null) 
    {
      try
      {
        while(isOk() && (bAvanzaTick || bEstoyParado)) 
          Thread.sleep(1000/iTicksPerSecond);
        if(isOk() && !bAvanzaTick && !bEstoyParado)
        {
          bAvanzaTick = true;
        }
      }
      catch(InterruptedException _ex) { }
    }

    System.out.println("saliendo del run()");
  }

//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
  /**
  *  Interfaz de WindowListener
  */
  public void windowClosing(WindowEvent e) 
  {
    System.out.println("in  - windowClosing");
    thrdEjecutor = null;
    System.out.println("out - windowClosing");
  }
  public void windowOpened       (WindowEvent e)  {  }
  public void windowClosed       (WindowEvent e)  {  }
  public void windowIconified    (WindowEvent e)  {  }
  public void windowDeiconified  (WindowEvent e)  {  }
  public void windowActivated    (WindowEvent e)  {  }
  public void windowDeactivated  (WindowEvent e)  {  }

//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
   /** Funcin Main de la aplicacin es la que se ejecuta al arrancar desde consola.
   * @param args Parametros pasados desde la consola.
   */
    public  static  void main(String[] args)
    {
      AplicacionGrafica  l_AppGrf = new AplicacionGrafica();
      System.out.println("antes   l_AppGrf.init - main()");
//      l_AppGrf.init(40, 40, 50);
      l_AppGrf.init(640, 480, 500);
//      l_AppGrf.init(512, 256, 200);
      System.out.println("despues l_AppGrf.init - main()");
      System.out.println("antes   l_AppGrf.arranca - main()");
      l_AppGrf.arranca();
      System.out.println("despues l_AppGrf.arranca - main()");
      System.exit(0);
    }
}




