#define MAXPALS 3

#include <stdio.h>
#include <conio.h>
#include <malloc.h>
#include <string.h>
#include <math.h>

signed int sin_table[256];

void plasma_init( void )
{
    int i;

    for( i=0; i<256; i++ )
        {
        sin_table[i] = 32.0*sin( 6.2831*i/256.0 );
        }
}


void doframe( unsigned char *buffer, float t )
{
    int             i, j;
    unsigned char   color;
    int             a, b, c, d;
    int             tt;

    tt = 10.0*t;

    for( j=0; j<256; j++ )
    for( i=0; i<256; i++ )
        {
        /*
        a = 3*i + 1*tt;
        b = 4*j - 1*tt;
        c = i+j + 2*tt;
        d = i-j - 2*tt;
        */

        a = 3*i + 1*tt;
        b = 4*j - 1*tt;
        //c = i+j + 2*tt;
        c = i-j + sin_table[tt&255];
        d = (i*i+j*j>>8) - 2*tt;


        a &= 255;
        b &= 255;
        c &= 255;
        d &= 255;


        color = 128 + sin_table[a] + sin_table[b] +
                      sin_table[c] + sin_table[d];

        buffer[256*j+i] = color;
        }
}


void hace_paleta( unsigned char *paleta, long cual )
{
    int     i;
    int     r, g, b;

    outp( 0x3c8, 0 );
    
    for( i=0; i<256; i++ )
        {
        switch( cual )
            {
            case 0:
                r = 32.0 + 31.0*cos( 0.0 + 6.2831*i/256.0 );
                g = 32.0 + 31.0*cos( 0.4 + 6.2831*i/256.0 );
                b = 32.0 + 31.0*cos( 0.7 + 6.2831*i/256.0 );
                break;
            case 1:
                r = 32.0 + 31.0*cos( 0.3 + 6.2831*i/256.0 );
                g = 32.0 + 31.0*cos( 0.2 + 6.2831*i/256.0 );
                b = 32.0 + 31.0*cos( 0.1 + 6.2831*i/256.0 );
                break;
            case 2:
                r = 32.0 + 31.0*cos( 0.4 + 6.2831*i/256.0 );
                g = 32.0 + 31.0*cos( 1.1 + 6.2831*i/256.0 );
                b = 32.0 + 31.0*cos( 1.0 + 6.2831*i/256.0 );
                break;
            case 3:
                r = 32.0 + 31.0*cos( 5.0 + 6.2831*i/256.0 );
                g = 32.0 + 31.0*cos( 5.2 + 6.2831*i/256.0 );
                b = 32.0 + 31.0*cos( 5.4 + 6.2831*i/256.0 );
                break;

            }

        paleta[3*i+0] = r;
        paleta[3*i+1] = g;
        paleta[3*i+2] = b;
        }

}

/*
void roto_doframe( unsigned char *buffer, unsigned char *tex, float a )
{
    int     i, j;
    float   co, si;
    float   x, y;
    float   x2, y2;
    unsigned char   xf, yf;
    unsigned short  off;

    co = cos(a);
    si = sin(a);

    for( j=0; j<200; j++ )
    for( i=0; i<320; i++ )
        {
        x = -1 + 2.0*i/320.0;
        y =  1 - 2.0*j/200.0;

        x2 = x*co - y*si;
        y2 = x*si + y*co;


        xf = 128.0 + 128.0*x2;
        yf = 128.0 + 128.0*y2;

        off = (yf<<8)|xf;

        *(buffer++) = tex[off];
        }
}
*/

void roto_doframe( unsigned char *buffer, unsigned char *tex, float a, float z,
                    int cenx, int ceny )
{
    int     i, j;
    long   co, si;
    long    x, y;
    long    x2, y2;
    unsigned char   xf, yf;
    unsigned short  off;

    co = 65536.0*cos(a)*z;
    si = 65536.0*sin(a)*z;

    for( j=0; j<200; j++ )
    for( i=0; i<320; i++ )
        {
        x = i-160;
        y = 100-j;

        xf = (x*co - y*si)>>16;
        yf = (x*si + y*co)>>16;

        xf += cenx;
        yf += ceny;

        off = (yf<<8)|xf;

        *(buffer++) = *(tex+off);
        }
}


void pone_paleta( unsigned char *paleta )
{
    int     i;
    int     r, g, b;

    outp( 0x3c8, 0 );
    for( i=0; i<0x300; i++ )
        outp( 0x3c9, *(paleta++) );
}

void inte_paleta( unsigned char *paleta3, unsigned char *paleta1,
                  unsigned char *paleta2, int alpha )
{
    int     i;

    for( i=0; i<0x300; i++ )
        {
        paleta3[i] = (paleta1[i]*alpha + paleta2[i]*(255-alpha) )>>8;
        }

}


void create_nextpalete( unsigned char *pal1, unsigned char *pal2 )
{
    static int  kk = 0;

    memcpy( pal2, pal1, 0x300 );
    hace_paleta( pal1, kk );
    kk++;

    if( kk>MAXPALS ) kk=0;
}


void motion_blur( unsigned char *buffer, unsigned char *old )
{
    int i;
    signed int c;

    i = 320*200;
    while( i-- )
        {
        c = *buffer + *old;

        c >>= 1;

        *(buffer++) = c;
        old++;
        }
}

void wait_retrace( void )
{
    //... como se haca?...
    // ah! que me lo chivan::

    while(  (inp(0x3da)&8) );
    while( !(inp(0x3da)&8) );

    // gracias elfhood!

}

void main( void )
{
    float         t;
    int             i;
    unsigned char *buffer;
    unsigned char *tex;
    unsigned char *old;

    unsigned char   paleta1[0x300];
    unsigned char   paleta2[0x300];
    unsigned char   paleta3[0x300];



    buffer = (unsigned char *)malloc( 320*200 );
    tex    = (unsigned char *)malloc( 256*256 );
    old    = (unsigned char *)malloc( 320*200 );

    if( !buffer )
        {
        printf( "No memo!\n" );
        return;
        }
    if( !tex )
        {
        printf( "No memo!\n" );
        return;
        }


    _asm
        {
        push    eax
        mov     eax, 13h
        int     10h
        pop     eax
        }

    create_nextpalete( paleta1, paleta2 );
    create_nextpalete( paleta1, paleta2 );

    plasma_init();

    memset( old, 0, 320*200 );

    t = 0;
    i = 0;
    while( !kbhit() )
        {

        inte_paleta( paleta3, paleta1, paleta2, i );
        pone_paleta( paleta3 );
        i++;
        if( i>255 )
            {
            create_nextpalete( paleta1, paleta2 );
            i = 0;
            }


        doframe( tex, 3*t );
        roto_doframe( buffer, tex,
                      2*6.28*sin(.1*t),             // ang
                      1+.6*sin(t),                  // zoom
                      0,0);

                      //80+80*sin(.4*t)*sin(1.2*t),   // cx
                      //50+50*sin(.3*t)*sin(1.7*t) ); // cy


        motion_blur( buffer, old );
        memcpy( old, buffer, 320*200 );


        wait_retrace();
        memcpy( (unsigned char*)0xa0000, buffer, 320*200 );

        t += .06;
        }

    getch();
    _asm
        {
        push    eax
        mov     eax, 03h
        int     10h
        pop     eax
        }


}
