#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int pixwidth=128;
int pixheight=64;
unsigned char origpixdata[1024*128][3];
unsigned char finalpixdata[64][128];

int rasthrestab[4] = { 64,192,128,255 }; 

#define RASTHRES2(x,y) rasthrestab[((x)^(y))&3]
#define RASTHRES(x,y) (rand()&255)
#define PIXEL(x,y) origpixdata[(y)*128+(x)+4]
#define PIXELD(x,y) origpixdata[(y)*128+(x)]

unsigned char vic2rgb[16][3] =
{
   0x00,0x00,0x00,
   0xf0,0xf0,0xf0,
   0xd0,0x00,0x20,
   0x00,0xf0,0xd0,
   0xf0,0x00,0xd0,
   0x00,0xf0,0x00,
   0x00,0x00,0xd0,
   0xe0,0xe0,0x00,

   0xe0,0x60,0x00,
   0xe0,0xc0,0xa0,
   0xf0,0xc0,0xc0,
   0xc0,0xf0,0xf0,
   0xf0,0xc0,0xf0,
   0xc0,0xf0,0xc0,
   0xc0,0xc0,0xf0,
   0xf0,0xf0,0xc0
};

void convpic_4col_tunfb_asm()
{
   int x0,y0,ch;
   int pixfreq[4]={0,0,0,0};
   for(ch=0;ch<128;ch++)
   {
      int x,y;

      if(ch<32) { y0=32+((ch&31)&3)*8; x0=64+((ch&31)>>2)*8; } else
      if(ch<64) { y0=32+((ch&31)&3)*8; x0=56-((ch&31)>>2)*8; } else
      if(ch<96) { y0= 0+((ch&31)&3)*8; x0=56-((ch&31)>>2)*8; } else
                { y0= 0+((ch&31)&3)*8; x0=64+((ch&31)>>2)*8; }

      printf("\n.byt ");

      for(y=0;y<8;y++)
      {
      int byte=0,x=0;
      for(x=0;x<8;x+=2)
      {
         int r=PIXEL((x0+x)%pixwidth,y0+y)[0],
             g=PIXEL((x0+x)%pixwidth,y0+y)[1],
             b=PIXEL((x0+x)%pixwidth,y0+y)[2];
         int pix;
         int brite=(3*r+6*g+b)/10;

         if(brite<0x80)pix=1;else
         if(brite<0xc0)pix=2;else
         if(brite<0xf0)pix=0;else
                       pix=3;

         pixfreq[pix]++;
         byte|=((64>>x)*pix);
      }
      printf("$%x",byte); if(y<7) printf(",");
      }
   }
   fprintf(stderr,"Amt of pixels: %d %d %d %d\n",
           pixfreq[0],pixfreq[1],pixfreq[2],pixfreq[3]);
}

void loadpic()
{
   int width,height;

   int x,y=0,c,xzoomfac,yzoomfac;
   char buf[160];

   fgets(buf,160,stdin); /* P6 */
//   fgets(buf,160,stdin); /* infoline */
   fscanf(stdin,"%d %d",&width,&height);
   fscanf(stdin,"%d",&x);

   xzoomfac=(pixwidth*256)/width;
   yzoomfac=(pixheight*256)/height;

   while(y<height)
   {
   fprintf(stderr,"loadpic: line %d/%d\n",y,height);

   for(x=0;x<width;x++)
   {
      int x1=(xzoomfac*x)>>8,
          y1=(yzoomfac*y)>>8;
/*
      PIXEL(x1,y1)[0] = PIXEL(x1+1,y1)[0] = fgetc(stdin);
      PIXEL(x1,y1)[1] = PIXEL(x1+1,y1)[1] = fgetc(stdin);
      PIXEL(x1,y1)[2] = PIXEL(x1+1,y1)[2] = fgetc(stdin);
*/
      PIXELD(x1,y1)[0] = PIXELD(x1+1,y1)[0] = 
      PIXELD(x1,y1)[1] = PIXELD(x1+1,y1)[1] =
      PIXELD(x1,y1)[2] = PIXELD(x1+1,y1)[2] = fgetc(stdin);
   }
   y++;
   }
}

unsigned char final0data[64][128];

void dumppic()
{
   int x,y;

   printf("P6\n%d %d\n255\n",pixwidth,pixheight);

   for(y=0;y<pixheight;y++){
   for(x=0;x<pixwidth;x++)
       printf("%c%c%c",
       (vic2rgb[final0data  [y][x]][0]+
        vic2rgb[finalpixdata[y][x]][0])>>1,

       (vic2rgb[final0data  [y][x]][1]+
        vic2rgb[finalpixdata[y][x]][1])>>1,

       (vic2rgb[final0data  [y][x]][2]+
        vic2rgb[finalpixdata[y][x]][2])>>1);
   }
}

int main(int argc,char**argv)
{
   if(argc>1)
   {
      pixheight=atoi(argv[1]);
   }

   loadpic();
   convpic_4col_tunfb_asm();

   return 0;
}

