#!/usr/bin/perl

@p=('##','  ');

$qd=500.7;
;$qa=196.4;
#for($qa=100;$qa<600;$qa+=0.1)
#{
#   print "-- rmul = $qa --\n";

# tunnel quarter for 16x16 pixels (8x4 chars)

$qa=64.0;$adif=0;



#for($qa=128;$qa<256;$qa+=.1)
#{
#print "qa=$qa\n";

sub calclut	# 16,16
{
      my ($ox,$oy)=@_;
      my $dith=($ox^$oy)&3;

      my $adith=(-0.10,+0.30,-0.10,+0.30)[$dith],
         $ddith=(+0.30,-0.10,+0.10,-0.30)[$dith],
         $qdith=(0.01,0.50,0.25,0.75)[$dith];

      my $y=($_[0]+0.5)*1.5*0.6;
      my $x=($_[1]+0.5)*1.0*0.8;

      $r = sqrt($x*$x+$y*$y);

      $darkness=($r-4)/2.4;

      if($darkness<0) { $darkness=0; }

      if($oy>=12 && $ox>=24) {
      $z=0;
      if($ox==31) { $z+=1.5; }
      if($oy==15) { $z+=1.5; }
      if($ox==30) { $z++; }
      if($oy==14) { $z++; }
      if($ox==29) { $z+=.5; }
      if($oy==13) { $z+=.5; }
      if($z>1)  { $darkness=0; }
      }

      if($darkness<.4) { $darkness=0; }

      if($darkness<$qdith) { $addo='$00'; } else {

      $r=($r*2)+.5;

      $d = int(($qd/$r)+$ddith)&15;

      $a = int((atan2($x,$y)/(2*3.1415926))*$qa+$adith);

#      print $p[($r^$a)&1];

       $hex = sprintf "%x%x",(($d&15)^15),(($a-$adif)&15);

       if($hex eq '00') { $addo='$01'; }
       elsif($hex eq 'ff') { $addo='$ef'; } 
       elsif($hex eq '0f') { $addo='$1f'; } 
       elsif($hex eq 'f0') { $addo='$f1'; } 
                      else { $addo="\$$hex";}
      }

   return $addo;
}

for($i=0;$i<16;$i++)
{
   print "\n; ";
   for($j=0;$j<32;$j++) { print &calclut($j,$i),","; }
}

print "\n\n";

#}

for($i=0;$i<8;$i++)
{
   $lut0.="\n.byt ";
   $lut1.="\n.byt ";

   for($j=0;$j<16;$j++)
   {
      $lut0 .= &calclut($i*4+0,$j).",".
               &calclut($i*4+1,$j).",";

      $lut1 .= &calclut($i*4+2,$j).",".
               &calclut($i*4+3,$j).","; 
   }
}

open F,'>tunneltab.inc';
print F "lookup0 $lut0\n\nlookup1 $lut1\n";
close F;

$txr2=<<EOD;
.!!!!!.xxx......
..!!!.xxx3x.....
.!!...xx33x.....
!!.....xxx..!!!!
!xxxxx....!!!!!!
xx33xxx..!!!!...
333xx!!!!!!.xxx.
33xxxx!!x!!xxx33
xxxx..!xxx!!xxxx
xx...!!xx!!!..xx
....!!!!!!......
!!....!!!!.xxx!!
!!!.!!!!..xx!!x!
..!!!!!..x!!!xx!
..!!!....xxxxx..
.!!!!......xx...
EOD

$txr=<<EOD;
33..!!!!!......3
3....!!!!.......
.....!!3!!......
....!!33!!...xx.
...!!3333!!!xxxx
...!!!33!!!!xxxx
x...!!!3!!!xxxxx
xx.xx!!!!xxxx..x
xxxxxxxxxxxxx...
3xxxxxxxxxxx...3
33xx.xx..xxx..33
333.......xxx333
333........xxxx3
33...!!!!...xx33
333!!!!3!!......
33..!!33!!......
EOD

# .x!3 1023
open F,'>tunneltxr.inc';
foreach(split("\n",$txr))
{
   tr/.x!3/0123/;
   print F ".byt ".join(',',split('',$_))."\n";
}
close F;

