#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
/*
global_settings {
 radiosity {
  count 100
  distance_maximum 0.1
  error_bound 0.3
 }
}
*/
camera {
 location <23, 2, 23>
 look_at <0, 0, 0>
}

//taivas

sky_sphere {
 pigment {
  gradient y
  turbulence 0.7
  color_map { 
   [0.0 color rgb <0.6,0.5,0.7>]
   [0.25 color rgb <0.5,0.4,0.6>] 
   [0.75 color rgb <0.3,0.2,0.4>] 
   [1.0 color rgb <0.1,0,0.1>]
  }
 }
}

//kuu

light_source {
 <-800, 200, -800>
 color rgb <0.25,0.2,0.2>
 media_attenuation on
 media_interaction on
 jitter
 looks_like {
  object {
   Sphere
   pigment { 
    bozo
    turbulence 1
    color_map { 
     [ 0 rgb <1,0.75,0.7> ]
     [ 1 rgb <1,0.6,0.5> ]
    }
   } 
   scale 60
   finish {
    ambient 1
   }
  }
 }
}

//"pehmennys"

light_source {
 <-802, 202, -798>
 color rgb <0.25,0.2,0.2> 
 media_attenuation on
 media_interaction on
 jitter
}

light_source {
 <-798, 202, -802>
 color rgb <0.25,0.2,0.2> 
 media_attenuation on
 media_interaction on
 jitter
}

light_source {
 <-802, 198, -798>
 color rgb <0.25,0.2,0.2> 
 media_attenuation on
 media_interaction on
 jitter
}

light_source {
 <-798, 198, -802>
 color rgb <0.25,0.2,0.2> 
 media_attenuation on
 media_interaction on
 jitter
}

//usva
/*
media {
 scattering {2, rgb<.7,.7,.7> extinction .5 }
 intervals 30
 density {
  marble
  scale <1,0,0>
  turbulence .5
  color_map{
   [0 Black]
   [1 White*2]
  }
 }
}
*/

fog {
 fog_type 2
 distance 5
 color rgbt <0.7, 0.6, 0.65, 0.2> 
 fog_offset 0.1
 fog_alt 0.45
 turbulence 2
}

//vesi

object {
 Plane_XZ
 pigment {
  color rgb <0.5, 0.5, 1>
 }
 hollow
 normal {
  marble 1 
  scale 5 
  turbulence 1
 }
 finish {
  specular 0.3
  roughness 0.01
  diffuse 0.1
  reflection 0.7
 }
}

//lautta

union { 
 object {
  Disk_X
  translate <1,0,0>
  scale <8,1,1>
 }
 object {
  Disk_X
  translate <1,0,2>
  scale <8,1,1>
 }
 object {
  Disk_X
  translate <1,0,4>
  scale <8,1,1>
 }
 object {
  Disk_X
  translate <1,0,6>
  scale <8,1,1>
 }
 object {
  Disk_X
  translate <1,0,8>
  scale <8,1,1>
 }
 
 object { //masto
  Disk_Y
  scale <0.2,5.5,0.2>
  translate <9,6,4> 
 }
 object {
  Disk_Z
  scale <0.1,0.1,4>
  translate <9,10,4> 
 }
 
 texture {
  pigment { 
   wood
   rotate <0,90,0>
   turbulence 0.5
   scale 0.1
   color_map { 
    [ 0 color Tan ]
    [ 0.2 color DarkTan ] 
    [ 0.7 color Brown ]
    [ 0.9 color DarkBrown ]
    [ 1 color VeryDarkBrown ]
   }
  }
  normal {
   wood 0.7
   scale 0.1
   turbulence 0.5
  }
  finish {
   specular 0.3
   roughness 0.3
   diffuse 0.1
  } 
 }
}

//purje

object {
 bicubic_patch { 
  type 1 flatness 0.01 u_steps 3 v_steps 3,
  <10, 2, 0>, <8.4, 2.5, 2>, <8.4, 2.5, 5>, <10, 2, 8>, //alareuna
  <8, 5, 0>, <7.5, 5, 2>, <7.5, 5, 5>, <8, 5, 8>,       
  <7.5, 8, 0>, <6.5, 8, 2>, <6.5, 8, 5>, <7.5, 8, 8>, 
  <9.1, 10, 0>, <9, 10, 2>, <9, 10, 5>, <9.1, 10, 8>    //ylreuna
 }
 texture {
  pigment {
   bozo
   turbulence 1
   color_map {
    [0 rgbf <1,1,0.8,0.05> ]
    [1 rgbf <0.9,0.9,0.4,0.1> ]
   }
  } 
 } 
 normal {
  waves 0.1
  scale 0.5
  turbulence 0.5
 }
 finish {
  specular 0.1
  roughness 0.1
  diffuse 0.5
 }
}

//kydet

polygon { //ala vasen
 5,
 <10,2,0>,<10,2.1,0.1>,
 <15,1.1,0.1>,<15,1,0>,
 <10,2,0>
 texture {
  pigment { color Tan }
 }
}

polygon { //ala oikea
 5,
 <10,2,8>,<10,2.1,7.9>,
 <15,1.1,7.9>,<15,1,8>,
 <10,2,8>
 texture {
  pigment { color Tan }
 }
}
  
polygon { //yl vasen
 5,
 <9,10,0>,<9,10.1,0.1>,
 <15,1.1,0.1>,<15,1,0>,
 <9,10,0>
 texture {
  pigment { color Tan }
 }
}

polygon { //yl oikea
 5,
 <9,10,8>,<9,10.1,7.9>,
 <15,1.1,7.9>,<15,1,8>,
 <9,10,8>
 texture {
  pigment { color Tan }
 }
}

//saari

height_field {
 gif              
 "saari.gif"    
 texture {
  pigment {
   marble
   scale 0.5
   turbulence 1
   color_map {
    [ 0 color rgb <0.1,0.4,0.1> ]
    [ 0.8 color DarkBrown ]
    [ 1 color Gray20 ]
   }
  }
 }
 smooth
 scale <100,10,100>
 translate <-200,-2,-100>
 normal {
  dents 0.5
  scale 1
  turbulence 3
 }
 finish {
  diffuse 0.3
 }   
}

//notski

light_source {
 <-116, 1.5, -18>
 color rgb <12,3.6,0>
 fade_distance 38
 fade_power 7
 jitter
 media_attenuation on
 media_interaction on
}

//lamppu 

#declare lampunpaikka = <0.5,1,8>;

//tuli

light_source {
 lampunpaikka + <0,0.1,0>
 color rgb <1.5,0.9,0>
 media_attenuation on
 media_interaction on
 jitter
 fade_distance 3
 fade_power 2
 looks_like {
  lathe {
   linear_spline
   3,
   <0.03,0>, <0.05,0.1>, <0,0.3>
   pigment { 
    marble
    turbulence 0.2
    scale 0.1
    color_map { 
     [0 color rgb <1,0.5,0> ]
     [1 color rgb <1,0.8,0> ]
    }
   }
   finish {
    ambient 1
   }
  }
 }
}

//lasi

lathe {
 cubic_spline
 7,
 <0,-0.3>, <0.3,0>, <0.4,0.3>, <0.4,0.5>, <0.25,0.8>, <0.2,1> ,<0.2,1.5>
 translate lampunpaikka
 hollow
 pigment { 
  color rgbf <1,1,1,0.8>
 }
 finish { 
  specular 0.5
  roughness 0.1
 }
}

//metalli osat

union {
 lathe { //yl osa
  linear_spline
  6,
  <0,1>, <0.25,1>, <0.25,1.1>, <0.2,1.15>, <0.2,1.25>, <0,1.25>
 }
 lathe { //ala osa
  linear_spline
  5,
  <0,-0.2>, <0.45,-0.2>, <0.45,-0.1>, <0.35,0.1>, <0,0.1>
 }
 translate lampunpaikka
 pigment {
  color Silver
 }
 finish {
  metallic
  specular 1
  roughness 0.1
  reflection 0.2
 }
}

//ij

//jalat

union {
 object { //vasen
  Disk_X
  translate <1,2.5,8>
  scale <1,0.5,0.5>
 }
 object {
  Sphere
  translate <0,2.5,8>
  scale 0.5
 }
 object {
  Disk_Y
  translate <0,0.2,8>
  scale <0.5,1,0.5>
 }
 object { //oikea
  Disk_X
  translate <1,2.5,10>
  scale <1,0.5,0.5>
 }
 object {
  Sphere
  translate <0,2.5,10>
  scale 0.5
 } 
 object {
  Disk_Y
  translate <0,0.2,10>
  scale <0.5,1,0.5>
 }
 pigment {
  color NavyBlue 
 }
 finish {
  diffuse 0.5
 }
 normal {
  dents 0.1
  scale 0.1
  turbulence 0.4
 }
}

//torso

union {
 intersection {
  object {
   Cube
   scale <0.5,1,1>
   rotate <0,0,-30>  
   translate <2.2,2.2,4.6>
  }
  object {
   Sphere
   scale 1.2
   translate <2,2.2,4.5>
  }
 }
 union { //kdet vasen
  object {
   Disk_Y
   scale <0.25,1,0.25>
   rotate <15,0,20>
   translate <2.9,1.6,3.5>
  }
  object {
   Disk_X
   scale <1,0.2,0.2>
   translate <2.3,0.9,3.3>
  }
 }
 union { //kdet oikea
  object {
   Disk_X
   scale <1,0.25,0.25>
   rotate <0,0,10>
   translate <1.5,2.4,5.5>
  }
  object {
   Disk_Y
   scale <0.2,1,0.2>
   rotate <-20,0,-10>
   translate <0.6,3,5.2>
  }
 }
 pigment {
  bozo
  scale 0.1
  turbulence 1
  color_map {
   [0 color rgb <1,1,0.5>]
   [1 color rgb <1,1,1>]
  } 
 }
 finish {
  diffuse 0.5
 }
 normal {
  dents 0.1
  scale 0.1
  turbulence 0.2
 }
 normal {
  bumps 0.3
  scale 0.8
  turbulence 0.5
 }
} 

//p

union {
 object {
  Disk_Y
  scale <0.25,0.4,0.25>
  translate <2.6,3.3,4.5>
 }
 object {
  Sphere
  scale <0.5,0.7,0.5>
  translate <2.6,4,4.5> 
 }
 pigment {
  color Tan 
 }
 finish {
  diffuse 0.5 
 }
}

//hattu

object {
 Cone_Y
 scale <1.5,0.5,1.5>
 rotate <10,0,-30>
 translate <2.7,4.5,4.5>
 hollow
 pigment {
  dents
  scale 0.05
  color_map {
   [0 color rgbf <1,0.8,0.7,0>]
   [1 color rgbf <1,0.8,0.7,0.8>]
  }  
 }
 normal {
  dents 1
  scale 0.05
 }
 finish {
  diffuse 0.5
 }
}

//kaukoputki

union {
 difference {
  object {
   Cone_X
   scale <1.8,0.15,0.15>
   translate <2,4,4.75>
   hollow
   pigment {
    color rgb <0.3,0.3,1>  
   }   
  }
  object {
   Cube
   scale 1
   translate <3,4,4.75>
   hollow
   pigment {
    color rgb <0.3,0.3,1>  
   }
  }
 }
 object {
  Disk_X
  scale <0.1,0.17,0.17>
  translate <0.2,4,4.75>
  hollow
  pigment {
  color rgb <1,1,0.3>  
  }
 }
 object {
  Disk_X
  scale <0.2,0.15,0.15>
  translate <1,4,4.75>
  hollow
  pigment {
  color rgb <1,1,0.3>  
  }
 }
 object {
  Disk_X
  scale <0.1,0.1,0.1>
  translate <1.9,4,4.75>
  hollow
  pigment {
  color rgb <1,1,0.3>  
  }
 }
 normal {
  bumps 0.1
  scale 0.01
  turbulence 0.3
 }
 finish {
  specular 1
  roughness 0.1
  metallic
 }
}


//lintu

#declare lintu_x =
 union {
  difference {
   object {
    Disk_X
    scale <3,1,1>
   }
   object { //etuosa leikkaus
    Cube
    scale 2
    rotate <0,0,-60>
    translate <2.75,-1.75,0>
   }
   object { //takaosa leikkaus
    Cube
    scale 2
    rotate <0,0,70>
    translate <-1.5,-1.75,0>
   }  
   object { //p leikkaus
    Cube
    scale 2
    rotate <0,-45,0>
    translate <-5,0,1>
   }  
   object {
    Cube
    scale 2
    rotate <0,45,0>
    translate <-5,0,-1>
   }  
  }
  object { //pyrst
   bicubic_patch { 
    type 1 flatness 0.01 u_steps 3 v_steps 3,
    <2.8, 0.7, -0.75>, <2.8, 1, -0.1>, <2.8, 1, 0.1>, <2.8, 0.7, 0.75>, //etuosa
    <3.5, 0.7, -1.2>, <4, 1, -0.5>, <4, 1, 0.5>, <3.5, 0.7, 1.2>,       
    <4, 0.7, -1.4>, <4.5, 1.1, -0.5>, <4.5, 1.1, 0.5>, <4, 0.7, 1.4>, 
    <4.5, 0.6, -1.6>, <5, 1, -0.6>, <5, 1, 0.6>, <4.5, 0.6, 1.6>    //takaosa
   }
  }
  object { //oikea siipi
   bicubic_patch { 
    type 1 flatness 0.01 u_steps 3 v_steps 3,
    <-1.5, 0.6, 0.5>, <0, 0.5, 2>, <2, 0.4, 3>, <3.5, -1, 4>, //etuosa (ruumis - krki)
    <-0.5, 0.7, 0.5>, <0.5, 0.6, 2>, <2, 0.4, 3>, <3.5, -1, 4>,
    <1, 0.8, 0.5>, <1.5, 0.9, 2>, <2.5, 0.5, 3>, <3.5, -1, 4>,
    <2, 0.7, 0.5>, <2.5, 0.9, 2>, <3, 0.5, 3>, <3.5, -1, 4> //takaosa
   }
  }
  object { //vasen siipi
   bicubic_patch { 
    type 1 flatness 0.01 u_steps 3 v_steps 3,
    <-1.5, 0.6, -0.5>, <0, 0.5, -2>, <2, 0.4, -3>, <3.5, -1, -4>, //etuosa (ruumis - krki)
    <-0.5, 0.7, -0.5>, <0.5, 0.6, -2>, <2, 0.4, -3>, <3.5, -1, -4>,
    <1, 0.8, -0.5>, <1.5, 0.9, -2>, <2.5, 0.5, -3>, <3.5, -1, -4>,
    <2, 0.7, -0.5>, <2.5, 0.9, -2>, <3, 0.5, -3>, <3.5, -1, -4> //takaosa
   }
  }
  texture {
   pigment {
    bozo
    turbulence 1
    scale 0.1
    color_map {
     [0 color <1,1,1>]
     [1 color <0.9,0.9,0.9>]
    }
   }
  }
  finish {
   diffuse 0.1
  }  
  normal {
   bumps 0.1
   turbulence 1
   scale 0.1   
  }
 }
 
//parvi

object {
 lintu_x
 scale 0.1
 rotate <3,20,0>
 translate <-108,6,-15>
}

object {
 lintu_x
 scale 0.1
 rotate <0,50,-10>
 translate <-110,6,-22>
}

object {
 lintu_x
 scale 0.1
 rotate <-18,-60,0>
 translate <-115,10,-12>
}

object {
 lintu_x
 scale 0.1
 rotate <0,45,12>
 translate <-99,7,-14>
}

object {
 lintu_x
 scale 0.1
 rotate <5,-30,0>
 translate <-100,8,-10>
}