// UtilityFunction.h: interface for the UtilityFunction class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_UTILITYFUNCTION_H__B569B7A1_7E9C_11D5_AD0F_606E57C10000__INCLUDED_)
#define AFX_UTILITYFUNCTION_H__B569B7A1_7E9C_11D5_AD0F_606E57C10000__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define RAND()			((FLOAT)rand()/(FLOAT)RAND_MAX)
#define SIGNEDRAND()	(1.0f - 2.0f*((FLOAT)rand()/(FLOAT)RAND_MAX))

typedef struct _FLOATKEY
{
	FLOAT					t;

	FLOAT					val;

	FLOAT					t0, t1;

	_FLOATKEY();
	_FLOATKEY( FLOAT time, FLOAT value );

} FLOATKEY, *PFLOATKEY;

typedef struct _VECTORKEY
{
	FLOAT					t;

	he3d_CVector			val;

	he3d_CVector			t0, t1;

	_VECTORKEY();
	_VECTORKEY( FLOAT time, he3d_CVector& v );
	_VECTORKEY( FLOAT time, FLOAT x, FLOAT y, FLOAT z );

} VECTORKEY, *PVECTORKEY;

DWORD FLT2DWORD( FLOAT f );
BOOL CreateRing( PDIRECT3DDEVICE8 pDevice, FLOAT fr, FLOAT fR, DWORD dwSegCount, PDIRECT3DVERTEXBUFFER8* ppvb );
BOOL CreateBox( PDIRECT3DDEVICE8 pDevice, FLOAT fA, PDIRECT3DVERTEXBUFFER8* ppvb );

VOID InitFloatSpline( DWORD dwKeysCount, PFLOATKEY pfkKeys );
FLOAT GetFloatSplineValue( FLOAT fT, DWORD dwKeysCount, PFLOATKEY pfkKeys );

VOID InitVectorSpline( DWORD dwKeysCount, PVECTORKEY pvkKeys );
he3d_CVector GetVectorSplineValue( FLOAT fT, DWORD dwKeysCount, PVECTORKEY pvkKeys );

he3d_CVector Polar2Cartesian3d( FLOAT fRadius, FLOAT fAlpha, FLOAT fBeta );

#endif // !defined(AFX_UTILITYFUNCTION_H__B569B7A1_7E9C_11D5_AD0F_606E57C10000__INCLUDED_)
