// Timer.cpp: implementation of the CTimer class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Timer.h"
#include <mmsystem.h>

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

VOID CPerformanceTimer::Init()
{
	if( !QueryPerformanceFrequency( (LARGE_INTEGER*)&m_liResolution ) )
		throw CSystemException( DEMO_EXCEPTION_TIMER );

	m_bInitialized = TRUE;
}

VOID CPerformanceTimer::Start()
{
	if( !m_bInitialized )
		Init();

	QueryPerformanceCounter( (LARGE_INTEGER*)&m_liStartTime );
	m_liLastScanTime = m_liStartTime;
}

VOID CPerformanceTimer::Pause()
{
	if( !m_bInitialized )
		throw CSystemException( DEMO_EXCEPTION_TIMER );

	QueryPerformanceCounter( (LARGE_INTEGER*)&m_liPauseTime );
	m_bPause = TRUE;
}

VOID CPerformanceTimer::Resume()
{
	if( !m_bInitialized )
		throw CSystemException( DEMO_EXCEPTION_TIMER );

	QueryPerformanceCounter( (LARGE_INTEGER*)&m_liLastScanTime );
	m_liStartTime += ( m_liLastScanTime - m_liPauseTime );
	m_bPause = FALSE;
}

FLOAT CPerformanceTimer::GetCurrentSec()
{
	if( m_bPause )
		return (FLOAT)( (DOUBLE)(m_liPauseTime - m_liStartTime)/(DOUBLE)m_liResolution );

	LONGLONG				liCurrentTime;

	QueryPerformanceCounter( (LARGE_INTEGER*)&liCurrentTime );

	return (FLOAT)( (DOUBLE)(liCurrentTime - m_liStartTime)/(DOUBLE)m_liResolution );
}

DWORD CPerformanceTimer::GetCurrentTime()
{
	if( m_bPause )
		return (DWORD)( (DOUBLE)(m_liPauseTime - m_liStartTime)*1000.0/(DOUBLE)m_liResolution );

	LONGLONG				liCurrentTime;

	QueryPerformanceCounter( (LARGE_INTEGER*)&liCurrentTime );

	return (DWORD)( (DOUBLE)(liCurrentTime - m_liStartTime)*1000.0/(DOUBLE)m_liResolution );
}

FLOAT CPerformanceTimer::GetElapsedSec()
{
	if( m_bPause )
		return 0.0f;

	LONGLONG				liCurrentTime;
	FLOAT					fElapsed;

	QueryPerformanceCounter( (LARGE_INTEGER*)&liCurrentTime );
	fElapsed = (FLOAT)( (DOUBLE)(liCurrentTime - m_liLastScanTime)/(DOUBLE)m_liResolution );
	m_liLastScanTime = liCurrentTime;

	return fElapsed;
}

DWORD CPerformanceTimer::GetElapsedTime()
{
	if( m_bPause )
		return 0;

	LONGLONG				liCurrentTime;
	DWORD					dwElapsed;

	QueryPerformanceCounter( (LARGE_INTEGER*)&liCurrentTime );
	dwElapsed = (DWORD)( (DOUBLE)(liCurrentTime - m_liLastScanTime)*1000.0/(DOUBLE)m_liResolution );
	m_liLastScanTime = liCurrentTime;

	return dwElapsed;
}

FLOAT CPerformanceTimer::GetAbsoluteSec()
{
	LONGLONG				liCurrentTime;	

	QueryPerformanceCounter( (LARGE_INTEGER*)&liCurrentTime );

	return (FLOAT)((DOUBLE)liCurrentTime/(DOUBLE)m_liResolution);
}

DWORD CPerformanceTimer::GetAbsoluteTime()
{
	LONGLONG				liCurrentTime;	

	QueryPerformanceCounter( (LARGE_INTEGER*)&liCurrentTime );

	return (DWORD)((DOUBLE)liCurrentTime*1000.0/(DOUBLE)m_liResolution);
}

VOID CMultimediaTimer::Init()
{
	m_bInitialized = TRUE;
}

VOID CMultimediaTimer::Start()
{
	m_bInitialized = TRUE;

	m_dwStartTime = timeGetTime();
	m_dwLastScanTime = m_dwStartTime;
}

VOID CMultimediaTimer::Pause()
{
	m_dwPauseTime = timeGetTime();

	m_bPause = TRUE;
}

VOID CMultimediaTimer::Resume()
{	
	m_dwLastScanTime = timeGetTime();
	m_dwStartTime += (m_dwLastScanTime - m_dwPauseTime);

	m_bPause = FALSE;
}

FLOAT CMultimediaTimer::GetCurrentSec()
{
	return (FLOAT)(timeGetTime() - m_dwStartTime)/1000.0f;
}

DWORD CMultimediaTimer::GetCurrentTime()
{
	return timeGetTime() - m_dwStartTime;
}

FLOAT CMultimediaTimer::GetElapsedSec()
{
	DWORD			dwCurrentTime = timeGetTime();
	FLOAT			fElapsed = (FLOAT)(dwCurrentTime-m_dwLastScanTime)/1000.0f;

	m_dwLastScanTime = dwCurrentTime;

	return fElapsed;
}

DWORD CMultimediaTimer::GetElapsedTime()
{
	DWORD			dwCurrentTime = timeGetTime();
	DWORD			dwElapsed = dwCurrentTime-m_dwLastScanTime;

	m_dwLastScanTime = dwCurrentTime;

	return dwElapsed;
}

FLOAT CMultimediaTimer::GetAbsoluteSec()
{
	return (FLOAT)timeGetTime()/1000.0f;
}

DWORD CMultimediaTimer::GetAbsoluteTime()
{
	return timeGetTime();
}


