// SolarSystemCreation.cpp: implementation of the CSolarSystemCreation class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "SolarSystemCreation.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CSolarSystemCreation::CSolarSystemCreation( PDIRECT3DDEVICE8 pDevice ) : CEfx( pDevice )
{
	for( DWORD i = 0 ; i < 10 ; i++ )
		m_pvbRing[i] = NULL;

	if( !CreateRing( m_pDevice, 1.0f, 2.0f, 100, &m_pvbRing[0] ) )
		throw CSystemException( DEMO_EXCEPTION_D3DERROR, "unable to create ring[0] vertex buffer" );

	if( !CreateRing( m_pDevice, 2.05f, 3.5f, 100, &m_pvbRing[1] ) )
		throw CSystemException( DEMO_EXCEPTION_D3DERROR, "unable to create ring[1] vertex buffer" );

	if( !CreateRing( m_pDevice, 3.65f, 6.0f, 100, &m_pvbRing[2] ) )
		throw CSystemException( DEMO_EXCEPTION_D3DERROR, "unable to create ring[2] vertex buffer" );

	if( !CreateRing( m_pDevice, 6.15f, 8.5f, 100, &m_pvbRing[3] ) )
		throw CSystemException( DEMO_EXCEPTION_D3DERROR, "unable to create ring[3] vertex buffer" );

	if( !CreateRing( m_pDevice, 8.6f, 10.0f, 100, &m_pvbRing[4] ) )
		throw CSystemException( DEMO_EXCEPTION_D3DERROR, "unable to create ring[4] vertex buffer" );

	if( !CreateRing( m_pDevice, 10.3f, 13.0f, 100, &m_pvbRing[5] ) )
		throw CSystemException( DEMO_EXCEPTION_D3DERROR, "unable to create ring[5] vertex buffer" );

	if( !CreateRing( m_pDevice, 13.2f, 16.0f, 100, &m_pvbRing[6] ) )
		throw CSystemException( DEMO_EXCEPTION_D3DERROR, "unable to create ring[6] vertex buffer" );

	if( !CreateRing( m_pDevice, 16.2f, 19.0f, 100, &m_pvbRing[7] ) )
		throw CSystemException( DEMO_EXCEPTION_D3DERROR, "unable to create ring[7] vertex buffer" );

	if( !CreateRing( m_pDevice, 19.3f, 21.5f, 100, &m_pvbRing[8] ) )
		throw CSystemException( DEMO_EXCEPTION_D3DERROR, "unable to create ring[8] vertex buffer" );

	if( !CreateRing( m_pDevice, 21.7f, 23.0f, 100, &m_pvbRing[9] ) )
		throw CSystemException( DEMO_EXCEPTION_D3DERROR, "unable to create ring[9] vertex buffer" );	

	if( !m_mSphere.Load( m_pDevice, "data//objects//detailsphere.smf" ) )
		throw CSystemException( DEMO_EXCEPTION_FILENOTFOUND, "unable to load detailsphere.smf" );

	if( !m_mPlanetDisk.Load( m_pDevice, "data//objects//planetarydisk.smf" ) )
		throw CSystemException( DEMO_EXCEPTION_FILENOTFOUND, "unable to load planetarydisk.smf" );

	m_pvbPlanetDisk = NULL;

	if( FAILED( m_pDevice->CreateVertexBuffer( 102*sizeof(LVERTEX), 0, FVF_LVERTEX, D3DPOOL_DEFAULT, &m_pvbPlanetDisk )	) )
		throw CSystemException( DEMO_EXCEPTION_D3DERROR, "unable to create planet disk vertex buffer" );	

	m_pvbSpaceDust = NULL;

	if( FAILED( m_pDevice->CreateVertexBuffer( 2000*sizeof(SIMPLEVERTEX), 0, FVF_SIMPLEVERTEX, D3DPOOL_DEFAULT, &m_pvbSpaceDust ) ) )
		throw CSystemException( DEMO_EXCEPTION_D3DERROR, "unable to create space dust vertex buffer" );

	m_pvbPlanetDust = NULL;
	
	if( FAILED( m_pDevice->CreateVertexBuffer( 100*sizeof(SIMPLEVERTEX), 0, FVF_SIMPLEVERTEX, D3DPOOL_DEFAULT, &m_pvbPlanetDust ) ) )
		throw CSystemException( DEMO_EXCEPTION_D3DERROR, "unable to create planet dust vertex buffer" );

	m_piqFade = NULL;

	m_piqFade = new CImageQuad( m_pDevice, 0, 0, 512, 512 );
	m_piqFade->SetColor( 0xffffff );

	PLVERTEX				pVertices;
	FLOAT					fAngle;
	FLOAT					fVal, fHeight;

	m_pvbPlanetDisk->Lock( 0, 0, (LPBYTE*)&pVertices, 0 );
	
	pVertices[0] = LVERTEX( 0.0f, 0.0f, 0.0f, 0xffffffff, 0.5f, 0.5f );

	for( i = 1 ; i < 102 ; i++ )
	{	
		fAngle = (FLOAT)(i - 1)*H_2PI/100.0f;
		pVertices[i] = LVERTEX( cosf( fAngle ), 0.0f, sinf( fAngle ), 0x60ffffff, 0.5f*(cosf( fAngle ) + 1.0f), 0.5f*(sinf( fAngle ) + 1.0f) );
	}

	m_pvbPlanetDisk->Unlock();

	PSIMPLEVERTEX			pVerts;

	m_pvbSpaceDust->Lock( 0, 0, (LPBYTE*)&pVerts, 0 );

	for( i = 0 ; i < 2000 ; i++ )
	{
		fVal = 5.0f*RAND();
		fHeight = expf( -fVal*fVal );
		fAngle = H_2PI*RAND();

		pVerts[i].m_vPos = he3d_CVector( fVal, fHeight*SIGNEDRAND(), 0.0f )*YRotationMtx( fAngle );

		fAngle = 255.0f/( 1.0f - fVal/5.0f );
		fHeight = 255.0f/( fVal/5.0f );

		if( fAngle > 255.0f )
			fAngle = 255.0f;
		else if( fAngle < 0.0f )
			fAngle = 0.0f;

		if( fHeight > 255.0f )
			fHeight = 255.0f;
		else if( fHeight < 0.0f )
			fHeight = 0.0f;

		pVerts[i].m_dwColor = D3DCOLOR_ARGB( 0x80, (DWORD)fAngle, (DWORD)fAngle, (DWORD)fHeight );
	}
	
	m_pvbSpaceDust->Unlock();

	m_pvbPlanetDust->Lock( 0, 0, (LPBYTE*)&pVerts, 0 );

	for( i = 0 ; i < 100 ; i++ )
	{
		pVerts[i].m_dwColor = 0x406773d8;
		pVerts[i].m_vPos = Polar2Cartesian3d( 1.0f, H_2PI*RAND(), H_2PI*RAND() );
	}
	
	m_pvbPlanetDust->Unlock();

	try
	{
		LoadTexture( "stardust.jpg" );
		LoadTexture( "planetarydisk.jpg" );
		LoadTexture( "smoke1.bmp" );
		LoadTexture( "sol.jpg" );
		LoadTexture( "planetseed.jpg" );
	}	
	catch( CTextureException )
	{
		throw CSystemException( DEMO_EXCEPTION_FILENOTFOUND, "unable to load textures" );
	}

	m_vsCameraPos[0] = VECTORKEY( 0.0f,   0.0f, 10.0f, -50.0f );
	m_vsCameraPos[1] = VECTORKEY( 3.0f, -20.0f, 20.0f, -40.0f );
	m_vsCameraPos[2] = VECTORKEY( 6.0f, -30.0f,  5.0f, -20.0f );
	m_vsCameraPos[3] = VECTORKEY( 9.0f, -40.0f,  2.0f, -10.0f );
	m_vsCameraPos[4] = VECTORKEY( 12.0f, -20.0f, 5.0f,  0.0f );
	m_vsCameraPos[5] = VECTORKEY( 15.0f, 20.0f, 20.0f,  10.0f );
	m_vsCameraPos[6] = VECTORKEY( 17.0f,  10.0f, 1.0f,  10.0f );

	he3d_CVector			vPos;

	for( i = 0, fVal = 0.0f ; i < 7 ; i++, fVal += 17.0f/7.0f )
	{	
		vPos = he3d_CVector( 11.65f, 0.0f, 0.0f )*YRotationMtx( 0.15f*1.3f*fVal + H_PI2 );	
		m_vsCameraTrg[i] = VECTORKEY( fVal, vPos );
	}

	m_fsRoll[0] = FLOATKEY(  0.0f, -40.0f );
	m_fsRoll[1] = FLOATKEY( 12.0f,   0.0f );
	m_fsRoll[2] = FLOATKEY( 17.0f,  30.0f );

	InitVectorSpline( 7, m_vsCameraPos );
	InitVectorSpline( 7, m_vsCameraTrg );
	InitFloatSpline( 3, m_fsRoll );
}

CSolarSystemCreation::~CSolarSystemCreation()
{
	for( DWORD i = 0 ; i < 10 ; i++ )
	{
		if( m_pvbRing[i] )
			m_pvbRing[i]->Release();
	}

	if( m_pvbPlanetDisk )
		m_pvbPlanetDisk->Release();

	if( m_pvbSpaceDust )
		m_pvbSpaceDust->Release();

	if( m_pvbPlanetDust )
		m_pvbPlanetDust->Release();

	if( m_piqFade )
		delete m_piqFade;
}

BOOL CSolarSystemCreation::InitEfx()
{
	return TRUE;
}

BOOL CSolarSystemCreation::FinishEfx()
{
	return TRUE;
}

#define	ROTATIONFACTOR		-0.15f

BOOL CSolarSystemCreation::UpdateFrame( FLOAT fTime )
{
	m_pDevice->SetTransform( D3DTS_PROJECTION, ProjectionMtx( 45.0f, 0.75f, 0.5f, 1000.0f ) );

	he3d_CVector			vPos = GetVectorSplineValue( fTime, 7, m_vsCameraPos );
	he3d_CVector			vTrg = GetVectorSplineValue( fTime, 7, m_vsCameraTrg );

	m_pDevice->SetTransform( D3DTS_VIEW, CameraMtx( vPos, vTrg, GetFloatSplineValue( fTime, 3, m_fsRoll ) ) );

	m_mtxRings[0] = ZRotationMtx( ROTATIONFACTOR*4.0f*fTime + 1.3f );
	m_mtxRings[1] = ZRotationMtx( ROTATIONFACTOR*6.0f*fTime + 0.3f );
	m_mtxRings[2] = ZRotationMtx( ROTATIONFACTOR*3.7f*fTime + 2.9f );
	m_mtxRings[3] = ZRotationMtx( ROTATIONFACTOR*2.2f*fTime + 1.8f );
	m_mtxRings[4] = ZRotationMtx( ROTATIONFACTOR*2.0f*fTime + 0.9f );
	m_mtxRings[5] = ZRotationMtx( ROTATIONFACTOR*1.3f*fTime + 1.5f );
	m_mtxRings[6] = ZRotationMtx( ROTATIONFACTOR*1.8f*fTime + 0.1f );
	m_mtxRings[7] = ZRotationMtx( ROTATIONFACTOR*1.1f*fTime + 2.3f );
	m_mtxRings[8] = ZRotationMtx( ROTATIONFACTOR*1.3f*fTime + 1.6f );
	m_mtxRings[9] = ZRotationMtx( ROTATIONFACTOR*1.1f*fTime + 2.5f );

	m_mtxPlanetsSeeds[0] = XRotationMtx( H_PI2 )*ScaleMtx( 0.03f, 0.04f, 0.03f )*YRotationMtx( 0.6f*fTime )*TranslationMtx( 1.5f, 0.0f, 0.0f )*YRotationMtx( -ROTATIONFACTOR*4.0f*fTime + 1.3f + H_PI2 );
	m_mtxPlanetsSeeds[1] = XRotationMtx( H_PI2 )*ScaleMtx( 0.06f, 0.08f, 0.06f )*YRotationMtx( 0.4f*fTime )*TranslationMtx( 2.75f, 0.0f, 0.0f )*YRotationMtx( -ROTATIONFACTOR*6.0f*fTime + 0.3f + H_PI2 );
	m_mtxPlanetsSeeds[2] = XRotationMtx( H_PI2 )*ScaleMtx( 0.06f, 0.08f, 0.06f )*YRotationMtx( 0.8f*fTime )*TranslationMtx( 4.825f, 0.0f, 0.0f )*YRotationMtx( -ROTATIONFACTOR*3.7f*fTime + 2.9f  + H_PI2 );
	m_mtxPlanetsSeeds[3] = XRotationMtx( H_PI2 )*ScaleMtx( 0.07f, 0.10f, 0.07f )*YRotationMtx( 0.2f*fTime )*TranslationMtx( 7.325f, 0.0f, 0.0f )*YRotationMtx( -ROTATIONFACTOR*2.2f*fTime + 1.8f  + H_PI2 );
	m_mtxPlanetsSeeds[4] = XRotationMtx( H_PI2 )*ScaleMtx( 0.06f, 0.08f, 0.06f )*YRotationMtx( 1.0f*fTime )*TranslationMtx( 9.3f, 0.0f, 0.0f )*YRotationMtx( -ROTATIONFACTOR*2.0f*fTime + 0.5f  + H_PI2 );
	m_mtxPlanetsSeeds[5] = XRotationMtx( H_PI2 )*ScaleMtx( 0.10f, 0.13f, 0.10f )*YRotationMtx( 1.4f*fTime )*TranslationMtx( 11.65f, 0.0f, 0.0f )*YRotationMtx( -ROTATIONFACTOR*1.3f*fTime + H_PI2 );
	m_mtxPlanetsSeeds[6] = XRotationMtx( H_PI2 )*ScaleMtx( 0.10f, 0.13f, 0.10f )*YRotationMtx( 1.2f*fTime )*TranslationMtx( 14.6f, 0.0f, 0.0f )*YRotationMtx( -ROTATIONFACTOR*1.8f*fTime + 1.2f  + H_PI2 );
	m_mtxPlanetsSeeds[7] = XRotationMtx( H_PI2 )*ScaleMtx( 0.10f, 0.13f, 0.10f )*YRotationMtx( 0.6f*fTime )*TranslationMtx( 17.6f, 0.0f, 0.0f )*YRotationMtx( -ROTATIONFACTOR*1.1f*fTime + 2.3f - 1.5f );
	m_mtxPlanetsSeeds[8] = XRotationMtx( H_PI2 )*ScaleMtx( 0.10f, 0.12f, 0.10f )*YRotationMtx( 0.4f*fTime )*TranslationMtx( 20.4f, 0.0f, 0.0f )*YRotationMtx( -ROTATIONFACTOR*1.3f*fTime - 0.2f + H_PI2 );
	m_mtxPlanetsSeeds[9] = XRotationMtx( H_PI2 )*ScaleMtx( 0.06f, 0.06f, 0.06f )*YRotationMtx( 1.0f*fTime )*TranslationMtx( 22.35f, 0.0f, 0.0f )*YRotationMtx( -ROTATIONFACTOR*1.1f*fTime + 2.1f + H_PI2 + H_PI );	

	m_mtxPlanetaryDust[0] = ScaleMtx( 1.23f, 0.24f, 1.23f )*YRotationMtx( 0.6f*fTime )*TranslationMtx( 1.5f, 0.0f, 0.0f )*YRotationMtx( -ROTATIONFACTOR*4.0f*fTime + 1.3f + H_PI2 );
	m_mtxPlanetaryDust[1] = ScaleMtx( 1.26f, 0.28f, 1.26f )*YRotationMtx( 0.4f*fTime )*TranslationMtx( 2.75f, 0.0f, 0.0f )*YRotationMtx( -ROTATIONFACTOR*6.0f*fTime + 0.3f + H_PI2 );
	m_mtxPlanetaryDust[2] = ScaleMtx( 1.26f, 0.28f, 1.26f )*YRotationMtx( 0.8f*fTime )*TranslationMtx( 4.825f, 0.0f, 0.0f )*YRotationMtx( -ROTATIONFACTOR*3.7f*fTime + 2.9f  + H_PI2 );
	m_mtxPlanetaryDust[3] = ScaleMtx( 1.27f, 0.20f, 1.27f )*YRotationMtx( 0.2f*fTime )*TranslationMtx( 7.325f, 0.0f, 0.0f )*YRotationMtx( -ROTATIONFACTOR*2.2f*fTime + 1.8f  + H_PI2 );
	m_mtxPlanetaryDust[4] = ScaleMtx( 1.26f, 0.28f, 1.26f )*YRotationMtx( 1.0f*fTime )*TranslationMtx( 9.3f, 0.0f, 0.0f )*YRotationMtx( -ROTATIONFACTOR*2.0f*fTime + 0.5f  + H_PI2 );
	m_mtxPlanetaryDust[5] = ScaleMtx( 1.30f, 0.23f, 1.30f )*YRotationMtx( 1.4f*fTime )*TranslationMtx( 11.65f, 0.0f, 0.0f )*YRotationMtx( -ROTATIONFACTOR*1.3f*fTime + H_PI2 );
	m_mtxPlanetaryDust[6] = ScaleMtx( 1.30f, 0.23f, 1.30f )*YRotationMtx( 1.2f*fTime )*TranslationMtx( 14.6f, 0.0f, 0.0f )*YRotationMtx( -ROTATIONFACTOR*1.8f*fTime + 1.2f  + H_PI2 );
	m_mtxPlanetaryDust[7] = ScaleMtx( 1.30f, 0.23f, 1.30f )*YRotationMtx( 0.6f*fTime )*TranslationMtx( 17.6f, 0.0f, 0.0f )*YRotationMtx( -ROTATIONFACTOR*1.1f*fTime + 2.3f - 1.5f );
	m_mtxPlanetaryDust[8] = ScaleMtx( 1.30f, 0.22f, 1.30f )*YRotationMtx( 0.4f*fTime )*TranslationMtx( 20.4f, 0.0f, 0.0f )*YRotationMtx( -ROTATIONFACTOR*1.3f*fTime - 0.2f + H_PI2 );
	m_mtxPlanetaryDust[9] = ScaleMtx( 1.26f, 0.26f, 1.26f )*YRotationMtx( 1.0f*fTime )*TranslationMtx( 22.35f, 0.0f, 0.0f )*YRotationMtx( -ROTATIONFACTOR*1.1f*fTime + 2.1f + H_PI2 + H_PI );	

	m_mtxDisk = YRotationMtx( 0.3f*fTime );

	FLOAT					fAlpha = 0.0f;

	if( fTime < 2.0f )
	{
		fAlpha = (2.0f - fTime)*128.0f;
	}

	if( fTime > 15.5f )
	{
		fAlpha = (fTime - 15.5f)*200.0f;
	}

	if( fAlpha < 0.0f )
		fAlpha = 0.0f;
	else if( fAlpha > 255.0f )
		fAlpha = 255.0f;
		
	m_piqFade->SetAlpha( (DWORD)fAlpha );

	return TRUE;
}

BOOL CSolarSystemCreation::RenderEfx()
{
	m_pDevice->Clear( 0, NULL, D3DCLEAR_ZBUFFER, 0x00, 1.0f, 0 );

	m_pDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );
	m_pDevice->SetRenderState( D3DRS_LIGHTING, FALSE );
	m_pDevice->SetRenderState( D3DRS_ZENABLE, D3DZB_TRUE );
	
	m_pDevice->SetRenderState( D3DRS_ZWRITEENABLE, FALSE );

	m_pDevice->SetTransform( D3DTS_WORLD, ScaleMtx( 0.5f ) );
	m_pDevice->SetTexture( 0, GetTexture( "deepspace.jpg" ) );
	m_pDevice->SetTextureStageState( 0, D3DTSS_TEXCOORDINDEX, D3DTSS_TCI_CAMERASPACENORMAL );
	m_pDevice->SetTextureStageState( 0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_COUNT2 );
	m_pDevice->SetTransform( D3DTS_TEXTURE0, TranslationMtx( 1.0f, 1.0f, 1.0f )*ScaleMtx( 0.5f ) );	
	m_mSphere.Render( m_pDevice );		
	m_pDevice->SetTextureStageState( 0, D3DTSS_TEXCOORDINDEX, D3DTSS_TCI_PASSTHRU );
	m_pDevice->SetTextureStageState( 0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE );


	m_pDevice->SetRenderState( D3DRS_ZWRITEENABLE, TRUE );

	m_pDevice->SetTransform( D3DTS_WORLD, ScaleMtx( 0.01f ) );

	m_pDevice->SetTexture( 0, GetTexture( "sol.jpg" ) );
	m_mSphere.Render( m_pDevice );	

	m_pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );

	m_pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
	m_pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
	m_pDevice->SetRenderState( D3DRS_ZWRITEENABLE, FALSE );

	m_pDevice->SetTexture( 0, GetTexture( "planetarydisk.jpg" ) );
	m_pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG2 );

	m_pDevice->SetTransform( D3DTS_WORLD, ScaleMtx( 50.0f )*m_mtxDisk );

	m_pDevice->SetVertexShader( FVF_LVERTEX );
	m_pDevice->SetStreamSource( 0, m_pvbPlanetDisk, sizeof(LVERTEX) );
	m_pDevice->DrawPrimitive( D3DPT_TRIANGLEFAN, 0, 100 );

	m_pDevice->SetTransform( D3DTS_WORLD, ScaleMtx( 1.5f, 1.5f, 1.5f )*m_mtxDisk );

	m_pDevice->SetRenderState( D3DRS_POINTSPRITEENABLE, TRUE );
	m_pDevice->SetRenderState( D3DRS_POINTSCALEENABLE, TRUE );
	m_pDevice->SetRenderState( D3DRS_POINTSIZE, FLT2DWORD( 0.4f ) );
	m_pDevice->SetRenderState( D3DRS_POINTSCALE_A, FLT2DWORD( 1.0f ) );
	m_pDevice->SetRenderState( D3DRS_POINTSCALE_B, FLT2DWORD( 1.0f ) );
	m_pDevice->SetRenderState( D3DRS_POINTSCALE_C, FLT2DWORD( 1.0f ) );

	m_pDevice->SetTexture( 0, GetTexture( "smoke1.bmp" ) );
	m_pDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );

	m_pDevice->SetVertexShader( FVF_SIMPLEVERTEX );
	m_pDevice->SetStreamSource( 0, m_pvbSpaceDust, sizeof(SIMPLEVERTEX) );
	m_pDevice->DrawPrimitive( D3DPT_POINTLIST, 0, 2000 );

	m_pDevice->SetStreamSource( 0, m_pvbPlanetDust, sizeof(SIMPLEVERTEX) );

	m_pDevice->SetRenderState( D3DRS_POINTSIZE, FLT2DWORD( 0.6f ) );

	for( DWORD i = 0 ; i < 10 ; i++ )
	{
		m_pDevice->SetTransform( D3DTS_WORLD, m_mtxPlanetaryDust[i] );
		m_pDevice->DrawPrimitive( D3DPT_POINTLIST, 0, 100 );
	}

	m_pDevice->SetRenderState( D3DRS_POINTSPRITEENABLE, FALSE );
	m_pDevice->SetRenderState( D3DRS_POINTSCALEENABLE, FALSE );
 
	m_pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1 );

	m_pDevice->SetTexture( 0, GetTexture( "stardust.jpg" ) );

	m_pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_ONE );
	m_pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );

	m_pDevice->SetVertexShader( FVF_LVERTEX );
	
	for( i = 0 ; i < 10 ; i++ )
	{
		m_pDevice->SetTransform( D3DTS_WORLD, m_mtxRings[i]*XRotationMtx( H_PI2 ) );
		m_pDevice->SetStreamSource( 0, m_pvbRing[i], sizeof(LVERTEX) );
		m_pDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, 200 );
	}	

	m_pDevice->SetTexture( 0, GetTexture( "planetseed.jpg" ) );

	for( i = 0 ; i < 10 ; i++ )
	{
		m_pDevice->SetTransform( D3DTS_WORLD, m_mtxPlanetsSeeds[i] );
		m_mPlanetDisk.Render( m_pDevice );
	}
	
	m_pDevice->SetTexture( 0, NULL );

	m_pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
	m_pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );

	m_piqFade->Render( m_pDevice );

	m_pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );
	m_pDevice->SetRenderState( D3DRS_ZWRITEENABLE, TRUE );

	return TRUE;
}