round	macro reg
	tst.w	\1
	bpl.s	*+8
	add.l	#$10000,\1
	clr.w	\1
	swap	\1
	endm

take_cos	macro	reg
	lea	sin_cos(pc),a2
	add.w	#90,\1
	lsl.w	#2,\1
	move.l	0(a2,\1.w),\1
	endm

take_sin	macro	reg
	lea	sin_cos(pc),a2
	lsl.w	#2,\1
	move.l	0(a2,\1.w),\1
	endm

cos_mul	macro	angle, multiplier
	move.w	\1,d0
	move.w	\2,d1
	move.w	d1,d2
	take_cos	d0
	mulu	d0,d1
	swap	d0
	mulu	d0,d2
	swap	d2
	clr.w	d2
	add.l	d2,d1
	round	d1
	endm

sin_mul	macro	angle, multiplier
	move.w	\1,d0
	move.w	\2,d1
	move.w	d1,d2
	take_sin	d0
	mulu	d0,d1
	swap	d0
	mulu	d0,d2
	swap	d2
	clr.w	d2
	add.l	d2,d1
	round	d1
	endm

PAL_BASE	equ	$400200

	dc.l	'SNK!'
	dc.l	$10000
	
	bset	#7,$10fd80
	
	move.w	#0007,d0
	jsr	$c0056a

	* Effacement de l'cran
	bsr	CLEAR_FIX
	bsr	CLEAR_SPR

	* Transfert des sprites
	move.w	#$1200,$7eda(a5)
	lea	spr(pc),a0
	move.l	a0,$7ef8(a5)
	clr.l	$7ef4(a5)
	move.l	#81920,$7efc(a5)
	jsr	$c00546

	* Transfert des palette (dpart  16)	
	lea	pal(pc),a0
	lea	PAL_BASE,a1
	move.w	#$5F,d0
copypal
	move.l	(a0)+,(a1)+
	dbf	d0,copypal	

	lea	PAL_BASE,a1
	moveq	#7,d0
clrpal1	clr.l	(a1)+
	dbf	d0,clrpal1

	lea	PAL_BASE+$140,a1
	moveq	#7,d0
clrpal2	clr.l	(a1)+
	dbf	d0,clrpal2

	lea	$3c0002,a6
	move.w	#1,2(a6)
	
	move.w	#$8040,-2(a6)
	moveq	#31,d0
initscrollzoom
	move.w	#$FFF,(a6)
	dbf	d0,initscrollzoom
	
	move.w	#$8240,-2(a6)
	move.w	#$9782,(a6)
	moveq	#30,d0
inityposscroll
	move.w	#$97C2,(a6)
	dbf	d0,inityposscroll	

	move.w	#$8440,-2(a6)
	move.w	#$0,(a6)

	lea	cur_txt(pc),a0
	lea	texte(pc),a1
	move.l	a1,(a0)+
	move.w	#$1f1,(a0)

	lea	irq(pc),a0
	move.l	a0,$68.w


MAIN_LOOP
	bsr	CLEAR_SCR

	move.w	#$00c0,-2(a6)
	moveq	#1,d0
	moveq	#18,d1
copylogo
	moveq	#12,d2
writesprdat1
	move.w	d0,(a6)
	move.w	#$1000,(a6)
	addq.w	#1,d0
	dbf	d2,writesprdat1

	moveq	#18,d2
writesprdat2	
	move.w	#$0001,(a6)	
	move.w	#$1000,(a6)
	dbf	d2,writesprdat2

	dbf	d1,copylogo
	
	move.w	#$8003,-2(a6)
	moveq	#18,d0

writesprzoom
	move.w	#$FFF,(a6)
	dbf	d0,writesprzoom
	
	move.w	#$8203,-2(a6)

	move.w	#$FC0D,(a6)
	
	moveq	#17,d0
writesprypos
	move.w	#$FC4D,(a6)
	dbf	d0,writesprypos
	
	move.w	#$8403,-2(a6)
	moveq	#18,d0
writesprxpos
	clr.w	(a6)
	dbf	d0,writesprxpos
	
	move.w	#$8020,-2(a6)
	move.w	#$FFF,(a6)
	move.w	#$FFF,(a6)
	move.w	#$FFF,(a6)
	move.w	#$FFF,(a6)
	move.w	#$FFF,(a6)
	move.w	#$FFF,(a6)
	move.w	#$FFF,(a6)
	move.w	#$FFF,(a6)
	move.w	#$FFF,(a6)
	move.w	#$FFF,(a6)
	move.w	#$FFF,(a6)
	move.w	#$FFF,(a6)
	move.w	#$FFF,(a6)
	move.w	#$FFF,(a6)

	lea	fade_flag(pc),a1
	move.w	#$ffff,(a1)
	lea	fade_offset(pc),a1
	move.l	#$0,(a1)
	lea	fade_size(pc),a1
	move.w	#2,(a1)

	lea	task_slots(pc),a0
	lea	fade_in(pc),a1
	move.l	a1,(a0)+	
	lea	scrolltext(pc),a1
	move.l	a1,(a0)+
	lea	disp_lucioles(pc),a1
	move.l	a1,(a0)+
	
	lea	task_slots(pc),a0
wcomp	tst.l	(a0)
	bne.s	wcomp

	move.w	#899,d0
wait1	clr.w	$18e.w
wait2	tst.w	$18e.w
	beq.s	wait2
	dbf	d0,wait1
	
	lea	fade_flag(pc),a1
	move.w	#$ffff,(a1)
	lea	task_slots(pc),a0
	lea	fade_out(pc),a1
	move.l	a1,(a0)+
	tst.l	(a0)+
	clr.l	(a0)+
	
	lea	task_slots(pc),a0
wcomp2	tst.l	(a0)
	bne.s	wcomp2
	
	bsr	CLEAR_SCR

	move.w	#$00c0,-2(a6)
	move.w	#$207,d0
	moveq	#10,d1
copyback
	moveq	#10,d2

writesprdat3
	move.w	d0,(a6)
	move.w	#$1A00,(a6)
	addq.w	#1,d0
	dbf	d2,writesprdat3

	moveq	#20,d2
writesprdat4	
	move.w	#$0001,(a6)	
	move.w	#$1000,(a6)
	dbf	d2,writesprdat4

	dbf	d1,copyback
	
	move.w	#$8003,-2(a6)
	moveq	#10,d0

writesprzoom2
	move.w	#$FFF,(a6)
	dbf	d0,writesprzoom2
	
	move.w	#$8203,-2(a6)

	move.w	#$F80D,(a6)
	
	moveq	#9,d0
writesprypos2
	move.w	#$F84D,(a6)
	dbf	d0,writesprypos2
	
	move.w	#$8403,-2(a6)
	moveq	#10,d0
writesprxpos2
	move.w	#$2800,(a6)
	dbf	d0,writesprxpos2

	lea	fade_flag(pc),a1
	move.w	#$ffff,(a1)
	lea	fade_offset(pc),a1
	move.l	#$140,(a1)
	lea	fade_size(pc),a1
	move.w	#1,(a1)

	lea	task_slots(pc),a0
	lea	fade_in(pc),a1
	move.l	a1,(a0)+	
	
	lea	task_slots(pc),a0
wcomp3	tst.l	(a0)
	bne.s	wcomp3

	lea	rx(pc),a0
	move.w	#220,(a0)
	lea	ry(pc),a0
	move.w	#200,(a0)

	lea	task_slots(pc),a0
	lea	bring_boules(pc),a1
	move.l	a1,(a0)+
	tst.l	(a0)+
	clr.l	(a0)+

	lea	task_slots(pc),a0
wcomp4	tst.l	(a0)
	bne.s	wcomp4

	lea	task_slots(pc),a0
	lea	disp_boules(pc),a1
	move.l	a1,(a0)+
	tst.l	(a0)+
	clr.l	(a0)+

	move.w	#899,d0
wait5	clr.w	$18e.w
wait6	tst.w	$18e.w
	beq.s	wait6
	dbf	d0,wait5
	
	lea	task_slots(pc),a0
	lea	pull_boules(pc),a1
	move.l	a1,(a0)+
	tst.l	(a0)+
	clr.l	(a0)+

	lea	task_slots(pc),a0
wcomp5	tst.l	(a0)
	bne.s	wcomp5

	lea	fade_flag(pc),a1
	move.w	#$ffff,(a1)
	lea	task_slots(pc),a0
	lea	fade_out(pc),a1
	move.l	a1,(a0)+
	tst.l	(a0)+
	clr.l	(a0)+
	
	lea	task_slots(pc),a0
wcomp6	tst.l	(a0)
	bne.s	wcomp6

	bra	MAIN_LOOP
	

CLEAR_SCR
	move.w	#0,-2(a6)
	move.w	#$FFF,d0
clear1	clr.w	(a6)
	dbf	d0,clear1

	move.w	#$8000,-2(a6)
	move.w	#$3F,d0
clear2	clr.w	(a6)
	dbf	d0,clear2
		
	move.w	#$8200,-2(a6)
	move.w	#$3F,d0
clear3	clr.w	(a6)
	dbf	d0,clear3

	move.w	#$8400,-2(a6)
	move.w	#$3F,d0
clear4	clr.w	(a6)
	dbf	d0,clear4
	rts
	
bring_boules
	lea	ry(pc),a1
	subq.w	#1,(a1)
	lea	rx(pc),a1
	subq.w	#1,(a1)
	
	cmp.w	#80,(a1)
	bne.s	fn1
	
	clr.l	-4(a0)

fn1	bra	disp_boules

pull_boules
	lea	ry(pc),a1
	addq.w	#1,(a1)
	lea	rx(pc),a1
	addq.w	#1,(a1)
	
	cmp.w	#220,(a1)
	bne.s	fn2
	
	clr.l	-4(a0)

fn2	bra	disp_boules
	
disp_boules
	lea	boules(pc),a0
	lea	pas(pc),a1

	rept	4
	clr.w	(a0)+
	cos_mul	(a0),2(a1)
	add.w	#140,d1
	move.w	d1,2(a0)
	sin_mul	(a0),4(a1)
	move.w	#104,d0
	sub.w	d1,d0
	move.w	d0,4(a0)
	sin_mul	(a0),6(a1)
	move.w	#$FF,d0
	sub.w	6(a1),d0
	sub.w	d1,d0
	move.w	d0,6(a0)
	sin_mul	(a0),8(a1)
	move.w	#$F,d0
	sub.w	8(a1),d0
	sub.w	d1,d0
	move.w	d0,8(a0)
	move.w	#$10,d1
	sub.w	d0,d1
	add.w	d1,2(a0)
	
	lea	14(a0),a0
	endr
	
	moveq	#3,d3
	move.l	#$3c0002,a6

	move.w	#$0800,d4
	move.w	#$8020,d5
	move.w	#$8220,d6
	move.w	#$8420,d7

dsploop	lea	boules(pc),a0
	moveq	#-1,d1
	moveq	#3,d2
dsploop2
	tst.w	(a0)
	bne.s	ignore
	cmp.w	8(a0),d1
	bls.s	ignore
	move.w	8(a0),d1
	move.l	a0,a2
ignore	lea	16(a0),a0
	dbf	d2,dsploop2

	move.l	a2,a0
	move.w	#$FFFF,(a0)+
	move.w	(a1),d0
	add.w	d0,(a0)

	cmp.w	#360,(a0)
	blt.s	*+6
	sub.w	#360,(a0)
	
	move.w	d4,-2(a6)
	move.w	10(a0),d0
	lea	12(a0),a2

	addq.w	#2,d0
	move.w	d0,(a6)
	move.w	(a2),(a6)
	addq.w	#1,d0
	move.w	d0,(a6)
	move.w	(a2),(a6)
	rept	28
	move.w	#0,(a6)
	move.w	(a2),(a6)
	endr
	subq.w	#3,d0
	move.w	d0,(a6)
	move.w	(a2),(a6)
	addq.w	#1,d0
	move.w	d0,(a6)
	move.w	(a2),(a6)
	addq.w	#5,d0

	move.w	d0,(a6)
	move.w	(a2),(a6)
	addq.w	#1,d0
	move.w	d0,(a6)
	move.w	(a2),(a6)
	rept	28
	move.w	#$1,(a6)
	move.w	(a2),(a6)
	endr
	subq.w	#3,d0
	move.w	d0,(a6)
	move.w	(a2),(a6)
	addq.w	#1,d0
	move.w	d0,(a6)
	move.w	(a2),(a6)
	addq.w	#5,d0

	move.w	d0,(a6)
	move.w	(a2),(a6)
	addq.w	#1,d0
	move.w	d0,(a6)
	move.w	(a2),(a6)
	rept	28
	move.w	#$1,(a6)
	move.w	(a2),(a6)
	endr
	subq.w	#3,d0
	move.w	d0,(a6)
	move.w	(a2),(a6)
	addq.w	#1,d0
	move.w	d0,(a6)
	move.w	(a2),(a6)

	add.w	#$c0,d4

	move.w	d7,-2(a6)
	move.w	2(a0),d0
	lsl.w	#7,d0
	move.w	d0,(a6)
	move.w	d0,(a6)
	move.w	d0,(a6)
	addq.w	#3,d7

	move.w	d6,-2(a6)
	move.w	4(a0),d0
	move.w	#$1FF,d1
	sub.w	d0,d1
	lsl.w	#7,d1
	or.w	#$20,d1
	move.w	d1,(a6)
	or.w	#$40,d1
	move.w	d1,(a6)
	move.w	d1,(a6)
	addq.w	#3,d6
	
	move.w	d5,-2(a6)
	move.w	6(a0),d0
	move.w	8(a0),d1
	lsl.w	#8,d1
	or.w	d0,d1
	move.w	d1,(a6)
	move.w	d1,(a6)
	move.w	d1,(a6)
	addq.w	#3,d5
	dbf	d3,dsploop
	rts		

disp_lucioles
	move.l	#$3c0002,a6
	
	lea	cur_dsp(pc),a0
	move.w	(a0),d5
	eor	#1,(a0)

	move.w	#$0800,d0
	moveq	#2,d4

filldata1
	move.w	d0,-2(a6)
	tst.b	d5
	bne.s	sp2
	move.w	#$105,(a6)
	move.w	#$1100,(a6)
	move.w	#$106,(a6)
	move.w	#$1100,(a6)
	add.w	#$40,d0
	move.w	d0,-2(a6)
	move.w	#$107,(a6)
	move.w	#$1100,(a6)
	move.w	#$108,(a6)
	move.w	#$1100,(a6)
	bra	sp1

sp2	move.w	#$109,(a6)
	move.w	#$1100,(a6)
	move.w	#$10a,(a6)
	move.w	#$1100,(a6)
	add.w	#$40,d0
	move.w	d0,-2(a6)
	move.w	#$10b,(a6)
	move.w	#$1100,(a6)
	move.w	#$10c,(a6)
	move.w	#$1100,(a6)

sp1	add.w	#$40,d0
	dbf	d4,filldata1

	moveq	#2,d4
filldata12
	move.w	d0,-2(a6)
	tst.b	d5
	bne.s	sp22
	move.w	#$10D,(a6)
	move.w	#$1100,(a6)
	bra	sp12

sp22	move.w	#$10E,(a6)
	move.w	#$1100,(a6)

sp12	add.w	#$40,d0
	dbf	d4,filldata12

	moveq	#2,d4
	move.w	#$8220,d6
	move.w	#$8420,d7
	lea	luciole_big(pc),a0
	
filldata2
	cos_mul	(a0),2(a0)
	move.w	(a0),d0
	add.w	4(a0),d0
	cmp.w	#360,d0
	bmi.s	*+4
	moveq	#0,d0
	move.w	d0,(a0)+
	tst.w	(a0)+
	tst.w	(a0)+
		
	add.w	(a0)+,d1
	lsl.w	#7,d1
	move.w	d7,-2(a6)
	move.w	d1,(a6)
	move.w	d1,(a6)	
	addq.w	#2,d7
	move.w	(a0)+,d1
	move.w	d1,d0
	lsl.w	#7,d1
	move.w	d6,-2(a6)
	or.w	#$02,d1
	move.w	d1,(a6)
	or.w	#$40,d1
	move.w	d1,(a6)
	addq.w	#2,d6	
	add.w	(a0)+,d0
	and.w	#$1FF,d0
	cmp.w	#$FF,d0
	bgt.s	*+6
	move.w	#$FF,d0	
	move.w	d0,-4(a0)
	dbf	d4,filldata2
		
	moveq	#2,d4
	lea	luciole_small(pc),a0
	
filldata22
	cos_mul	(a0),2(a0)
	move.w	(a0),d0
	add.w	4(a0),d0
	cmp.w	#360,d0
	bmi.s	*+4
	moveq	#0,d0
	move.w	d0,(a0)+
	tst.w	(a0)+
	tst.w	(a0)+
		
	add.w	(a0)+,d1
	lsl.w	#7,d1
	move.w	d7,-2(a6)
	move.w	d1,(a6)
	addq.w	#1,d7
	move.w	(a0)+,d1
	move.w	d1,d0
	lsl.w	#7,d1
	move.w	d6,-2(a6)
	or.w	#$02,d1
	move.w	d1,(a6)
	addq.w	#1,d6	
	add.w	(a0)+,d0
	and.w	#$1FF,d0
	cmp.w	#$FF,d0
	bgt.s	*+6
	move.w	#$FF,d0	
	move.w	d0,-4(a0)
	dbf	d4,filldata22
	rts

reset_rout
	move.l	#$19a,$68.w
	jmp	$250.w

irq	movem.l	d0-d7/a0-a6,-(sp)

	lea	task_slots(pc),a0

	rept	16	
	move.l	(a0)+,a1
	cmp.l	#0,a1
	beq.s	*+8
	move.l	a0,-(sp)
	jsr	(a1)
	move.l	(sp)+,a0
	endr

	movem.l	(sp)+,d0-d7/a0-a6
	jmp	$19a.w

scrolltext
	move.l	#$3c0002,a6
	lea	cur_pos(pc),a0
	move.w	(a0),d0
	subq.w	#1,d0
	and.w	#$1FF,d0
	move.w	d0,(a0)

	move.w	#$8440,-2(a6)
	lsl.w	#7,d0
	move.w	d0,(a6)
	
	move.w	(a0),d0
	and.w	#$1F,d0
	bne.s	nowrt	

	lea	cur_txt(pc),a0
	lea	texte(pc),a1
	lea	char_map(pc),a2

retry	move.l	(a0),a0
	move.b	(a0)+,d0
	bne.s	nowrap
	lea	cur_txt(pc),a0
	move.l	a1,(a0)
	bra.s	retry
nowrap	cmp.b	(a2)+,d0
	beq.s	found
	tst.b	(a2)+
	bra.s	nowrap
	
found	lea	cur_txt(pc),a1
	move.l	a0,(a1)

	moveq	#0,d1
	move.b	(a2)+,d1
	add.w	#$10f,d1

	lea	cur_spr(pc),a0
	move.w	(a0),d0
	add.w	#$80,d0
	cmp.w	#$1800,d0
	bne.s	*+6
	move.w	#$1000,d0
	move.w	d0,(a0)
	move.w	d0,-2(a6)
	move.w	d1,(a6)
	move.w	#$1500,(a6)
	addq.w	#1,d1
	move.w	d1,(a6)
	move.w	#$1500,(a6)
	add.w	#$40,d0
	move.w	d0,-2(a6)
	add.w	#9,d1
	move.w	d1,(a6)
	move.w	#$1500,(a6)
	addq.w	#1,d1
	move.w	d1,(a6)		
	move.w	#$1500,(a6)
nowrt	rts	

fade_out
	lea	fade_flag(pc),a1
	move.w	(a1),d0
	bpl.s	do_fade_out
	
	clr.w	(a1)
	lea	fade_offset(pc),a3
	move.l	(a3),d0
	lea	pal(pc),a1
	move.l	#PAL_BASE,a2
	add.l	d0,a1
	add.l	d0,a2
	lea	fade_size(pc),a3
	move.l	(a3),d0
	lsl.l	#2,d0
cpy1	move.l	(a1)+,(a2)+
	dbf	d0,cpy1
	rts
	
do_fade_out
	lea	fade_offset(pc),a4
	move.l	(a4),d0
	lea	pal(pc),a2
	move.l	#PAL_BASE,a3
	add.l	d0,a2
	add.l	d0,a3
	lea	fade_size(pc),a4
	move.l	(a4),d0
	lsl.l	#4,d0
	subq.w	#1,d0
	lea	fade_table(pc),a4
	
floop1	
	move.w	(a2),d1
	move.w	d1,d2
	lsr.w	#7,d1
	and.w	#$1E,d1
	and.w	#$4000,d2
	beq.s	*+4
	addq.w	#1,d1

	move.w	(a1),d2
	lsl.w	#5,d1
	add.w	d2,d1
	tst.b	0(a4,d1.w)
	beq.s	no_red
	
	move.w	(a3),d1
	move.w	d1,d2
	and.w	#$4000,d2
	beq.s	rm1
	
	and.w	#$BFFF,(a3)
	bra.s	no_red
	
rm1	move.w	d1,d2
	and.w	#$0F00,d2
	beq.s	no_red
	
	sub.w	#$0100,d1
	or.w	#$4000,d1
	move.w	d1,(a3)

no_red
	move.w	(a2),d1
	move.w	d1,d2
	lsr.w	#3,d1
	and.w	#$1E,d1
	and.w	#$2000,d2
	beq.s	*+4
	addq.w	#1,d1

	move.w	(a1),d2
	lsl.w	#5,d1
	add.w	d2,d1
	tst.b	0(a4,d1.w)
	beq.s	no_green
	
	move.w	(a3),d1
	move.w	d1,d2
	and.w	#$2000,d2
	beq.s	rm2
	
	and.w	#$DFFF,(a3)
	bra.s	no_green
	
rm2	move.w	d1,d2
	and.w	#$00F0,d2
	beq.s	no_green
	
	sub.w	#$0010,d1
	or.w	#$2000,d1
	move.w	d1,(a3)

no_green
	move.w	(a2),d1
	move.w	d1,d2
	lsl.w	#1,d1
	and.w	#$1E,d1
	and.w	#$1000,d2
	beq.s	*+4
	addq.w	#1,d1

	move.w	(a1),d2
	lsl.w	#5,d1
	add.w	d2,d1
	tst.b	0(a4,d1.w)
	beq.s	no_blue
	
	move.w	(a3),d1
	move.w	d1,d2
	and.w	#$1000,d2
	beq.s	rm3
	
	and.w	#$EFFF,(a3)
	bra.s	no_blue
	
rm3	move.w	d1,d2
	and.w	#$000F,d2
	beq.s	no_blue
	
	sub.w	#$0001,d1
	or.w	#$1000,d1
	move.w	d1,(a3)

no_blue	addq.w	#2,a2
	addq.w	#2,a3
	dbf	d0,floop1

	move.w	(a1),d0
	addq.w	#1,d0
	and.w	#$1F,d0
	bne.s	do_it_now1
	
	clr.l	-4(a0)
	move.w	#$FFFF,(a1)
	rts

do_it_now1
	move.w	d0,(a1)
	rts

fade_in	lea	fade_flag(pc),a1
	move.w	(a1),d0
	bpl.s	do_fade_in
	
	clr.w	(a1)
	lea	fade_offset(pc),a0
	move.l	(a0),d0
	move.l	#PAL_BASE,a2
	add.l	d0,a2
	lea	fade_size(pc),a0
	move.l	(a0),d0
	lsl.l	#2,d0
cpy2	clr.l	(a2)+
	dbf	d0,cpy2
	rts
	
do_fade_in
	lea	fade_offset(pc),a4
	move.l	(a4),d0
	lea	pal(pc),a2
	move.l	#PAL_BASE,a3
	add.l	d0,a2
	add.l	d0,a3
	lea	fade_size(pc),a4
	move.l	(a4),d0
	lsl.l	#4,d0
	subq.w	#1,d0
	lea	fade_table(pc),a4
	
floop2	
	move.w	(a2),d1
	move.w	d1,d2
	lsr.w	#7,d1
	and.w	#$1E,d1
	and.w	#$4000,d2
	beq.s	*+4
	addq.w	#1,d1

	move.w	(a1),d2
	lsl.w	#5,d1
	add.w	d2,d1
	tst.b	0(a4,d1.w)
	beq.s	no_red1
	
	move.w	(a3),d1
	move.w	d1,d2
	move.w	(a2),d3
	and.w	#$4F00,d2
	and.w	#$4F00,d3
	cmp.w	d3,d4
	beq.s	no_red1

	move.w	d1,d2
	and.w	#$4000,d2
	bne.s	rm11

	or.w	#$4000,(a3)
	bra.s	no_red1
	
rm11	add.w	#$0100,d1
	and.w	#$BFFF,d1
	move.w	d1,(a3)

no_red1
	move.w	(a2),d1
	move.w	d1,d2
	lsr.w	#3,d1
	and.w	#$1E,d1
	and.w	#$2000,d2
	beq.s	*+4
	addq.w	#1,d1

	move.w	(a1),d2
	lsl.w	#5,d1
	add.w	d2,d1
	tst.b	0(a4,d1.w)
	beq.s	no_green1
	
	move.w	(a3),d1
	move.w	d1,d2
	move.w	(a2),d3
	and.w	#$20F0,d2
	and.w	#$20F0,d3
	cmp.w	d2,d3
	beq.s	no_green1

	move.w	d1,d2
	and.w	#$2000,d2
	bne.s	rm21
		
	or.w	#$2000,(a3)
	bra.s	no_green1
	
rm21	add.w	#$0010,d1
	and.w	#$DFFF,d1
	move.w	d1,(a3)

no_green1
	move.w	(a2),d1
	move.w	d1,d2
	lsl.w	#1,d1
	and.w	#$1E,d1
	and.w	#$1000,d2
	beq.s	*+4
	addq.w	#1,d1

	move.w	(a1),d2
	lsl.w	#5,d1
	add.w	d2,d1
	tst.b	0(a4,d1.w)
	beq.s	no_blue1
	
	move.w	(a3),d1
	move.w	d1,d2
	move.w	(a2),d3
	and.w	#$100F,d2
	and.w	#$100F,d3
	cmp.w	d3,d4
	beq.s	no_blue1

	move.w	d1,d2
	and.w	#$1000,d2
	bne.s	rm31
	
	or.w	#$1000,(a3)
	bra.s	no_blue1
	
rm31	add.w	#$0001,d1
	and.w	#$EFFF,d1
	move.w	d1,(a3)

no_blue1
	addq.w	#2,a2
	addq.w	#2,a3
	dbf	d0,floop2

	move.w	(a1),d0
	addq.w	#1,d0
	and.w	#$1F,d0
	bne.s	do_it_now2
	
	clr.l	-4(a0)
	move.w	#$FFFF,(a1)
	rts

do_it_now2
	move.w	d0,(a1)
	rts
	
CLEAR_FIX:
	lea	$3C0002,a0
	move.w	#1727,d0
	move.w	#1,2(a0)
	move.w	#$7002,-2(a0)
	
.clear_fix
	move.w	#$00FF,(a0)
	dbf	d0,.clear_fix	
	rts

CLEAR_SPR:
	lea	$3C0002,a0
	move.w	#1,2(a0)

	move.w	#12287,d0
	move.w	#$0000,-2(a0)
.clear_spr1
	move.w	#$0000,(a0)
	move.w	#$0000,(a0)
	dbf	d0,.clear_spr1

	move.w	#383,d0
	move.w	#$8000,-2(a0)
.clear_spr2
	move.w	#$0000,(a0)
	dbf	d0,.clear_spr2

	move.w	#383,d0
	move.w	#$8200,-2(a0)
.clear_spr3
	move.w	#$0000,(a0)
	dbf	d0,.clear_spr3
	
	move.w	#383,d0
	move.w	#$8400,-2(a0)
.clear_spr4
	move.w	#$0000,(a0)
	dbf	d0,.clear_spr4
	rts

luciole_big
	dc.w	0
	dc.w	32
	dc.w	5	
	dc.w	$a0
	dc.w	$11F
	dc.w	3
	
	dc.w	90
	dc.w	70
	dc.w	2	
	dc.w	70
	dc.w	$11F
	dc.w	1

	dc.w	45
	dc.w	55
	dc.w	4	
	dc.w	250
	dc.w	$11F
	dc.w	2

luciole_small
	dc.w	0
	dc.w	20
	dc.w	5	
	dc.w	85
	dc.w	$15F
	dc.w	3
	
	dc.w	170
	dc.w	60
	dc.w	2	
	dc.w	45
	dc.w	$15F
	dc.w	1

	dc.w	45
	dc.w	50
	dc.w	3 	
	dc.w	250
	dc.w	$15F
	dc.w	2

	dc.w	60
	dc.w	35
	dc.w	4	
	dc.w	25
	dc.w	$15F
	dc.w	3

pas	dc.w	2
rx	dc.w	80
ry	dc.w	60
rz	dc.w	64
rz2	dc.w	4

boules	
	dc.w	0
	dc.w	0
	dc.w	0
	dc.w	0
	dc.w	0
	dc.w	0
	dc.w	$1D7
	dc.w	$1600
	
	dc.w	0
	dc.w	90
	dc.w	0
	dc.w	0
	dc.w	0
	dc.w	0
	dc.w	$1E3
	dc.w	$1700

	dc.w	0
	dc.w	180
	dc.w	0
	dc.w	0
	dc.w	0
	dc.w	0
	dc.w	$1EF
	dc.w	$1800

	dc.w	0
	dc.w	270
	dc.w	0
	dc.w	0
	dc.w	0
	dc.w	0
	dc.w	$1FB
	dc.w	$1900

pal	incbin	"d:\vip\intro.pal"
sin_cos	incbin	"c:\sin_cos.bin"

task_slots
	dcb.b	$40,0
	
fade_flag	dc.w	$FFFF
fade_offset	dc.l	0
fade_size	dc.l	2
fade_table	incbin	"d:\vip\fade_tbl.bin"

char_map
	dc.b	'a',0
	dc.b	'k',2
	dc.b	'u',4
	dc.b	'o',6
	dc.b	"'",8

	dc.b	'b',20
	dc.b	'l',22
	dc.b	'v',24
	dc.b	'1',26
	dc.b	'(',28
	
	dc.b	'c',40
	dc.b	'm',42
	dc.b	'w',44
	dc.b	'2',46
	dc.b	')',48
	
	dc.b	'd',60
	dc.b	'n',62
	dc.b	'x',64
	dc.b	'3',66
	dc.b	'.',68
	
	dc.b	'e',80
	dc.b	'o',82
	dc.b	'y',84
	dc.b	'4',86
	dc.b	'-',88
	
	dc.b	'f',100
	dc.b	'p',102
	dc.b	'z',104
	dc.b	'5',106
	dc.b	'_',108
	
	dc.b	'g',120
	dc.b	'q',122
	dc.b	' ',124
	dc.b	'6',126
	dc.b	'?',128
	
	dc.b	'h',140
	dc.b	'r',142
	dc.b	'!',144
	dc.b	'7',146
	dc.b	'%',148
	
	dc.b	'i',160
	dc.b	's',162
	dc.b	':',164
	dc.b	'8',166
	dc.b	'%',168
	
	dc.b	'j',180
	dc.b	't',182
	dc.b	'%',184
	dc.b	'9',186
	dc.b	'%',188
	
	dc.b	0,0

texte	dc.b	"supremacy is proud to present the first neogeo demo ever. done for the v.i.p 2 party in st priest near lyon. this is a very simple demo with only two screens but nothing was prepared before the party so i didn't have"
	dc.b	" much time to do better things. hope you enjoy it see you later !!!                 time to wrap                ",0
cur_txt	dc.l	0
cur_pos dc.w	0
cur_spr	dc.w	$1580
cur_dsp	dc.w	0

spr	incbin	"d:\vip\intro.spr"
