/*
        Plant.inc
        
        By Pelle Coltau onthe 22. dec. 2000
        
        All rights reserved and all that crap :)
        
        If you want to use - do it! (I hereby give my support to freeware)
        
        If you want to change it - ask me (E-mail: pcoltau@hotmail.com )
        
        
        Description of the variables (see PlantScene.pov for a scene-example):
        --------------------------------------------------------------------------------------------------------------------------------------
          Name            Type          Min.- and max.-      Default    Description
                                         suggestions
        --------------------------------------------------------------------------------------------------------------------------------------
          PlLeaves        Integer           1 - 200             4*      The number of leaves in the plant.
          PlRadius        Float           0.0 -  ~              1*      The minimum radius of the whole plant.
          PlTexture       Texture             ~                 **      The texture of the leaves.
          LeafLength      Float           0.1 -  ~              8*      The minimum length of each leaf.
          LeafWidth       Float           0.1 -  ~            0.5*      The minimum width of each leaf (at the bottom of the leaf).
          LeafSegments    Integer           5 - 100            40       The number of segments (4-sided-polygons or two triangles) in a leaf.
          LeafCurve       Degree          0.0 - 120             0       The minimum curving/bending a leaf.
          LeafLean        Degree          0.0 -  90             0       The minimum leaning of a leaf.
          RanLen          Boolean             ~               false     Is randomizing in each leafs height on?
          RanWid          Boolean             ~               false     Is randomizing in each leafs width on?    
          RanCur          Boolean             ~               false     Is randomizing in each leafs curving on?
          RanLean         Boolean             ~               false     Is randomizing in the leaning of the leaves on?
          RanLeaSpread    Boolean             ~               false     Is randomizing in the dispositioning of the leaves on?
          RanPlRad        Boolean             ~               false     Is randomizing in the radius of the whole plant?
          RanAmLen        Float           0.1 -  ~              0       The amount of randomizing in the length of each leaf.
          RanAmWid        Float           0.1 -  ~              0       The amount of randomizing in width.
          RanAmCur        Float           0.1 -  ~              0       The amount of randomizing in curving.
          RanAmLean       Float           0.1 -  ~              0       The amount of randomizing in the leaning of the leaves.
          RanAmLeaSpread  Float           0.1 -  ~              0       The amount of randomizing in the dispositioning of the leaves.
          RanAmPlRad      Float           0.1 -  ~              0       The amount of randomizing in the width of the plant.
          RandomSeed      Integer          0  -  ~              0       The seed for the random-generator (any number).
          NoMsg           Boolean             ~               false     Do you want a message if something is wrong or missing?
        --------------------------------------------------------------------------------------------------------------------------------------
          Explenation:
        --------------------------------------------------------------------------------------------------------------------------------------
          Integer:        Whole numbers       (1,2,3 etc.)
          Float           Decimal numbers     (0.1 , 3.14 , 42.0 etc.)
          Boolean:        True or false
          Texture         That you have to know :) (see POVRay documentation)
          ~               Unknown/not defined.
          *               This has to be declared.                 
          **              The default texture is defined like this:
          
                            #declare PlTexture = texture{
                              pigment { color <0.86,0.58,0.44>*0.4+<0.14,0.56,0.14>*(rand(s)/4+0.5)*0.8 }
                              normal { wrinkles 0.25 scale 0.1 }                          ^
                              finish { specular 0.2 roughness 0.25 }                      |
                            }                                                             |
                                                                                          |
                            where                                                         |
                                                                                          |
                                s                is seed(RandomSeed) ---------------------'
                                <0.86,0.58,0.44> is a brown color with hint of yellow (like 'Tan' in 'color.inc').
                                <0.14,0.56,0.14> is a green color (like 'ForestGreen' in 'color.inc').
        --------------------------------------------------------------------------------------------------------------------------------------


        /Pelle Coltau

*/

#ifndef (NoMsg)
  #declare NoMsg = false;
#end

// **** Brag ****

#if (NoMsg = false) 
  #ifndef (Brag)      #debug "\n*******************************************************\n" 
                    #debug "Plant.inc was made by Pelle Coltau on the 22. dec. 2000\n"
  #end
#end

// **** Errors msg ****

#ifndef (PlLeaves)
  #if (NoMsg = false) #warning "Warning! You have to define a number to PlLeaves (the number of leaves in the plant)     - PlLeaves is now: 4\n" #end
  #declare PlLeaves = 4;
#end

#ifndef (PlRadius)
  #if (NoMsg = false) #warning "Warning! You have to define a number to PlRadius (the minimum radius of the whole plant) - PlRadius is now: 1\n" #end
  #declare PlRadius = 1;
#end

#ifndef (LeafLength)
  #if (NoMsg = false) #warning "Warning! You have to define a number to LeafLength (the minimum length of each leaf)     - LeafLength is now: 8\n" #end
  #declare LeafLength = 8;
#end

#ifndef (LeafWidth)
  #if (NoMsg = false) #warning "Warning! You have to define a number to LeafWidth (the minimum width of each leaf)       - LeafWidth is now: 0.5\n" #end
  #declare LeafWidth = 0.5;
#end

// **** Not errors - but something is missing ****

#ifndef (LeafCurve)
  #if (NoMsg = false) #warning "You should define a number to LeafCurve (the minimum curving/bending of a leaf).\n" #end
  #declare LeafCurve = 0;
#end
                                                                                                                             
#ifndef (LeafLean)
  #if (NoMsg = false) #warning "You should define a number to LeafLean (the minimum leaning of a leaf).\n" #end
  #declare LeafLean = 0;
#end

#ifndef (RanLen)
  #declare RanLen = false;
#else
  #if (RanLen = true)
    #ifndef (RanAmLen)
      #if (NoMsg = false) #warning "You have defined RanLen as true, so you should also define RanAmLen (amount of random in leaf-length). - RanAmLen is now: 0\n" #end
      #declare RanAmLen = 0;
    #end
  #end
#end

#ifndef (RanWid)
  #declare RanWid = false;
#else
  #if (RanWid = true)
    #ifndef (RanAmWid)
      #if (NoMsg = false) #warning "You have defined RanWid as true, so you should also define RanAmWid (amount of random in leaf-width). - RanAmWid is now: 0\n" #end
      #declare RanAmWid = 0;
    #end
  #end
#end

#ifndef (RanCur)
  #declare RanCur = false;
#else
  #if (RanCur = true)
    #ifndef (RanAmCur)
      #if (NoMsg = false) #warning "You have defined RanCur as true, so you should also define RanAmCur (amount of random in leaf-curving).\n"
                          #warning " - RanAmCur is now: 0\n" #end
      #declare RanAmCur = 0;
    #end
  #end
#end

#ifndef (RanCur)
  #declare RanCur = false;
#else
  #if (RanCur = true)
    #ifndef (RanAmCur)
      #if (NoMsg = false) #warning "You have defined RanCur as true, so you should also define RanAmCur (amount of random in leaf-curving).\n"
                          #warning " - RanAmCur is now: 0\n" #end
      #declare RanAmCur = 0;
    #end
  #end
#end

#ifndef (RanLean)
  #declare RanLean = false;
#else
  #if (RanLean = true)
    #ifndef (RanAmLean)
      #if (NoMsg = false) #warning "You have defined RanLean as true, so you should also define RanAmLean (amount of random in leaf-leaning).\n"
                          #warning " - RanAmLean is now: 0\n" #end
      #declare RanAmLean = 0;
    #end
  #end
#end

#ifndef (RanLeaSpread)
  #declare RanLeaSpread = false;
#else
  #if (RanLeaSpread = true)
    #ifndef (RanAmLeaSpread)
      #if (NoMsg = false) #warning "You have defined RanLeaSpread as true, so you should also define RanAmLeaSpread (amount of random in leaf-spreading).\n"
                          #warning " - RanAmLeaSpread is now: 0\n" #end
      #declare RanAmLeaSpread = 0;
    #end
  #end
#end

#ifndef (RanPlRad)
  #declare RanPlRad = false;
#else
  #if (RanPlRad = true)
    #ifndef (RanAmPlRad)
      #if (NoMsg = false) #warning "You have defined RanPlRad as true, so you should also define RanAmPlRad (amount of random in plant-radius).\n"
                          #warning " - RanAmPlRad is now: 0\n" #end
      #declare RanAmPlRad = 0;
    #end
  #end
#end

#if (NoMsg = false)
  #ifndef (Brag)      #debug "*******************************************************\n"  #end
#end

#declare Brag = true;

// **** Reading and setting of variables... ****

#ifndef (LeafSegments)
  #declare LeafSegments = 40;
#end
                                                                                                                             
#ifndef (RandomSeed)
  #declare RandomSeed = 0;
#end

#declare s = seed(RandomSeed);

#ifndef (PlTexture)
  #declare PlTexture = texture{
    pigment { color <0.86,0.58,0.44>*0.4+<0.14,0.56,0.14>*(rand(s)/4+0.5)*0.8 }
    normal { wrinkles 0.25 scale 0.1 }
    finish { specular 0.2 roughness 0.25 }
  }
#end 

#declare LNum = 1;    

#declare Plant = union {

#while (LNum <= PlLeaves)           
  #if (RanLen = true)
    #declare rl = rand(s)*RanAmLen;
  #else                                                   
    #declare rl = 0;    
  #end
  #if (RanWid = true)
    #declare rw = rand(s)*RanAmWid;
  #else                                                   
    #declare rw = 0;    
  #end
  #if (RanCur = true)
    #declare rc = rand(s)*RanAmCur;
  #else                                                   
    #declare rc = 0;    
  #end
  #if (RanLeaSpread = true)
    #declare rl = rand(s)*RanAmLeaSpread;
  #else                                                   
    #declare rl = 0;    
  #end
  #if (RanLean = true)
    #declare re = rand(s)*RanAmLean;
  #else                                                   
    #declare re = 0;    
  #end
  #if (RanPlRad = true)
    #declare rr = rand(s)*RanAmPlRad;
  #else                                                   
    #declare rr = 0;    
  #end
  
  #declare SNum = 1;
  #declare Height = LeafLength + rl;
  #declare Width = LeafWidth + rw;
  #declare Curve = (LeafCurve + rc)*1.5;
  #declare Lean = LeafLean + re;
  #declare Rad = PlRadius + rr;
  #declare Segments = LeafSegments;
  
// **** The Math! ****
  
  mesh {
    #while (SNum <= Segments)           
      #declare THei = (Height/Segments);         // The height of the triangle.
      #declare TTop = ((Height/Segments)*SNum);   // The top of the triangle.      
      #declare NWid = (Width/2);                   // New Width
      #declare X = TTop*(10/Height);
      #declare TWidT = NWid-NWid*(0.03*X*sqrt(X));   // Width of triangle at top.
      #declare X = (TTop-THei)*(10/Height);
      #declare TWidB = NWid-NWid*(0.03*X*sqrt(X));   // Width of triangle at bottom.     
      #declare TCurTz = sin((Curve/(90*pi))*(TTop/Height))*TTop;    // The bending of the triangle at the top.
      #declare TCurBz = sin((Curve/(90*pi))*((TTop-THei)/Height))*(TTop-THei); // The bending of the triangle at the bottom.
      #declare TCurTy = cos((Curve/(45*pi))*(TTop/Height));    // The curving of the triangle in the height (at the top of the triangle).
      #declare TCurBy = cos((Curve/(45*pi))*((TTop-THei)/Height)); // The curving of the triangle in the height (at the bottom of the triangle).
      triangle { <-TWidB,(TTop-THei)*TCurBy,TCurBz>, <TWidB,(TTop-THei)*TCurBy,TCurBz>, <-TWidT,TTop*TCurTy,TCurTz> }
      triangle { < TWidB,(TTop-THei)*TCurBy,TCurBz>, <TWidT,TTop*TCurTy       ,TCurTz>, <-TWidT,TTop*TCurTy,TCurTz> } 
      #declare SNum = SNum + 1;
    #end              
    rotate x*Lean
    translate z*Rad
    rotate y*360*((LNum/PlLeaves)+rand(s)*rl)
    texture{ PlTexture }
  }
  #declare LNum = LNum + 1;
#end
}

// **** End of file ****