// ***************    
// ** Main file **
// ***************

// **** Settings ****

global_settings { max_trace_level 20 }

// **** Main includes ****

#include "MS_Tex.inc"
#include "MS_Includes.inc"
#include "MS_Media.inc"
#include "MS_Obj.inc"

// **** Objects in scene ****

object { WaterBed              translate y*0.2 }                                                         
object { Hills    rotate y*180 translate <175,-13,2200> }
object { Shore }   

object { Meteor01                       translate <  -4,  0.5,  10> no_shadow }
object { Meteor01           rotate z*10 translate <   7,  2.0,  15> no_shadow }
object { Meteor02           rotate z*40 translate <   5,  0.5,  20> no_shadow }
object { Meteor03           rotate z*10 translate < -15,  4.0,  20> no_shadow }
object { Meteor03 scale 0.8 rotate z*30 translate < -10,  8.0,  40> no_shadow }
object { Meteor03 scale 0.9 rotate z*25 translate <   4, 21.0,  40> no_shadow }
object { Meteor03           rotate z*5  translate < -25, 20.0,  75> no_shadow }
object { Meteor03           rotate z*15 translate < -60, 40.0, 100> no_shadow }
object { Meteor03           rotate z*35 translate < -50, 10.0, 100> no_shadow }
object { Meteor03           rotate z*25 translate <  10,  6.0,  60> no_shadow }
object { Meteor03           rotate z*15 translate <  60, 16.0, 100> no_shadow }
  
object { Plant01 scale 0.3 translate <2,0.06,-3> }
object { Plant01 rotate y*135 scale 0.3 translate <-2.2,0.06,-2.85> }
object { Plant02 scale 0.3 translate <0,0.14,-3.3> }
object { Plant02 scale 0.25 translate <-1,0.12,-3.5> }
object { Plant03 scale 0.2 translate <1,0.15,-3.5> }
object { Plant04 scale 0.2 translate <-2,0.25,-3.8> }

object { Turtle01 scale 0.02 rotate y*190 translate <-0.9,0.4,-3.3> }
object { Turtle02 scale 0.018 rotate z*-20 rotate y*170 translate <-0.655,0.4,-3.3> }

object { Flag rotate -20*z translate <-0.7,0.25,-3.16> }

object { WaterSquirt01 }
object { WaterSquirt02 }

sky_sphere { Sky }

// **** Common ****

camera { 
  location <0,2,-7> 
  look_at <0,2,0> 
//  aperture 0.15
//  blur_samples 20
//  focal_point <0,2,5>
} 

light_source { <0,20,-50> rgb 1 }
         
// **** End of file ****