/*
 * Decompiled with CFR 0.152.
 */
package org.komplex.audio.device;

import com.ms.directX.DSBufferDesc;
import com.ms.directX.DSCaps;
import com.ms.directX.DSCursors;
import com.ms.directX.DirectSound;
import com.ms.directX.DirectSoundBuffer;
import com.ms.directX.DirectXConstants;
import com.ms.directX.WaveFormatEx;
import java.awt.Component;
import org.komplex.audio.AudioDataConverter;
import org.komplex.audio.AudioException;
import org.komplex.audio.AudioOutDevice;
import org.komplex.audio.BaseDevice;

public class MiniDirectSoundDevice
extends BaseDevice
implements Runnable,
DirectXConstants,
AudioOutDevice {
    static final int BUFSIZE = 8192;
    Thread mixer;
    AudioDataConverter ac;
    private DirectSound ds;
    private DirectSoundBuffer dsBuffer;
    private DirectSoundBuffer dsBuffer_primary;
    private DSCaps dsCaps;
    DSCursors dsc = new DSCursors();
    int len = 8192 / this.splitAm;
    int splitAm = 8;
    int[] buffer;
    int[] bufferEmpty;
    byte[] buffer8;

    public void stop() {
        this.mixer = null;
    }

    public void initDS(Component component) throws AudioException {
        this.ds = new DirectSound();
        this.ds.setCooperativeLevel(component, 2);
        WaveFormatEx wf = this.getWaveFormatEx();
        DSBufferDesc m_dsBufferDesc = null;
        try {
            m_dsBufferDesc = new DSBufferDesc();
            m_dsBufferDesc.flags = 1;
            m_dsBufferDesc.bufferBytes = 0;
            this.dsBuffer_primary = this.ds.createSoundBuffer(m_dsBufferDesc, null);
            this.dsBuffer_primary.setFormat(wf);
            this.dsCaps = new DSCaps();
            this.ds.getCaps(this.dsCaps);
            m_dsBufferDesc = new DSBufferDesc();
            m_dsBufferDesc.flags = 16384;
            m_dsBufferDesc.bufferBytes = this.buffer8.length;
            this.dsBuffer = this.ds.createSoundBuffer(m_dsBufferDesc, wf);
        }
        catch (Exception e2) {
            throw new AudioException(e2.toString());
        }
    }

    public void copyBuffer(int pos) {
        int bytesPerSample = this.getSampleSize();
        this.dsBuffer.writeBuffer(pos * bytesPerSample * this.buffer.length, this.buffer.length * bytesPerSample, this.buffer8, 0);
    }

    int getCurrentPosition() {
        this.dsBuffer.getCurrentPosition(this.dsc);
        return this.dsc.play;
    }

    public void play() {
        if (this.dsBuffer_primary != null) {
            this.dsBuffer_primary.play(1);
        }
        this.dsBuffer.play(1);
    }

    protected WaveFormatEx getWaveFormatEx() {
        WaveFormatEx wf = new WaveFormatEx();
        wf.bitsPerSample = this.getBits();
        wf.channels = this.getChannels();
        wf.blockAlign = this.getSampleSize();
        wf.samplesPerSec = this.getSampleRate();
        wf.avgBytesPerSec = this.getSampleRate() * this.getSampleSize();
        wf.formatTag = 1;
        wf.extra = null;
        wf.size = 0;
        return wf;
    }

    void initMixingBuffers() {
        this.buffer = new int[this.len];
        this.bufferEmpty = new int[this.len];
        this.buffer8 = new byte[this.len * this.getSampleSize() * this.splitAm];
    }

    public void start() throws AudioException {
        if (this.mixer == null) {
            this.mixer = new Thread(this);
            this.mixer.start();
            this.mixer.setPriority(10);
        }
    }

    public void run() {
        try {
            this.play();
            int bytesPerSample = this.getSampleSize();
            while (this.mixer != null) {
                int i2 = 0;
                while (i2 < this.splitAm) {
                    int playPos;
                    if (this.source != null) {
                        this.source.read(this.buffer, 0, this.buffer.length);
                        this.ac.convert(this.buffer, 0, this.buffer8, i2 * this.buffer.length * bytesPerSample, this.buffer.length);
                    }
                    int bufferPos = i2 * this.len;
                    int nextPos = (i2 + 1) * this.len;
                    while ((playPos = this.getCurrentPosition()) <= nextPos * bytesPerSample && playPos >= bufferPos * bytesPerSample) {
                        int time = (nextPos - playPos / bytesPerSample) * 1000 / this.getSampleRate();
                        if ((time += 5) < 5) {
                            time = 5;
                        }
                        Thread.sleep(time);
                    }
                    this.copyBuffer(i2);
                    ++i2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void init(int n2, Component component) throws AudioException {
        try {
            this.setFormat(n2);
            this.initMixingBuffers();
            this.initDS(component);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new AudioException(e2.toString());
        }
        this.ac = AudioDataConverter.getConverter(this.getFormat());
    }
}

