/*
 * Decompiled with CFR 0.152.
 */
package org.komplex.audio;

import java.util.Dictionary;
import org.komplex.audio.AudioException;
import org.komplex.audio.AudioOutDevice;
import org.komplex.audio.PullAudioSource;

public abstract class BaseDevice
implements AudioOutDevice {
    protected PullAudioSource source;
    int formatID;

    public abstract void stop();

    public int getEncoding() {
        return this.formatID & 0x880;
    }

    public int getFormat() {
        return this.formatID;
    }

    public int setFormat(int n2) {
        this.formatID = n2;
        return this.getFormat();
    }

    public int getSampleSize() {
        return this.getBits() / 8 * this.getChannels();
    }

    public int getSampleRate() {
        switch (this.formatID & 0x1F) {
            case 16: {
                return 44100;
            }
            case 17: {
                return 22050;
            }
            case 18: {
                return 11025;
            }
            case 19: {
                return 8000;
            }
        }
        return 0;
    }

    public abstract void start() throws AudioException;

    public void setProperties(Dictionary d2) {
    }

    public int getBits() {
        switch (this.formatID & 0x440) {
            case 1024: {
                return 8;
            }
            case 1088: {
                return 16;
            }
        }
        return 0;
    }

    public void init(int n2) throws AudioException {
        this.setFormat(n2);
    }

    public int getChannels() {
        switch (this.formatID & 0x220) {
            case 512: {
                return 1;
            }
            case 544: {
                return 2;
            }
        }
        return 0;
    }

    public void setPullSource(PullAudioSource p2) {
        this.source = p2;
    }
}

