/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;

public class Vector3f
extends Tuple3f
implements Serializable {
    static final long serialVersionUID = -7031930069184524614L;

    public Vector3f() {
    }

    public Vector3f(float f2, float f3, float f4) {
        super(f2, f3, f4);
    }

    public Vector3f(Tuple3d tuple3d) {
        super(tuple3d);
    }

    public Vector3f(Tuple3f tuple3f) {
        super(tuple3f);
    }

    public Vector3f(Vector3d vector3d) {
        super(vector3d);
    }

    public Vector3f(Vector3f vector3f) {
        super(vector3f);
    }

    public Vector3f(float[] fArray) {
        super(fArray);
    }

    public final float angle(Vector3f vector3f) {
        double d2 = this.dot(vector3f) / (this.length() * vector3f.length());
        if (d2 < -1.0) {
            d2 = -1.0;
        }
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        return (float)Math.acos(d2);
    }

    public final void cross(Vector3f vector3f, Vector3f vector3f2) {
        float f2 = vector3f.y * vector3f2.z - vector3f.z * vector3f2.y;
        float f3 = vector3f2.x * vector3f.z - vector3f2.z * vector3f.x;
        this.z = vector3f.x * vector3f2.y - vector3f.y * vector3f2.x;
        this.x = f2;
        this.y = f3;
    }

    public final float dot(Vector3f vector3f) {
        return this.x * vector3f.x + this.y * vector3f.y + this.z * vector3f.z;
    }

    public final float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public final float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final void normalize() {
        float f2 = (float)(1.0 / Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z));
        this.x *= f2;
        this.y *= f2;
        this.z *= f2;
    }

    public final void normalize(Vector3f vector3f) {
        float f2 = (float)(1.0 / Math.sqrt(vector3f.x * vector3f.x + vector3f.y * vector3f.y + vector3f.z * vector3f.z));
        this.x = vector3f.x * f2;
        this.y = vector3f.y * f2;
        this.z = vector3f.z * f2;
    }
}

