/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4d;
import javax.vecmath.Quat4f;
import javax.vecmath.SingularMatrixException;
import javax.vecmath.Tuple4f;
import javax.vecmath.VecMathI18N;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;

public class Matrix4f
implements Serializable {
    static final long serialVersionUID = -8405036035410109353L;
    public float m00;
    public float m01;
    public float m02;
    public float m03;
    public float m10;
    public float m11;
    public float m12;
    public float m13;
    public float m20;
    public float m21;
    public float m22;
    public float m23;
    public float m30;
    public float m31;
    public float m32;
    public float m33;
    double[] tmp = new double[9];
    double[] tmp_scale = new double[3];
    double[] tmp_rot = new double[9];
    private static final double EPS = 1.0E-8;

    public Matrix4f() {
        this.m00 = 0.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 0.0f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 0.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 0.0f;
    }

    public Matrix4f(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17) {
        this.m00 = f2;
        this.m01 = f3;
        this.m02 = f4;
        this.m03 = f5;
        this.m10 = f6;
        this.m11 = f7;
        this.m12 = f8;
        this.m13 = f9;
        this.m20 = f10;
        this.m21 = f11;
        this.m22 = f12;
        this.m23 = f13;
        this.m30 = f14;
        this.m31 = f15;
        this.m32 = f16;
        this.m33 = f17;
    }

    public Matrix4f(Matrix3f matrix3f, Vector3f vector3f, float f2) {
        this.m00 = matrix3f.m00 * f2;
        this.m01 = matrix3f.m01 * f2;
        this.m02 = matrix3f.m02 * f2;
        this.m03 = vector3f.x;
        this.m10 = matrix3f.m10 * f2;
        this.m11 = matrix3f.m11 * f2;
        this.m12 = matrix3f.m12 * f2;
        this.m13 = vector3f.y;
        this.m20 = matrix3f.m20 * f2;
        this.m21 = matrix3f.m21 * f2;
        this.m22 = matrix3f.m22 * f2;
        this.m23 = vector3f.z;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public Matrix4f(Matrix4d matrix4d) {
        this.m00 = (float)matrix4d.m00;
        this.m01 = (float)matrix4d.m01;
        this.m02 = (float)matrix4d.m02;
        this.m03 = (float)matrix4d.m03;
        this.m10 = (float)matrix4d.m10;
        this.m11 = (float)matrix4d.m11;
        this.m12 = (float)matrix4d.m12;
        this.m13 = (float)matrix4d.m13;
        this.m20 = (float)matrix4d.m20;
        this.m21 = (float)matrix4d.m21;
        this.m22 = (float)matrix4d.m22;
        this.m23 = (float)matrix4d.m23;
        this.m30 = (float)matrix4d.m30;
        this.m31 = (float)matrix4d.m31;
        this.m32 = (float)matrix4d.m32;
        this.m33 = (float)matrix4d.m33;
    }

    public Matrix4f(Matrix4f matrix4f) {
        this.m00 = matrix4f.m00;
        this.m01 = matrix4f.m01;
        this.m02 = matrix4f.m02;
        this.m03 = matrix4f.m03;
        this.m10 = matrix4f.m10;
        this.m11 = matrix4f.m11;
        this.m12 = matrix4f.m12;
        this.m13 = matrix4f.m13;
        this.m20 = matrix4f.m20;
        this.m21 = matrix4f.m21;
        this.m22 = matrix4f.m22;
        this.m23 = matrix4f.m23;
        this.m30 = matrix4f.m30;
        this.m31 = matrix4f.m31;
        this.m32 = matrix4f.m32;
        this.m33 = matrix4f.m33;
    }

    public Matrix4f(Quat4f quat4f, Vector3f vector3f, float f2) {
        this.m00 = (float)((double)f2 * (1.0 - 2.0 * (double)quat4f.y * (double)quat4f.y - 2.0 * (double)quat4f.z * (double)quat4f.z));
        this.m10 = (float)((double)f2 * (2.0 * (double)(quat4f.x * quat4f.y + quat4f.w * quat4f.z)));
        this.m20 = (float)((double)f2 * (2.0 * (double)(quat4f.x * quat4f.z - quat4f.w * quat4f.y)));
        this.m01 = (float)((double)f2 * (2.0 * (double)(quat4f.x * quat4f.y - quat4f.w * quat4f.z)));
        this.m11 = (float)((double)f2 * (1.0 - 2.0 * (double)quat4f.x * (double)quat4f.x - 2.0 * (double)quat4f.z * (double)quat4f.z));
        this.m21 = (float)((double)f2 * (2.0 * (double)(quat4f.y * quat4f.z + quat4f.w * quat4f.x)));
        this.m02 = (float)((double)f2 * (2.0 * (double)(quat4f.x * quat4f.z + quat4f.w * quat4f.y)));
        this.m12 = (float)((double)f2 * (2.0 * (double)(quat4f.y * quat4f.z - quat4f.w * quat4f.x)));
        this.m22 = (float)((double)f2 * (1.0 - 2.0 * (double)quat4f.x * (double)quat4f.x - 2.0 * (double)quat4f.y * (double)quat4f.y));
        this.m03 = vector3f.x;
        this.m13 = vector3f.y;
        this.m23 = vector3f.z;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public Matrix4f(float[] fArray) {
        this.m00 = fArray[0];
        this.m01 = fArray[1];
        this.m02 = fArray[2];
        this.m03 = fArray[3];
        this.m10 = fArray[4];
        this.m11 = fArray[5];
        this.m12 = fArray[6];
        this.m13 = fArray[7];
        this.m20 = fArray[8];
        this.m21 = fArray[9];
        this.m22 = fArray[10];
        this.m23 = fArray[11];
        this.m30 = fArray[12];
        this.m31 = fArray[13];
        this.m32 = fArray[14];
        this.m33 = fArray[15];
    }

    public final void add(float f2) {
        this.m00 += f2;
        this.m01 += f2;
        this.m02 += f2;
        this.m03 += f2;
        this.m10 += f2;
        this.m11 += f2;
        this.m12 += f2;
        this.m13 += f2;
        this.m20 += f2;
        this.m21 += f2;
        this.m22 += f2;
        this.m23 += f2;
        this.m30 += f2;
        this.m31 += f2;
        this.m32 += f2;
        this.m33 += f2;
    }

    public final void add(float f2, Matrix4f matrix4f) {
        this.m00 = matrix4f.m00 + f2;
        this.m01 = matrix4f.m01 + f2;
        this.m02 = matrix4f.m02 + f2;
        this.m03 = matrix4f.m03 + f2;
        this.m10 = matrix4f.m10 + f2;
        this.m11 = matrix4f.m11 + f2;
        this.m12 = matrix4f.m12 + f2;
        this.m13 = matrix4f.m13 + f2;
        this.m20 = matrix4f.m20 + f2;
        this.m21 = matrix4f.m21 + f2;
        this.m22 = matrix4f.m22 + f2;
        this.m23 = matrix4f.m23 + f2;
        this.m30 = matrix4f.m30 + f2;
        this.m31 = matrix4f.m31 + f2;
        this.m32 = matrix4f.m32 + f2;
        this.m33 = matrix4f.m33 + f2;
    }

    public final void add(Matrix4f matrix4f) {
        this.m00 += matrix4f.m00;
        this.m01 += matrix4f.m01;
        this.m02 += matrix4f.m02;
        this.m03 += matrix4f.m03;
        this.m10 += matrix4f.m10;
        this.m11 += matrix4f.m11;
        this.m12 += matrix4f.m12;
        this.m13 += matrix4f.m13;
        this.m20 += matrix4f.m20;
        this.m21 += matrix4f.m21;
        this.m22 += matrix4f.m22;
        this.m23 += matrix4f.m23;
        this.m30 += matrix4f.m30;
        this.m31 += matrix4f.m31;
        this.m32 += matrix4f.m32;
        this.m33 += matrix4f.m33;
    }

    public final void add(Matrix4f matrix4f, Matrix4f matrix4f2) {
        this.m00 = matrix4f.m00 + matrix4f2.m00;
        this.m01 = matrix4f.m01 + matrix4f2.m01;
        this.m02 = matrix4f.m02 + matrix4f2.m02;
        this.m03 = matrix4f.m03 + matrix4f2.m03;
        this.m10 = matrix4f.m10 + matrix4f2.m10;
        this.m11 = matrix4f.m11 + matrix4f2.m11;
        this.m12 = matrix4f.m12 + matrix4f2.m12;
        this.m13 = matrix4f.m13 + matrix4f2.m13;
        this.m20 = matrix4f.m20 + matrix4f2.m20;
        this.m21 = matrix4f.m21 + matrix4f2.m21;
        this.m22 = matrix4f.m22 + matrix4f2.m22;
        this.m23 = matrix4f.m23 + matrix4f2.m23;
        this.m30 = matrix4f.m30 + matrix4f2.m30;
        this.m31 = matrix4f.m31 + matrix4f2.m31;
        this.m32 = matrix4f.m32 + matrix4f2.m32;
        this.m33 = matrix4f.m33 + matrix4f2.m33;
    }

    public final float determinant() {
        float f2 = this.m00 * (this.m11 * this.m22 * this.m33 + this.m12 * this.m23 * this.m31 + this.m13 * this.m21 * this.m32 - this.m13 * this.m22 * this.m31 - this.m11 * this.m23 * this.m32 - this.m12 * this.m21 * this.m33);
        f2 -= this.m01 * (this.m10 * this.m22 * this.m33 + this.m12 * this.m23 * this.m30 + this.m13 * this.m20 * this.m32 - this.m13 * this.m22 * this.m30 - this.m10 * this.m23 * this.m32 - this.m12 * this.m20 * this.m33);
        f2 += this.m02 * (this.m10 * this.m21 * this.m33 + this.m11 * this.m23 * this.m30 + this.m13 * this.m20 * this.m31 - this.m13 * this.m21 * this.m30 - this.m10 * this.m23 * this.m31 - this.m11 * this.m20 * this.m33);
        return f2 -= this.m03 * (this.m10 * this.m21 * this.m32 + this.m11 * this.m22 * this.m30 + this.m12 * this.m20 * this.m31 - this.m12 * this.m21 * this.m30 - this.m10 * this.m22 * this.m31 - this.m11 * this.m20 * this.m32);
    }

    public boolean epsilonEquals(Matrix4f matrix4f, float f2) {
        boolean bl = true;
        if (Math.abs(this.m00 - matrix4f.m00) > f2) {
            bl = false;
        }
        if (Math.abs(this.m01 - matrix4f.m01) > f2) {
            bl = false;
        }
        if (Math.abs(this.m02 - matrix4f.m02) > f2) {
            bl = false;
        }
        if (Math.abs(this.m03 - matrix4f.m03) > f2) {
            bl = false;
        }
        if (Math.abs(this.m10 - matrix4f.m10) > f2) {
            bl = false;
        }
        if (Math.abs(this.m11 - matrix4f.m11) > f2) {
            bl = false;
        }
        if (Math.abs(this.m12 - matrix4f.m12) > f2) {
            bl = false;
        }
        if (Math.abs(this.m13 - matrix4f.m13) > f2) {
            bl = false;
        }
        if (Math.abs(this.m20 - matrix4f.m20) > f2) {
            bl = false;
        }
        if (Math.abs(this.m21 - matrix4f.m21) > f2) {
            bl = false;
        }
        if (Math.abs(this.m22 - matrix4f.m22) > f2) {
            bl = false;
        }
        if (Math.abs(this.m23 - matrix4f.m23) > f2) {
            bl = false;
        }
        if (Math.abs(this.m30 - matrix4f.m30) > f2) {
            bl = false;
        }
        if (Math.abs(this.m31 - matrix4f.m31) > f2) {
            bl = false;
        }
        if (Math.abs(this.m32 - matrix4f.m32) > f2) {
            bl = false;
        }
        if (Math.abs(this.m33 - matrix4f.m33) > f2) {
            bl = false;
        }
        return bl;
    }

    public boolean equals(Object object) {
        try {
            Matrix4f matrix4f = (Matrix4f)object;
            return this.m00 == matrix4f.m00 && this.m01 == matrix4f.m01 && this.m02 == matrix4f.m02 && this.m03 == matrix4f.m03 && this.m10 == matrix4f.m10 && this.m11 == matrix4f.m11 && this.m12 == matrix4f.m12 && this.m13 == matrix4f.m13 && this.m20 == matrix4f.m20 && this.m21 == matrix4f.m21 && this.m22 == matrix4f.m22 && this.m23 == matrix4f.m23 && this.m30 == matrix4f.m30 && this.m31 == matrix4f.m31 && this.m32 == matrix4f.m32 && this.m33 == matrix4f.m33;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean equals(Matrix4f matrix4f) {
        try {
            return this.m00 == matrix4f.m00 && this.m01 == matrix4f.m01 && this.m02 == matrix4f.m02 && this.m03 == matrix4f.m03 && this.m10 == matrix4f.m10 && this.m11 == matrix4f.m11 && this.m12 == matrix4f.m12 && this.m13 == matrix4f.m13 && this.m20 == matrix4f.m20 && this.m21 == matrix4f.m21 && this.m22 == matrix4f.m22 && this.m23 == matrix4f.m23 && this.m30 == matrix4f.m30 && this.m31 == matrix4f.m31 && this.m32 == matrix4f.m32 && this.m33 == matrix4f.m33;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public final void get(Matrix3d matrix3d) {
        this.getScaleRotate(this.tmp_scale, this.tmp_rot);
        matrix3d.m00 = this.tmp_rot[0];
        matrix3d.m01 = this.tmp_rot[1];
        matrix3d.m02 = this.tmp_rot[2];
        matrix3d.m10 = this.tmp_rot[3];
        matrix3d.m11 = this.tmp_rot[4];
        matrix3d.m12 = this.tmp_rot[5];
        matrix3d.m20 = this.tmp_rot[6];
        matrix3d.m21 = this.tmp_rot[7];
        matrix3d.m22 = this.tmp_rot[8];
    }

    public final void get(Matrix3f matrix3f) {
        this.getScaleRotate(this.tmp_scale, this.tmp_rot);
        matrix3f.m00 = (float)this.tmp_rot[0];
        matrix3f.m01 = (float)this.tmp_rot[1];
        matrix3f.m02 = (float)this.tmp_rot[2];
        matrix3f.m10 = (float)this.tmp_rot[3];
        matrix3f.m11 = (float)this.tmp_rot[4];
        matrix3f.m12 = (float)this.tmp_rot[5];
        matrix3f.m20 = (float)this.tmp_rot[6];
        matrix3f.m21 = (float)this.tmp_rot[7];
        matrix3f.m22 = (float)this.tmp_rot[8];
    }

    public final float get(Matrix3f matrix3f, Vector3f vector3f) {
        this.getScaleRotate(this.tmp_scale, this.tmp_rot);
        matrix3f.m00 = (float)this.tmp_rot[0];
        matrix3f.m01 = (float)this.tmp_rot[1];
        matrix3f.m02 = (float)this.tmp_rot[2];
        matrix3f.m10 = (float)this.tmp_rot[3];
        matrix3f.m11 = (float)this.tmp_rot[4];
        matrix3f.m12 = (float)this.tmp_rot[5];
        matrix3f.m20 = (float)this.tmp_rot[6];
        matrix3f.m21 = (float)this.tmp_rot[7];
        matrix3f.m22 = (float)this.tmp_rot[8];
        vector3f.x = this.m03;
        vector3f.y = this.m13;
        vector3f.z = this.m23;
        return (float)Matrix3d.max3(this.tmp_scale);
    }

    public final void get(Quat4f quat4f) {
        this.getScaleRotate(this.tmp_scale, this.tmp_rot);
        double d2 = 0.25 * (1.0 + this.tmp_rot[0] + this.tmp_rot[4] + this.tmp_rot[8]);
        if (!((d2 < 0.0 ? -d2 : d2) < 1.0E-30)) {
            quat4f.w = (float)Math.sqrt(d2);
            d2 = 0.25 / (double)quat4f.w;
            quat4f.x = (float)((this.tmp_rot[7] - this.tmp_rot[5]) * d2);
            quat4f.y = (float)((this.tmp_rot[2] - this.tmp_rot[6]) * d2);
            quat4f.z = (float)((this.tmp_rot[3] - this.tmp_rot[1]) * d2);
            return;
        }
        quat4f.w = 0.0f;
        d2 = -0.5 * (this.tmp_rot[4] + this.tmp_rot[8]);
        if (!((d2 < 0.0 ? -d2 : d2) < 1.0E-30)) {
            quat4f.x = (float)Math.sqrt(d2);
            d2 = 0.5 / (double)quat4f.x;
            quat4f.y = (float)(this.tmp_rot[3] * d2);
            quat4f.z = (float)(this.tmp_rot[6] * d2);
            return;
        }
        quat4f.x = 0.0f;
        d2 = 0.5 * (1.0 - this.tmp_rot[8]);
        if (!((d2 < 0.0 ? -d2 : d2) < 1.0E-30)) {
            quat4f.y = (float)Math.sqrt(d2);
            quat4f.z = (float)(this.tmp_rot[7] / (2.0 * (double)quat4f.y));
            return;
        }
        quat4f.y = 0.0f;
        quat4f.z = 1.0f;
    }

    public final void get(Vector3f vector3f) {
        vector3f.x = this.m03;
        vector3f.y = this.m13;
        vector3f.z = this.m23;
    }

    public final void getColumn(int n2, Vector4f vector4f) {
        if (n2 == 0) {
            vector4f.x = this.m00;
            vector4f.y = this.m10;
            vector4f.z = this.m20;
            vector4f.w = this.m30;
        } else if (n2 == 1) {
            vector4f.x = this.m01;
            vector4f.y = this.m11;
            vector4f.z = this.m21;
            vector4f.w = this.m31;
        } else if (n2 == 2) {
            vector4f.x = this.m02;
            vector4f.y = this.m12;
            vector4f.z = this.m22;
            vector4f.w = this.m32;
        } else if (n2 == 3) {
            vector4f.x = this.m03;
            vector4f.y = this.m13;
            vector4f.z = this.m23;
            vector4f.w = this.m33;
        } else {
            throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4f4"));
        }
    }

    public final void getColumn(int n2, float[] fArray) {
        if (n2 == 0) {
            fArray[0] = this.m00;
            fArray[1] = this.m10;
            fArray[2] = this.m20;
            fArray[3] = this.m30;
        } else if (n2 == 1) {
            fArray[0] = this.m01;
            fArray[1] = this.m11;
            fArray[2] = this.m21;
            fArray[3] = this.m31;
        } else if (n2 == 2) {
            fArray[0] = this.m02;
            fArray[1] = this.m12;
            fArray[2] = this.m22;
            fArray[3] = this.m32;
        } else if (n2 == 3) {
            fArray[0] = this.m03;
            fArray[1] = this.m13;
            fArray[2] = this.m23;
            fArray[3] = this.m33;
        } else {
            throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4f4"));
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    public final float getElement(int n2, int n3) {
        switch (n2) {
            case 0: {
                switch (n3) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m01;
                    }
                    case 2: {
                        return this.m02;
                    }
                    case 3: {
                        return this.m03;
                    }
                    default: {
                        throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4f1"));
                    }
                }
            }
            case 1: {
                switch (n3) {
                    case 0: {
                        return this.m10;
                    }
                    case 1: {
                        return this.m11;
                    }
                    case 2: {
                        return this.m12;
                    }
                    case 3: {
                        return this.m13;
                    }
                    default: {
                        throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4f1"));
                    }
                }
            }
            case 2: {
                switch (n3) {
                    case 0: {
                        return this.m20;
                    }
                    case 1: {
                        return this.m21;
                    }
                    case 2: {
                        return this.m22;
                    }
                    case 3: {
                        return this.m23;
                    }
                    default: {
                        throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4f1"));
                    }
                }
            }
            case 3: {
                switch (n3) {
                    case 0: {
                        return this.m30;
                    }
                    case 1: {
                        return this.m31;
                    }
                    case 2: {
                        return this.m32;
                    }
                    case 3: {
                        return this.m33;
                    }
                }
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4f1"));
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4f1"));
            }
        }
    }

    public final void getRotationScale(Matrix3f matrix3f) {
        matrix3f.m00 = this.m00;
        matrix3f.m01 = this.m01;
        matrix3f.m02 = this.m02;
        matrix3f.m10 = this.m10;
        matrix3f.m11 = this.m11;
        matrix3f.m12 = this.m12;
        matrix3f.m20 = this.m20;
        matrix3f.m21 = this.m21;
        matrix3f.m22 = this.m22;
    }

    public final void getRow(int n2, Vector4f vector4f) {
        if (n2 == 0) {
            vector4f.x = this.m00;
            vector4f.y = this.m01;
            vector4f.z = this.m02;
            vector4f.w = this.m03;
        } else if (n2 == 1) {
            vector4f.x = this.m10;
            vector4f.y = this.m11;
            vector4f.z = this.m12;
            vector4f.w = this.m13;
        } else if (n2 == 2) {
            vector4f.x = this.m20;
            vector4f.y = this.m21;
            vector4f.z = this.m22;
            vector4f.w = this.m23;
        } else if (n2 == 3) {
            vector4f.x = this.m30;
            vector4f.y = this.m31;
            vector4f.z = this.m32;
            vector4f.w = this.m33;
        } else {
            throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4f2"));
        }
    }

    public final void getRow(int n2, float[] fArray) {
        if (n2 == 0) {
            fArray[0] = this.m00;
            fArray[1] = this.m01;
            fArray[2] = this.m02;
            fArray[3] = this.m03;
        } else if (n2 == 1) {
            fArray[0] = this.m10;
            fArray[1] = this.m11;
            fArray[2] = this.m12;
            fArray[3] = this.m13;
        } else if (n2 == 2) {
            fArray[0] = this.m20;
            fArray[1] = this.m21;
            fArray[2] = this.m22;
            fArray[3] = this.m23;
        } else if (n2 == 3) {
            fArray[0] = this.m30;
            fArray[1] = this.m31;
            fArray[2] = this.m32;
            fArray[3] = this.m33;
        } else {
            throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4f2"));
        }
    }

    public final float getScale() {
        this.getScaleRotate(this.tmp_scale, this.tmp_rot);
        return (float)Matrix3d.max3(this.tmp_scale);
    }

    private final void getScaleRotate(double[] dArray, double[] dArray2) {
        this.tmp[0] = this.m00;
        this.tmp[1] = this.m01;
        this.tmp[2] = this.m02;
        this.tmp[3] = this.m10;
        this.tmp[4] = this.m11;
        this.tmp[5] = this.m12;
        this.tmp[6] = this.m20;
        this.tmp[7] = this.m21;
        this.tmp[8] = this.m22;
        Matrix3d.compute_svd(this.tmp, dArray, dArray2, false);
    }

    public int hashCode() {
        long l2 = 1L;
        l2 = 31L * l2 + (long)Float.floatToIntBits(this.m00);
        l2 = 31L * l2 + (long)Float.floatToIntBits(this.m01);
        l2 = 31L * l2 + (long)Float.floatToIntBits(this.m02);
        l2 = 31L * l2 + (long)Float.floatToIntBits(this.m03);
        l2 = 31L * l2 + (long)Float.floatToIntBits(this.m10);
        l2 = 31L * l2 + (long)Float.floatToIntBits(this.m11);
        l2 = 31L * l2 + (long)Float.floatToIntBits(this.m12);
        l2 = 31L * l2 + (long)Float.floatToIntBits(this.m13);
        l2 = 31L * l2 + (long)Float.floatToIntBits(this.m20);
        l2 = 31L * l2 + (long)Float.floatToIntBits(this.m21);
        l2 = 31L * l2 + (long)Float.floatToIntBits(this.m22);
        l2 = 31L * l2 + (long)Float.floatToIntBits(this.m23);
        l2 = 31L * l2 + (long)Float.floatToIntBits(this.m30);
        l2 = 31L * l2 + (long)Float.floatToIntBits(this.m31);
        l2 = 31L * l2 + (long)Float.floatToIntBits(this.m32);
        l2 = 31L * l2 + (long)Float.floatToIntBits(this.m33);
        return (int)(l2 ^ l2 >> 32);
    }

    public final void invert() {
        this.invertGeneral(this);
    }

    public final void invert(Matrix4f matrix4f) {
        this.invertGeneral(matrix4f);
    }

    final void invertGeneral(Matrix4f matrix4f) {
        double[] dArray = new double[16];
        double[] dArray2 = new double[16];
        int[] nArray = new int[4];
        dArray[0] = matrix4f.m00;
        dArray[1] = matrix4f.m01;
        dArray[2] = matrix4f.m02;
        dArray[3] = matrix4f.m03;
        dArray[4] = matrix4f.m10;
        dArray[5] = matrix4f.m11;
        dArray[6] = matrix4f.m12;
        dArray[7] = matrix4f.m13;
        dArray[8] = matrix4f.m20;
        dArray[9] = matrix4f.m21;
        dArray[10] = matrix4f.m22;
        dArray[11] = matrix4f.m23;
        dArray[12] = matrix4f.m30;
        dArray[13] = matrix4f.m31;
        dArray[14] = matrix4f.m32;
        dArray[15] = matrix4f.m33;
        if (!Matrix4f.luDecomposition(dArray, nArray)) {
            throw new SingularMatrixException(VecMathI18N.getString("Matrix4f12"));
        }
        int n2 = 0;
        while (n2 < 16) {
            dArray2[n2] = 0.0;
            ++n2;
        }
        dArray2[0] = 1.0;
        dArray2[5] = 1.0;
        dArray2[10] = 1.0;
        dArray2[15] = 1.0;
        Matrix4f.luBacksubstitution(dArray, nArray, dArray2);
        this.m00 = (float)dArray2[0];
        this.m01 = (float)dArray2[1];
        this.m02 = (float)dArray2[2];
        this.m03 = (float)dArray2[3];
        this.m10 = (float)dArray2[4];
        this.m11 = (float)dArray2[5];
        this.m12 = (float)dArray2[6];
        this.m13 = (float)dArray2[7];
        this.m20 = (float)dArray2[8];
        this.m21 = (float)dArray2[9];
        this.m22 = (float)dArray2[10];
        this.m23 = (float)dArray2[11];
        this.m30 = (float)dArray2[12];
        this.m31 = (float)dArray2[13];
        this.m32 = (float)dArray2[14];
        this.m33 = (float)dArray2[15];
    }

    static void luBacksubstitution(double[] dArray, int[] nArray, double[] dArray2) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < 4) {
            int n4;
            int n5 = n3;
            int n6 = -1;
            int n7 = 0;
            while (n7 < 4) {
                int n8 = nArray[n2 + n7];
                double d2 = dArray2[n5 + 4 * n8];
                dArray2[n5 + 4 * n8] = dArray2[n5 + 4 * n7];
                if (n6 >= 0) {
                    n4 = n7 * 4;
                    int n9 = n6;
                    while (n9 <= n7 - 1) {
                        d2 -= dArray[n4 + n9] * dArray2[n5 + 4 * n9];
                        ++n9;
                    }
                } else if (d2 != 0.0) {
                    n6 = n7;
                }
                dArray2[n5 + 4 * n7] = d2;
                ++n7;
            }
            n4 = 12;
            int n10 = n5 + 12;
            dArray2[n10] = dArray2[n10] / dArray[n4 + 3];
            dArray2[n5 + 8] = (dArray2[n5 + 8] - dArray[(n4 -= 4) + 3] * dArray2[n5 + 12]) / dArray[n4 + 2];
            dArray2[n5 + 4] = (dArray2[n5 + 4] - dArray[(n4 -= 4) + 2] * dArray2[n5 + 8] - dArray[n4 + 3] * dArray2[n5 + 12]) / dArray[n4 + 1];
            dArray2[n5] = (dArray2[n5] - dArray[(n4 -= 4) + 1] * dArray2[n5 + 4] - dArray[n4 + 2] * dArray2[n5 + 8] - dArray[n4 + 3] * dArray2[n5 + 12]) / dArray[n4];
            ++n3;
        }
    }

    static boolean luDecomposition(double[] dArray, int[] nArray) {
        double[] dArray2 = new double[4];
        int n2 = 0;
        int n3 = 0;
        int n4 = 4;
        while (n4-- != 0) {
            double d2 = 0.0;
            int n5 = 4;
            while (n5-- != 0) {
                double d3 = dArray[n2++];
                if (!((d3 = Math.abs(d3)) > d2)) continue;
                d2 = d3;
            }
            if (d2 == 0.0) {
                return false;
            }
            dArray2[n3++] = 1.0 / d2;
        }
        int n6 = 0;
        int n7 = 0;
        while (n7 < 4) {
            double d4;
            int n8;
            int n9;
            int n10;
            double d5;
            int n11;
            int n12 = 0;
            while (n12 < n7) {
                n11 = n6 + 4 * n12 + n7;
                d5 = dArray[n11];
                n10 = n12;
                n9 = n6 + 4 * n12;
                n8 = n6 + n7;
                while (n10-- != 0) {
                    d5 -= dArray[n9] * dArray[n8];
                    ++n9;
                    n8 += 4;
                }
                dArray[n11] = d5;
                ++n12;
            }
            double d6 = 0.0;
            int n13 = -1;
            n12 = n7;
            while (n12 < 4) {
                double d7;
                n11 = n6 + 4 * n12 + n7;
                d5 = dArray[n11];
                n10 = n7;
                n9 = n6 + 4 * n12;
                n8 = n6 + n7;
                while (n10-- != 0) {
                    d5 -= dArray[n9] * dArray[n8];
                    ++n9;
                    n8 += 4;
                }
                dArray[n11] = d5;
                d4 = dArray2[n12] * Math.abs(d5);
                if (d7 >= d6) {
                    d6 = d4;
                    n13 = n12;
                }
                ++n12;
            }
            if (n13 < 0) {
                throw new RuntimeException(VecMathI18N.getString("Matrix4f13"));
            }
            if (n7 != n13) {
                n10 = 4;
                n9 = n6 + 4 * n13;
                n8 = n6 + 4 * n7;
                while (n10-- != 0) {
                    d4 = dArray[n9];
                    dArray[n9++] = dArray[n8];
                    dArray[n8++] = d4;
                }
                dArray2[n13] = dArray2[n7];
            }
            nArray[n7] = n13;
            if (dArray[n6 + 4 * n7 + n7] == 0.0) {
                return false;
            }
            if (n7 != 3) {
                d4 = 1.0 / dArray[n6 + 4 * n7 + n7];
                n11 = n6 + 4 * (n7 + 1) + n7;
                n12 = 3 - n7;
                while (n12-- != 0) {
                    int n14 = n11;
                    dArray[n14] = dArray[n14] * d4;
                    n11 += 4;
                }
            }
            ++n7;
        }
        return true;
    }

    public final void mul(float f2) {
        this.m00 *= f2;
        this.m01 *= f2;
        this.m02 *= f2;
        this.m03 *= f2;
        this.m10 *= f2;
        this.m11 *= f2;
        this.m12 *= f2;
        this.m13 *= f2;
        this.m20 *= f2;
        this.m21 *= f2;
        this.m22 *= f2;
        this.m23 *= f2;
        this.m30 *= f2;
        this.m31 *= f2;
        this.m32 *= f2;
        this.m33 *= f2;
    }

    public final void mul(float f2, Matrix4f matrix4f) {
        this.m00 = matrix4f.m00 * f2;
        this.m01 = matrix4f.m01 * f2;
        this.m02 = matrix4f.m02 * f2;
        this.m03 = matrix4f.m03 * f2;
        this.m10 = matrix4f.m10 * f2;
        this.m11 = matrix4f.m11 * f2;
        this.m12 = matrix4f.m12 * f2;
        this.m13 = matrix4f.m13 * f2;
        this.m20 = matrix4f.m20 * f2;
        this.m21 = matrix4f.m21 * f2;
        this.m22 = matrix4f.m22 * f2;
        this.m23 = matrix4f.m23 * f2;
        this.m30 = matrix4f.m30 * f2;
        this.m31 = matrix4f.m31 * f2;
        this.m32 = matrix4f.m32 * f2;
        this.m33 = matrix4f.m33 * f2;
    }

    public final void mul(Matrix4f matrix4f) {
        float f2 = this.m00 * matrix4f.m00 + this.m01 * matrix4f.m10 + this.m02 * matrix4f.m20 + this.m03 * matrix4f.m30;
        float f3 = this.m00 * matrix4f.m01 + this.m01 * matrix4f.m11 + this.m02 * matrix4f.m21 + this.m03 * matrix4f.m31;
        float f4 = this.m00 * matrix4f.m02 + this.m01 * matrix4f.m12 + this.m02 * matrix4f.m22 + this.m03 * matrix4f.m32;
        float f5 = this.m00 * matrix4f.m03 + this.m01 * matrix4f.m13 + this.m02 * matrix4f.m23 + this.m03 * matrix4f.m33;
        float f6 = this.m10 * matrix4f.m00 + this.m11 * matrix4f.m10 + this.m12 * matrix4f.m20 + this.m13 * matrix4f.m30;
        float f7 = this.m10 * matrix4f.m01 + this.m11 * matrix4f.m11 + this.m12 * matrix4f.m21 + this.m13 * matrix4f.m31;
        float f8 = this.m10 * matrix4f.m02 + this.m11 * matrix4f.m12 + this.m12 * matrix4f.m22 + this.m13 * matrix4f.m32;
        float f9 = this.m10 * matrix4f.m03 + this.m11 * matrix4f.m13 + this.m12 * matrix4f.m23 + this.m13 * matrix4f.m33;
        float f10 = this.m20 * matrix4f.m00 + this.m21 * matrix4f.m10 + this.m22 * matrix4f.m20 + this.m23 * matrix4f.m30;
        float f11 = this.m20 * matrix4f.m01 + this.m21 * matrix4f.m11 + this.m22 * matrix4f.m21 + this.m23 * matrix4f.m31;
        float f12 = this.m20 * matrix4f.m02 + this.m21 * matrix4f.m12 + this.m22 * matrix4f.m22 + this.m23 * matrix4f.m32;
        float f13 = this.m20 * matrix4f.m03 + this.m21 * matrix4f.m13 + this.m22 * matrix4f.m23 + this.m23 * matrix4f.m33;
        float f14 = this.m30 * matrix4f.m00 + this.m31 * matrix4f.m10 + this.m32 * matrix4f.m20 + this.m33 * matrix4f.m30;
        float f15 = this.m30 * matrix4f.m01 + this.m31 * matrix4f.m11 + this.m32 * matrix4f.m21 + this.m33 * matrix4f.m31;
        float f16 = this.m30 * matrix4f.m02 + this.m31 * matrix4f.m12 + this.m32 * matrix4f.m22 + this.m33 * matrix4f.m32;
        float f17 = this.m30 * matrix4f.m03 + this.m31 * matrix4f.m13 + this.m32 * matrix4f.m23 + this.m33 * matrix4f.m33;
        this.m00 = f2;
        this.m01 = f3;
        this.m02 = f4;
        this.m03 = f5;
        this.m10 = f6;
        this.m11 = f7;
        this.m12 = f8;
        this.m13 = f9;
        this.m20 = f10;
        this.m21 = f11;
        this.m22 = f12;
        this.m23 = f13;
        this.m30 = f14;
        this.m31 = f15;
        this.m32 = f16;
        this.m33 = f17;
    }

    public final void mul(Matrix4f matrix4f, Matrix4f matrix4f2) {
        if (this != matrix4f && this != matrix4f2) {
            this.m00 = matrix4f.m00 * matrix4f2.m00 + matrix4f.m01 * matrix4f2.m10 + matrix4f.m02 * matrix4f2.m20 + matrix4f.m03 * matrix4f2.m30;
            this.m01 = matrix4f.m00 * matrix4f2.m01 + matrix4f.m01 * matrix4f2.m11 + matrix4f.m02 * matrix4f2.m21 + matrix4f.m03 * matrix4f2.m31;
            this.m02 = matrix4f.m00 * matrix4f2.m02 + matrix4f.m01 * matrix4f2.m12 + matrix4f.m02 * matrix4f2.m22 + matrix4f.m03 * matrix4f2.m32;
            this.m03 = matrix4f.m00 * matrix4f2.m03 + matrix4f.m01 * matrix4f2.m13 + matrix4f.m02 * matrix4f2.m23 + matrix4f.m03 * matrix4f2.m33;
            this.m10 = matrix4f.m10 * matrix4f2.m00 + matrix4f.m11 * matrix4f2.m10 + matrix4f.m12 * matrix4f2.m20 + matrix4f.m13 * matrix4f2.m30;
            this.m11 = matrix4f.m10 * matrix4f2.m01 + matrix4f.m11 * matrix4f2.m11 + matrix4f.m12 * matrix4f2.m21 + matrix4f.m13 * matrix4f2.m31;
            this.m12 = matrix4f.m10 * matrix4f2.m02 + matrix4f.m11 * matrix4f2.m12 + matrix4f.m12 * matrix4f2.m22 + matrix4f.m13 * matrix4f2.m32;
            this.m13 = matrix4f.m10 * matrix4f2.m03 + matrix4f.m11 * matrix4f2.m13 + matrix4f.m12 * matrix4f2.m23 + matrix4f.m13 * matrix4f2.m33;
            this.m20 = matrix4f.m20 * matrix4f2.m00 + matrix4f.m21 * matrix4f2.m10 + matrix4f.m22 * matrix4f2.m20 + matrix4f.m23 * matrix4f2.m30;
            this.m21 = matrix4f.m20 * matrix4f2.m01 + matrix4f.m21 * matrix4f2.m11 + matrix4f.m22 * matrix4f2.m21 + matrix4f.m23 * matrix4f2.m31;
            this.m22 = matrix4f.m20 * matrix4f2.m02 + matrix4f.m21 * matrix4f2.m12 + matrix4f.m22 * matrix4f2.m22 + matrix4f.m23 * matrix4f2.m32;
            this.m23 = matrix4f.m20 * matrix4f2.m03 + matrix4f.m21 * matrix4f2.m13 + matrix4f.m22 * matrix4f2.m23 + matrix4f.m23 * matrix4f2.m33;
            this.m30 = matrix4f.m30 * matrix4f2.m00 + matrix4f.m31 * matrix4f2.m10 + matrix4f.m32 * matrix4f2.m20 + matrix4f.m33 * matrix4f2.m30;
            this.m31 = matrix4f.m30 * matrix4f2.m01 + matrix4f.m31 * matrix4f2.m11 + matrix4f.m32 * matrix4f2.m21 + matrix4f.m33 * matrix4f2.m31;
            this.m32 = matrix4f.m30 * matrix4f2.m02 + matrix4f.m31 * matrix4f2.m12 + matrix4f.m32 * matrix4f2.m22 + matrix4f.m33 * matrix4f2.m32;
            this.m33 = matrix4f.m30 * matrix4f2.m03 + matrix4f.m31 * matrix4f2.m13 + matrix4f.m32 * matrix4f2.m23 + matrix4f.m33 * matrix4f2.m33;
        } else {
            float f2 = matrix4f.m00 * matrix4f2.m00 + matrix4f.m01 * matrix4f2.m10 + matrix4f.m02 * matrix4f2.m20 + matrix4f.m03 * matrix4f2.m30;
            float f3 = matrix4f.m00 * matrix4f2.m01 + matrix4f.m01 * matrix4f2.m11 + matrix4f.m02 * matrix4f2.m21 + matrix4f.m03 * matrix4f2.m31;
            float f4 = matrix4f.m00 * matrix4f2.m02 + matrix4f.m01 * matrix4f2.m12 + matrix4f.m02 * matrix4f2.m22 + matrix4f.m03 * matrix4f2.m32;
            float f5 = matrix4f.m00 * matrix4f2.m03 + matrix4f.m01 * matrix4f2.m13 + matrix4f.m02 * matrix4f2.m23 + matrix4f.m03 * matrix4f2.m33;
            float f6 = matrix4f.m10 * matrix4f2.m00 + matrix4f.m11 * matrix4f2.m10 + matrix4f.m12 * matrix4f2.m20 + matrix4f.m13 * matrix4f2.m30;
            float f7 = matrix4f.m10 * matrix4f2.m01 + matrix4f.m11 * matrix4f2.m11 + matrix4f.m12 * matrix4f2.m21 + matrix4f.m13 * matrix4f2.m31;
            float f8 = matrix4f.m10 * matrix4f2.m02 + matrix4f.m11 * matrix4f2.m12 + matrix4f.m12 * matrix4f2.m22 + matrix4f.m13 * matrix4f2.m32;
            float f9 = matrix4f.m10 * matrix4f2.m03 + matrix4f.m11 * matrix4f2.m13 + matrix4f.m12 * matrix4f2.m23 + matrix4f.m13 * matrix4f2.m33;
            float f10 = matrix4f.m20 * matrix4f2.m00 + matrix4f.m21 * matrix4f2.m10 + matrix4f.m22 * matrix4f2.m20 + matrix4f.m23 * matrix4f2.m30;
            float f11 = matrix4f.m20 * matrix4f2.m01 + matrix4f.m21 * matrix4f2.m11 + matrix4f.m22 * matrix4f2.m21 + matrix4f.m23 * matrix4f2.m31;
            float f12 = matrix4f.m20 * matrix4f2.m02 + matrix4f.m21 * matrix4f2.m12 + matrix4f.m22 * matrix4f2.m22 + matrix4f.m23 * matrix4f2.m32;
            float f13 = matrix4f.m20 * matrix4f2.m03 + matrix4f.m21 * matrix4f2.m13 + matrix4f.m22 * matrix4f2.m23 + matrix4f.m23 * matrix4f2.m33;
            float f14 = matrix4f.m30 * matrix4f2.m00 + matrix4f.m31 * matrix4f2.m10 + matrix4f.m32 * matrix4f2.m20 + matrix4f.m33 * matrix4f2.m30;
            float f15 = matrix4f.m30 * matrix4f2.m01 + matrix4f.m31 * matrix4f2.m11 + matrix4f.m32 * matrix4f2.m21 + matrix4f.m33 * matrix4f2.m31;
            float f16 = matrix4f.m30 * matrix4f2.m02 + matrix4f.m31 * matrix4f2.m12 + matrix4f.m32 * matrix4f2.m22 + matrix4f.m33 * matrix4f2.m32;
            float f17 = matrix4f.m30 * matrix4f2.m03 + matrix4f.m31 * matrix4f2.m13 + matrix4f.m32 * matrix4f2.m23 + matrix4f.m33 * matrix4f2.m33;
            this.m00 = f2;
            this.m01 = f3;
            this.m02 = f4;
            this.m03 = f5;
            this.m10 = f6;
            this.m11 = f7;
            this.m12 = f8;
            this.m13 = f9;
            this.m20 = f10;
            this.m21 = f11;
            this.m22 = f12;
            this.m23 = f13;
            this.m30 = f14;
            this.m31 = f15;
            this.m32 = f16;
            this.m33 = f17;
        }
    }

    public final void mulTransposeBoth(Matrix4f matrix4f, Matrix4f matrix4f2) {
        if (this != matrix4f && this != matrix4f2) {
            this.m00 = matrix4f.m00 * matrix4f2.m00 + matrix4f.m10 * matrix4f2.m01 + matrix4f.m20 * matrix4f2.m02 + matrix4f.m30 * matrix4f2.m03;
            this.m01 = matrix4f.m00 * matrix4f2.m10 + matrix4f.m10 * matrix4f2.m11 + matrix4f.m20 * matrix4f2.m12 + matrix4f.m30 * matrix4f2.m13;
            this.m02 = matrix4f.m00 * matrix4f2.m20 + matrix4f.m10 * matrix4f2.m21 + matrix4f.m20 * matrix4f2.m22 + matrix4f.m30 * matrix4f2.m23;
            this.m03 = matrix4f.m00 * matrix4f2.m30 + matrix4f.m10 * matrix4f2.m31 + matrix4f.m20 * matrix4f2.m32 + matrix4f.m30 * matrix4f2.m33;
            this.m10 = matrix4f.m01 * matrix4f2.m00 + matrix4f.m11 * matrix4f2.m01 + matrix4f.m21 * matrix4f2.m02 + matrix4f.m31 * matrix4f2.m03;
            this.m11 = matrix4f.m01 * matrix4f2.m10 + matrix4f.m11 * matrix4f2.m11 + matrix4f.m21 * matrix4f2.m12 + matrix4f.m31 * matrix4f2.m13;
            this.m12 = matrix4f.m01 * matrix4f2.m20 + matrix4f.m11 * matrix4f2.m21 + matrix4f.m21 * matrix4f2.m22 + matrix4f.m31 * matrix4f2.m23;
            this.m13 = matrix4f.m01 * matrix4f2.m30 + matrix4f.m11 * matrix4f2.m31 + matrix4f.m21 * matrix4f2.m32 + matrix4f.m31 * matrix4f2.m33;
            this.m20 = matrix4f.m02 * matrix4f2.m00 + matrix4f.m12 * matrix4f2.m01 + matrix4f.m22 * matrix4f2.m02 + matrix4f.m32 * matrix4f2.m03;
            this.m21 = matrix4f.m02 * matrix4f2.m10 + matrix4f.m12 * matrix4f2.m11 + matrix4f.m22 * matrix4f2.m12 + matrix4f.m32 * matrix4f2.m13;
            this.m22 = matrix4f.m02 * matrix4f2.m20 + matrix4f.m12 * matrix4f2.m21 + matrix4f.m22 * matrix4f2.m22 + matrix4f.m32 * matrix4f2.m23;
            this.m23 = matrix4f.m02 * matrix4f2.m30 + matrix4f.m12 * matrix4f2.m31 + matrix4f.m22 * matrix4f2.m32 + matrix4f.m32 * matrix4f2.m33;
            this.m30 = matrix4f.m03 * matrix4f2.m00 + matrix4f.m13 * matrix4f2.m01 + matrix4f.m23 * matrix4f2.m02 + matrix4f.m33 * matrix4f2.m03;
            this.m31 = matrix4f.m03 * matrix4f2.m10 + matrix4f.m13 * matrix4f2.m11 + matrix4f.m23 * matrix4f2.m12 + matrix4f.m33 * matrix4f2.m13;
            this.m32 = matrix4f.m03 * matrix4f2.m20 + matrix4f.m13 * matrix4f2.m21 + matrix4f.m23 * matrix4f2.m22 + matrix4f.m33 * matrix4f2.m23;
            this.m33 = matrix4f.m03 * matrix4f2.m30 + matrix4f.m13 * matrix4f2.m31 + matrix4f.m23 * matrix4f2.m32 + matrix4f.m33 * matrix4f2.m33;
        } else {
            float f2 = matrix4f.m00 * matrix4f2.m00 + matrix4f.m10 * matrix4f2.m01 + matrix4f.m20 * matrix4f2.m02 + matrix4f.m30 * matrix4f2.m03;
            float f3 = matrix4f.m00 * matrix4f2.m10 + matrix4f.m10 * matrix4f2.m11 + matrix4f.m20 * matrix4f2.m12 + matrix4f.m30 * matrix4f2.m13;
            float f4 = matrix4f.m00 * matrix4f2.m20 + matrix4f.m10 * matrix4f2.m21 + matrix4f.m20 * matrix4f2.m22 + matrix4f.m30 * matrix4f2.m23;
            float f5 = matrix4f.m00 * matrix4f2.m30 + matrix4f.m10 * matrix4f2.m31 + matrix4f.m20 * matrix4f2.m32 + matrix4f.m30 * matrix4f2.m33;
            float f6 = matrix4f.m01 * matrix4f2.m00 + matrix4f.m11 * matrix4f2.m01 + matrix4f.m21 * matrix4f2.m02 + matrix4f.m31 * matrix4f2.m03;
            float f7 = matrix4f.m01 * matrix4f2.m10 + matrix4f.m11 * matrix4f2.m11 + matrix4f.m21 * matrix4f2.m12 + matrix4f.m31 * matrix4f2.m13;
            float f8 = matrix4f.m01 * matrix4f2.m20 + matrix4f.m11 * matrix4f2.m21 + matrix4f.m21 * matrix4f2.m22 + matrix4f.m31 * matrix4f2.m23;
            float f9 = matrix4f.m01 * matrix4f2.m30 + matrix4f.m11 * matrix4f2.m31 + matrix4f.m21 * matrix4f2.m32 + matrix4f.m31 * matrix4f2.m33;
            float f10 = matrix4f.m02 * matrix4f2.m00 + matrix4f.m12 * matrix4f2.m01 + matrix4f.m22 * matrix4f2.m02 + matrix4f.m32 * matrix4f2.m03;
            float f11 = matrix4f.m02 * matrix4f2.m10 + matrix4f.m12 * matrix4f2.m11 + matrix4f.m22 * matrix4f2.m12 + matrix4f.m32 * matrix4f2.m13;
            float f12 = matrix4f.m02 * matrix4f2.m20 + matrix4f.m12 * matrix4f2.m21 + matrix4f.m22 * matrix4f2.m22 + matrix4f.m32 * matrix4f2.m23;
            float f13 = matrix4f.m02 * matrix4f2.m30 + matrix4f.m12 * matrix4f2.m31 + matrix4f.m22 * matrix4f2.m32 + matrix4f.m32 * matrix4f2.m33;
            float f14 = matrix4f.m03 * matrix4f2.m00 + matrix4f.m13 * matrix4f2.m01 + matrix4f.m23 * matrix4f2.m02 + matrix4f.m33 * matrix4f2.m03;
            float f15 = matrix4f.m03 * matrix4f2.m10 + matrix4f.m13 * matrix4f2.m11 + matrix4f.m23 * matrix4f2.m12 + matrix4f.m33 * matrix4f2.m13;
            float f16 = matrix4f.m03 * matrix4f2.m20 + matrix4f.m13 * matrix4f2.m21 + matrix4f.m23 * matrix4f2.m22 + matrix4f.m33 * matrix4f2.m23;
            float f17 = matrix4f.m03 * matrix4f2.m30 + matrix4f.m13 * matrix4f2.m31 + matrix4f.m23 * matrix4f2.m32 + matrix4f.m33 * matrix4f2.m33;
            this.m00 = f2;
            this.m01 = f3;
            this.m02 = f4;
            this.m03 = f5;
            this.m10 = f6;
            this.m11 = f7;
            this.m12 = f8;
            this.m13 = f9;
            this.m20 = f10;
            this.m21 = f11;
            this.m22 = f12;
            this.m23 = f13;
            this.m30 = f14;
            this.m31 = f15;
            this.m32 = f16;
            this.m33 = f17;
        }
    }

    public final void mulTransposeLeft(Matrix4f matrix4f, Matrix4f matrix4f2) {
        if (this != matrix4f && this != matrix4f2) {
            this.m00 = matrix4f.m00 * matrix4f2.m00 + matrix4f.m10 * matrix4f2.m10 + matrix4f.m20 * matrix4f2.m20 + matrix4f.m30 * matrix4f2.m30;
            this.m01 = matrix4f.m00 * matrix4f2.m01 + matrix4f.m10 * matrix4f2.m11 + matrix4f.m20 * matrix4f2.m21 + matrix4f.m30 * matrix4f2.m31;
            this.m02 = matrix4f.m00 * matrix4f2.m02 + matrix4f.m10 * matrix4f2.m12 + matrix4f.m20 * matrix4f2.m22 + matrix4f.m30 * matrix4f2.m32;
            this.m03 = matrix4f.m00 * matrix4f2.m03 + matrix4f.m10 * matrix4f2.m13 + matrix4f.m20 * matrix4f2.m23 + matrix4f.m30 * matrix4f2.m33;
            this.m10 = matrix4f.m01 * matrix4f2.m00 + matrix4f.m11 * matrix4f2.m10 + matrix4f.m21 * matrix4f2.m20 + matrix4f.m31 * matrix4f2.m30;
            this.m11 = matrix4f.m01 * matrix4f2.m01 + matrix4f.m11 * matrix4f2.m11 + matrix4f.m21 * matrix4f2.m21 + matrix4f.m31 * matrix4f2.m31;
            this.m12 = matrix4f.m01 * matrix4f2.m02 + matrix4f.m11 * matrix4f2.m12 + matrix4f.m21 * matrix4f2.m22 + matrix4f.m31 * matrix4f2.m32;
            this.m13 = matrix4f.m01 * matrix4f2.m03 + matrix4f.m11 * matrix4f2.m13 + matrix4f.m21 * matrix4f2.m23 + matrix4f.m31 * matrix4f2.m33;
            this.m20 = matrix4f.m02 * matrix4f2.m00 + matrix4f.m12 * matrix4f2.m10 + matrix4f.m22 * matrix4f2.m20 + matrix4f.m32 * matrix4f2.m30;
            this.m21 = matrix4f.m02 * matrix4f2.m01 + matrix4f.m12 * matrix4f2.m11 + matrix4f.m22 * matrix4f2.m21 + matrix4f.m32 * matrix4f2.m31;
            this.m22 = matrix4f.m02 * matrix4f2.m02 + matrix4f.m12 * matrix4f2.m12 + matrix4f.m22 * matrix4f2.m22 + matrix4f.m32 * matrix4f2.m32;
            this.m23 = matrix4f.m02 * matrix4f2.m03 + matrix4f.m12 * matrix4f2.m13 + matrix4f.m22 * matrix4f2.m23 + matrix4f.m32 * matrix4f2.m33;
            this.m30 = matrix4f.m03 * matrix4f2.m00 + matrix4f.m13 * matrix4f2.m10 + matrix4f.m23 * matrix4f2.m20 + matrix4f.m33 * matrix4f2.m30;
            this.m31 = matrix4f.m03 * matrix4f2.m01 + matrix4f.m13 * matrix4f2.m11 + matrix4f.m23 * matrix4f2.m21 + matrix4f.m33 * matrix4f2.m31;
            this.m32 = matrix4f.m03 * matrix4f2.m02 + matrix4f.m13 * matrix4f2.m12 + matrix4f.m23 * matrix4f2.m22 + matrix4f.m33 * matrix4f2.m32;
            this.m33 = matrix4f.m03 * matrix4f2.m03 + matrix4f.m13 * matrix4f2.m13 + matrix4f.m23 * matrix4f2.m23 + matrix4f.m33 * matrix4f2.m33;
        } else {
            float f2 = matrix4f.m00 * matrix4f2.m00 + matrix4f.m10 * matrix4f2.m10 + matrix4f.m20 * matrix4f2.m20 + matrix4f.m30 * matrix4f2.m30;
            float f3 = matrix4f.m00 * matrix4f2.m01 + matrix4f.m10 * matrix4f2.m11 + matrix4f.m20 * matrix4f2.m21 + matrix4f.m30 * matrix4f2.m31;
            float f4 = matrix4f.m00 * matrix4f2.m02 + matrix4f.m10 * matrix4f2.m12 + matrix4f.m20 * matrix4f2.m22 + matrix4f.m30 * matrix4f2.m32;
            float f5 = matrix4f.m00 * matrix4f2.m03 + matrix4f.m10 * matrix4f2.m13 + matrix4f.m20 * matrix4f2.m23 + matrix4f.m30 * matrix4f2.m33;
            float f6 = matrix4f.m01 * matrix4f2.m00 + matrix4f.m11 * matrix4f2.m10 + matrix4f.m21 * matrix4f2.m20 + matrix4f.m31 * matrix4f2.m30;
            float f7 = matrix4f.m01 * matrix4f2.m01 + matrix4f.m11 * matrix4f2.m11 + matrix4f.m21 * matrix4f2.m21 + matrix4f.m31 * matrix4f2.m31;
            float f8 = matrix4f.m01 * matrix4f2.m02 + matrix4f.m11 * matrix4f2.m12 + matrix4f.m21 * matrix4f2.m22 + matrix4f.m31 * matrix4f2.m32;
            float f9 = matrix4f.m01 * matrix4f2.m03 + matrix4f.m11 * matrix4f2.m13 + matrix4f.m21 * matrix4f2.m23 + matrix4f.m31 * matrix4f2.m33;
            float f10 = matrix4f.m02 * matrix4f2.m00 + matrix4f.m12 * matrix4f2.m10 + matrix4f.m22 * matrix4f2.m20 + matrix4f.m32 * matrix4f2.m30;
            float f11 = matrix4f.m02 * matrix4f2.m01 + matrix4f.m12 * matrix4f2.m11 + matrix4f.m22 * matrix4f2.m21 + matrix4f.m32 * matrix4f2.m31;
            float f12 = matrix4f.m02 * matrix4f2.m02 + matrix4f.m12 * matrix4f2.m12 + matrix4f.m22 * matrix4f2.m22 + matrix4f.m32 * matrix4f2.m32;
            float f13 = matrix4f.m02 * matrix4f2.m03 + matrix4f.m12 * matrix4f2.m13 + matrix4f.m22 * matrix4f2.m23 + matrix4f.m32 * matrix4f2.m33;
            float f14 = matrix4f.m03 * matrix4f2.m00 + matrix4f.m13 * matrix4f2.m10 + matrix4f.m23 * matrix4f2.m20 + matrix4f.m33 * matrix4f2.m30;
            float f15 = matrix4f.m03 * matrix4f2.m01 + matrix4f.m13 * matrix4f2.m11 + matrix4f.m23 * matrix4f2.m21 + matrix4f.m33 * matrix4f2.m31;
            float f16 = matrix4f.m03 * matrix4f2.m02 + matrix4f.m13 * matrix4f2.m12 + matrix4f.m23 * matrix4f2.m22 + matrix4f.m33 * matrix4f2.m32;
            float f17 = matrix4f.m03 * matrix4f2.m03 + matrix4f.m13 * matrix4f2.m13 + matrix4f.m23 * matrix4f2.m23 + matrix4f.m33 * matrix4f2.m33;
            this.m00 = f2;
            this.m01 = f3;
            this.m02 = f4;
            this.m03 = f5;
            this.m10 = f6;
            this.m11 = f7;
            this.m12 = f8;
            this.m13 = f9;
            this.m20 = f10;
            this.m21 = f11;
            this.m22 = f12;
            this.m23 = f13;
            this.m30 = f14;
            this.m31 = f15;
            this.m32 = f16;
            this.m33 = f17;
        }
    }

    public final void mulTransposeRight(Matrix4f matrix4f, Matrix4f matrix4f2) {
        if (this != matrix4f && this != matrix4f2) {
            this.m00 = matrix4f.m00 * matrix4f2.m00 + matrix4f.m01 * matrix4f2.m01 + matrix4f.m02 * matrix4f2.m02 + matrix4f.m03 * matrix4f2.m03;
            this.m01 = matrix4f.m00 * matrix4f2.m10 + matrix4f.m01 * matrix4f2.m11 + matrix4f.m02 * matrix4f2.m12 + matrix4f.m03 * matrix4f2.m13;
            this.m02 = matrix4f.m00 * matrix4f2.m20 + matrix4f.m01 * matrix4f2.m21 + matrix4f.m02 * matrix4f2.m22 + matrix4f.m03 * matrix4f2.m23;
            this.m03 = matrix4f.m00 * matrix4f2.m30 + matrix4f.m01 * matrix4f2.m31 + matrix4f.m02 * matrix4f2.m32 + matrix4f.m03 * matrix4f2.m33;
            this.m10 = matrix4f.m10 * matrix4f2.m00 + matrix4f.m11 * matrix4f2.m01 + matrix4f.m12 * matrix4f2.m02 + matrix4f.m13 * matrix4f2.m03;
            this.m11 = matrix4f.m10 * matrix4f2.m10 + matrix4f.m11 * matrix4f2.m11 + matrix4f.m12 * matrix4f2.m12 + matrix4f.m13 * matrix4f2.m13;
            this.m12 = matrix4f.m10 * matrix4f2.m20 + matrix4f.m11 * matrix4f2.m21 + matrix4f.m12 * matrix4f2.m22 + matrix4f.m13 * matrix4f2.m23;
            this.m13 = matrix4f.m10 * matrix4f2.m30 + matrix4f.m11 * matrix4f2.m31 + matrix4f.m12 * matrix4f2.m32 + matrix4f.m13 * matrix4f2.m33;
            this.m20 = matrix4f.m20 * matrix4f2.m00 + matrix4f.m21 * matrix4f2.m01 + matrix4f.m22 * matrix4f2.m02 + matrix4f.m23 * matrix4f2.m03;
            this.m21 = matrix4f.m20 * matrix4f2.m10 + matrix4f.m21 * matrix4f2.m11 + matrix4f.m22 * matrix4f2.m12 + matrix4f.m23 * matrix4f2.m13;
            this.m22 = matrix4f.m20 * matrix4f2.m20 + matrix4f.m21 * matrix4f2.m21 + matrix4f.m22 * matrix4f2.m22 + matrix4f.m23 * matrix4f2.m23;
            this.m23 = matrix4f.m20 * matrix4f2.m30 + matrix4f.m21 * matrix4f2.m31 + matrix4f.m22 * matrix4f2.m32 + matrix4f.m23 * matrix4f2.m33;
            this.m30 = matrix4f.m30 * matrix4f2.m00 + matrix4f.m31 * matrix4f2.m01 + matrix4f.m32 * matrix4f2.m02 + matrix4f.m33 * matrix4f2.m03;
            this.m31 = matrix4f.m30 * matrix4f2.m10 + matrix4f.m31 * matrix4f2.m11 + matrix4f.m32 * matrix4f2.m12 + matrix4f.m33 * matrix4f2.m13;
            this.m32 = matrix4f.m30 * matrix4f2.m20 + matrix4f.m31 * matrix4f2.m21 + matrix4f.m32 * matrix4f2.m22 + matrix4f.m33 * matrix4f2.m23;
            this.m33 = matrix4f.m30 * matrix4f2.m30 + matrix4f.m31 * matrix4f2.m31 + matrix4f.m32 * matrix4f2.m32 + matrix4f.m33 * matrix4f2.m33;
        } else {
            float f2 = matrix4f.m00 * matrix4f2.m00 + matrix4f.m01 * matrix4f2.m01 + matrix4f.m02 * matrix4f2.m02 + matrix4f.m03 * matrix4f2.m03;
            float f3 = matrix4f.m00 * matrix4f2.m10 + matrix4f.m01 * matrix4f2.m11 + matrix4f.m02 * matrix4f2.m12 + matrix4f.m03 * matrix4f2.m13;
            float f4 = matrix4f.m00 * matrix4f2.m20 + matrix4f.m01 * matrix4f2.m21 + matrix4f.m02 * matrix4f2.m22 + matrix4f.m03 * matrix4f2.m23;
            float f5 = matrix4f.m00 * matrix4f2.m30 + matrix4f.m01 * matrix4f2.m31 + matrix4f.m02 * matrix4f2.m32 + matrix4f.m03 * matrix4f2.m33;
            float f6 = matrix4f.m10 * matrix4f2.m00 + matrix4f.m11 * matrix4f2.m01 + matrix4f.m12 * matrix4f2.m02 + matrix4f.m13 * matrix4f2.m03;
            float f7 = matrix4f.m10 * matrix4f2.m10 + matrix4f.m11 * matrix4f2.m11 + matrix4f.m12 * matrix4f2.m12 + matrix4f.m13 * matrix4f2.m13;
            float f8 = matrix4f.m10 * matrix4f2.m20 + matrix4f.m11 * matrix4f2.m21 + matrix4f.m12 * matrix4f2.m22 + matrix4f.m13 * matrix4f2.m23;
            float f9 = matrix4f.m10 * matrix4f2.m30 + matrix4f.m11 * matrix4f2.m31 + matrix4f.m12 * matrix4f2.m32 + matrix4f.m13 * matrix4f2.m33;
            float f10 = matrix4f.m20 * matrix4f2.m00 + matrix4f.m21 * matrix4f2.m01 + matrix4f.m22 * matrix4f2.m02 + matrix4f.m23 * matrix4f2.m03;
            float f11 = matrix4f.m20 * matrix4f2.m10 + matrix4f.m21 * matrix4f2.m11 + matrix4f.m22 * matrix4f2.m12 + matrix4f.m23 * matrix4f2.m13;
            float f12 = matrix4f.m20 * matrix4f2.m20 + matrix4f.m21 * matrix4f2.m21 + matrix4f.m22 * matrix4f2.m22 + matrix4f.m23 * matrix4f2.m23;
            float f13 = matrix4f.m20 * matrix4f2.m30 + matrix4f.m21 * matrix4f2.m31 + matrix4f.m22 * matrix4f2.m32 + matrix4f.m23 * matrix4f2.m33;
            float f14 = matrix4f.m30 * matrix4f2.m00 + matrix4f.m31 * matrix4f2.m01 + matrix4f.m32 * matrix4f2.m02 + matrix4f.m33 * matrix4f2.m03;
            float f15 = matrix4f.m30 * matrix4f2.m10 + matrix4f.m31 * matrix4f2.m11 + matrix4f.m32 * matrix4f2.m12 + matrix4f.m33 * matrix4f2.m13;
            float f16 = matrix4f.m30 * matrix4f2.m20 + matrix4f.m31 * matrix4f2.m21 + matrix4f.m32 * matrix4f2.m22 + matrix4f.m33 * matrix4f2.m23;
            float f17 = matrix4f.m30 * matrix4f2.m30 + matrix4f.m31 * matrix4f2.m31 + matrix4f.m32 * matrix4f2.m32 + matrix4f.m33 * matrix4f2.m33;
            this.m00 = f2;
            this.m01 = f3;
            this.m02 = f4;
            this.m03 = f5;
            this.m10 = f6;
            this.m11 = f7;
            this.m12 = f8;
            this.m13 = f9;
            this.m20 = f10;
            this.m21 = f11;
            this.m22 = f12;
            this.m23 = f13;
            this.m30 = f14;
            this.m31 = f15;
            this.m32 = f16;
            this.m33 = f17;
        }
    }

    public final void negate() {
        this.m00 = -this.m00;
        this.m01 = -this.m01;
        this.m02 = -this.m02;
        this.m03 = -this.m03;
        this.m10 = -this.m10;
        this.m11 = -this.m11;
        this.m12 = -this.m12;
        this.m13 = -this.m13;
        this.m20 = -this.m20;
        this.m21 = -this.m21;
        this.m22 = -this.m22;
        this.m23 = -this.m23;
        this.m30 = -this.m30;
        this.m31 = -this.m31;
        this.m32 = -this.m32;
        this.m33 = -this.m33;
    }

    public final void negate(Matrix4f matrix4f) {
        this.m00 = -matrix4f.m00;
        this.m01 = -matrix4f.m01;
        this.m02 = -matrix4f.m02;
        this.m03 = -matrix4f.m03;
        this.m10 = -matrix4f.m10;
        this.m11 = -matrix4f.m11;
        this.m12 = -matrix4f.m12;
        this.m13 = -matrix4f.m13;
        this.m20 = -matrix4f.m20;
        this.m21 = -matrix4f.m21;
        this.m22 = -matrix4f.m22;
        this.m23 = -matrix4f.m23;
        this.m30 = -matrix4f.m30;
        this.m31 = -matrix4f.m31;
        this.m32 = -matrix4f.m32;
        this.m33 = -matrix4f.m33;
    }

    public final void rotX(float f2) {
        float f3 = (float)Math.sin(f2);
        float f4 = (float)Math.cos(f2);
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = f4;
        this.m12 = -f3;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = f3;
        this.m22 = f4;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void rotY(float f2) {
        float f3;
        float f4 = (float)Math.sin(f2);
        this.m00 = f3 = (float)Math.cos(f2);
        this.m01 = 0.0f;
        this.m02 = f4;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = -f4;
        this.m21 = 0.0f;
        this.m22 = f3;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void rotZ(float f2) {
        float f3;
        float f4 = (float)Math.sin(f2);
        this.m00 = f3 = (float)Math.cos(f2);
        this.m01 = -f4;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = f4;
        this.m11 = f3;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void set(float f2) {
        this.m00 = f2;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = f2;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = f2;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void set(float f2, Vector3f vector3f) {
        this.m00 = f2;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = vector3f.x;
        this.m10 = 0.0f;
        this.m11 = f2;
        this.m12 = 0.0f;
        this.m13 = vector3f.y;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = f2;
        this.m23 = vector3f.z;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void set(AxisAngle4d axisAngle4d) {
        double d2 = Math.sqrt(axisAngle4d.x * axisAngle4d.x + axisAngle4d.y * axisAngle4d.y + axisAngle4d.z * axisAngle4d.z);
        if (d2 < 1.0E-8) {
            this.m00 = 1.0f;
            this.m01 = 0.0f;
            this.m02 = 0.0f;
            this.m10 = 0.0f;
            this.m11 = 1.0f;
            this.m12 = 0.0f;
            this.m20 = 0.0f;
            this.m21 = 0.0f;
            this.m22 = 1.0f;
        } else {
            d2 = 1.0 / d2;
            double d3 = axisAngle4d.x * d2;
            double d4 = axisAngle4d.y * d2;
            double d5 = axisAngle4d.z * d2;
            float f2 = (float)Math.sin(axisAngle4d.angle);
            float f3 = (float)Math.cos(axisAngle4d.angle);
            float f4 = 1.0f - f3;
            float f5 = (float)(d3 * d5);
            float f6 = (float)(d3 * d4);
            float f7 = (float)(d4 * d5);
            this.m00 = f4 * (float)(d3 * d3) + f3;
            this.m01 = f4 * f6 - f2 * (float)d5;
            this.m02 = f4 * f5 + f2 * (float)d4;
            this.m10 = f4 * f6 + f2 * (float)d5;
            this.m11 = f4 * (float)(d4 * d4) + f3;
            this.m12 = f4 * f7 - f2 * (float)d3;
            this.m20 = f4 * f5 - f2 * (float)d4;
            this.m21 = f4 * f7 + f2 * (float)d3;
            this.m22 = f4 * (float)(d5 * d5) + f3;
        }
        this.m03 = 0.0f;
        this.m13 = 0.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void set(AxisAngle4f axisAngle4f) {
        float f2 = (float)Math.sqrt(axisAngle4f.x * axisAngle4f.x + axisAngle4f.y * axisAngle4f.y + axisAngle4f.z * axisAngle4f.z);
        if ((double)f2 < 1.0E-8) {
            this.m00 = 1.0f;
            this.m01 = 0.0f;
            this.m02 = 0.0f;
            this.m10 = 0.0f;
            this.m11 = 1.0f;
            this.m12 = 0.0f;
            this.m20 = 0.0f;
            this.m21 = 0.0f;
            this.m22 = 1.0f;
        } else {
            f2 = 1.0f / f2;
            float f3 = axisAngle4f.x * f2;
            float f4 = axisAngle4f.y * f2;
            float f5 = axisAngle4f.z * f2;
            float f6 = (float)Math.sin(axisAngle4f.angle);
            float f7 = (float)Math.cos(axisAngle4f.angle);
            float f8 = 1.0f - f7;
            float f9 = f3 * f5;
            float f10 = f3 * f4;
            float f11 = f4 * f5;
            this.m00 = f8 * f3 * f3 + f7;
            this.m01 = f8 * f10 - f6 * f5;
            this.m02 = f8 * f9 + f6 * f4;
            this.m10 = f8 * f10 + f6 * f5;
            this.m11 = f8 * f4 * f4 + f7;
            this.m12 = f8 * f11 - f6 * f3;
            this.m20 = f8 * f9 - f6 * f4;
            this.m21 = f8 * f11 + f6 * f3;
            this.m22 = f8 * f5 * f5 + f7;
        }
        this.m03 = 0.0f;
        this.m13 = 0.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void set(Matrix3d matrix3d) {
        this.m00 = (float)matrix3d.m00;
        this.m01 = (float)matrix3d.m01;
        this.m02 = (float)matrix3d.m02;
        this.m03 = 0.0f;
        this.m10 = (float)matrix3d.m10;
        this.m11 = (float)matrix3d.m11;
        this.m12 = (float)matrix3d.m12;
        this.m13 = 0.0f;
        this.m20 = (float)matrix3d.m20;
        this.m21 = (float)matrix3d.m21;
        this.m22 = (float)matrix3d.m22;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void set(Matrix3d matrix3d, Vector3d vector3d, double d2) {
        this.m00 = (float)(matrix3d.m00 * d2);
        this.m01 = (float)(matrix3d.m01 * d2);
        this.m02 = (float)(matrix3d.m02 * d2);
        this.m03 = (float)vector3d.x;
        this.m10 = (float)(matrix3d.m10 * d2);
        this.m11 = (float)(matrix3d.m11 * d2);
        this.m12 = (float)(matrix3d.m12 * d2);
        this.m13 = (float)vector3d.y;
        this.m20 = (float)(matrix3d.m20 * d2);
        this.m21 = (float)(matrix3d.m21 * d2);
        this.m22 = (float)(matrix3d.m22 * d2);
        this.m23 = (float)vector3d.z;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void set(Matrix3f matrix3f) {
        this.m00 = matrix3f.m00;
        this.m01 = matrix3f.m01;
        this.m02 = matrix3f.m02;
        this.m03 = 0.0f;
        this.m10 = matrix3f.m10;
        this.m11 = matrix3f.m11;
        this.m12 = matrix3f.m12;
        this.m13 = 0.0f;
        this.m20 = matrix3f.m20;
        this.m21 = matrix3f.m21;
        this.m22 = matrix3f.m22;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void set(Matrix3f matrix3f, Vector3f vector3f, float f2) {
        this.m00 = matrix3f.m00 * f2;
        this.m01 = matrix3f.m01 * f2;
        this.m02 = matrix3f.m02 * f2;
        this.m03 = vector3f.x;
        this.m10 = matrix3f.m10 * f2;
        this.m11 = matrix3f.m11 * f2;
        this.m12 = matrix3f.m12 * f2;
        this.m13 = vector3f.y;
        this.m20 = matrix3f.m20 * f2;
        this.m21 = matrix3f.m21 * f2;
        this.m22 = matrix3f.m22 * f2;
        this.m23 = vector3f.z;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void set(Matrix4d matrix4d) {
        this.m00 = (float)matrix4d.m00;
        this.m01 = (float)matrix4d.m01;
        this.m02 = (float)matrix4d.m02;
        this.m03 = (float)matrix4d.m03;
        this.m10 = (float)matrix4d.m10;
        this.m11 = (float)matrix4d.m11;
        this.m12 = (float)matrix4d.m12;
        this.m13 = (float)matrix4d.m13;
        this.m20 = (float)matrix4d.m20;
        this.m21 = (float)matrix4d.m21;
        this.m22 = (float)matrix4d.m22;
        this.m23 = (float)matrix4d.m23;
        this.m30 = (float)matrix4d.m30;
        this.m31 = (float)matrix4d.m31;
        this.m32 = (float)matrix4d.m32;
        this.m33 = (float)matrix4d.m33;
    }

    public final void set(Matrix4f matrix4f) {
        this.m00 = matrix4f.m00;
        this.m01 = matrix4f.m01;
        this.m02 = matrix4f.m02;
        this.m03 = matrix4f.m03;
        this.m10 = matrix4f.m10;
        this.m11 = matrix4f.m11;
        this.m12 = matrix4f.m12;
        this.m13 = matrix4f.m13;
        this.m20 = matrix4f.m20;
        this.m21 = matrix4f.m21;
        this.m22 = matrix4f.m22;
        this.m23 = matrix4f.m23;
        this.m30 = matrix4f.m30;
        this.m31 = matrix4f.m31;
        this.m32 = matrix4f.m32;
        this.m33 = matrix4f.m33;
    }

    public final void set(Quat4d quat4d) {
        this.m00 = (float)(1.0 - 2.0 * quat4d.y * quat4d.y - 2.0 * quat4d.z * quat4d.z);
        this.m10 = (float)(2.0 * (quat4d.x * quat4d.y + quat4d.w * quat4d.z));
        this.m20 = (float)(2.0 * (quat4d.x * quat4d.z - quat4d.w * quat4d.y));
        this.m01 = (float)(2.0 * (quat4d.x * quat4d.y - quat4d.w * quat4d.z));
        this.m11 = (float)(1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.z * quat4d.z);
        this.m21 = (float)(2.0 * (quat4d.y * quat4d.z + quat4d.w * quat4d.x));
        this.m02 = (float)(2.0 * (quat4d.x * quat4d.z + quat4d.w * quat4d.y));
        this.m12 = (float)(2.0 * (quat4d.y * quat4d.z - quat4d.w * quat4d.x));
        this.m22 = (float)(1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.y * quat4d.y);
        this.m03 = 0.0f;
        this.m13 = 0.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void set(Quat4d quat4d, Vector3d vector3d, double d2) {
        this.m00 = (float)(d2 * (1.0 - 2.0 * quat4d.y * quat4d.y - 2.0 * quat4d.z * quat4d.z));
        this.m10 = (float)(d2 * (2.0 * (quat4d.x * quat4d.y + quat4d.w * quat4d.z)));
        this.m20 = (float)(d2 * (2.0 * (quat4d.x * quat4d.z - quat4d.w * quat4d.y)));
        this.m01 = (float)(d2 * (2.0 * (quat4d.x * quat4d.y - quat4d.w * quat4d.z)));
        this.m11 = (float)(d2 * (1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.z * quat4d.z));
        this.m21 = (float)(d2 * (2.0 * (quat4d.y * quat4d.z + quat4d.w * quat4d.x)));
        this.m02 = (float)(d2 * (2.0 * (quat4d.x * quat4d.z + quat4d.w * quat4d.y)));
        this.m12 = (float)(d2 * (2.0 * (quat4d.y * quat4d.z - quat4d.w * quat4d.x)));
        this.m22 = (float)(d2 * (1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.y * quat4d.y));
        this.m03 = (float)vector3d.x;
        this.m13 = (float)vector3d.y;
        this.m23 = (float)vector3d.z;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void set(Quat4f quat4f) {
        this.m00 = 1.0f - 2.0f * quat4f.y * quat4f.y - 2.0f * quat4f.z * quat4f.z;
        this.m10 = 2.0f * (quat4f.x * quat4f.y + quat4f.w * quat4f.z);
        this.m20 = 2.0f * (quat4f.x * quat4f.z - quat4f.w * quat4f.y);
        this.m01 = 2.0f * (quat4f.x * quat4f.y - quat4f.w * quat4f.z);
        this.m11 = 1.0f - 2.0f * quat4f.x * quat4f.x - 2.0f * quat4f.z * quat4f.z;
        this.m21 = 2.0f * (quat4f.y * quat4f.z + quat4f.w * quat4f.x);
        this.m02 = 2.0f * (quat4f.x * quat4f.z + quat4f.w * quat4f.y);
        this.m12 = 2.0f * (quat4f.y * quat4f.z - quat4f.w * quat4f.x);
        this.m22 = 1.0f - 2.0f * quat4f.x * quat4f.x - 2.0f * quat4f.y * quat4f.y;
        this.m03 = 0.0f;
        this.m13 = 0.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void set(Quat4f quat4f, Vector3f vector3f, float f2) {
        this.m00 = f2 * (1.0f - 2.0f * quat4f.y * quat4f.y - 2.0f * quat4f.z * quat4f.z);
        this.m10 = f2 * (2.0f * (quat4f.x * quat4f.y + quat4f.w * quat4f.z));
        this.m20 = f2 * (2.0f * (quat4f.x * quat4f.z - quat4f.w * quat4f.y));
        this.m01 = f2 * (2.0f * (quat4f.x * quat4f.y - quat4f.w * quat4f.z));
        this.m11 = f2 * (1.0f - 2.0f * quat4f.x * quat4f.x - 2.0f * quat4f.z * quat4f.z);
        this.m21 = f2 * (2.0f * (quat4f.y * quat4f.z + quat4f.w * quat4f.x));
        this.m02 = f2 * (2.0f * (quat4f.x * quat4f.z + quat4f.w * quat4f.y));
        this.m12 = f2 * (2.0f * (quat4f.y * quat4f.z - quat4f.w * quat4f.x));
        this.m22 = f2 * (1.0f - 2.0f * quat4f.x * quat4f.x - 2.0f * quat4f.y * quat4f.y);
        this.m03 = vector3f.x;
        this.m13 = vector3f.y;
        this.m23 = vector3f.z;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void set(Vector3f vector3f) {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = vector3f.x;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m13 = vector3f.y;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        this.m23 = vector3f.z;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void set(Vector3f vector3f, float f2) {
        this.m00 = f2;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = f2 * vector3f.x;
        this.m10 = 0.0f;
        this.m11 = f2;
        this.m12 = 0.0f;
        this.m13 = f2 * vector3f.y;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = f2;
        this.m23 = f2 * vector3f.z;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void set(float[] fArray) {
        this.m00 = fArray[0];
        this.m01 = fArray[1];
        this.m02 = fArray[2];
        this.m03 = fArray[3];
        this.m10 = fArray[4];
        this.m11 = fArray[5];
        this.m12 = fArray[6];
        this.m13 = fArray[7];
        this.m20 = fArray[8];
        this.m21 = fArray[9];
        this.m22 = fArray[10];
        this.m23 = fArray[11];
        this.m30 = fArray[12];
        this.m31 = fArray[13];
        this.m32 = fArray[14];
        this.m33 = fArray[15];
    }

    public final void setColumn(int n2, float f2, float f3, float f4, float f5) {
        switch (n2) {
            case 0: {
                this.m00 = f2;
                this.m10 = f3;
                this.m20 = f4;
                this.m30 = f5;
                break;
            }
            case 1: {
                this.m01 = f2;
                this.m11 = f3;
                this.m21 = f4;
                this.m31 = f5;
                break;
            }
            case 2: {
                this.m02 = f2;
                this.m12 = f3;
                this.m22 = f4;
                this.m32 = f5;
                break;
            }
            case 3: {
                this.m03 = f2;
                this.m13 = f3;
                this.m23 = f4;
                this.m33 = f5;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4f9"));
            }
        }
    }

    public final void setColumn(int n2, Vector4f vector4f) {
        switch (n2) {
            case 0: {
                this.m00 = vector4f.x;
                this.m10 = vector4f.y;
                this.m20 = vector4f.z;
                this.m30 = vector4f.w;
                break;
            }
            case 1: {
                this.m01 = vector4f.x;
                this.m11 = vector4f.y;
                this.m21 = vector4f.z;
                this.m31 = vector4f.w;
                break;
            }
            case 2: {
                this.m02 = vector4f.x;
                this.m12 = vector4f.y;
                this.m22 = vector4f.z;
                this.m32 = vector4f.w;
                break;
            }
            case 3: {
                this.m03 = vector4f.x;
                this.m13 = vector4f.y;
                this.m23 = vector4f.z;
                this.m33 = vector4f.w;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4f9"));
            }
        }
    }

    public final void setColumn(int n2, float[] fArray) {
        switch (n2) {
            case 0: {
                this.m00 = fArray[0];
                this.m10 = fArray[1];
                this.m20 = fArray[2];
                this.m30 = fArray[3];
                break;
            }
            case 1: {
                this.m01 = fArray[0];
                this.m11 = fArray[1];
                this.m21 = fArray[2];
                this.m31 = fArray[3];
                break;
            }
            case 2: {
                this.m02 = fArray[0];
                this.m12 = fArray[1];
                this.m22 = fArray[2];
                this.m32 = fArray[3];
                break;
            }
            case 3: {
                this.m03 = fArray[0];
                this.m13 = fArray[1];
                this.m23 = fArray[2];
                this.m33 = fArray[3];
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4f9"));
            }
        }
    }

    public final void setElement(int n2, int n3, float f2) {
        block0 : switch (n2) {
            case 0: {
                switch (n3) {
                    case 0: {
                        this.m00 = f2;
                        break block0;
                    }
                    case 1: {
                        this.m01 = f2;
                        break block0;
                    }
                    case 2: {
                        this.m02 = f2;
                        break block0;
                    }
                    case 3: {
                        this.m03 = f2;
                        break block0;
                    }
                }
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4f0"));
            }
            case 1: {
                switch (n3) {
                    case 0: {
                        this.m10 = f2;
                        break block0;
                    }
                    case 1: {
                        this.m11 = f2;
                        break block0;
                    }
                    case 2: {
                        this.m12 = f2;
                        break block0;
                    }
                    case 3: {
                        this.m13 = f2;
                        break block0;
                    }
                }
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4f0"));
            }
            case 2: {
                switch (n3) {
                    case 0: {
                        this.m20 = f2;
                        break block0;
                    }
                    case 1: {
                        this.m21 = f2;
                        break block0;
                    }
                    case 2: {
                        this.m22 = f2;
                        break block0;
                    }
                    case 3: {
                        this.m23 = f2;
                        break block0;
                    }
                }
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4f0"));
            }
            case 3: {
                switch (n3) {
                    case 0: {
                        this.m30 = f2;
                        break block0;
                    }
                    case 1: {
                        this.m31 = f2;
                        break block0;
                    }
                    case 2: {
                        this.m32 = f2;
                        break block0;
                    }
                    case 3: {
                        this.m33 = f2;
                        break block0;
                    }
                }
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4f0"));
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4f0"));
            }
        }
    }

    public final void setIdentity() {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void setRotation(AxisAngle4f axisAngle4f) {
        this.getScaleRotate(this.tmp_scale, this.tmp_rot);
        double d2 = Math.sqrt(axisAngle4f.x * axisAngle4f.x + axisAngle4f.y * axisAngle4f.y + axisAngle4f.z * axisAngle4f.z);
        if (d2 < 1.0E-8) {
            this.m00 = 1.0f;
            this.m01 = 0.0f;
            this.m02 = 0.0f;
            this.m10 = 0.0f;
            this.m11 = 1.0f;
            this.m12 = 0.0f;
            this.m20 = 0.0f;
            this.m21 = 0.0f;
            this.m22 = 1.0f;
        } else {
            d2 = 1.0 / d2;
            double d3 = (double)axisAngle4f.x * d2;
            double d4 = (double)axisAngle4f.y * d2;
            double d5 = (double)axisAngle4f.z * d2;
            double d6 = Math.sin(axisAngle4f.angle);
            double d7 = Math.cos(axisAngle4f.angle);
            double d8 = 1.0 - d7;
            double d9 = axisAngle4f.x * axisAngle4f.z;
            double d10 = axisAngle4f.x * axisAngle4f.y;
            double d11 = axisAngle4f.y * axisAngle4f.z;
            this.m00 = (float)((d8 * d3 * d3 + d7) * this.tmp_scale[0]);
            this.m01 = (float)((d8 * d10 - d6 * d5) * this.tmp_scale[1]);
            this.m02 = (float)((d8 * d9 + d6 * d4) * this.tmp_scale[2]);
            this.m10 = (float)((d8 * d10 + d6 * d5) * this.tmp_scale[0]);
            this.m11 = (float)((d8 * d4 * d4 + d7) * this.tmp_scale[1]);
            this.m12 = (float)((d8 * d11 - d6 * d3) * this.tmp_scale[2]);
            this.m20 = (float)((d8 * d9 - d6 * d4) * this.tmp_scale[0]);
            this.m21 = (float)((d8 * d11 + d6 * d3) * this.tmp_scale[1]);
            this.m22 = (float)((d8 * d5 * d5 + d7) * this.tmp_scale[2]);
        }
    }

    public final void setRotation(Matrix3d matrix3d) {
        this.getScaleRotate(this.tmp_scale, this.tmp_rot);
        this.m00 = (float)(matrix3d.m00 * this.tmp_scale[0]);
        this.m01 = (float)(matrix3d.m01 * this.tmp_scale[1]);
        this.m02 = (float)(matrix3d.m02 * this.tmp_scale[2]);
        this.m10 = (float)(matrix3d.m10 * this.tmp_scale[0]);
        this.m11 = (float)(matrix3d.m11 * this.tmp_scale[1]);
        this.m12 = (float)(matrix3d.m12 * this.tmp_scale[2]);
        this.m20 = (float)(matrix3d.m20 * this.tmp_scale[0]);
        this.m21 = (float)(matrix3d.m21 * this.tmp_scale[1]);
        this.m22 = (float)(matrix3d.m22 * this.tmp_scale[2]);
    }

    public final void setRotation(Matrix3f matrix3f) {
        this.getScaleRotate(this.tmp_scale, this.tmp_rot);
        this.m00 = (float)((double)matrix3f.m00 * this.tmp_scale[0]);
        this.m01 = (float)((double)matrix3f.m01 * this.tmp_scale[1]);
        this.m02 = (float)((double)matrix3f.m02 * this.tmp_scale[2]);
        this.m10 = (float)((double)matrix3f.m10 * this.tmp_scale[0]);
        this.m11 = (float)((double)matrix3f.m11 * this.tmp_scale[1]);
        this.m12 = (float)((double)matrix3f.m12 * this.tmp_scale[2]);
        this.m20 = (float)((double)matrix3f.m20 * this.tmp_scale[0]);
        this.m21 = (float)((double)matrix3f.m21 * this.tmp_scale[1]);
        this.m22 = (float)((double)matrix3f.m22 * this.tmp_scale[2]);
    }

    public final void setRotation(Quat4d quat4d) {
        this.getScaleRotate(this.tmp_scale, this.tmp_rot);
        this.m00 = (float)((1.0 - 2.0 * quat4d.y * quat4d.y - 2.0 * quat4d.z * quat4d.z) * this.tmp_scale[0]);
        this.m10 = (float)(2.0 * (quat4d.x * quat4d.y + quat4d.w * quat4d.z) * this.tmp_scale[0]);
        this.m20 = (float)(2.0 * (quat4d.x * quat4d.z - quat4d.w * quat4d.y) * this.tmp_scale[0]);
        this.m01 = (float)(2.0 * (quat4d.x * quat4d.y - quat4d.w * quat4d.z) * this.tmp_scale[1]);
        this.m11 = (float)((1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.z * quat4d.z) * this.tmp_scale[1]);
        this.m21 = (float)(2.0 * (quat4d.y * quat4d.z + quat4d.w * quat4d.x) * this.tmp_scale[1]);
        this.m02 = (float)(2.0 * (quat4d.x * quat4d.z + quat4d.w * quat4d.y) * this.tmp_scale[2]);
        this.m12 = (float)(2.0 * (quat4d.y * quat4d.z - quat4d.w * quat4d.x) * this.tmp_scale[2]);
        this.m22 = (float)((1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.y * quat4d.y) * this.tmp_scale[2]);
    }

    public final void setRotation(Quat4f quat4f) {
        this.getScaleRotate(this.tmp_scale, this.tmp_rot);
        this.m00 = (float)((double)(1.0f - 2.0f * quat4f.y * quat4f.y - 2.0f * quat4f.z * quat4f.z) * this.tmp_scale[0]);
        this.m10 = (float)((double)(2.0f * (quat4f.x * quat4f.y + quat4f.w * quat4f.z)) * this.tmp_scale[0]);
        this.m20 = (float)((double)(2.0f * (quat4f.x * quat4f.z - quat4f.w * quat4f.y)) * this.tmp_scale[0]);
        this.m01 = (float)((double)(2.0f * (quat4f.x * quat4f.y - quat4f.w * quat4f.z)) * this.tmp_scale[1]);
        this.m11 = (float)((double)(1.0f - 2.0f * quat4f.x * quat4f.x - 2.0f * quat4f.z * quat4f.z) * this.tmp_scale[1]);
        this.m21 = (float)((double)(2.0f * (quat4f.y * quat4f.z + quat4f.w * quat4f.x)) * this.tmp_scale[1]);
        this.m02 = (float)((double)(2.0f * (quat4f.x * quat4f.z + quat4f.w * quat4f.y)) * this.tmp_scale[2]);
        this.m12 = (float)((double)(2.0f * (quat4f.y * quat4f.z - quat4f.w * quat4f.x)) * this.tmp_scale[2]);
        this.m22 = (float)((double)(1.0f - 2.0f * quat4f.x * quat4f.x - 2.0f * quat4f.y * quat4f.y) * this.tmp_scale[2]);
    }

    public final void setRotationScale(Matrix3f matrix3f) {
        this.m00 = matrix3f.m00;
        this.m01 = matrix3f.m01;
        this.m02 = matrix3f.m02;
        this.m10 = matrix3f.m10;
        this.m11 = matrix3f.m11;
        this.m12 = matrix3f.m12;
        this.m20 = matrix3f.m20;
        this.m21 = matrix3f.m21;
        this.m22 = matrix3f.m22;
    }

    public final void setRow(int n2, float f2, float f3, float f4, float f5) {
        switch (n2) {
            case 0: {
                this.m00 = f2;
                this.m01 = f3;
                this.m02 = f4;
                this.m03 = f5;
                break;
            }
            case 1: {
                this.m10 = f2;
                this.m11 = f3;
                this.m12 = f4;
                this.m13 = f5;
                break;
            }
            case 2: {
                this.m20 = f2;
                this.m21 = f3;
                this.m22 = f4;
                this.m23 = f5;
                break;
            }
            case 3: {
                this.m30 = f2;
                this.m31 = f3;
                this.m32 = f4;
                this.m33 = f5;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4f6"));
            }
        }
    }

    public final void setRow(int n2, Vector4f vector4f) {
        switch (n2) {
            case 0: {
                this.m00 = vector4f.x;
                this.m01 = vector4f.y;
                this.m02 = vector4f.z;
                this.m03 = vector4f.w;
                break;
            }
            case 1: {
                this.m10 = vector4f.x;
                this.m11 = vector4f.y;
                this.m12 = vector4f.z;
                this.m13 = vector4f.w;
                break;
            }
            case 2: {
                this.m20 = vector4f.x;
                this.m21 = vector4f.y;
                this.m22 = vector4f.z;
                this.m23 = vector4f.w;
                break;
            }
            case 3: {
                this.m30 = vector4f.x;
                this.m31 = vector4f.y;
                this.m32 = vector4f.z;
                this.m33 = vector4f.w;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4f6"));
            }
        }
    }

    public final void setRow(int n2, float[] fArray) {
        switch (n2) {
            case 0: {
                this.m00 = fArray[0];
                this.m01 = fArray[1];
                this.m02 = fArray[2];
                this.m03 = fArray[3];
                break;
            }
            case 1: {
                this.m10 = fArray[0];
                this.m11 = fArray[1];
                this.m12 = fArray[2];
                this.m13 = fArray[3];
                break;
            }
            case 2: {
                this.m20 = fArray[0];
                this.m21 = fArray[1];
                this.m22 = fArray[2];
                this.m23 = fArray[3];
                break;
            }
            case 3: {
                this.m30 = fArray[0];
                this.m31 = fArray[1];
                this.m32 = fArray[2];
                this.m33 = fArray[3];
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4f6"));
            }
        }
    }

    public final void setScale(float f2) {
        this.getScaleRotate(this.tmp_scale, this.tmp_rot);
        this.m00 = (float)(this.tmp_rot[0] * (double)f2);
        this.m01 = (float)(this.tmp_rot[1] * (double)f2);
        this.m02 = (float)(this.tmp_rot[2] * (double)f2);
        this.m10 = (float)(this.tmp_rot[3] * (double)f2);
        this.m11 = (float)(this.tmp_rot[4] * (double)f2);
        this.m12 = (float)(this.tmp_rot[5] * (double)f2);
        this.m20 = (float)(this.tmp_rot[6] * (double)f2);
        this.m21 = (float)(this.tmp_rot[7] * (double)f2);
        this.m22 = (float)(this.tmp_rot[8] * (double)f2);
    }

    public final void setTranslation(Vector3f vector3f) {
        this.m03 = vector3f.x;
        this.m13 = vector3f.y;
        this.m23 = vector3f.z;
    }

    public final void setZero() {
        this.m00 = 0.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 0.0f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 0.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 0.0f;
    }

    public final void sub(Matrix4f matrix4f) {
        this.m00 -= matrix4f.m00;
        this.m01 -= matrix4f.m01;
        this.m02 -= matrix4f.m02;
        this.m03 -= matrix4f.m03;
        this.m10 -= matrix4f.m10;
        this.m11 -= matrix4f.m11;
        this.m12 -= matrix4f.m12;
        this.m13 -= matrix4f.m13;
        this.m20 -= matrix4f.m20;
        this.m21 -= matrix4f.m21;
        this.m22 -= matrix4f.m22;
        this.m23 -= matrix4f.m23;
        this.m30 -= matrix4f.m30;
        this.m31 -= matrix4f.m31;
        this.m32 -= matrix4f.m32;
        this.m33 -= matrix4f.m33;
    }

    public final void sub(Matrix4f matrix4f, Matrix4f matrix4f2) {
        this.m00 = matrix4f.m00 - matrix4f2.m00;
        this.m01 = matrix4f.m01 - matrix4f2.m01;
        this.m02 = matrix4f.m02 - matrix4f2.m02;
        this.m03 = matrix4f.m03 - matrix4f2.m03;
        this.m10 = matrix4f.m10 - matrix4f2.m10;
        this.m11 = matrix4f.m11 - matrix4f2.m11;
        this.m12 = matrix4f.m12 - matrix4f2.m12;
        this.m13 = matrix4f.m13 - matrix4f2.m13;
        this.m20 = matrix4f.m20 - matrix4f2.m20;
        this.m21 = matrix4f.m21 - matrix4f2.m21;
        this.m22 = matrix4f.m22 - matrix4f2.m22;
        this.m23 = matrix4f.m23 - matrix4f2.m23;
        this.m30 = matrix4f.m30 - matrix4f2.m30;
        this.m31 = matrix4f.m31 - matrix4f2.m31;
        this.m32 = matrix4f.m32 - matrix4f2.m32;
        this.m33 = matrix4f.m33 - matrix4f2.m33;
    }

    public String toString() {
        return String.valueOf(this.m00) + ", " + this.m01 + ", " + this.m02 + ", " + this.m03 + "\n" + this.m10 + ", " + this.m11 + ", " + this.m12 + ", " + this.m13 + "\n" + this.m20 + ", " + this.m21 + ", " + this.m22 + ", " + this.m23 + "\n" + this.m30 + ", " + this.m31 + ", " + this.m32 + ", " + this.m33 + "\n";
    }

    public final void transform(Point3f point3f) {
        float f2 = this.m00 * point3f.x + this.m01 * point3f.y + this.m02 * point3f.z + this.m03;
        float f3 = this.m10 * point3f.x + this.m11 * point3f.y + this.m12 * point3f.z + this.m13;
        point3f.z = this.m20 * point3f.x + this.m21 * point3f.y + this.m22 * point3f.z + this.m23;
        point3f.x = f2;
        point3f.y = f3;
    }

    public final void transform(Point3f point3f, Point3f point3f2) {
        float f2 = this.m00 * point3f.x + this.m01 * point3f.y + this.m02 * point3f.z + this.m03;
        float f3 = this.m10 * point3f.x + this.m11 * point3f.y + this.m12 * point3f.z + this.m13;
        point3f2.z = this.m20 * point3f.x + this.m21 * point3f.y + this.m22 * point3f.z + this.m23;
        point3f2.x = f2;
        point3f2.y = f3;
    }

    public final void transform(Tuple4f tuple4f) {
        float f2 = this.m00 * tuple4f.x + this.m01 * tuple4f.y + this.m02 * tuple4f.z + this.m03 * tuple4f.w;
        float f3 = this.m10 * tuple4f.x + this.m11 * tuple4f.y + this.m12 * tuple4f.z + this.m13 * tuple4f.w;
        float f4 = this.m20 * tuple4f.x + this.m21 * tuple4f.y + this.m22 * tuple4f.z + this.m23 * tuple4f.w;
        tuple4f.w = this.m30 * tuple4f.x + this.m31 * tuple4f.y + this.m32 * tuple4f.z + this.m33 * tuple4f.w;
        tuple4f.x = f2;
        tuple4f.y = f3;
        tuple4f.z = f4;
    }

    public final void transform(Tuple4f tuple4f, Tuple4f tuple4f2) {
        float f2 = this.m00 * tuple4f.x + this.m01 * tuple4f.y + this.m02 * tuple4f.z + this.m03 * tuple4f.w;
        float f3 = this.m10 * tuple4f.x + this.m11 * tuple4f.y + this.m12 * tuple4f.z + this.m13 * tuple4f.w;
        float f4 = this.m20 * tuple4f.x + this.m21 * tuple4f.y + this.m22 * tuple4f.z + this.m23 * tuple4f.w;
        tuple4f2.w = this.m30 * tuple4f.x + this.m31 * tuple4f.y + this.m32 * tuple4f.z + this.m33 * tuple4f.w;
        tuple4f2.x = f2;
        tuple4f2.y = f3;
        tuple4f2.z = f4;
    }

    public final void transform(Vector3f vector3f) {
        float f2 = this.m00 * vector3f.x + this.m01 * vector3f.y + this.m02 * vector3f.z;
        float f3 = this.m10 * vector3f.x + this.m11 * vector3f.y + this.m12 * vector3f.z;
        vector3f.z = this.m20 * vector3f.x + this.m21 * vector3f.y + this.m22 * vector3f.z;
        vector3f.x = f2;
        vector3f.y = f3;
    }

    public final void transform(Vector3f vector3f, Vector3f vector3f2) {
        float f2 = this.m00 * vector3f.x + this.m01 * vector3f.y + this.m02 * vector3f.z;
        float f3 = this.m10 * vector3f.x + this.m11 * vector3f.y + this.m12 * vector3f.z;
        vector3f2.z = this.m20 * vector3f.x + this.m21 * vector3f.y + this.m22 * vector3f.z;
        vector3f2.x = f2;
        vector3f2.y = f3;
    }

    public final void transpose() {
        float f2 = this.m10;
        this.m10 = this.m01;
        this.m01 = f2;
        f2 = this.m20;
        this.m20 = this.m02;
        this.m02 = f2;
        f2 = this.m30;
        this.m30 = this.m03;
        this.m03 = f2;
        f2 = this.m21;
        this.m21 = this.m12;
        this.m12 = f2;
        f2 = this.m31;
        this.m31 = this.m13;
        this.m13 = f2;
        f2 = this.m32;
        this.m32 = this.m23;
        this.m23 = f2;
    }

    public final void transpose(Matrix4f matrix4f) {
        if (this != matrix4f) {
            this.m00 = matrix4f.m00;
            this.m01 = matrix4f.m10;
            this.m02 = matrix4f.m20;
            this.m03 = matrix4f.m30;
            this.m10 = matrix4f.m01;
            this.m11 = matrix4f.m11;
            this.m12 = matrix4f.m21;
            this.m13 = matrix4f.m31;
            this.m20 = matrix4f.m02;
            this.m21 = matrix4f.m12;
            this.m22 = matrix4f.m22;
            this.m23 = matrix4f.m32;
            this.m30 = matrix4f.m03;
            this.m31 = matrix4f.m13;
            this.m32 = matrix4f.m23;
            this.m33 = matrix4f.m33;
        } else {
            this.transpose();
        }
    }
}

