/* Linux demo by lairfight. */
/* There should be a readme along with this file. */

#include <stdio.h>
#include <curses.h>
#include <signal.h>
#include <math.h>
#include <sys/time.h>

#define PI 3.14159265358979323864264

#define CP_BlueWhite 1
#define CP_BrownWhite 2
#define CP_BlueBlack 3
#define CP_BrownBlack 4

char spaces80[81];
int lastlineofupperhalf;
volatile long alarmtimer = 0;
int scrolling = 0;

char *ascii_phong[] = { /* 8 lines */
        " ********   ****   ****    *****    ****                    ",
	" **********  ***   ****  ***   ***   ****    ****     ***** ",
	" *****    *  ***   ***  ***     ***  ******  ***   *********",
	" ****    **  *********  ****   ****  ******* ***  ****      ",
	" *********   *********  ****   ****  *** *** ***  ***   ****",
	" ****        ***   ***  ***     ***  ***  ******  ***    ***",
	" ****        ***   ***   ***   ***   ***   *****  **********",
        "******      ****   ****   *******   *****   ****   ******** "};

char *ascii_shaded[] = { /* 9 lines */
      " ******   ***                    **                 **",
      "*********  **                     *                  *",
      "**    ***  **                     *                  *",
      " ** ****   ** ***    ****    ******   ******    ******",
      "  **       ***   *  **   *  **    *  **    **  **    *",
      "   **      **    *  ******  **    *  *******   **    *",
      "**  ***    **    *  ******  **    *  *****     **    *",
      "***  ***   **    *  **   *  **    *  **        **    *",
      " *******   **    *  **   *   ******   *******   ******"};

char *ascii_polygons[] = { /* 9 lines */
   "******  ******  **     **  **  ******  ******  **  **  ******",
   "******  ******  **     **  **  ******  ******  **  **  ******",
   "**  **  **  **  **     **  **  **  **  **  **  *** **  **  **",
   "**  **  **  **  **      ****   **      **  **  *** **  ***   ",
   "******  **  **  **      ****   ** ***  **  **  ******   ***  ",
   "******  **  **  **       **    **  **  **  **  ** ***     ***",
   "**      **  **  **       **    **  **  **  **  ** ***  **  **",
   "**      ******  ******   **    ******  ******  **  **  ******",
   "**      ******  ******   **    ******  ******  **  **  ******"};


const char realtxt[] = "WHILE WE WAIT FOR THE PHONG SHADED POLYGONS, "
                       "HOW ABOUT SOME GREETINGS? HELLO TO EVERYONE AT "
		       "HYPE, AND EVERYONE ELSE.     SCROLL RESTARTING...  ";
char txt[sizeof(realtxt)+16];

const char *font[59][5] = {
	{"     ",
	 "     ",
	 "     ",
	 "     ",
	 "     "},
	 
	{"  *  ",
	 "  *  ",
	 "  *  ",
	 "     ",
	 "  *  "},
	 
	{" * * ",
	 " * * ",
	 "     ",
	 "     ",
	 "     "},
	 
	{" * * ",
	 "*****",
	 " * * ",
	 "*****",
	 " * * "},
	 
	{"  *  ",
	 " **  ",
	 "*****",
	 "  ** ",
	 "  *  "},
	 
	{"*   *",
	 "   * ",
	 "  *  ",
	 " *   ",
	 "*   *"},
	 
	{"  ** ",
	 " *** ",
	 "* ***",
	 " ** *",
	 " *** "},
	 
	{"   **",
	 "   * ",
	 "     ",
	 "     ",
	 "     "},
	 
	{"   * ",
	 "  *  ",
	 "  *  ",
	 "  *  ",
	 "   * "},
	 
	{" *   ",
	 "  *  ",
	 "  *  ",
	 "  *  ",
	 " *   "},
	 
	{"  *  ",
	 " * * ",
	 "* * *",
	 " * * ",
	 "  *  "},
	 
	{"  *  ",
	 "  *  ",
	 "*****",
	 "  *  ",
	 "  *  "},
	 
	{"     ",
	 "     ",
	 "     ",
	 " **  ",
	 " *   "},
	 
	{"     ",
	 "     ",
	 "*****",
	 "     ",
	 "     "},
	 
	{"     ",
	 "     ",
	 "     ",
	 " **  ",
	 " **  "},
	 
	{"   **",
	 "  ** ",
	 " **  ",
	 "**   ",
	 "*    "},
	
	{" *** ",
	 "*   *",
	 "*   *",
	 "*   *",
	 " *** "},
	 
	{"  *  ",
	 " **  ",
	 "  *  ",
	 "  *  ",
	 " *** "},
	 
	{" *** ",
	 "*   *",
	 "   * ",
	 "  *  ",
	 "*****"},
	 
	{" *** ",
	 "*   *",
	 "  ** ",
	 "*   *",
	 " *** "},
	 
	{"   * ",
	 "  ** ",
	 " * * ",
	 "*****",
	 "   * "},
	 
	{"*****",
	 "*    ",
	 " *** ",
	 "    *",
	 "**** "},
	 
	{" *** ",
	 "*    ",
	 "**** ",
	 "*   *",
	 " *** "},
	 
	{"*****",
	 "*  * ",
	 "  *  ",
	 "  *  ",
	 "  *  "},
	 
	{" *** ",
	 "*   *",
	 " *** ",
	 "*   *",
	 " *** "},
	 
	{" *** ",
	 "*   *",
	 " ****",
	 "    *",
	 " *** "},
	 
	{" **  ",
	 " **  ",
	 "     ",
	 " **  ",
	 " **  "},
	 
	{" **  ",
	 " **  ",
	 "     ",
	 " **  ",
	 " *   "},
	 
	{"   * ",
	 "  *  ",
	 " *   ",
	 "  *  ",
	 "   * "},
	 
	{"     ",
	 "*****",
	 "     ",
	 "*****",
	 "     "},
	 
	{" *   ",
	 "  *  ",
	 "   * ",
	 "  *  ",
	 " *   "},
	 
	{" *** ",
	 "*   *",
	 "   * ",
	 "     ",
	 "  *  "},
	 
	{" *** ",
	 "* * *",
	 "* ***",
	 "* ***",
	 " *** "},
	 
	{" *** ",
	 "*   *",
	 "*****",
	 "*   *",
	 "*   *"},
	 
	{"**** ",
	 "*   *",
	 "**** ",
	 "*   *",
	 "**** "},
	 
	{" *** ",
	 "*   *",
	 "*    ",
	 "*   *",
	 " *** "},
	 
	{"**** ",
	 "*   *",
	 "*   *",
	 "*   *",
	 "**** "},
	 
	{"*****",
	 "*    ",
	 "***  ",
	 "*    ",
	 "*****"},
	 
	{"*****",
	 "*    ",
	 "***  ",
	 "*    ",
	 "*    "},
	 
	{" ****",
	 "*    ",
	 "* ***",
	 "*   *",
	 " ****"},
	 
	{"*   *",
	 "*   *",
	 "*****",
	 "*   *",
	 "*   *"},
	 
	{"*****",
	 "  *  ",
	 "  *  ",
	 "  *  ",
	 "*****"},
	 
	{"*****",
	 "    *",
	 "    *",
	 "*   *",
	 " *** "},
	 
	{"*   *",
	 "*  * ",
	 "***  ",
	 "*  * ",
	 "*   *"},
	 
	{"*    ",
	 "*    ",
	 "*    ",
	 "*   *",
	 "*****"},
	 
	{"*   *",
	 "** **",
	 "* * *",
	 "*   *",
	 "*   *"},
	 
	{"*   *",
	 "**  *",
	 "* * *",
	 "*  **",
	 "*   *"},
	 
	{" *** ",
	 "*   *",
	 "*   *",
	 "*   *",
	 " *** "},
	 
	{"**** ",
	 "*   *",
	 "**** ",
	 "*    ",
	 "*    "},
	 
	{" *** ",
	 "*   *",
	 "*   *",
	 "*  **",
	 " ****"},
	 
	{"**** ",
	 "*   *",
	 "**** ",
	 "*  * ",
	 "*   *"},
	 
	{" *** ",
	 "*    ",
	 " *** ",
	 "    *",
	 " *** "},
	 
	{"**** ",
	 "    *",
	 "    *",
	 "    *",
	 "    *"},
	 
	{"*   *",
	 "*   *",
	 "*   *",
	 "*   *",
	 " *** "},
	 
	{"*   *",
	 "*   *",
	 " * * ",
	 " * * ",
	 "  *  "},
	 
	{"*   *",
	 "*   *",
	 "* * *",
	 "** **",
	 "*   *"},
	 
	{"*   *",
	 " * * ",
	 "  *  ",
	 " * * ",
	 "*   *"},
	 
	{"*   *",
	 "*   *",
	 " * * ",
	 "  *  ",
	 "  *  "},
	 
	{"*****",
	 "   * ",
	 " *** ",
	 " *   ",
	 "*****"}
	 
};
	 
int scrollpos = 0, sinpos = 0;

void typewrite(char *txt)
{
	int i;

	for(i=0; i<strlen(txt); i++)
	{
		addch(txt[i]);
		refresh();
		m_msleep(200);
	}
}

scrollmain()
{
	register int i, y;
	int cscrollpos, csinpos;

	scrolling = 1;

	memset(txt, 32, COLS/12);
	memcpy(&txt[COLS/12], realtxt, strlen(realtxt));
	memset(&txt[COLS/12+strlen(realtxt)], 32, COLS/12);

	while(1)
	{
		cscrollpos = scrollpos; csinpos = sinpos;
		cleardisp();
		move(LINES-4, 20);
		attrset(COLOR_PAIR(CP_BrownWhite));
		addstr("pHONg sHAdeD pOlYgoNS!");
		move(LINES-2, 20);
		attrset(COLOR_PAIR(CP_BrownBlack));
		addstr("coming up. a.s.a.p");

		for(i=0; i<COLS; i++)
		{
			for(y=0; y<10; y++)
			{
				attrset(COLOR_PAIR( (LINES>>1) + (int) (3*sin((((double)(csinpos+i))*M_PI)/32)) + y - 5 <= lastlineofupperhalf? CP_BlueWhite : CP_BrownWhite ));
				move((LINES>>1) + (int) (3*sin((((double)(csinpos+i))*M_PI)/32)) + y - 5, i);				
				addch(((cscrollpos+i)/2)%6!=5 ? font[txt[((cscrollpos+i)/2)/6]-32][y/2][((cscrollpos+i)/2)%6] : ' ');
			}
		}
		refresh();
		pause();
	}
}

void siginthandler(int signum)
{
	endwin();
	printf("Oh my god! You killed the program! (Signal %d)\n", signum);
	signal(signum, SIG_DFL);
	raise(signum);
}

void sigalarmhandler(int signum)
{
	if(scrolling)
	{
		if(++scrollpos>12*strlen(txt)-COLS) scrollpos=0;
		sinpos--; sinpos&=63;
		if(++scrollpos>12*strlen(txt)-COLS) scrollpos=0;
		sinpos--; sinpos&=63;
	}
	else
	{
		alarmtimer++;
	}
	signal(signum, sigalarmhandler);
}

void sigwinchhandler(int signum)
{
	endwin();
	printf("Don't mess around!\n");
	exit(1);
}

#define LIVINGLINELENGTH 51
char livingline[LIVINGLINELENGTH];
int livinglinex[LIVINGLINELENGTH];
int livingliney[LIVINGLINELENGTH];

cleardisp()
{
	int i;

	for(i=0; i<LINES; i++)
	{
		move(i, 0);
		attrset(COLOR_PAIR(i<=lastlineofupperhalf? CP_BlueWhite : CP_BrownWhite));
		addstr(spaces80);
	}
}

/*livinglinedraw()
{
	int i;

	cleardisp();

	for(i=0; i<LIVINGLINELENGTH; i++)
	{
		attrset(COLOR_PAIR(livingliney[i]<=lastlineofupperhalf? CP_BlueWhite : CP_BrownWhite));
		move(livingliney[i], livinglinex[i]);
		addch(livingline[i]);
	}
	refresh();
	pause();
}

livinglineleft()
{
	int i;
	char tmp;
	
	tmp = livingline[LIVINGLINELENGTH-1];
	for(i=0; i<LIVINGLINELENGTH-1; i++)
	{
		livingline[LIVINGLINELENGTH-i-1] = livingline[LIVINGLINELENGTH-i-2];
		livinglinex[i] = livinglinex[i+1] - 1;
		livingliney[i] = livingliney[i+1];
	}
	livingline[0] = tmp;
}
		
livinglineeffect()
{
	int i;

	for(i=0; i<LIVINGLINELENGTH; i++)
	{
		livingline[i] = i%3? ' ' : 'o';
		livinglinex[i] = 10 + i;
		livingliney[i] = lastlineofupperhalf + 1;
	}

	alarmtimer = 0;
	while(alarmtimer < 1000)
	{
		livinglinedraw();
		livinglineleft();
		livinglinex[LIVINGLINELENGTH-1] = 10+LIVINGLINELENGTH;
		livingliney[LIVINGLINELENGTH-1] = LINES/4 * sin(PI*alarmtimer/45) + lastlineofupperhalf;
	}
}*/

m_sleep(int secs)
{
	long a;

	a = alarmtimer; while(alarmtimer < a + secs*10) pause();
}

m_msleep(int millies)
{
	long a;
	
	a = alarmtimer; while(alarmtimer < a + millies/100) pause();
}

main()
{
	int i, x;
	static struct itimerval timespec = {{0, 30000}, {0, 30000}};
	
	signal(SIGINT, siginthandler);
	signal(SIGTERM, siginthandler);
	setitimer(ITIMER_REAL, &timespec, NULL);
	signal(SIGALRM, sigalarmhandler);
	signal(SIGWINCH, sigwinchhandler);
	initscr();
	start_color();
	init_pair(CP_BlueWhite,  COLOR_WHITE, COLOR_BLUE);
	init_pair(CP_BrownWhite, COLOR_WHITE, COLOR_YELLOW);
	init_pair(CP_BlueBlack,  COLOR_BLACK, COLOR_BLUE);
	init_pair(CP_BrownBlack, COLOR_BLACK, COLOR_YELLOW);
	noecho();
	keypad(stdscr, 1);

	for(i=0; i<80; i++) spaces80[i] = 32;
	spaces80[80] = 0;

	if(COLS!=80)
	{
		endwin();
		printf("I need an 80 column display!\n");
		exit(1);
	}
	if(!has_colors)
	{
		endwin();
		printf("I need colours, dammit!\n");
		exit(1);
	}

	erase(); refresh();
	m_sleep(2);
	
	move(LINES/2, 10);
	typewrite("lairfight @ hype 2000... feel it.");
	m_sleep(3);

	erase(); refresh();

	lastlineofupperhalf = LINES/3;
	attrset(COLOR_PAIR(CP_BlueWhite));
	for(i=0; i<=lastlineofupperhalf; i++)
	{
		move(i, 0);
		addstr(spaces80);
		refresh();
		m_msleep(1000/8);
	}
	attrset(COLOR_PAIR(CP_BrownWhite));
	for(i=LINES-1; i>lastlineofupperhalf; i--)
	{
		move(i, 0);
		addstr(spaces80);
		refresh();
		m_msleep(1000/8);
	}

	/*livinglineeffect();*/
	
	m_sleep(1);
		
	for(i=0; i<8; i++)
	{
		move(lastlineofupperhalf - 5 + i, 10);
		attrset(COLOR_PAIR(lastlineofupperhalf-5+i<=lastlineofupperhalf? CP_BlueWhite : CP_BrownWhite));
		addstr(ascii_phong[i]);
	}
	move(lastlineofupperhalf - 3, 17);
	attrset(COLOR_PAIR(CP_BlueBlack));
	addstr("phong");
	refresh();

	m_sleep(6);
	for(i=0; i<8; i++)
	{
		move(lastlineofupperhalf - 5 + i, 0);
		attrset(COLOR_PAIR(lastlineofupperhalf-5+i<=lastlineofupperhalf? CP_BlueWhite : CP_BrownWhite));
		addstr(spaces80);
		refresh();
		m_msleep(100);
	}
	
	for(i=0; i<9; i++)
	{
		move(lastlineofupperhalf - 4 + i, 10);
		attrset(COLOR_PAIR(lastlineofupperhalf-4+i<=lastlineofupperhalf? CP_BlueWhite : CP_BrownWhite));
		addstr(ascii_shaded[i]);
	}
	move(lastlineofupperhalf, 26);
	attrset(COLOR_PAIR(CP_BlueBlack));
	addstr("shaded");
	refresh();

	m_sleep(6);
	for(i=0; i<9; i++)
	{
		move(lastlineofupperhalf - 4 + i, 0);
		attrset(COLOR_PAIR(lastlineofupperhalf-4+i<=lastlineofupperhalf? CP_BlueWhite : CP_BrownWhite));
		addstr(spaces80);
		refresh();
		m_msleep(100);
	}
	
	for(i=0; i<9; i++)
	{
		move(lastlineofupperhalf - 2 + i, 10);
		attrset(COLOR_PAIR(lastlineofupperhalf-2+i<=lastlineofupperhalf? CP_BlueWhite : CP_BrownWhite));
		addstr(ascii_polygons[i]);
	}
	move(lastlineofupperhalf + 5, 45);
	attrset(COLOR_PAIR(CP_BrownBlack));
	addstr("polygons");
	refresh();

	m_sleep(6);
	for(i=0; i<9; i++)
	{
		move(lastlineofupperhalf - 2 + i, 0);
		attrset(COLOR_PAIR(lastlineofupperhalf-2+i<=lastlineofupperhalf? CP_BlueWhite : CP_BrownWhite));
		addstr(spaces80);
		refresh();
		m_msleep(100);
	}
	
	move(lastlineofupperhalf - 1, 20);
	attrset(COLOR_PAIR(CP_BlueWhite));
	addstr("pHONg sHAdeD pOlYgoNS!");
	refresh();
	m_sleep(3);
	move(lastlineofupperhalf + 6, 10);
	attrset(COLOR_PAIR(CP_BrownBlack));
	typewrite("...manufactured from only the finest ascii raw material...");
	m_sleep(3);
	move(lastlineofupperhalf + 10, 20);
	attrset(COLOR_PAIR(CP_BrownWhite));
	addstr("Coming");
	refresh();
	m_sleep(3);
	move(lastlineofupperhalf + 10, 30);
	addstr("Up");
	refresh();
	m_sleep(3);
	move(lastlineofupperhalf + 10, 36);
	addstr("Soon!");
	refresh();
	m_sleep(3);

	for(i=0; i<80; i++)
	{
		for(x=lastlineofupperhalf + 6; x<=lastlineofupperhalf + 10; x++)
		{
			move(x, x==lastlineofupperhalf+6? i : 79-i);
			attrset(COLOR_PAIR(x<=lastlineofupperhalf? CP_BlueWhite : CP_BrownWhite));
			addch(' ');
		}
		refresh();
		m_msleep(100);
	}

	for(i=lastlineofupperhalf - 1; i<LINES-4; i++)
	{
		move(i, 0);
		attrset(COLOR_PAIR(i<=lastlineofupperhalf? CP_BlueWhite : CP_BrownWhite));
		addstr(spaces80);
		move(i+1, 20);
		attrset(COLOR_PAIR(i+1<=lastlineofupperhalf? CP_BlueWhite : CP_BrownWhite));
		addstr("pHONg sHAdeD pOlYgoNS!");
		refresh();
		m_msleep(100);
	}
	
	move(LINES-2, 20);
	attrset(COLOR_PAIR(CP_BrownBlack));
	typewrite("coming up. a.s.a.p");
	
	m_sleep(9);
	
	scrollmain();
	
	endwin();
	printf("lft '00\n");
}

