/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.net.URL;
import java.util.Date;

public class IntroJava_Euskal8_Alo
extends Applet
implements Runnable {
    private Thread idx_Thread;
    private Thread mb_thread;
    private boolean initialized = false;
    private int idx_w;
    private int idx_h;
    private boolean animate = true;
    private boolean motionblur = true;
    private String BumpMapFile = new String();
    private Image BumpMapImage;
    private int BumpHeight = 255;
    private int Lx;
    private int Ly;
    private int L_Red;
    private int L_Green;
    private int L_Blue;
    private int LightRadius;
    private int phong = 128;
    private Image TargetImage;
    private int[] TargetPixel;
    private double pi = 3.14159265;
    private double angle;
    private double speed = 5.0;
    private byte[][] nx;
    private byte[][] ny;
    private int length;
    double W1;
    double W2;
    private MemoryImageSource idx_mis;
    private ColorModel idx_cm;
    Date idx_date;
    private int[][] EnvMap;
    public double inicio_ejecucion;
    private AudioClip ac;

    public void init() {
    }

    public void initialize() {
        this.setBumpSize(this.size().width, this.size().height);
        this.getParameters();
        this.putParameters();
        this.initBumpMap();
        this.initColorTable();
        this.initEnvMap();
        this.idx_mis = new MemoryImageSource(this.idx_w, this.idx_h, this.idx_cm, this.TargetPixel, 0, this.idx_w);
        this.TargetImage = this.createImage(this.idx_mis);
        System.gc();
        this.initialized = true;
        Date date = new Date();
        this.inicio_ejecucion = date.getTime();
        date = null;
        this.poner_musiquita_buena();
    }

    private void poner_musiquita_buena() {
        URL uRL = null;
        try {
            uRL = new URL(this.getDocumentBase(), "/IntroJava_Euskal8_Alo.au");
        }
        catch (Exception exception) {
            System.out.println("ERROR al leer el sonido!!!!! =:-O");
        }
        this.ac = this.getAudioClip(uRL);
        this.ac.loop();
    }

    private void getParameters() {
        this.BumpMapFile = this.getParameter("BumpMapFile");
        this.BumpHeight = Integer.parseInt(this.getParameter("BumpHeight"));
        if (this.BumpHeight > 255) {
            this.BumpHeight = 255;
        }
        if (this.BumpHeight < -255) {
            this.BumpHeight = -255;
        }
        this.phong = Integer.parseInt(this.getParameter("Phong"));
        if (this.phong < 1) {
            this.phong = 1;
        }
        if (this.phong > 254) {
            this.phong = 254;
        }
        Color color = new Color(Integer.parseInt(this.getParameter("LightColor"), 16));
        this.L_Red = color.getRed();
        this.L_Green = color.getGreen();
        this.L_Blue = color.getBlue();
        this.LightRadius = Integer.parseInt(this.getParameter("LightRadius"));
        this.speed = (double)Integer.parseInt(this.getParameter("Speed")) / 10.0;
        this.motionblur = Integer.parseInt(this.getParameter("MotionBlur")) == 1;
    }

    private void putParameters() {
        this.TargetPixel = new int[this.idx_w * this.idx_h];
        this.TargetImage = this.BumpMapImage;
        this.nx = new byte[this.idx_w][this.idx_h];
        this.ny = new byte[this.idx_w][this.idx_h];
        this.EnvMap = new int[this.LightRadius][this.LightRadius];
        this.W1 = this.pi / 1000.0 * (Math.random() / 2.0 + 0.5) * this.speed;
        this.W2 = this.pi / 1000.0 * (Math.random() / 2.0 + 0.5) * this.speed;
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, this.size().width, this.size().height);
        graphics.setColor(new Color(0, 255, 0));
    }

    public void start() {
        if (this.idx_Thread == null) {
            this.idx_Thread = new Thread(this);
            this.idx_Thread.start();
        }
    }

    public void stop() {
        if (this.idx_Thread != null) {
            this.idx_Thread.stop();
            this.idx_Thread = null;
        }
    }

    public void run() {
        while (true) {
            this.repaint();
            try {
                Thread.sleep(20L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                System.out.println("interrupido");
                continue;
            }
            break;
        }
    }

    public void update(Graphics graphics) {
        if (this.initialized) {
            this.Animate();
            this.Render();
            this.TargetImage.flush();
            graphics.drawImage(this.TargetImage, 0, 0, this);
            return;
        }
        this.paint(graphics);
        this.initialize();
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return true;
    }

    private void initBumpMap() {
        int n;
        int n2;
        int n3;
        int[] nArray = new int[this.length];
        int[][] nArray2 = new int[this.idx_w][this.idx_h];
        int[][] nArray3 = new int[this.idx_w][this.idx_h];
        this.BumpMapImage = this.getImage(this.getDocumentBase(), this.BumpMapFile);
        nArray = this.getPixels(this.BumpMapImage, this.idx_w, this.idx_h);
        this.BumpMapImage = null;
        int n4 = 0;
        while (n4 < this.idx_h) {
            n3 = 0;
            while (n3 < this.idx_w) {
                Color color = new Color(nArray[n4 * this.idx_w + n3]);
                n2 = color.getRed();
                n = color.getGreen();
                int n5 = color.getBlue();
                nArray2[n3][n4] = n2 + n + n5;
                ++n3;
            }
            ++n4;
        }
        int n6 = 0;
        while (n6 < this.idx_w) {
            n2 = 0;
            while (n2 < this.idx_h) {
                n3 = nArray2[n6][n2];
                n3 += nArray2[(n6 + 1) % this.idx_w][n2];
                n3 += nArray2[(n6 + this.idx_w - 1) % this.idx_w][n2];
                n3 += nArray2[n6][(n2 + 1) % this.idx_h];
                n3 += nArray2[n6][(n2 + this.idx_h - 1) % this.idx_h];
                n3 += nArray2[(n6 + 1) % this.idx_w][(n2 + 1) % this.idx_h];
                n3 += nArray2[(n6 + this.idx_w - 1) % this.idx_w][(n2 + this.idx_h - 1) % this.idx_h];
                n3 += nArray2[(n6 + this.idx_w - 1) % this.idx_w][(n2 + 1) % this.idx_h];
                n3 += nArray2[(n6 + 1) % this.idx_w][(n2 + this.idx_h - 1) % this.idx_h];
                nArray3[n6][n2] = (byte)((float)(n3 /= 9) / 3.0f * (float)this.BumpHeight / 255.0f);
                ++n2;
            }
            ++n6;
        }
        nArray2 = nArray3;
        n2 = 1;
        while (n2 < this.idx_w - 1) {
            n = 1;
            while (n < this.idx_h - 1) {
                this.nx[n2][n] = (byte)(nArray2[n2 + 1][n] - nArray2[n2 - 1][n]);
                this.ny[n2][n] = (byte)(nArray2[n2][n + 1] - nArray2[n2][n - 1]);
                ++n;
            }
            ++n2;
        }
        nArray = null;
        nArray2 = null;
        nArray3 = null;
    }

    private void initEnvMap() {
        float f = this.LightRadius;
        int n = 0;
        while (n < this.LightRadius) {
            int n2 = 0;
            while (n2 < this.LightRadius) {
                float f2 = (float)n2 / f;
                float f3 = (float)n / f;
                float f4 = (float)(1.0 - Math.sqrt(f2 * f2 + f3 * f3));
                if (f4 < 0.0f) {
                    f4 = 0.0f;
                }
                this.EnvMap[n2][n] = (int)(f4 * 255.0f);
                ++n2;
            }
            ++n;
        }
    }

    private void initColorTable() {
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        int n = 0;
        while (n < 255 - this.phong) {
            byArray[n] = (byte)(this.L_Red * n / (255 - this.phong));
            byArray2[n] = (byte)(this.L_Green * n / (255 - this.phong));
            byArray3[n] = (byte)(this.L_Blue * n / (255 - this.phong));
            ++n;
        }
        int n2 = 255 - this.phong;
        while (n2 < 256) {
            byArray[n2] = (byte)(this.L_Red + (255 - this.L_Red) * (n2 + this.phong - 255) / this.phong);
            byArray2[n2] = (byte)(this.L_Green + (255 - this.L_Green) * (n2 + this.phong - 255) / this.phong);
            byArray3[n2] = (byte)(this.L_Blue + (255 - this.L_Blue) * (n2 + this.phong - 255) / this.phong);
            ++n2;
        }
        this.idx_cm = new IndexColorModel(8, 256, byArray, byArray2, byArray3);
    }

    private int[] getPixels(Image image, int n, int n2) {
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {}
        return nArray;
    }

    public void setBumpSize(int n, int n2) {
        this.idx_w = n;
        this.idx_h = n2;
    }

    private void Render() {
        int n = this.LightRadius - 1;
        int n2 = 0;
        while (n2 < this.idx_h) {
            int n3 = n2 * this.idx_w;
            int n4 = 0;
            while (n4 < this.idx_w) {
                int n5 = Math.abs(this.nx[n4][n2] - n4 + this.Lx);
                int n6 = Math.abs(this.ny[n4][n2] - n2 + this.Ly);
                if (n5 > n) {
                    n5 = n;
                }
                if (n6 > n) {
                    n6 = n;
                }
                this.TargetPixel[n4 + n3] = this.motionblur ? (this.EnvMap[n5][n6] >> 1) + (this.TargetPixel[n4 + n3] >> 1) : this.EnvMap[n5][n6];
                ++n4;
            }
            ++n2;
        }
    }

    private void Animate() {
        this.idx_date = new Date();
        double d = this.idx_date.getTime();
        double d2 = d - this.inicio_ejecucion;
        if (d2 < 10000.0 && this.animate) {
            this.Lx = (int)((Math.cos(this.W1 * d) + 1.0) * (double)this.idx_w / 2.0);
            this.Ly = (int)((Math.sin(this.W2 * d) + 1.0) * (double)this.idx_h / 2.0);
        }
        if (d2 < 15000.0 && d2 < 30000.0 && this.animate) {
            this.Lx = (int)((Math.cos(this.W1 * d) + 1.0) * (double)this.idx_w / 2.0);
            this.Ly = (int)((Math.sin(this.W2 * d) + 1.0) * (double)this.idx_h / 2.0);
        }
        if (d2 > 35000.0 && d2 < 50000.0) {
            this.Lx = (int)((Math.cos(this.W1 * d) + 1.0) * (double)this.idx_w / 2.0);
            this.Ly = (int)((Math.sin(this.W2 * d) + 1.0) * (double)this.idx_h / 2.0);
        }
        if (d2 > 50000.0) {
            System.exit(1);
        }
    }
}

