#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <malloc.h>


typedef unsigned char      UBYTE;
typedef unsigned short int UWORD;
typedef unsigned long  int UDWORD;

typedef short int WORD;  //signed
typedef long  int DWORD;


#define GRD  0.0174532925


typedef struct
{
  UWORD x;
  UBYTE inc, vib;
}pto;

pto nieve[200];



void SetColorPalette ( UBYTE color, UBYTE r, UBYTE g,
                       UBYTE b )
{
 outp ( 0x3C8, color );
 outp ( 0x3C9, r );
 outp ( 0x3C9, g );
 outp ( 0x3C9, b );
}



void setmode ( short modo );
#pragma aux setmode = \
 "int 0x10" \
 parm[ ax ];


void WaitRetrace ( void )
{
 while ( inp(0x3DA)&8 );
 while ( !(inp(0x3DA)&8) );
}


void Move ( UBYTE *, UBYTE *, UWORD );
#pragma aux Move=\
"rep movsd"\
modify [eax ecx edi]\
parm [edi] [esi] [ecx]

void MSet ( UBYTE *, UWORD );
#pragma aux MSet=\
"xor eax, eax"\
"rep stosd"\
modify [eax ecx edi]\
parm [edi] [ecx]



void main ( void )
{
 UBYTE *vga = ( UBYTE *) 0xA0000;
 UBYTE *vscreen;
 UBYTE *blurscreen;

 UWORD i = 0, j = 0;
 WORD x = 0, y = 0;

 char delta;
 UBYTE c;




 if ( ( vscreen = ( UBYTE *) malloc ( 64000U ) ) == NULL )
 {
  setmode ( 0x3 );
  printf ( "Problemas al asignar memoria" );
  exit ( -1 );
 }
 MSet ( vscreen, 16000 );

 if ( ( blurscreen = ( UBYTE *) malloc ( 64000U ) ) == NULL )
 {
  setmode ( 0x3 );
  printf ( "Problemas al asignar memoria" );
  exit ( -1 );
 }
 MSet ( blurscreen,  16000 );


 setmode ( 0x13 );

 for ( i = 0; i<256; i++ )
    SetColorPalette ( i, i<<2, i<<2, i<<2 );


 for ( c = 0; c<200; c++ )
 {
    nieve[c].inc = (rand()%4);
    nieve[c].x = (rand()%319);
    nieve[c].vib = 1;
 }


 while ( !kbhit() )
 {

 for ( c = 0; c<200; c++ )
 {
     y+= nieve[c].inc;
     x = nieve[c].x + (20*sin(nieve[c].vib*y*GRD));

     if ( x<0 )
     {
       delta = -2*x;
       x = delta;
     }

     if ( x>319 )
     {
       delta = x - 319;
       x = 319 - delta;
     }

     if ( y>= 199 ) y = 0;

     vscreen[x+(y<<8)+(y<<6)] = 15;
 }

 for ( c = 0; c<200; c++ )
 {
     y+= nieve[c].inc;
     x = nieve[c].x + (-20*cos(nieve[c].vib*-y*GRD));

     if ( x<0 )
     {
       delta = -2*x;
       x = delta;
     }

     if ( x>319 )
     {
       delta = x - 319;
       x = 319 - delta;
     }

     if ( y>= 199 ) y = 0;

     vscreen[x+(y<<8)+(y<<6)] = 15;
 }


  if ( !(rand()%10) )
    for ( j = 0; j<200; j++ )
       for ( i = 0; i<320; i++ )
          vscreen[i+(j<<8)+(j<<6)] = 15;


  for ( j = 0; j<200; j++ )
     for ( i = 0; i<320; i++ )
        blurscreen[i+(j<<8)+(j<<6)] = (vscreen[i+(j<<8)+(j<<6)] +
                                       blurscreen[i+(j<<8)+(j<<6)])<<1;

  WaitRetrace ();
  Move ( vga, blurscreen, 16000 );
  MSet ( vscreen, 16000 );

 }

 free ( vscreen );
 free ( blurscreen );
 setmode ( 0x3 );
 printf ( "\n ElfHood / RgB... SUX! :P\n\a\a\a" );
 printf ( "\n\nSceneGay RULEEEEEEEEEEEEZZZZZZZZZZZ!!! :)\n" );
}
