{$M 65135, 0, 330360}
program npi;

uses    mse_tp, dos, crt, gfx32,
        crys32u,realgra3,gfxmcga;

{--------------------------------------------------------------[CONST]------}
const
     SndDevice  =4;             {Sound Device, 1 = Gravis ULTRSND }
                                {              2 = SBlaster 1.xx  }
                                {              3 = SBlaster 2.xx  }
                                {              4 = SBlaster PRO   }
                                {              5 = SBlaster 16    }
                                {              6 = ProAudioSprect }


     MODULENAME ='PSYCHO.GDM';

     hpoints=3400;             {number of horizontal points[part1]} {[1&2]}
     vpoints=4300;             {number of vertical points[part1]}

     curve = 125;                                                   {[3]}
     xmax = 38;
     ymax = 58;
     sofs = 57; samp = 10; slen = 255;
     tunnelspeed=2;                                                 {[4]}
     tunnelpoints=500;

     factor=7;                                                      {[5]}

     Num_V=8;                                                    {[6&7&8]}
     Num_P=6;

     c1=10;                                                         {[6]}
     c2=30;
{---------------------------------------------------------------[TYPES]-----}
type
   hpt     =array [1..hpoints,0..2] of integer;
   vpt     =array [1..vpoints,0..2] of integer;
   stabt   =array[0..slen] of longint;

   Vertex = Record x, y, z : Longint; End;                           {[6]}
   Poly = Record v1,v2,v3,v4,c : Byte; end;
   rotation = Record rx,ry,rz:byte; end;

   sTable   =Array[0..511] of Longint;

   OCdst    =Array[0..Num_V-1] of Vertex; {object coords}
   OPolt    =Array[0..Num_P-1] of Poly;
   WCdst    =Array[0..Num_V*2-1] of Vertex; {world/screen coords}
   PINDt    =array[0..Num_P] of integer;
   PZt      =array[0..Num_P] of longint;

   ftablet  =array [0..59,0..59] of byte; {fire}
{---------------------------------------------------------------[VARS]------}
var
   ModHeader    :GDMheader;
   ErrorFlag    :word;
   BASEIO       :word;
   irq          :byte;
   dma          :byte;
   EmsFlag      :word;
   f            :file;
   muschans     :byte;
   floop        :byte;

   bufp,prep,
   gfxp         :pointer;
   bufs,pres,
   gfxs         :word;

   loop1,loop2,
   loop3,loop4  :word;

   ytable       :array [0..199] of word;
   pal1         :array [0..767] of byte;
   pal2         :array [0..767] of byte;
   frames       :word;
   xarray       :array[0..319] of word;
   yarray       :array[0..399] of word;

   xp,yp   :word;

   hp      : ^hpt;
   vp      : ^vpt;

   stab    : ^stabt;

   tp      : array[1..tunnelpoints] of byte;

   sidx    :byte;
   escape  :byte;
   IRQ_seg,IRQ_off:word;

   Sint, Cost : ^STable;

   OCds : ^ocdst;
   OPol : ^Opolt;
   WCds : ^Wcdst;
   PIND : ^PINDt;
   PZ : ^PZt;

   rx,ry,rz:Word;
   rot1,rot2:rotation;
   wx,wy,wz,xc1,yc1,xc2,yc2,Loop,mode:integer;
   xf,yf:integer;
   xx,yy,zz,xc,yc,zflux:Integer;


   ftable : ^ftablet;
   ftp : pointer;
   movem:integer;


{-------------------------------------------------------------[PROCS]-------}
{$I GENERAL.INC}
{$I Init.INC}                 {These are some PROCS used
                               as they were MACROS :-)  }
{$I PART1&2.inc}              {ELERIUM CORE LOGO & CREDITS & PAINFULLY PRS}
{$I PART3.inc}                {ENERGY POOL WITH NPI TITLE}
{$I PART4.INC}                {MID-RES GHOST TUNNEL PENK!}
{$I PART5.INC}                {SPOTLIGHTED DOTS & ELERIUM CORE LOGO}
{$I PART6.inc}                {CRYSTAL VECTORS OVER GRAVITY FIELD (?)}
{-------------------------------------------------------------[MAIN CODE]---}
Begin
 InstalaIRQ;
 clrscr;
 InitStuff;
 InitDemo;
 Clearmemory;
 asm mov ax,13h; int 10h; end;

 if paramcount<1 then
 MusicOrder(2)
 else begin
  val(paramstr(1),loop1,loop2);
  musicorder(loop1);
 end;



 preparepart1;
 if musicorder($ff)=2 then DoFIPart1;
 while musicorder($ff)=2 do doPart1;
 while musicorder($ff)=3 do doPart1;
 PreparePart2;
 while musicorder($ff)=4 do dopart2;
 preparepart2_5;

 for floop:=1 to 3 do begin
  doflash3;
  dopart2_5;
 end;

 while musicorder($ff)<6 do dopart2_5;
 doflash2;
 clearmemory;
 dispose(hp);
 dispose(vp);
 preparepart3;

 for floop:=1 to 3 do begin
  doflash3;
  dopart3;
 end;

 while musicorder($ff)<8 do dopart3;
 dopart3_2;
 clearpart3;
 pre4_2;
 dispose(stab);
 preparepart4;
 while musicorder($ff)<10 do dopart4;
 while musicorder($ff)=10 do begin
  if musicrow<=32 then dopart4;
  if musicrow>32 then dopart4_2;
 end;

 preparepart5_1;
 while musicorder($ff)=11 do dopart5_2(1);

 for floop:=1 to 3 do doflash3;
 preparepart5_2;
 while musicorder($ff)=12 do dopart5_2(4);

 for floop:=1 to 3 do doflash3;
 preparepart5_2;
 while musicorder($ff)=13 do dopart5_1;

 for floop:=1 to 3 do doflash3;
 preparepart5_2;
 while musicorder($ff)<15 do dopart5_3(4);

 cls32($a000,0);
 clearmemory;

 for floop:=1 to 3 do doflash3;               {CRYSTAL VECTORS OVR GRVITY..}
   New(Sint);
   new(Cost);
   New(OCds);
   New(OPol);
   New(WCds);
   New(PIND);
   New(PZ);
   New(ftable);


 preparepart6;
 while musicorder($ff)<17 do dopart6;
   dispose(Sint);
   dispose(Cost);
   dispose(OCds);
   dispose(OPol);
   dispose(WCds);
   dispose(PIND);
   dispose(PZ);
   dispose(ftable);

 CloseDemo;
end.
