Program fILTER;

Uses CRT,GFXMCGAf,GFX32f,gfxmcga,gfx32;

Const Num_V=50;
      Num_P=48;

Type
  Vertex = Record x, y, z : Longint; End;
  Poly = Record v1,v2,v3,v4,c : byte; end;

Var
  Time : Longint ABSOLUTE $0:$046c;
  STime, ETime, Frame : Longint;
  Sint, Cost : Array[0..511] of Longint;

  OCds : Array[0..Num_V-1] of Vertex; {object coords}
  OPol : Array[0..Num_P-1] of Poly;
  WCds : Array[0..Num_V-1] of Vertex; {world/screen coords}
  PIND : array[0..Num_P] of integer;
  PZ : array[0..Num_P] of longint;

  rx,ry,rz,wx,wy,wz,Loop:Word;


{$L filtdata.obj}
PROCEDURE FiltData; external;

{}
Procedure MakeTables;
Begin
 For Loop := 0 to 511 do Begin
  Sint[Loop]:=Round(Sin(Loop*(2*Pi)/512)*32768);
  Cost[Loop]:=Round(Cos(Loop*(2*Pi)/512)*32768);
 End;
End;

{}
PROCEDURE Init;
var LW:Word;
begin
  for LW:=0 to Num_V-1 do with OCds[LW] do
  begin
   x:=mem[seg(@Filtdata^):ofs(@Filtdata^)+LW*3]-100;
   y:=mem[seg(@Filtdata^):ofs(@Filtdata^)+LW*3+1]-100;
   z:=mem[seg(@Filtdata^):ofs(@Filtdata^)+LW*3+2]-100;
   x:=x*11;
   y:=y*11;
   z:=z*22;
  end;
  for LW:=0 to Num_P-1 do with OPol[LW] do
  begin
   v1:=mem[seg(@Filtdata^):ofs(@Filtdata^)+Num_V*3+LW*4];
   v2:=mem[seg(@Filtdata^):ofs(@Filtdata^)+Num_V*3+LW*4+1];
   v3:=mem[seg(@Filtdata^):ofs(@Filtdata^)+Num_V*3+LW*4+2];
   v4:=mem[seg(@Filtdata^):ofs(@Filtdata^)+Num_V*3+LW*4+3];
  end;

  For Loop := 0 to 11 do OPol[Loop].c:=0;
  For Loop := 12 to 23 do OPol[Loop].c:=128;
  For Loop := 24 to 35 do OPol[Loop].c:=63;
  For Loop := 36 to 41 do OPol[Loop].c:=63;
  For Loop := 42 to 47 do OPol[Loop].c:=0;

  for Loop:= 1 to 63 do
  begin
   Pal(Loop,Loop div 3+20,Loop div 4+20,20);
   Pal(Loop+64,Loop,Loop,Loop);
   Pal(Loop+128,Loop,Loop,Loop);
  end;
end;

{}
PROCEDURE quicksort(lo,hi:integer);

procedure sort(l,r:integer);
var i,j,x,y:integer;
begin
  i:=l; j:=r; x:=PZ[(l+r) div 2];
  repeat
    while PZ[i]<x do inc(i);
    while x<PZ[j] do dec(j);
    if i<=j then begin
      y:=PZ[i]; PZ[i]:=PZ[j]; PZ[j]:=y;
      y:=pind[i]; pind[i]:=pind[j]; pind[j]:=y;
      inc(i); dec(j);
    end;
  until i>j;
  if l<j then sort(l,j);
  if i<r then sort(i,r);
end;

begin
  sort(lo,hi);
end;

{}
Function SHRI(I,B : Longint) : Longint;
Begin If I<0 Then SHRI:=-((-I) Shr B) Else SHRI:=(I Shr B); End;

{}
Procedure Rotate3D;
var  x,y,z,xn,yn,zn,count:Longint;
     rxnew,rynew,rznew : WORD;
Begin
 For Loop := 0 to Num_V -1 do
 Begin
   x:=OCds[Loop].x; y:=OCds[Loop].y; z :=OCds[Loop].z;
   RXnew:=RX;
   RYnew:=RY;
   RZnew:=RZ;

  inc(Count);
  Yn:=shri((Y*Cost[RXnew])-(Z*Sint[RXnew]),15);
  Zn:=shri((Y*Sint[RXnew])+(Z*Cost[RXnew]),15);
  Y:=Yn; Z:=Zn;

  Xn:=shri(X*Cost[RYnew]-Z*Sint[RY],15);
  Zn:=shri(X*Sint[RYnew]+Z*Cost[RY],15);
  X:=Xn; Z:=Zn;

  Xn:=shri(X*Cost[RZnew]-Y*Sint[RZnew],15);
  Yn:=shri(X*Sint[RZnew]+Y*Cost[RZnew],15);
  X:=Xn; Y:=Yn;

  WCds[Loop].x := (X Shl 8) Div (5000-Z) + 160;
  WCds[Loop].y := (Y Shl 8) Div (5500-Z) + 100;
  WCds[Loop].z:=8000+Z;
 End;
End;

{}
{}

Begin
 Asm Mov ax,13h;int 10h;end;
 SetUpVirtual;
 Init;
 MakeTables;
 rx:=30; ry:=0; rz:=0;
 wx:=1; wy:=2; wz:=3;
 Frame:=0;STime:=Time;
 Repeat
  Rotate3D;
  for Loop:=0 to Num_P-1 do with OPol[Loop] do begin
   PZ[Loop]:=(WCds[v1].z+WCds[v2].z+WCds[v3].z+WCds[v4].z) shr 1;
   Pind[Loop]:=Loop;
  end;
  QuickSort(0,Num_P);

  for Loop:=0 to Num_P-1 do begin
   PZ[Loop]:=(PZ[Loop] div 118-110)*2;
   if PZ[LOOP]<0 then PZ[Loop]:=0;
   if PZ[LOOP]>63 then PZ[Loop]:=63;
  end;


  CLS32(VirSeg,0);
  For Loop := 0 to Num_P-1 do with OPol[Pind[Loop]] do
    DrawPolyf(WCds[v1].x,WCds[v1].y,
             WCds[v2].x,WCds[v2].y,
             WCds[v3].x,WCds[v3].y,
             WCds[v4].x,WCds[v4].y,PZ[Loop]+c,VirSeg);

  rx:=(rx+wx) and 511; ry:=(ry+wy) and 511; rz:=(rz+wz) and 511;
  Frame:=Frame+1;
  WaitRetrace;
  Flip32(VirSeg,VidSeg);
  Until Port[$60]=1; ETime := Time;
 Asm Mov ax,03h;int 10h;end;
 ShutDown;
 Write('3D SAVUKN (FILTER) .. 031196 by EleriuM CorE     at ');
 Writeln((Frame*18.2)/(ETime-STime):5:2, ' fps');
 WriteLn;
 WriteLn(' Code........Real Ice');
 WriteLn(' Object......Obscure');
 WriteLn;
 WriteLn('last mod. 041196');
end.
