#include <math.h>
#include <malloc.h>
#include <wgt5.h>
#include <wgtvesa.h>
#include <stdlib.h>
#include <direct.h>
#include <string.h>
#include <pr.h>

#include "e:\seal\test\audio\include\audio.h"

#ifdef __3DFX__
#include <glide.h>
#include <pr3dfx.h>
#endif

/*
   Dreams
   For The Party 6
   Started on Dec. 17/1996
   Finished on Dec. 23/1996

   Note that some parts work on the 3Dfx but not all
   (mirrors and motion blur).

   Written by Chris Egerter
   egerter@egerter.com            www.egerter.com
*/


PR_DWORD device;                /* Video output device */
PR_DWORD ticks=0;               /* Total number of ticks passed */
PR_DWORD global_ticks=0;
PR_DWORD secret = 0;
PR_DWORD demo_sound;            /* 1 if sound is on */
PR_DWORD sound_config = 0;      /* 1 if manual configuration is used */
PR_DWORD fading = 0;
PR_DWORD song_row, song_patt;   /* Song row and pattern */

color fadepal[256];


PR_DWORD vwidth;                /* Viewport size */
PR_DWORD vheight;
PR_VIEWPORT viewport;           /* Our viewport structure */
PR_VIEWPORT mirrorview;         /* Our mirror viewport */

PR_CAMERA *newcam;              /* One camera */
PR_LIGHTLIST userlights;        /* A bunch of lights */


AUDIOINFO info;
AUDIOCAPS caps;
LPAUDIOMODULE lpModule;
UINT rc, nDevId;



void InitializeSound (void)
/* Loads in the song and wave files */
{
int i;
char szText[80];
PR_DWORD sound_device, sound_bits, sound_mode, sound_rate;


  /* initialize audio library */
  AInitialize ();

  /* open audio device */
  info.nDeviceId = AUDIO_DEVICE_MAPPER;
  info.wFormat = AUDIO_FORMAT_8BITS | AUDIO_FORMAT_MONO;
  info.nSampleRate = 22050;

  if (sound_config)
    {
     /* show registered device drivers */
     printf("List of registered devices:\n");
     for (nDevId = 1; nDevId < AGetAudioNumDevs(); nDevId++) {
         AGetAudioDevCaps(nDevId, &caps);
         printf("  %2d. %s\n", nDevId, caps.szProductName);
        }

     printf("\n");
     printf ("Choose a sound device: ");
     scanf ("%i", &sound_device);
     info.nDeviceId = sound_device;


     printf("\n\n");
     printf ("0. 8 bit\n");
     printf ("1. 16 bit\n");
     printf ("Choose the bit quality: ");
     scanf ("%i", &sound_bits);
     if (sound_bits == 1)
       info.wFormat = AUDIO_FORMAT_16BITS;
     else
       info.wFormat = AUDIO_FORMAT_8BITS;

     printf("\n\n");
     printf ("0. Mono\n");
     printf ("1. Stereo\n");
     printf ("Choose the mode: ");
     scanf ("%i", &sound_mode);
     if (sound_bits == 1)
       info.wFormat |= AUDIO_FORMAT_STEREO;
     else
       info.wFormat |= AUDIO_FORMAT_MONO;


     printf("\n\n");
     printf ("0. 16000\n");
     printf ("1. 22050\n");
     printf ("2. 44100\n");
     printf ("Choose the sample rate (22050 recommended): ");
     scanf ("%i", &sound_rate);
     if (sound_rate == 0)
       info.nSampleRate = 16000;
     else if (sound_rate == 2)
       info.nSampleRate = 44100;
     else 
       info.nSampleRate = 22050;
    }


    if ((rc = AOpenAudio(&info)) != AUDIO_ERROR_NONE) {
        AGetErrorText(rc, szText, sizeof(szText) - 1);
        printf("ERROR: %s\n", szText);
        exit(1);
    }
    else {
        AGetAudioDevCaps(info.nDeviceId, &caps);
        printf("Using %s.\n", caps.szProductName);
        printf("Audio device initialized at %d bits %s %u Hz\n",
            info.wFormat & AUDIO_FORMAT_16BITS ? 16 : 8,
            info.wFormat & AUDIO_FORMAT_STEREO ?
                "stereo" : "mono", info.nSampleRate);
    }


  /* load module and waveform file */
  ALoadModuleFile ("bm_green.xm", &lpModule, 0);

  /* open voices for module and waveforms */
  AOpenVoices (lpModule->nTracks);

  delay (1000);
}



void DeinitSound (void)
/* Stop the music and any waves that are playing, and frees the
   sound data */
{
int i;

  /* stop playing the module */
  AStopModule ();
  ACloseVoices ();

  /* release the module */
  AFreeModuleFile (lpModule);

  /* close audio device */
  ACloseAudio ();
}




/* ---------------------------------------------------------------------- */
/* Initialize the video output device */
/* ---------------------------------------------------------------------- */
void InitializeDevices (void)
{
 #ifdef __3DFX__
  if ((device == DEVICE_3DFX) || (device == DEVICE_ANY))
    device = PR_Detect3Dfx ();
 #endif

  if ((device == DEVICE_SVGA) || (device == DEVICE_ANY))
    device = PR_DetectSVGA ();   /* Attempt to find the device */

  if ((device == DEVICE_VGA) || (device == DEVICE_ANY))
    device = PR_DetectVGA ();   /* Attempt to find the device */

 #ifdef __3DFX__
  if (device == DEVICE_3DFX)
    {
     PR_Initialize3Dfx ();
     atexit (PR_Shutdown3Dfx);
    }
 #endif

  if (device == DEVICE_SVGA)
    {
     PR_InitializeSVGA ();
     atexit (PR_ShutdownSVGA);
    }
  else if (device == DEVICE_VGA)
    {
     PR_InitializeVGA ();
    }
}


/* ---------------------------------------------------------------------- */
/* Sets the fade palette to white */
/* ---------------------------------------------------------------------- */
void WhitePalette (void)
{
PR_DWORD i;

  for (i = 0; i < 256; i++)
    wsetrgb (i, 63, 63, 63, fadepal);
  wsetpalette (0, 255, fadepal);
}

/* ---------------------------------------------------------------------- */
/* Sets the global palette to black */
/* ---------------------------------------------------------------------- */
void BlackPalette (void)
{
PR_DWORD i;

  for (i = 0; i < 256; i++)
    wsetrgb (i, 0, 0, 0, global_palette);
}

/* ---------------------------------------------------------------------- */
/* Sets the global palette to 4/3 */
/* ---------------------------------------------------------------------- */
void BrightPalette (void)
{
PR_DWORD i;

  for (i = 0; i < 256; i++)
    {
     fadepal[i].r = (PR_REAL)global_palette[i].r * 1.5;
     fadepal[i].g = (PR_REAL)global_palette[i].g * 1.5;
     fadepal[i].b = (PR_REAL)global_palette[i].b * 1.5;

     if (fadepal[i].r > 63)
       fadepal[i].r = 63;
     if (fadepal[i].g > 63)
       fadepal[i].g = 63;
     if (fadepal[i].b > 63)
       fadepal[i].b = 63;
    }
}

/* ---------------------------------------------------------------------- */
/* Decreases each color in fade pal until it reaches the color in */
/* global_palette */
/* ---------------------------------------------------------------------- */
void DecPalette (void)
{
PR_DWORD i;

  for (i = 0; i < 256; i++)
    {
     if (fadepal[i].r > global_palette[i].r)
       fadepal[i].r--;
     if (fadepal[i].g > global_palette[i].g)
       fadepal[i].g--;
     if (fadepal[i].b > global_palette[i].b)
       fadepal[i].b--;
    }
  wsetpalette (0, 255, fadepal);
}


/* ---------------------------------------------------------------------- */
/* Timer Interrupt */
/* ---------------------------------------------------------------------- */
void timerproc (void)
{
  ticks++;
  global_ticks++;

  if (fading)
    DecPalette ();

  if (demo_sound)
    AUpdateAudio ();
}                


/* ---------------------------------------------------------------------- */
/* Sets to 320x200 mode */
/* ---------------------------------------------------------------------- */
void SetVideoMode (void)
{

#ifdef __3DFX__
  vwidth = 640;
  vheight = 480;
#else
  vwidth = 320;
  vheight = 200;
#endif

  PR_SetMode (vwidth, vheight, 60);

  PR_OpenViewport (&viewport, 1, 1, vwidth-2, vheight-2, VIEW_PLAIN);

  PR_SetViewport (&viewport);
  PRGFX_Clip (active_viewport.topx,
              active_viewport.topy,
              active_viewport.bottomx,
              active_viewport.bottomy);
}





/* ---------------------------------------------------------------------- */
/* Make a list of lights */
/* ---------------------------------------------------------------------- */
void InitializeLights (void)
{
  /* Initialize the lights */
  PR_AllocLights (&userlights, 20);      /* User lights */
  PR_AllocLights (&scenelights, 20);     /* Master scene light list */

  PR_SetLightPosition (&userlights, 0, 0, 0, 10000);
  /* Doesn't matter because we set it to the camera location every frame */

  PR_SetLightOn (&userlights, 0);
  PR_SetLightType (&userlights, 0, DIRECTIONAL_LIGHT);
  PR_SetLightStrength (&userlights, 0, 1.0);
  PR_SetLightColor (&userlights, 0, 1.0, 1.0, 1.0);

  PR_SetLightOn (&userlights, 1);
  PR_SetLightType (&userlights, 1, DIRECTIONAL_LIGHT);
  PR_SetLightStrength (&userlights, 1, 1.0);
  PR_SetLightColor (&userlights, 1, 1.0, 1.0, 1.0);


  userlights.NumLights = 1;     /* This sets how many lights are actually used */
}



/* ---------------------------------------------------------------------- */
/* Loads a PRO file */
/* ---------------------------------------------------------------------- */
PR_OBJECT *LoadFile (char *filename)
{
PR_REAL cenx, ceny, cenz;
PR_OBJECT *newobj;

  load_palette = 1;
  newobj = PR_LoadPRO (filename, LOAD_NORMAL);

  PR_Settings.FrontToBack = 0;
  if (newobj == NULL)
    {
     wsetmode (3);
     printf ("Could not open the PRO file %s\n", filename);
     exit (1);
    }
  wsetpalette (0, 255, global_palette);
  PR_CenterObject (newobj, &cenx, &ceny, &cenz);
  return (newobj);
}



/* ---------------------------------------------------------------------- */
/* Returns 0 if the song has passed a certain place */
/* ---------------------------------------------------------------------- */
PR_DWORD CheckSongPosition (PR_DWORD order, PR_DWORD row)
{
PR_DWORD pos;
PR_DWORD past;

  past = (order << 6) + row;

  if (demo_sound)
    {
     AGetModulePosition (&song_patt, &song_row);
     pos = (song_patt << 6) + song_row;
    }
  else
    {
     pos = global_ticks * 0.35;
    }

  if (kbdon[KEY_ESC])
    exit (1);

  if (pos > past)
    return 0;
  return 1;
}    


/* Opening with Kosmic logo */

void Part1 (void)
{
PR_OBJECT *torus_shape;
PR_OBJECT *logo_shape;
PR_ENTITY *torus_entity;
PR_ENTITY *logo_entity;

PR_REAL logoz = 0, logodist = 200;
PR_REAL sinw1 = 0;
PR_REAL sinw2 = 27;
PR_DWORD past_ticks;
block ktitle;

  wnormscreen ();
  wcls (0);
  PR_AllocMaterialList (256);
  PR_AllocWorldTextures (64);
  PR_AllocShadeTables (32);

  ktitle = wloadgif ("kproduct.gif", global_palette);
  torus_shape = LoadFile ("torus.pro");
  logo_shape = LoadFile ("kosmic.pro");
  torus_entity = PR_CreateEntity (torus_shape, "Torus");
  logo_entity = PR_CreateEntity (logo_shape, "Kosmic Logo");
  PR_ScaleEntity (logo_entity, 0.05, 0.05, 0.05);
  PR_PositionEntity (logo_entity, 0, 0, logodist);


  PR_SetLightPosition (&userlights, 0,
                       newcam->source.x,
                       newcam->source.y,
                       newcam->source.z);

  PR_SetCameraSource (newcam, 0, 0, 5500);
  PR_SetCameraTarget (newcam, 0, 0, 0);
  newcam->fov = (1.0 / 3.0) * 3.1415;
  PR_SetActiveCamera (newcam);

  ticks = 0;
  PR_OpenScreen (PR_BACKBUFFER);

  while (CheckSongPosition (7,60))
    {
     PR_NewFrame ();                         

     PRGFX_ClearScreen ();

     PR_AddLightsToScene (&userlights);

     past_ticks = ticks;
     ticks = 0;

     PR_RotateEntity (torus_entity, sin (sinw1) * 25, sin (sinw2) * 25, 0);
     sinw1 += past_ticks * 0.025;
     sinw2 += past_ticks * 0.032;

     PR_RotateEntity (logo_entity, -90, 0, logoz);
     logoz += past_ticks * 2.5;

     logodist += past_ticks * 5.5;
     if (logodist > 5000)
       logodist = 5000;
     PR_PositionEntity (logo_entity, 0, 0, logodist);

     PR_TransformEntity (torus_entity);
     PR_TransformEntity (logo_entity);
     PR_RenderEntity (torus_entity);
     PR_RenderEntity (logo_entity);


     PRGFX_Clip (active_viewport.topx,
                 active_viewport.topy,
                 active_viewport.bottomx,
                 active_viewport.bottomy);

   #ifndef __3DFX__
     PR_RenderFrame ();
   #endif

     if (!CheckSongPosition (6, 0))
       wputblock (0, 160, ktitle, 1);

     PR_Flip ();
    }

  wfreeblock (ktitle);
  PR_FreeObject (torus_shape);
  PR_FreeObject (logo_shape);
  PR_FreeEntity (torus_entity);
  PR_FreeEntity (logo_entity);
  PR_DeleteAllWorldTextures ();
  PR_DeleteAllShadeTables ();
  PR_DeleteAllMaterials ();

  wnormscreen ();
  wsetrgb (0, 0, 0, 0, global_palette);
  wsetpalette (0, 0, global_palette);
  wcls (0);

  ktitle = wloadgif ("dreams.gif", global_palette);
  while (CheckSongPosition (8,0)) {}
  WhitePalette ();
  wclip (0, 0, 319, 199);
  wputblock (0, 0, ktitle, 0);
  fading = 1;
  wfreeblock (ktitle);

  while (CheckSongPosition (0x0B,0)) {}
  fading = 0;

  ktitle = wloadgif ("ce.gif", global_palette);
  while (CheckSongPosition (0x0C,0)) {}
  WhitePalette ();
  fading = 1;
  wputblock (0, 0, ktitle, 0);
  wfreeblock (ktitle);

  while (CheckSongPosition (0x0D,0)) {}
  fading = 0;

  ktitle = wloadgif ("jb.gif", global_palette);
  while (CheckSongPosition (0x0E,0)) {}
  WhitePalette ();
  fading = 1;
  wputblock (0, 0, ktitle, 0);
  wfreeblock (ktitle);

  while (CheckSongPosition (0x0F,36)) {}
  BlackPalette ();

  while (CheckSongPosition (0x0F,54)) {}
}




PR_REAL psinw1 = 0;
PR_REAL psinw2 = 0;
void PulseObject (PR_OBJECT *obj1, PR_OBJECT *obj2)
/* Deforms the vertices of an object using sine waves */
{
PR_SEGMENT *seg;
PR_VERTEX *vert;
PR_VERTEX *vertdest;
PR_DWORD i;

  seg = obj1->segment_list;
  vert = seg->vertex_list;
  vertdest = obj2->segment_list[0].vertex_list;
  for (i = 0; i < seg->num_vertices; i++)
    {
     vertdest->x = vert->x + (sin (vert->x/200 + psinw1) * 200);
     vertdest->y = vert->y + (sin (vert->y/300 + psinw2) * 300); 

     vert++;
     vertdest++;
    }

}



/* Mirror room and green pulsating blob */

void Part2 (void)
{
PR_OBJECT *pulse_shape;         /* Original blob */
PR_OBJECT *deformed_shape;      /* Deformed blob */
PR_OBJECT *dome_shape;          /* Dome room */
PR_OBJECT *mirror_shape;        /* Mirror */

PR_ENTITY *pulse_entity;
PR_ENTITY *dome_entity;
PR_ENTITY *mirror_entity;

PR_REAL pulsex = -90, pulsey = 0, pulsez = 0;
                                /* Rotation values for pulse entity */

PR_DWORD past_ticks;            /* Number of ticks since last frame */

PR_REAL spin = -1.8;            /* Camera sine wave parameter */
PR_REAL spin2 = -2.2;           /* Second camera sine wave parameter */
PR_REAL spincos, spinsin;
                                /* Sine wave movement pattern vars */
PR_REAL bounce = 0;             /* Camera and blob bounce calculation */

PR_DWORD mirtex;                /* Texture number of the mirror image */
PR_DWORD mirspin = 0;           /* Mirror spin variable (x axis) */
PR_POINT mirror_direction;      /* Normal of mirror */

  wnormscreen ();
  wcls (0);
  fading = 0;
  PR_AllocMaterialList (256);
  PR_AllocWorldTextures (64);
  PR_AllocShadeTables (32);

  /* -------------- Load objects ----------------- */

  /* Load the blob twice, the first one contains the original points.
     The second one will have the vertex modified after the deformation
     function */
  pulse_shape = LoadFile ("bean.pro");
  deformed_shape = LoadFile ("bean.pro");

  /* Load the dome and mirror objects */
  dome_shape = LoadFile ("dome.pro");
  mirror_shape = LoadFile ("mirror.pro");

  wsetpalette (0, 255, global_palette);

  /* -------------- Initialize Entities ----------- */

  pulse_entity = PR_CreateEntity (deformed_shape, "Pulser");
  PR_ScaleEntity (pulse_entity, 1.3, 1.3, 1.3);
  PR_PositionEntity (pulse_entity, 0, -1500, 0);

  dome_entity = PR_CreateEntity (dome_shape, "Dome");
  PR_ScaleEntity (dome_entity, 1, 1, 1);
  PR_PositionEntity (dome_entity, 0, 0, 0);
  PR_RotateEntity (dome_entity, -90, 0, 0);

  mirror_entity = PR_CreateEntity (mirror_shape, "Mirror1");
  PR_ScaleEntity (mirror_entity, 1.5, 1.5, 1.5);
  PR_PositionEntity (mirror_entity, 0, -1500, -3000);
  PR_RotateEntity (mirror_entity, 0, 0, 0);


  /* -------------- Misc Setup ----------- */
#ifndef __3DFX__

  /* Open a new viewport for the mirror */
  PR_OpenViewport (&mirrorview, 0, 0, 105, 65, VIEW_PLAIN);

  mirtex = PR_FindTexture ("mirror.pcx");
#endif

  PR_SetLightPosition (&userlights, 1, 0, -7900, 0);

  userlights.NumLights = 2;
                    /* This sets how many lights are actually used */

  ticks = 0;

  /* -------------- Loop ----------- */

  while (CheckSongPosition (0x17, 45))
    {
     past_ticks = ticks;
     ticks = 0;

     /* -------------- Animation Parameters ----------- */

     bounce = -1500 + sin (psinw1) * 1000;
     psinw1 += past_ticks * 0.05;               /* Pulsating vars */
     psinw2 += past_ticks * 0.08;               /* Pulsating vars */
     pulsex += past_ticks * 0.7;                /* Blob rotation */
     pulsey += past_ticks * 0.8;
     pulsez += past_ticks * 0.5;
     spin += past_ticks * 0.0017;               /* Camera var 1 */
     spin2 += past_ticks * 0.0085;              /* Camera var 2 */
     spinsin = sin (spin + spin2) * 6300 + 200;
     spincos = cos (spin + sin(spin2)) * 6300;
     mirspin += past_ticks * 1;                 /* Mirror rotation */

     /* -------------- 3D Parameters ----------- */

     PR_SetLightPosition (&userlights, 0,       /* Set second light */
                          spincos,
                          spinsin,
                          spincos);

     PR_PositionEntity (pulse_entity, 0, bounce, 0);

     PR_RotateEntity (pulse_entity, pulsex, pulsey, pulsez);
     PulseObject (pulse_shape, deformed_shape);

     PR_RotateEntity (mirror_entity, mirspin, 0, 0);

     /* -------------- Mirror image ----------- */
#ifndef __3DFX__

     PR_SetViewport (&mirrorview);
     wsetscreen (PR_WorldTextures[mirtex].image);
     PRGFX_Clip (active_viewport.topx,
                 active_viewport.topy,
                 active_viewport.bottomx,
                 active_viewport.bottomy);

     PR_NewFrame ();
     PR_AddLightsToScene (&userlights);


     /* Figure out the normal of the mirror */
     mirror_direction.x = 0;
     mirror_direction.y = 0;
     if (mirror_shape->segment_list[0].face_list[0].flags & FFLAG_VISIBLE_NOW)
       mirror_direction.z = 1;
     else
       mirror_direction.z = -1;
     PR_FindDirectionVector (&mirror_direction,
                        mirspin, 0, 0);

     /* Now we have the normal in mirror_direction.  Set up a camera target
        that is perpendicular to the mirror and a fair distance away */

     PR_SetCameraTarget (newcam,
        mirror_entity->orientation.location.x + mirror_direction.x * 4000,
        mirror_entity->orientation.location.y + mirror_direction.y * 4000,
        mirror_entity->orientation.location.z + mirror_direction.z * 4000);

     PR_SetCameraSource (newcam, mirror_entity->orientation.location.x,
                                 mirror_entity->orientation.location.y,
                                 mirror_entity->orientation.location.z);

     PR_SetActiveCamera (newcam);

     /* Transform and render all the entities to the mirror texture */
     /* Do not render the mirror entity since it can't be seen */

     PR_TransformEntity (dome_entity);
     PR_RenderEntity (dome_entity);
     PR_TransformEntity (pulse_entity);
     PR_RenderEntity (pulse_entity);
     PR_RenderFrame ();
#endif


     /* -------------- Render Normal Frame ----------- */

     PR_SetViewport (&viewport);
     PR_OpenScreen (PR_BACKBUFFER);
   #ifdef __3DFX__
     PRGFX_ClearScreen ();
   #endif

     PR_NewFrame ();
     PR_TransformLights (&userlights);

     bounce = -1500 + sin ((psinw1)/10) * 1000;
     PR_SetCameraSource (newcam, spinsin, bounce, spincos);
     PR_SetCameraTarget (newcam, 0, bounce, 0);
     PR_SetActiveCamera (newcam);

     PRGFX_Clip (active_viewport.topx,
                 active_viewport.topy,
                 active_viewport.bottomx,
                 active_viewport.bottomy);

     PR_TransformEntity (dome_entity);
     PR_RenderEntity (dome_entity);

     PR_TransformEntity (pulse_entity);
     PR_RenderEntity (pulse_entity);

     PR_TransformEntity (mirror_entity);
     PR_RenderEntity (mirror_entity);

   #ifndef __3DFX__
     PR_RenderFrame ();
   #endif

     PR_Flip ();
    }

  memcpy (fadepal, global_palette, 768);
  BlackPalette ();
  fading = 1;

  /* -------------- Clean Up ----------- */
  PR_FreeEntity (pulse_entity);
  PR_FreeEntity (dome_entity);
  PR_FreeEntity (mirror_entity);
  PR_FreeObject (dome_shape);
  PR_FreeObject (pulse_shape);
  PR_FreeObject (deformed_shape);
  PR_FreeObject (mirror_shape);
  PR_DeleteAllWorldTextures ();
  PR_DeleteAllShadeTables ();
  PR_DeleteAllMaterials ();

  while (CheckSongPosition (0x17, 63)) {}
}




void PulseObject2 (PR_OBJECT *obj1, PR_OBJECT *obj2)
/* Deforms the vertices of an object using sine waves */
{
PR_SEGMENT *seg;
PR_VERTEX *vert;
PR_VERTEX *vertdest;
PR_DWORD i;

  seg = obj1->segment_list;
  vert = seg->vertex_list;
  vertdest = obj2->segment_list[0].vertex_list;
  for (i = 0; i < seg->num_vertices; i++)
    {
     vertdest->x = vert->x + (sin (vert->x/400 + psinw1) * 200);
     vertdest->y = vert->y + (sin (vert->y/600 + psinw2) * 300); 
     vert++;
     vertdest++;
    }

}



/* Mirror Room with pulsating object in center */

void Part3 (void)
{
PR_OBJECT *pulse_shape;         /* Original blob */
PR_OBJECT *deformed_shape;      /* Deformed blob */
PR_OBJECT *cubic_shape;          /* Dome room */

PR_ENTITY *pulse_entity;
PR_ENTITY *cubic_entity;

PR_REAL pulsex = -90, pulsey = 0, pulsez = 0;
                                /* Rotation values for pulse entity */

PR_DWORD past_ticks;            /* Number of ticks since last frame */

PR_REAL spin = -1.8;            /* Camera sine wave parameter */
PR_REAL spin2 = -2.2;           /* Second camera sine wave parameter */
PR_REAL spincos, spinsin;       /* Sine wave movement pattern vars */

PR_DWORD screen = 0;
block render_buffer;
PR_DWORD backtex;
PR_DWORD flash=0, flashcount;

  wnormscreen ();
  wcls (0);
  fading = 0;
  PR_AllocMaterialList (256);
  PR_AllocWorldTextures (64);
  PR_AllocShadeTables (32);

  /* -------------- Load objects ----------------- */

  /* Load the blob twice, the first one contains the original points.
     The second one will have the vertex modified after the deformation
     function */
  pulse_shape = LoadFile ("bean2.pro");
  deformed_shape = LoadFile ("bean2.pro");

  /* Load the cubic object */
  cubic_shape = LoadFile ("cubic.pro");

  backtex = PR_FindTexture ("shot.pcx");
  wfreeblock (PR_WorldTextures[backtex].image);

  wsetpalette (0, 255, global_palette);


  /* -------------- Initialize Entities ----------- */

  pulse_entity = PR_CreateEntity (deformed_shape, "Pulser");
  PR_ScaleEntity (pulse_entity, 1.3, 1.3, 1.3);
  PR_PositionEntity (pulse_entity, 0, -1500, 0);

  cubic_entity = PR_CreateEntity (cubic_shape, "Cubic Room");
  PR_ScaleEntity (cubic_entity, 1, 1, 1);
  PR_PositionEntity (cubic_entity, 0, 0, 0);
  PR_RotateEntity (cubic_entity, -90, 0, 0);


  /* -------------- Misc Setup ----------- */

  PR_SetLightPosition (&userlights, 1, 0, -7900, 0);

  userlights.NumLights = 2;
                    /* This sets how many lights are actually used */

  render_buffer = wallocblock (320, 200);
  wsetscreen (render_buffer);
  wcls (0);

  ticks = 0;

  /* -------------- Loop ----------- */

  while (CheckSongPosition (0x1B, 40))
    {
     past_ticks = ticks;
     ticks = 0;

     for (flashcount = 0; flashcount < 64; flashcount++)
       {
        if ((flash == flashcount) &&
            (!CheckSongPosition (0x18, 32 + flashcount*8L)))
          {
           fading = 1;
           BrightPalette ();
           flash++;
          }
       }


     if (screen)
       {
        PR_WorldTextures[backtex].image = PR_VGABuffer;
        wsetscreen (render_buffer);
       }
     else
       { 
        PR_WorldTextures[backtex].image = render_buffer;
        wsetscreen (PR_VGABuffer);
       }

   #ifdef __3DFX__
     PRGFX_ClearScreen ();
   #endif

     /* -------------- Animation Parameters ----------- */

     psinw1 += past_ticks * 0.05;               /* Pulsating vars */
     psinw2 += past_ticks * 0.08;               /* Pulsating vars */
     pulsex += past_ticks * 0.7;                /* Blob rotation */
     pulsey += past_ticks * 0.8;
     pulsez += past_ticks * 0.5;
     spin += past_ticks * 0.0017;               /* Camera var 1 */
     spin2 += past_ticks * 0.0085;              /* Camera var 2 */
     spinsin = sin (spin + spin2) * 5300 + 200;
     spincos = cos (spin + sin(spin2)) * 5300;

     /* -------------- 3D Parameters ----------- */

     PR_SetLightPosition (&userlights, 0,       /* Set second light */
                          spincos,
                          spinsin,
                          spincos);

     PR_PositionEntity (pulse_entity, 0, 0, 0);

     PR_RotateEntity (pulse_entity, pulsex, pulsey, pulsez);
     PulseObject2 (pulse_shape, deformed_shape);

     /* -------------- Render Normal Frame ----------- */

     PR_SetViewport (&viewport);

     PR_NewFrame ();
     PR_TransformLights (&userlights);

     PR_SetCameraSource (newcam, spinsin, 0, spincos);
     PR_SetCameraTarget (newcam, 0, 0, 0);
     PR_SetActiveCamera (newcam);

     PRGFX_Clip (active_viewport.topx,
                 active_viewport.topy,
                 active_viewport.bottomx,
                 active_viewport.bottomy);

     PR_TransformEntity (cubic_entity);
     PR_RenderEntity (cubic_entity);

     PR_TransformEntity (pulse_entity);
     PR_RenderEntity (pulse_entity);

   #ifndef __3DFX__
     PR_RenderFrame ();
   #endif

     PR_Flip ();

     screen = !screen;
    }

  memcpy (fadepal, global_palette, 768);
  BlackPalette ();
  fading = 1;

  /* -------------- Clean Up ----------- */
  PR_WorldTextures[backtex].image = render_buffer;
  PR_FreeEntity (pulse_entity);
  PR_FreeEntity (cubic_entity);
  PR_FreeObject (cubic_shape);
  PR_FreeObject (pulse_shape);
  PR_FreeObject (deformed_shape);
  PR_DeleteAllWorldTextures ();
  PR_DeleteAllShadeTables ();
  PR_DeleteAllMaterials ();

  while (CheckSongPosition (0x1B, 48)) {}
}



void motion_blur (block shadetable, block source,
                  block dest, int length);
#pragma aux motion_blur = \
 "push ebp" \
 "cld" \
 "mov ebp, edx" \
 "xor ebx, ebx" \
 "shadeloop: mov bl, [esi]" \
 "mov bh, [edi]" \
 "mov al, [ebp + ebx]" \
 "inc esi" \
 "mov bl, [esi]" \
 "mov bh, [edi+1]" \
 "mov ah, [ebp + ebx]" \
 "mov [edi], ax" \
 "inc esi" \
 "add edi, 2" \
 "dec ecx" \
 "jnz shadeloop" \
 "pop ebp" \
parm [edx] [esi] [edi] [ecx] \
modify exact [eax ebx ecx edx esi edi] nomemory;


/* Bobbing head */

void Part4 (void)
{
PR_OBJECT *face_shape;
PR_OBJECT *light_shape;

PR_ENTITY *face_entity;
#define HEADLIGHTS 16
PR_ENTITY *light_entity[HEADLIGHTS];
PR_DWORD i;
PR_REAL lightx[HEADLIGHTS], lighty[HEADLIGHTS], lightz[HEADLIGHTS];

PR_REAL facex = -90, facey = 0, facez = 0;
PR_DWORD past_ticks;
PR_REAL spin = -1.8;            /* Camera sine wave parameter */
PR_REAL spin2 = -2.2;           /* Second camera sine wave parameter */
PR_REAL spincos, spinsin;       /* Sine wave movement pattern vars */
PR_REAL lspin1 = 0;
PR_REAL lspin2 = 0;
PR_DWORD mixtabnum;
PR_DWORD flash, flashcount;

  wnormscreen ();
  wcls (0);
  fading = 0;
  PR_AllocMaterialList (256);
  PR_AllocWorldTextures (64);
  PR_AllocShadeTables (32);

  /* -------------- Load objects ----------------- */

  face_shape = LoadFile ("face.pro");
  light_shape = LoadFile ("light.pro");

  /* -------------- Initialize Entities ----------- */

  face_entity = PR_CreateEntity (face_shape, "The Face");
  PR_ScaleEntity (face_entity, 1, 1, 1);
  PR_PositionEntity (face_entity, 0, 0, 0);

  for (i = 0; i < HEADLIGHTS; i++)
    {
     light_entity[i] = PR_CreateEntity (light_shape, "Head light");
     PR_ScaleEntity (light_entity[i], 0.1, 0.1, 0.1);
     PR_PositionEntity (light_entity[i], 0, i * 200, 0);
     lightx[i] = 0;
     lighty[i] = 0;
     lightz[i] = 0;
    }

  /* -------------- Misc Setup ----------- */

  PR_SetLightPosition (&userlights, 0,
                       newcam->source.x,
                       newcam->source.y,
                       newcam->source.z);

  mixtabnum = PR_LoadTable ("face.tab");

  ticks = 0;

  while (CheckSongPosition (0x1B, 52)) {}
  WhitePalette ();
  fading = 1;

  /* -------------- Loop ----------- */

  while (CheckSongPosition (0x1E, 60))
    {
     PR_OpenScreen (PR_BACKBUFFER);
     past_ticks = ticks;
     ticks = 0;
     /* -------------- Animation Parameters ----------- */

     spin += past_ticks * 0.0047;              /* Camera var 1 */
     spin2 += past_ticks * 0.015;              /* Camera var 2 */
     spinsin = sin (spin + spin2) * 3300 + 200;
     spincos = cos (spin + sin(spin2)) * 2300;
     lspin1 += past_ticks * 0.007;              /* Lights var 1 */
     lspin2 += past_ticks * 0.005;              /* Lights var 2 */

     /* -------------- 3D Parameters ----------- */
     PR_SetCameraSource (newcam, spinsin, spincos, 2500);
     PR_SetCameraTarget (newcam, 0, 0, 0);
     PR_SetActiveCamera (newcam);

     /* -------------- Render Normal Frame ----------- */

     PR_NewFrame ();
     wsetcolor (255);
     PRGFX_ClearScreen ();
     PR_AddLightsToScene (&userlights);


     PR_RotateEntity (face_entity, facex, facey, facez);
     facey = sin (spin2) * 180;
     facex = sin (spin) * 30 - 90;

     PR_TransformEntity (face_entity);
     PR_RenderEntity (face_entity);

     PRGFX_Clip (active_viewport.topx,
                 active_viewport.topy,
                 active_viewport.bottomx,
                 active_viewport.bottomy);

     #ifndef __3DFX__
       PR_RenderFrame ();
     #endif

     PR_Flip ();
    }

  WhitePalette ();
  fading = 1;
  flash = 0;

  while (CheckSongPosition (0x26, 24))
    {
     PR_OpenScreen (PR_BACKBUFFER);
     past_ticks = ticks;
     ticks = 0;

     for (flashcount = 0; flashcount < 64; flashcount++)
       {
        if ((flash == flashcount) &&
            (!CheckSongPosition (0x1F, flashcount*8L)))
          {
           fading = 1;
           BrightPalette ();
           flash++;
           spin += 0.0141;
           spin2 += 0.045;
          }
       }


     /* -------------- Animation Parameters ----------- */

     spin += past_ticks * 0.0047;              /* Camera var 1 */
     spin2 += past_ticks * 0.015;              /* Camera var 2 */
     spinsin = sin (spin + spin2) * 3300 + 200;
     spincos = cos (spin + sin(spin2)) * 2300;
     lspin1 += past_ticks * 0.007;              /* Lights var 1 */
     lspin2 += past_ticks * 0.005;              /* Lights var 2 */

     /* -------------- 3D Parameters ----------- */
     PR_SetCameraSource (newcam, spinsin, spincos, 2500);
     PR_SetCameraTarget (newcam, 0, 0, 0);
     PR_SetActiveCamera (newcam);

     /* -------------- Render Normal Frame ----------- */

     PR_NewFrame ();
     wsetcolor (255);
     PRGFX_ClearScreen ();
     PR_AddLightsToScene (&userlights);


     PR_RotateEntity (face_entity, facex, facey, facez);
     facey = sin (spin2) * 180;
     facex = sin (spin) * 30 - 90;

     PR_TransformEntity (face_entity);
     PR_RenderEntity (face_entity);


     /* Lights */
     for (i = 0; i < HEADLIGHTS; i++)
       {
        lightx[i] += 0.1;
        lighty[i] += 0.11;
        lightz[i] += 0.12;
        PR_RotateEntity (light_entity[i], lightx[i], lighty[i], lightz[i]);

        PR_PositionEntity (light_entity[i],
              sin (lspin1 + lspin2 + i) * (sin(lspin1)*850 + 1700) + 200, i * 200,
              cos (lspin1 + lspin2 + i) * (sin(lspin1)*850 + 1700));
        PR_TransformEntity (light_entity[i]);
        PR_RenderEntity (light_entity[i]);
       }

     PRGFX_Clip (active_viewport.topx,
                 active_viewport.topy,
                 active_viewport.bottomx,
                 active_viewport.bottomy);

   #ifndef __3DFX__
     PR_RenderFrame ();
   #endif

     PR_OpenScreen (PR_FRONTBUFFER);
     motion_blur (PR_ShadeTables[mixtabnum].table, PR_VGABuffer + 4,
                  abuf, 32000);
    }

  memcpy (fadepal, global_palette, 768);
  BlackPalette ();
  fading = 1;

  PR_FreeObject (face_shape);
  PR_FreeEntity (face_entity);
  PR_DeleteAllWorldTextures ();
  PR_DeleteAllShadeTables ();
  PR_DeleteAllMaterials ();
  while (CheckSongPosition (0x1B, 32)) {}
}


void ExitDemo (void)
{
  if (demo_sound)
    DeinitSound ();

  uninstallkbd ();
  wstoptimer ();
  wdonetimer ();
  wsetmode (3);

  printf ("Dreams - Party Version   Copyright 1996 Chris Egerter\n");
  printf ("A Kosmic Production by GooRoo and BOOMER...\n");
}





/* ---------------------------------------------------------------------- */
/* Main program */
/* ---------------------------------------------------------------------- */
void main (int argc, char *argv[])
{
  wsetmode (3);
  printf ("Dreams - Party Version   Copyright 1996 Chris Egerter\n");
  printf ("A Kosmic Production by GooRoo and BOOMER...\n");

  if (strcmp (argv[1], "-nosound") == 0)
    demo_sound = 0;
  else demo_sound = 1;

  if (strcmp (argv[1], "-setup") == 0)
    sound_config = 1;
  else sound_config = 0;

  if (strcmp (argv[1], "-secret") == 0)
    {
     demo_sound = 0;
     secret = 1;
     vga256 ();
     minit ();
    }

  PRGUI_InitPath (argv[0]);
  PRGUI_SetUserPath ();

  if (demo_sound)
    InitializeSound ();

  PR_Initialize ();

#ifdef __3DFX__
  device = DEVICE_3DFX;
#else
  device = DEVICE_VGA;
#endif
  InitializeDevices ();

  InitializeLights ();

  /* Initialize the graphics mode */
  SetVideoMode ();

  /* Initialize the camera */
  newcam = PR_AllocCamera ();
  PR_InitializeCamera (newcam);
  PR_SetCameraSource (newcam, 0, 0, 5500);
  PR_SetCameraTarget (newcam, 0, 0, 0);
  PR_SetCameraMode (newcam, CAMFLAG_ANGLE_BASED); 


  /* play the module file */
  if (demo_sound)
    APlayModule (lpModule);

  atexit (ExitDemo);

  /* Initialize the input devices */
  installkbd ();
  winittimer ();
  wstarttimer (timerproc, TICKS(60));


  /* Number of perspective texture subdivisions */
  PR_TextureDivisions = 32;

  global_ticks = 0;
  ticks = 0;

  setlib ("dreams.wow");
  setpassword ("left out on purpose");

  if (!secret)
    {
     Part1 ();
     Part2 ();
     Part3 ();
     Part4 ();
     Part6 ();
    }
  Part5 ();

  if (!secret)
    {
     Part7 ();
     Part8 ();
    }
}

