#include <stdio.h>
#include <mem.h>

char nchannels=4;
FILE *f;
FILE *f2;
char orders[128];
char toppattern;

void error(char *s)
{
  printf("\n%s", s);
  exit(1);
}

void openmod(char *s)
{
  char title[21], channels[5];
  
  f=fopen(s, "rb");
  if(!f) error("Unable to open read file");
  fseek(f, 0, SEEK_SET);
  fread(title, 21, 1, f);
  fseek(f, 1080, SEEK_SET);
  fread(channels, 4, 1, f);
  channels[4]=0;
  if(!strcmp(channels, "M.K.")) nchannels=4;
  if(!strcmp(channels, "FLT4")) nchannels=4;
  if(!strcmp(channels, "FLT8")) nchannels=8;
  if(!strcmp(channels, "6CHN")) nchannels=6;
  if(!strcmp(channels, "8CHN")) nchannels=8;
  printf("\n%d channel module: %s", nchannels, title);
}

void copyfile(char *s)
{
  char space[10000];
  int n;

  f2=fopen(s, "wb");
  fseek(f, 0, SEEK_SET);
  do
  {
    n=fread(space, 1, 10000, f);
    if(fwrite(space, 1, n, f2)<n) error("Error writing to file (disk full?)");
  } while(n==10000);
}

void revorders()
{
  int i;
  char length;
  char revorders[128];
  
  fseek(f, 950, SEEK_SET);
  fread(&length, 1, 1, f);
  fseek(f, 952, SEEK_SET);  
  fread(orders, 1, length, f);

  for(i=0; i<length; i++)
  {
    if(orders[i]>toppattern) toppattern=orders[i];
    revorders[i]=orders[length-i-1];
  }
  fseek(f2, 952, SEEK_SET);
  fwrite(revorders, 1, length, f2);
}

void revpatterns()
{
  char data[2048];
  char backdata[2048];
  char *rowdata[64];
  int i, j;
  char *p, len;

  len=4*nchannels;

  for(j=0; j<64; j++)  
    rowdata[j]=data+len*j;
  
  fseek(f, 1084, SEEK_SET);
  fseek(f2, 1084, SEEK_SET);
  for(i=0; i<toppattern+1; i++)
  {
    fread(data, 1, nchannels*4*64, f);
    p=backdata;
    for(j=63; j>=0; j--)
    {
      memmove(p, rowdata[j], len);
      p+=len;
    }
    fwrite(backdata, 1, nchannels*4*64, f2);
  }
}

main(int argc, char **argv)
{
  printf("MOD Reverser");
  
  printf("\nCopyright (c) 1995 by Jim Crawford");
  openmod(argv[1]);
  
  printf("\nCreating new file: %s", argv[2]);
  copyfile(argv[2]);
  
  printf("\nReversing orders...");
  revorders();
  
  printf("\nReversing patterns...");
  revpatterns();

  fclose(f);
  fclose(f2);

  printf("\nDone!");

  return argc-argc;
}
