//===============================================================================================
//
//===============================================================================================
//
//	CBaseTrack
//	 |
//	 +--------------------+--------------------+
//	 |					  |					   |				   
//	CTrack				 CDataEnvelope		  CValueEnvelope
//	 |
//	 +--------------------+
//	 |					  |
//	CVectorTrack		 CQuaternionTrack
//	 |
//	 +--------------------+--------------------+
//	 |					  |					   |
//	CPositionTrack	 CScaleTrack		  CEulerRotTrack
//
//================================================================================================
//
//	objekty typu Track sa modyfikatorami obiektow zawieraja informacje o transformacji
//	w czasie, mimo tego ze sa dziedziczone z jednej klasy nie wszystkie sa uzywane w ten sam
//  sposob, na hierarchi dziedziczenie latwo wyroznic dwa podstawowe typy obiektow
//	czyli podstawowe sciezki (CTrack, nawet chcialem je nazwac CMovementTrack ale to za dluga nazwa:)
//	i dodatkowe sciezki (cos jak envelopy z lw) o ile sciezki opisujace ruch sa czescia keyframer
//  envelopy znajduja sa czescia obiektu
//
//================================================================================================

#ifndef __TRACK_H_
#define __TRACK_H_

#include "math3d.h"

class he3d_CBaseTrack
{
public:

	DWORD			dwKeysCount;

public:

	he3d_CBaseTrack() : dwKeysCount( 0 )
	{
	}
	
	virtual ~he3d_CBaseTrack()
	{
	}

	FLOAT Ease( FLOAT easefrom, FLOAT easeto, FLOAT t );
};

class he3d_CTrack : public he3d_CBaseTrack
{
public:

	he3d_CTrack() 
	{
	}	

	virtual he3d_CMatrix FrameMtx( FLOAT frame ) = 0;
	virtual void InitTrack() = 0;
};
 
class he3d_CVectorTrack : public he3d_CTrack
{
public:

	class CKey
	{
	public:

		FLOAT				frame;
		he3d_CVector		key;

		he3d_CVector		t0;
		he3d_CVector		t1;

		FLOAT				T, B, C;

		FLOAT				easeto, easefrom;
	};

	CKey*				pkKeys;

public:

	he3d_CVectorTrack() : pkKeys( NULL )
	{
	}

	virtual ~he3d_CVectorTrack();

	virtual he3d_CMatrix FrameMtx( FLOAT frame ) = 0;
	virtual void InitTrack();

	he3d_CVector FrameVector( FLOAT frame );
};

class he3d_CScaleTrack : public he3d_CVectorTrack
{
public:

	he3d_CScaleTrack()
	{
	}

	virtual he3d_CMatrix FrameMtx( FLOAT frame );	
};

class he3d_CEulerRotTrack : public he3d_CVectorTrack
{
public:

	he3d_CEulerRotTrack()
	{
	}

	virtual he3d_CMatrix FrameMtx( FLOAT frame );
};

class he3d_CPositionTrack : public he3d_CVectorTrack
{
public:

	he3d_CPositionTrack()
	{
	}

	virtual he3d_CMatrix FrameMtx( FLOAT frame );
};

class he3d_CQuaternionTrack : public he3d_CTrack
{
public:

	class CKey
	{
	public:

		FLOAT				frame;
		he3d_CQuaternion	key;

		he3d_CQuaternion	an;
		he3d_CQuaternion	bn;

		he3d_CVector		axis;
		FLOAT				angle;

		LONG				spin;

		FLOAT				T, B, C;

		FLOAT				easefrom, easeto;
	};

	CKey*				pkKeys;

public:

	he3d_CQuaternionTrack() : pkKeys( NULL )
	{
	}

	virtual ~he3d_CQuaternionTrack();

	virtual he3d_CMatrix FrameMtx( FLOAT frame );
	virtual void InitTrack();

	he3d_CQuaternion FrameQuaternion( FLOAT frame );
};

class he3d_CDataEnvelope : public he3d_CBaseTrack
{
public:

	class CKey
	{
	public:
		
		FLOAT			frame;
		DWORD			key;

		FLOAT			easeto, easefrom;
	};
	
	CKey*			pkKeys;

public:

	he3d_CDataEnvelope() : pkKeys( NULL )
	{
	}

	virtual ~he3d_CDataEnvelope();

	DWORD PrevData( FLOAT frame );
	DWORD NextData( FLOAT frame );

	FLOAT LocalTime( FLOAT frame );

	void InitEnvelope();
};

class he3d_CValueEnvelope : public he3d_CBaseTrack
{
public:

	class CKey
	{
	public:

		FLOAT				frame;
		FLOAT				key;

		FLOAT				t0;
		FLOAT				t1;

		FLOAT				T, B, C;
		
		FLOAT				easeto, easefrom;
	};

	CKey*			pkKeys;	

public:

	he3d_CValueEnvelope() : pkKeys( NULL )
	{
	}
	
	virtual ~he3d_CValueEnvelope();	

	FLOAT EnvelopeValue( FLOAT frame );

	void InitEnvelope();
};


#endif