// SolarSystemCreation.h: interface for the CSolarSystemCreation class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SOLARSYSTEMCREATION_H__8001CD21_8048_11D5_AD0F_106957C10000__INCLUDED_)
#define AFX_SOLARSYSTEMCREATION_H__8001CD21_8048_11D5_AD0F_106957C10000__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Efx.h"

class CSolarSystemCreation : public CEfx  
{
private:

	CSimpleMesh				m_mSphere;
	CSimpleMesh				m_mPlanetDisk;

	PDIRECT3DVERTEXBUFFER8	m_pvbRing[10];	
	PDIRECT3DVERTEXBUFFER8	m_pvbPlanetDisk;

	PDIRECT3DVERTEXBUFFER8	m_pvbSpaceDust;
	PDIRECT3DVERTEXBUFFER8	m_pvbPlanetDust;

	VECTORKEY				m_vsCameraPos[10];
	VECTORKEY				m_vsCameraTrg[10];
	FLOATKEY				m_fsRoll[3];

	he3d_CMatrix			m_mtxRings[10];
	he3d_CMatrix			m_mtxPlanetsSeeds[10];
	he3d_CMatrix			m_mtxPlanetaryDust[10];

	he3d_CMatrix			m_mtxDisk;	

	CImageQuad*				m_piqFade;
	
public:

	CSolarSystemCreation( PDIRECT3DDEVICE8 pDevice );
	virtual ~CSolarSystemCreation();

	virtual BOOL InitEfx();
	virtual BOOL FinishEfx();
	virtual BOOL UpdateFrame( FLOAT fTime );
	virtual BOOL RenderEfx();
};

#endif // !defined(AFX_SOLARSYSTEMCREATION_H__8001CD21_8048_11D5_AD0F_106957C10000__INCLUDED_)
