; *Basic vector operations
; (C)oded by Sergey Chaban

; In: SI=Ptr to vec1 (A.x, A.y, A.z)
;     DI=Ptr to vec2 (B.x, B.y, B.z)
;     BX=Ptr to result vec
; Out:
; vec[BX]=(A.y*B.z-B.y*A.z, A.z*B.x-B.z*A.x, A.x*B.y-B.x*A.y)
VectorMath_CrossProduct proc
 fld dword ptr [si].VecX
 fld st(0)
 fmul dword ptr [di].VecZ
 fxch
 fmul dword ptr [di].VecY
 ;****
 fld dword ptr [si].VecY
 fld st(0)
 fmul dword ptr [di].VecZ
 fxch
 fmul dword ptr [di].VecX
 ;****
 fld dword ptr [si].VecZ
 fld st(0)
 fmul dword ptr [di].VecY
 fxch
 fmul dword ptr [di].VecX
 ; 0       1       2       3       4       5
 ; Az*Bx . Az*By . Ay*Bx . Ay*Bz . Ax*By . Ax*Bz
 fxch st(5)
 fsubp st(5),st
 fsubp st(2),st
 fsubp st(2),st
 fstp dword ptr [bx].VecX
 fstp dword ptr [bx].VecZ
 fstp dword ptr [bx].VecY
 ret
VectorMath_CrossProduct endp

; In: SI=ptr to vec1(A.x, A.y, A.z)
;     DI=ptr to vec2(B.x, B.y, B.z)
;     BX=ptr to dword to store result
; Out:
;     Vec[BX]=A.x*B.x+A.y*B.y+A.z*B.z
VectorMath_DotProduct proc
 fld   dword ptr [si].VecX
 fmul  dword ptr [di].VecX
 fld   dword ptr [si].VecY
 fmul  dword ptr [di].VecY
 faddp st(1),st
 fld   dword ptr [si].VecZ
 fmul  dword ptr [di].VecZ
 faddp st(1),st
 fstp  dword ptr [bx]
 ret
VectorMath_DotProduct endp

; Vector-scalar (dot) multiplication
; In: ST(0)=scalar
;     BX=Ptr to vector
VectorMath_MulByScalar proc
 fld st(0)
 fld st(0)
 fmul dword ptr [bx].VecX
 fstp dword ptr [bx].VecX
 fmul dword ptr [bx].VecY
 fstp dword ptr [bx].VecY
 fmul dword ptr [bx].VecZ
 fstp dword ptr [bx].VecZ
 ret
VectorMath_MulByScalar endp

; Add two vectors and store result into third one.
; IN: SI=Ptr to vec1
;     DI=Ptr to vec2
;     BX=Ptr to result vector
VectorMath_Add proc
 fld  dword ptr [si].VecX
 fadd dword ptr [di].VecX
 fstp dword ptr [bx].VecX
 fld  dword ptr [si].VecY
 fadd dword ptr [di].VecY
 fstp dword ptr [bx].VecY
 fld  dword ptr [si].VecZ
 fadd dword ptr [di].VecZ
 fstp dword ptr [bx].VecZ
 ret
VectorMath_Add endp