;****************************
;* (C)oded by Sergey Chaban *
;****************************
;* I just like 2see my name *
;****** on the screen *******

; WARNING!
; This file contains explicit hardcore programming materials!
; If you under 18, or over 90, or came from Mars, or an idiot
; please leave this file NOW!


;> This code was written for a purpose of making the debugging dumps
;> in a pure Assembly implementations.
;> This is a matter-of-fact, prosaic, boring code, not intended to be
;> used for the educational purposes. Blah, blah, blah...
;> In other words... GET AWAY FROM HERE!!! ...
;> You still here? Oh, well, that's your funeral! Get lost...


;/////////////////////////////////////////////////////////
; Convert a floating point real number to a mantissa
; (represented as a BCD) and a base ten exponent.
; Number passed in ST.

_debug_SaveCW = -2
_debug_NewCW = -4

Float2Dec:
 enter 4,0
 fnstcw word ptr [bp]._debug_SaveCW
 mov word ptr [bp]._debug_NewCW,3BFh   ; round to nearest
 fldcw word ptr [bp]._debug_NewCW
 mov word ptr ds:[FPU_Temp],57         ; number of significant bits
                                       ; i. e. bits in mantissa
 fild word ptr ds:[FPU_Temp]

 fld st(1)                             ; n, sbits, n
 fxtract                               ; get mantissa and exponent
 fstp st(0)                            ; remove mantissa; exp, sbits, n
 fxam
 GetFPUFlags
 and ah,1000101b                       ; isolate C3,C2,C0
 cmp ah,0000101b                       ; Infinity?
 jnz NotInfinity
 fstp st(0)
 fldz
NotInfinity:
 fsubp st(1),st                        ; sbits-exp
 fldl2t                                ; log2(10)
 fdivp st(1),st                        ; 10^X
 frndint                               ; round to nearest
 fist word ptr [bx].floatExponent      ; save exponent
 call Exp10                            ; 10^ST -> get exponent factor
 fmulp st(1),st                        ; adjust real number for exponent
 mov ax,17
 sub ax,word ptr [bx].floatExponent
 mov word ptr [bx].floatExponent,ax
 fldcw word ptr [bp]._debug_SaveCW
 leave
 fbstp tbyte ptr [bx].floatMantissa
 ret


;///////////////////////////////////////////////////////////
; Calc 10^n
; IN: ST=n
; 10^n=2^(n*log2(10))
Exp10:
 fldl2t           ; log2(10)
 fmulp st(1),st   ; n*log2(10)
Exp2:
; Calc 2^n
; Rounding mode must be set to nearest! (Take it easy! That's the case.)
; Represent ST=n as n=W+F or n=W-F, where W is a whole part and F is a
; fractional part [0,0.5]
; i. e. W=round(n), F=n-round(n)
 fld st(0)                   ; used as temporal reg
 fld st(0)                   ; duplicate n
 frndint                     ; round (n), n
 fsub st(1),st               ; W, F
 fxch                        ; F, W
 ftst                        ; test fractional part for sign
 fnstsw ax
 sahf
 jns Exp2_Pos1
 fabs
Exp2_Pos1:
 f2xm1                       ; 2^F-1
 fadd dword ptr ds:[fp_One]  ; 2^F
 fxch
 fld1
 fscale                      ; 2^W
 fst st(3)                   ; copy 2^W to temporal reg
 fcompp                      ; remove 2^W and exponent;  2^F, 2^W
 jns Exp2_Pos2
 fdivr dword ptr ds:[fp_One] ; 1/2^F
Exp2_Pos2:
 fmulp st(1),st              ;    2^W * 2^F for positive case
                             ; or  2^W/2^F  for negative case
 ret


;///////////////////////////////////////////////////////////////////////////
TempBCD        = -10
TempWordStore  = -12
TempDwordStore = -14
TempQwordStore = -18

PrintUnsignedDword:       ; EAX
 enter 10+8,0
 sub edx,edx
 jmp ConvertQword
PrintSignedDword:         ; EAX
 cdq
PrintQword:               ; EDX:EAX
 enter 10+8,0
ConvertQword:
 mov dword ptr [bp].TempQwordStore,eax
 mov dword ptr [bp].TempQwordStore+4,edx
 fild qword ptr [bp].TempQwordStore
 jmp PrintBCD
PrintUnsignedWord:        ; AX
 enter 10+4,0
 and eax,0000FFFFh
 jmp ConvertDword
PrintSignedWord:          ; AX
 enter 10+4,0
 cwde
ConvertDword:
 mov dword ptr [bp].TempDwordStore,eax
 fild dword ptr [bp].TempDwordStore
 jmp PrintBCD
PrintUnsignedByte:        ; AL
 enter 10+2,0
 sub ah,ah
 jmp ConvertWord
PrintSignedByte:          ; AL
 enter 10+2,0
 cbw
ConvertWord:
 mov word ptr [bp].TempWordStore,ax
 fild word ptr [bp].TempWordStore
PrintBCD:
 push si
 fbstp tbyte ptr [bp].TempBCD
 mov al,byte ptr [bp].TempBCD+9
 test al,al
 jns PrBCDPos
 mov al,'-'
 stosb
PrBCDPos:
 mov ah,0F0h       ; start with high nibble
 xor dx,dx
 mov si,8
 mov cx,9*2
FindBCDDigits:
 test byte ptr [bp].TempBCD.[si],ah
 jnz BCDDigFound
 mov dl,1
 and dl,ah
 rol ah,4
 sub si,dx
 loop FindBCDDigits
 mov al,'0'
 stosb
 jmp PrintBCD_Done
BCDDigFound:
 mov dl,cl
PrintBCDigits:
 mov al,byte ptr [bp].TempBCD.[si]
 and al,ah
 rol ah,4
 mov cl,ah
 and cl,4
 shr al,cl
 add al,'0'
 test ah,ah
 sets cl
 sub si,cx
 stosb
 dec dx
 jnz PrintBCDigits
PrintBCD_Done:
 pop si
 leave
 ret


;//////////////////////////////////////////////////////////////
;// ST=number to print
PrintFloat:
;; ftst
;; GetFPUFlags
;; jnz FloatNonZero
;; fstp st(0)
;; mov al,'0'
;; stosb
;; ret
;;FloatNonZero:
 test byte ptr ds:[_dbgPrintFlags],_dbgprnEXPFORM
 jnz _dbgUseExpForm
 push si bx
 enter 4,0
 fnstcw word ptr [bp]._debug_SaveCW
 mov word ptr [bp]._debug_NewCW,37Fh OR 0C00h  ; Truncate to zero mode
 fldcw word ptr [bp]._debug_NewCW
 fld st(0)
 ftst
 GetFPUFlags
 setb dh
 mov word ptr [bp]._debug_NewCW,37Fh           ; Round to nearest mode
 frndint                                       ; [x]  (truncate)
 fist dword ptr ds:[_dbgTempIntPart]
 fsubp st(1),st                                ; {x}=x-[x]
 fabs                                          ; to avoid negative zeroes
 fadd dword ptr ds:[fp_One]                    ; 1.{x}
 fldcw word ptr [bp]._debug_NewCW              ; For fractional part
 fmul dword ptr ds:[_dbgPrecMult]              ; move decimal point
 frndint                                       ; (to nearest)
 fbstp tbyte ptr ds:[_dbgTempFracPart]
 mov eax,dword ptr ds:[_dbgTempIntPart]
 test eax,eax
 jnz PrintFltInt
 test dh,dh
 jz PrintFltInt
 mov byte ptr es:[di],'-'
 inc di
PrintFltInt:
 call PrintSignedDword
 mov al,'.'
 stosb
 mov si,offset _dbgTempFracPart
 mov ah,0F0h       ; start with high nibble
 xor dx,dx
 mov bx,8
 mov cx,9*2
FindFirstFracDigit:
 test byte ptr [si].[bx],ah
 jnz FracDigFound
 mov dl,1
 and dl,ah
 rol ah,4
 sub bx,dx
 loop FindFirstFracDigit
FracDigFound:
 dec cx      ; skip '1'
 dec bx
 rol ah,4
 mov dl,cl
PrintFracDigits:
 mov al,byte ptr [si].[bx]
 and al,ah
 rol ah,4
 mov cl,ah
 and cl,4
 shr al,cl
 add al,'0'
 test ah,ah
 sets cl
 sub bx,cx
 stosb
 dec dx
 jnz PrintFracDigits
 fldcw word ptr [bp]._debug_SaveCW
 leave
 pop bx si
 ret

_dbgUseExpForm:
 push bx si
 mov bx,offset _dbgTempFloat
 call Float2Dec
 mov dx,word ptr [bx].floatMantissa+8
 ; get the mantissa sign
 mov al,'+'
 test dh,dh
 jns MantissaSign
 mov al,'-'
MantissaSign:
 stosb
 ; print 1st digit, decimal point and 2nd digit
 mov al,dl
 mov ah,dl
 and ax,0FF0h
 shr al,4
 add ax,'00'
 stosb
 mov al,'.'
 stosw
 mov si,7
 mov ah,0F0h
 xor ch,ch
PrintMantissaDigits:
 mov al,byte ptr [bx].floatMantissa.[si]
 and al,ah
 rol ah,4
 mov cl,ah
 and cl,4
 shr al,cl
 add al,'0'
 test ah,ah
 sets cl
 stosb
 sub si,cx
 jns PrintMantissaDigits
 mov al,'E'
 stosb
 mov ax,[bx].floatExponent
 pop si bx
 test ah,ah
 js PrintSignedWord
 mov byte ptr es:[di],'+'
 inc di
 jmp PrintSignedWord

;//////////////////////////////////////////////////////////////
PrintHexDword:
 rol eax,16
 call PrintHexWord
 rol eax,16
PrintHexWord:
 mov dl,al
 mov al,ah
 call PrintHexByte
 mov al,dl
PrintHexByte:
 call Byte2Hex
 stosw
 ret

Byte2Hex:
 mov ah,al
 shr al,4
 call Nibble2Hex
 and al,0Fh
Nibble2Hex:
 add al,90h
 daa
 adc al,40h
 daa
 xchg al,ah
 ret

HexPrefix:
 mov ax,'x0'
 stosw
 ret

SetPrintPrecision:
 fld1
_dbgMoveDecPoint:
 fmul dword ptr ds:[fp_Ten]
 loop _dbgMoveDecPoint
 fstp dword ptr ds:[_dbgPrecMult]
 ret


EVENDATA

_dbgTempFloat    BCR <>
_dbgTempIntPart  dd 0
_dbgTempFracPart dt 0
_dbgPrecMult     dd 100.0
_dbgPrintFlags   db 0,0

fp_Ten dd 10.0
