program Vstarfield;

uses mode13h,crt;

type star=record
                x,y,z:integer;
                end;

var stars:array [1..1000] of star;
    a:integer;

procedure initstars;
var a:integer;
begin
      cls (0,vp[1]);
      for a:=0 to 15 do setcolor (a,a*4,a*4,a*4);
      for a:=1 to 1000 do
      begin
           stars[a].x:=random(320);
           stars[a].y:=random(200);
           stars[a].z:=random(15)+1;
      end;
end;

procedure clearstars;
var a:integer;
begin
     copypage (vp[2],vp[1]);
end;

procedure movestars(ix,iy,iz:integer);
var a:word;
begin
      for a:=1 to 1000 do
      begin
            stars[a].x:=stars[a].x+ix*(stars[a].z div 4);
            stars[a].y:=stars[a].y+iy*(stars[a].z div 4);
            stars[a].z:=stars[a].z+iz;
            if stars[a].z<1 then stars[a].z:=15;
            if stars[a].z>15 then stars[a].z:=1;
            if stars[a].x<0 then stars[a].x:=319;
            if stars[a].x>319 then stars[a].x:=0;
            if stars[a].y<0 then stars[a].y:=199;
            if stars[a].y>199 then stars[a].y:=0;
      end;
end;

procedure drawstars;
var a:integer;
begin
      for a:=1 to 1000 do
      putpixel(stars[a].x,stars[a].y,stars[a].z,vp[1]);
end;

procedure movearound(ix,iy,iz:integer);
begin
     if iz<>0 then delay(50);
     clearstars;
     movestars (ix,iy,iz);
     drawstars;
     waitvbl;
     copypage(vp[1],vga);
end;

procedure startinit;
begin
     initgraph;
     initvirt;
end;

procedure endinit;
begin
     closegraph;
     closevirt;
     textcolor (15);
     writeln ('Starfield v1.2');
     writeln;
     textcolor (8);
     writeln ('Have a nice day!');
end;

begin
     startinit;
     loadpcx ('dat01.dat',vp[2]);
     for a:=1 to 130 do
         begin
         copypage (vp[2],vga);
         delay (20);
         move(mem[vp[2]:320],mem[vp[2]:0],43680);
         end;
     loadpcx ('dat02.dat',vp[2]);
     for a:=1 to 150 do
         begin
         copypage (vp[2],vga);
         delay (20);
         move(mem[vp[2]:320],mem[vp[2]:0],47680);
         end;
     initstars;
     for a:=1 to 100 do movearound(0,0,-1);
     for a:=1 to 100 do movearound(0,0,1);
     for a:=1 to 100 do movearound(-1,0,0);
     for a:=1 to 100 do movearound(-1,0,0);
     for a:=1 to 100 do movearound(1,0,0);
     for a:=1 to 100 do movearound(1,-1,0);
     for a:=1 to 100 do movearound(0,-1,0);
     for a:=1 to 100 do movearound(-1,-1,0);
     endinit;
end.