{$M 22048,0,163520}
program block;

uses crush13h,games,mse_tp,sound;
{crush13h for vga}
{games for keyboard and timing}
{mse_tp for bwsb}
{sound for setup sound}

const  npart=12;
       nlevels=6;

type   partrecord= record
                         x,y,vx,vy:integer;
                         okay,destroy:boolean;
                   end;
       batrecord= record
                        active,long:boolean;
                        x,rlimit,llimit:integer;
                  end;
       levelrec= record
                       bonusperc,initvel,nblocks:integer;
                       background:string[17];
                 end;

var    part       : array [1..npart] of partrecord;
       bat        : array [1..2] of batrecord;
       level      : array [1..nlevels , 1..14 , 1..16] of integer;
       levelmisc  : array [1..nlevels] of levelrec;
       bonus,velocity, nlevel: integer;
       a,b        : integer;
       hblock,vblock,blevel,blockcount: integer;
       light,theend: boolean;


procedure terminate;
begin
     closevirt;                 {close vp's}
     video_mode ( 03);          {back to normal mode}
     {stopmusic;                 {no more music}
     {stopoutput;                {no more sound output}
     {unloadmodule;              {unloadmodule}
     {freemse;                   {free memory for sound}
     setoldtimint;              {returning timer to normal}
     halt;
end;

procedure checkend;
var x,y,c:integer;
begin
     theend:=true;
     for x:=0 to 319 do
         begin
              for y:=0 to 199 do
                  begin
                       c:=getpixel (x,y,vp[2]);
                       if c=12 then theend:=false;
                  end;
         end;
end;


procedure loadlevels;
var f:text;
    cha:char;
    x,y:integer;
begin
     assign (f,'data\level.dat');
     reset (f);

     for a:=1 to nlevels do
         begin
              for y:=1 to 16 do
                  begin
                       for x:=1 to 14 do
                           begin
                                read (f,level[a,x,y]);
                           end;
                  end;
              readln (f,levelmisc[a].bonusperc);
              readln (f,levelmisc[a].initvel);
              readln (f,levelmisc[a].nblocks);
              readln (f,levelmisc[a].background);
              levelmisc[a].background:='data\'+levelmisc[a].background;
         end;
     close (f);
     nlevel:=0; {start from scratch... loadnext will do the dirty work}
end;

procedure endproc;
begin
     {this is the last level!!! :( }
     terminate;
end;

procedure putblocks (nlevel:integer;from,where:word);
var x,y:integer;
begin

     copypage (from,where);

     for x:=0 to 319 do putpixel (x,7,6,where);
     for x:=0 to 319 do putpixel (x,199,7,where);   {temp}
     for y:=0 to 199 do putpixel (7,y,4,where);
     for y:=0 to 199 do putpixel (232,y,5,where);  {232= 8+14*16}

     for x:=1 to 14 do
         begin
              for y:=1 to 16 do
                  begin
                       if level[nlevel,x,y]<>0 then
                          begin
                       for a:=1 to 15 do for b:=1 to 7 do putpixel (x*16-8+a,y*8+b,level[nlevel,x,y],where);
                       for a:=1 to 15 do putpixel (x*16-8+a,y*8,10,where);
                       for a:=1 to 15 do putpixel (x*16-8+a,y*8+7,11,where);
                       for a:=1 to 7 do putpixel (x*16-8,y*8+a,8,where);
                       for a:=1 to 7 do putpixel (x*16-8+15,y*8+a,9,where);
                       putpixel (x*16-8,y*8,12,where);
                       putpixel (x*16-8+15,y*8,13,where);
                       putpixel (x*16-8,y*8+7,14,where);
                       putpixel (x*16-8+15,y*8+7,15,where);
                          end;
                  end;
         end;
end;

procedure loadnext;
var x,y :integer;
begin
     if nlevel=nlevels then endproc;
     nlevel:=nlevel+1;

     loadpcx (levelmisc[nlevel].background,vp[2]);

     putblocks (nlevel,vp[2],vp[1]);

     hblock:=7;    {height}
     vblock:=15;   {volume...well actually i got them mistaken :) }

     blockcount:=0;

     for a:=1 to npart do part[a].okay:=false;
     part[1].vx:=1;
     part[1].vy:=-1;
     part[1].x:=10;
     part[1].y:=180;
     part[1].okay:=true;

     bat[2].x:=60;           {ta ao contrario pq 1 debe tar na dir!}
     bat[1].x:=160;
     bat[2].llimit:=8;
     bat[1].llimit:=121;
     bat[2].rlimit:=100;
     bat[1].rlimit:=212;

end;

procedure checkcontact(a:integer);
var c,d,blockx,blocky: integer;
begin
     c:=getpixel (part[a].x,part[a].y,vp[1]);
     if c<>0 then
        begin
              blockx:=part[a].x;
              blocky:=part[a].y;

              if c=1 then
                 begin
                      part[a].vx:=-1;
                      part[a].vy:=-1;
                 end;
              if c=2 then part[a].vy:=-1;
              if c=3 then
                 begin
                      part[a].vx:=1;
                      part[a].vy:=-1;
                 end;
              if c=4 then part[a].vx:=1;
              if c=5 then part[a].vx:=-1;
              if c=6 then part[a].vy:=1;
              if c=7 then part[a].vy:=-1;
              if c=8 then
                 begin
                      part[a].vx:=part[a].vx*(-1);

                         repeat
                               blocky:=blocky-1;
                               d:= getpixel (blockx,blocky,vp[1]);
                               blockx:=blockx;
                         until d=12;

                      level[nlevel,(d-8) div 16,(b-8) div 8]:=0;

                      blockcount:=blockcount+1;
                      if blockcount=levelmisc[nlevel].nblocks then loadnext;
                 end;
              if c=9 then
                 begin
                      part[a].vx:=part[a].vx*(-1);

                      repeat
                            blocky:=blocky-1;
                            d:= getpixel (blockx,blocky,vp[1]);

                      until d=13;
                      blockx:=blockx-vblock;

                      level[nlevel,(d-8) div 16,(b-8) div 8]:=0;

                      blockcount:=blockcount+1;
                      if blockcount=levelmisc[nlevel].nblocks then loadnext;
                 end;
              if c=10 then
                 begin
                      part[a].vy:=part[a].vy*(-1);
                      repeat
                            blockx:=blockx-1;
                            d:= getpixel (blockx,blocky,vp[1]);
                            blocky:=blocky;
                      until d=12;

                      level[nlevel,(d-8) div 16,(b-8) div 8]:=0;

                      blockcount:=blockcount+1;
                      if blockcount=levelmisc[nlevel].nblocks then loadnext;
                 end;
              if c=11 then
                 begin
                      part[a].vy:=part[a].vy*(-1);
                      repeat
                            blockx:=blockx-1;
                            d:= getpixel (blockx,blocky,vp[1]);

                      until d=14;
                      blocky:=blocky-hblock;

                      level[nlevel,(d-8) div 16,(b-8) div 8]:=0;

                      blockcount:=blockcount+1;
                      if blockcount=levelmisc[nlevel].nblocks then loadnext;
                 end;
              if c=12 then
                 begin
                      if part[a].vy=1 then part[a].vy:=part[a].vy*(-1);
                      if part[a].vx=1 then part[a].vx:=part[a].vx*(-1);
                      blockx:=blockx;
                      blocky:=blocky;

                      level[nlevel,(d-8) div 16,(b-8) div 8]:=0;

                      blockcount:=blockcount+1;
                      if blockcount=levelmisc[nlevel].nblocks then loadnext;
                 end;
              if c=13 then
                 begin
                      if part[a].vy=1 then part[a].vy:=part[a].vy*(-1);
                      if part[a].vx=-1 then part[a].vx:=part[a].vx*(-1);
                      blockx:=blockx-vblock;
                      blocky:=blocky;

                      level[nlevel,(d-8) div 16,(b-8) div 8]:=0;

                      blockcount:=blockcount+1;
                      if blockcount=levelmisc[nlevel].nblocks then loadnext;
                 end;
              if c=14 then
                 begin
                      if part[a].vy=-1 then part[a].vy:=part[a].vy*(-1);
                      if part[a].vx=1 then part[a].vx:=part[a].vx*(-1);
                      blockx:=blockx;
                      blocky:=blocky-hblock;

                      level[nlevel,(d-8) div 16,(b-8) div 8]:=0;

                      blockcount:=blockcount+1;
                      if blockcount=levelmisc[nlevel].nblocks then loadnext;
                 end;
              if c=15 then
                 begin
                      if part[a].vy=-1 then part[a].vy:=part[a].vy*(-1);
                      if part[a].vx=-1 then part[a].vx:=part[a].vx*(-1);
                      blockx:=blockx-vblock;
                      blocky:=blocky-hblock;

                      level[nlevel,(d-8) div 16,(b-8) div 8]:=0;

                      blockcount:=blockcount+1;
                      if blockcount=levelmisc[nlevel].nblocks then loadnext;
                 end;
         end;
end;

procedure updateballs;
begin

     putblocks(nlevel,vp[2],vp[1]);

     for a:=1 to 2 do
         begin
              putpixel (bat[a].x,189,1,vp[1]);
              putpixel (bat[a].x+1,189,1,vp[1]);
              putpixel (bat[a].x+1,188,1,vp[1]);
              putpixel (bat[a].x+2,188,1,vp[1]);
              putpixel (bat[a].x+2,187,1,vp[1]);
              putpixel (bat[a].x+3,187,2,vp[1]);
              putpixel (bat[a].x+4,187,2,vp[1]);
              putpixel (bat[a].x+5,187,2,vp[1]);
              putpixel (bat[a].x+6,187,2,vp[1]);
              putpixel (bat[a].x+7,187,2,vp[1]);
              putpixel (bat[a].x+8,187,2,vp[1]);
              putpixel (bat[a].x+9,187,2,vp[1]);
              putpixel (bat[a].x+10,187,2,vp[1]);
              putpixel (bat[a].x+11,187,2,vp[1]);
              putpixel (bat[a].x+12,187,2,vp[1]);
              putpixel (bat[a].x+13,187,2,vp[1]);
              putpixel (bat[a].x+14,187,2,vp[1]);
              putpixel (bat[a].x+15,187,2,vp[1]);
              putpixel (bat[a].x+16,187,2,vp[1]);
              putpixel (bat[a].x+17,187,2,vp[1]);
              putpixel (bat[a].x+18,187,3,vp[1]);
              putpixel (bat[a].x+18,188,3,vp[1]);
              putpixel (bat[a].x+19,188,3,vp[1]);
              putpixel (bat[a].x+19,189,3,vp[1]);
              putpixel (bat[a].x+20,189,3,vp[1]);
         end;
     for a:=1 to npart do
         begin
              if part[a].okay=true then
                 begin
                      part[a].x:=part[a].x+part[a].vx*1;
                      part[a].y:=part[a].y+part[a].vy*1;
                      checkcontact(a);
                 end;
         end;

end;

procedure putballs;     {199-y pq se nao ficava tudo ao contrario :) }
begin

     for a:=1 to npart do
         begin
              if part[a].okay=true then putpixel (part[a].x,part[a].y,116,vp[1]);
         end;
     copypage (vp[1],vga);
end;


procedure movebatleft(a:integer);
begin
     if a=1 then
     begin
          if keydown[rshscan]=true then bat[1].x:=bat[1].x-3;
          bat[1].x:=bat[1].x-3;
          if bat[1].x<bat[1].llimit then bat[1].x:=bat[1].llimit;
     end
     else begin
          if keydown[lshscan]=true then bat[2].x:=bat[2].x-3;
          bat[2].x:=bat[2].x-3;
          if bat[2].x<bat[2].llimit then bat[2].x:=bat[2].llimit;
     end;
end;

procedure movebatright(a:integer);
begin
     if a=1 then
     begin
          if keydown[rshscan]=true then bat[1].x:=bat[1].x+3;
          bat[1].x:=bat[1].x+3;
          if bat[1].x>bat[1].rlimit then bat[1].x:=bat[1].rlimit;
     end
     else begin
          if keydown[lshscan]=true then bat[2].x:=bat[2].x+3;
          bat[2].x:=bat[2].x+3;
          if bat[2].x>bat[2].rlimit then bat[2].x:=bat[2].rlimit;
     end;
end;



begin
     initnewtimint;             {using timer sync instead of music}
     tickwait(0);               {}
     {getcardinfo;               {setup sound}
     INITNEWKEYINT;             { keydown scan :) }
     video_mode ( $13);         {change to 13h}
     initvirt;                  {vp[1] and vp[2]}

     loadlevels;
     loadnext;

     repeat
           if keydown[leftscan]=true then movebatleft(1);
           if keydown[rightscan]=true then movebatright(1);
           if keydown[scanof('z')]=true then movebatleft(2);
           if keydown[scanof('x')]=true then movebatright(2);
           updateballs;
           putballs;

     until keydown[escscan]=true;

     terminate;

end.
