#include "Shader.h"


const char* shaderFragFromResource(int resourceId)
{
	HRSRC		rec;
	HGLOBAL		handle;

	LPCSTR lpResourceId = MAKEINTRESOURCE(resourceId);

	rec = FindResource(NULL, lpResourceId, "FSHADER");
	handle = LoadResource(NULL, rec);

	int size = SizeofResource(NULL, rec);

	const char* data = ( const char*)LockResource(handle);
	char* buffer = new char[size+1];
	msys_memcpy(buffer, data, size);
	buffer[size] = 0; // NULL terminator
	return buffer;
}

const char* shaderVertFromResource(int resourceId)
{
	HRSRC		rec;
	HGLOBAL		handle;

	LPCSTR lpResourceId = MAKEINTRESOURCE(resourceId);

	rec = FindResource(NULL, lpResourceId, "VSHADER");
	handle = LoadResource(NULL, rec);

	int size = SizeofResource(NULL, rec);

	const char* data = ( const char*)LockResource(handle);
	char* buffer = new char[size+1];
	msys_memcpy(buffer, data, size);
	buffer[size] = 0; // NULL terminator
	return buffer;
}

void initShader( int *pid, const char *vs, const char *fs, const char *shaderName )
{
	msys_debugPrintf("INIT SHADER: %s\n", shaderName);
    pid[0] = oglCreateProgram();                           
	int vsId;
	int fsId;
	if (vs != NULL)
	{
		vsId = oglCreateShader( GL_VERTEX_SHADER ); 
		oglShaderSource( vsId, 1, &vs, 0 );
		oglCompileShader( vsId );
		oglAttachShader( pid[0], vsId );
	}
	if (fs != NULL)
	{
		fsId = oglCreateShader( GL_FRAGMENT_SHADER ); 
		oglShaderSource( fsId, 1, &fs, 0 );
		oglCompileShader( fsId );
		oglAttachShader( pid[0], fsId );
	}	
	oglLinkProgram( pid[0] );

    #ifdef DEBUG
        int		result;
        char    info[1536];
        if (vs != NULL) oglGetObjectParameteriv( vsId,   GL_OBJECT_COMPILE_STATUS_ARB, &result ); 
		oglGetInfoLog( vsId,   1024, NULL, (char *)info ); 
		if( !result )
		{			
			msys_debugPrintf("VERTEX SHADER FAILED: %s\n", info);
			MessageBox( 0, info, 0, MB_OK|MB_ICONERROR);
			DebugBreak();
		}
        if (fs != NULL) oglGetObjectParameteriv( fsId,   GL_OBJECT_COMPILE_STATUS_ARB, &result ); 
		oglGetInfoLog( fsId,   1024, NULL, (char *)info );
		if( !result )
		{
			msys_debugPrintf("FRAG SHADER FAILED: %s\n", info);
			MessageBox( 0, info, 0, MB_OK|MB_ICONERROR);
			DebugBreak();
		}
        oglGetObjectParameteriv( pid[0], GL_OBJECT_LINK_STATUS_ARB,    &result ); oglGetInfoLog( pid[0], 1024, NULL, (char*)info ); 
		if( !result ) 
		{
			msys_debugPrintf("LINK SHADER FAILED: %s\n", info);
			MessageBox( 0, info, 0, MB_OK|MB_ICONERROR);
			DebugBreak();
		}		
    #endif
}

#ifdef DEBUG
// Load shader from disk into a null-terminated string
GLchar *LoadShaderText(const char *fileName)
{
	char path[MAX_PATH];
	char shaderPath[MAX_PATH];
	GetCurrentDirectory(MAX_PATH, path);

	sprintf(&shaderPath[0], "%s\\%s", path, fileName);

    GLchar *shaderText = NULL;
    GLint shaderLength = 0;
    FILE *fp;

    fp = fopen(shaderPath, "r");
    if (fp != NULL)
    {
        while (fgetc(fp) != EOF)
        {
            shaderLength++;
        }
        rewind(fp);
        shaderText = (GLchar *)msys_mallocAlloc(shaderLength+1);
        if (shaderText != NULL)
        {
            fread(shaderText, 1, shaderLength, fp);
		}else{

		}
        shaderText[shaderLength] = '\0';
        fclose(fp);
    }

    return shaderText;
}
#endif
