#include "loadtexture.h"
#include "../msys.h"

GLuint TextureFromTgaResource(int resourceId)
{	
	HRSRC		rec;
	HGLOBAL		handle;

	LPCSTR lpResourceId = MAKEINTRESOURCE(resourceId);

	rec = FindResource(NULL, lpResourceId, "TGA");
	handle = LoadResource(NULL, rec);

	MEMFILE *memfile;
	memfile = (MEMFILE *)msys_mallocAlloc(sizeof(MEMFILE));

	memfile->data = LockResource(handle);
	memfile->length = SizeofResource(NULL, rec);
	memfile->pos = 0;

	unsigned char type[4];
	unsigned char info[6];

	memread(&type, sizeof(char)*4, (unsigned int)memfile);
	memseek((unsigned int)memfile, 12, SEEK_SET);
	memread(&info, sizeof(char)*6, (unsigned int)memfile);

	STGA *tgaFile = new STGA();
	tgaFile->width = info[0] + info[1] * 256;
	tgaFile->height = info[2] + info[3] * 256;
	tgaFile->byteCount = info[4] / 8;
	long imageSize = tgaFile->width * tgaFile->height * tgaFile->width * tgaFile->byteCount;
	tgaFile->data = new unsigned char[imageSize];
	memread(tgaFile->data, sizeof(unsigned char) * imageSize, (unsigned int)memfile);

	GLuint texname;
	glGenTextures(1,&texname);
	glBindTexture(GL_TEXTURE_2D,texname);
	glTexImage2D(GL_TEXTURE_2D,0,3,tgaFile->width,tgaFile->height,0,GL_RGBA,GL_UNSIGNED_BYTE,(GLvoid*)tgaFile->data);

	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR); // Linear Filtering
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR); // Linear Filtering

	return texname;
}

/*
GLuint load_texture(char * aFilename)
{
    GLuint texname;
    glGenTextures(1,&texname);
    glBindTexture(GL_TEXTURE_2D,texname);
    SDL_Surface *temp = SDL_LoadBMP(aFilename);
    SDL_PixelFormat pf;
    pf.palette = NULL;
    pf.BitsPerPixel = 32;
    pf.BytesPerPixel = 4;
    pf.alpha = 0;
    pf.colorkey = 0;
    pf.Rmask = 0x000000ff;
    pf.Rshift = 0;
    pf.Rloss = 0;
    pf.Gmask = 0x0000ff00;
    pf.Gshift = 8;
    pf.Gloss = 0;
    pf.Bmask = 0x00ff0000;
    pf.Bshift = 16;
    pf.Bloss = 0;
    pf.Amask = 0xff000000;
    pf.Ashift = 24;
    pf.Aloss = 0;
    
    SDL_Surface *tm = SDL_ConvertSurface(temp, &pf,SDL_SWSURFACE);
    SDL_FreeSurface(temp);
    SDL_LockSurface(tm);
    glTexImage2D(GL_TEXTURE_2D,0,3,tm->w,tm->h,0,GL_RGBA,GL_UNSIGNED_BYTE,(GLvoid*)tm->pixels);
    SDL_UnlockSurface(tm);
    
    SDL_FreeSurface(tm);

    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR); // Linear Filtering
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR); // Linear Filtering

    return texname;
}*/
