#include "stacks.h"

vertexStack::vertexStack(int size)
{	
	max = size;
	items = new vertex[max];
	count = 0;
}

void vertexStack::push(vertex* v)
{
	copyVertex(&items[count++], v);
}

void vertexStack::pop()
{
	count--;
}

vertexStack::~vertexStack(void)
{
	delete(items);
}

/////////////////////////////

texCoordStack::texCoordStack(int size)
{
	max = size;
	items = new vertexTexCoord[max];	
	count = 0;
}

void texCoordStack::push(vertexTexCoord* tc)
{
	items[count].u = tc->u;
	items[count].v = tc->v;
	count++;
}

void texCoordStack::pop()
{
	count--;
}

texCoordStack::~texCoordStack(void)
{
	delete(items);
}

/////////////////////////////

indexStack::indexStack(int size)
{
	max = size;
	items = new GLuint[max];	
	count = 0;
}

void indexStack::push(GLuint i)
{
	items[count++] = i;
}

void indexStack::pop()
{
	count--;
}

indexStack::~indexStack(void)
{
	delete(items);
}


