#include "skybox.h"

void skybox::HandleTexture()
{
	glGenTextures(6, &_textureMap[0]);

	for(int i=0; i<6; i++)
	{
		GLint width, height, icomps;
		GLenum eFormat;
		GLbyte *pixels = gltLoadJPG(IDR_JPG_BACKGROUND_1_RIGHT+i, &width, &height, &icomps, &eFormat );		
		glBindTexture(GL_TEXTURE_2D, _textureMap[i]);
		glTexImage2D(GL_TEXTURE_2D, 0, icomps, width, height, 0, eFormat, GL_UNSIGNED_BYTE, pixels );
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR); // Linear Filtering
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR); // Linear Filtering
		oglGenerateMipmapEXT(GL_TEXTURE_2D); 

		msys_mallocFree(pixels);
	}

}

skybox::skybox(float size)
{
	_size = size;
	HandleTexture();
}

void skybox::Draw(float time)
{
	float size = _size;
	glPushMatrix();
	{
		// Enable/Disable features
		glPushAttrib(GL_ENABLE_BIT);
		glEnable(GL_TEXTURE_2D);
		glDisable(GL_DEPTH_TEST);
		glDisable(GL_LIGHTING);
		glDisable(GL_BLEND);

		float tcMin = 0.002f;
		float tcMax = 0.998f;

		float rotAmount = (time+50)*45;
		//glRotatef(-rotAmount, 0.1f, 1, 0);

		// Just in case we set all vertices to white.
		glColor4f(1,1,1,1);

		// Render the left quad
		glBindTexture(GL_TEXTURE_2D, _textureMap[1]);
		glBegin(GL_QUADS);
		glTexCoord2f(tcMax, tcMax); glVertex3f( -size/2, -size/2, -size/2 );
		glTexCoord2f(tcMin, tcMax); glVertex3f( -size/2, -size/2,  size/2 );
		glTexCoord2f(tcMin, tcMin); glVertex3f( -size/2,  size/2,  size/2 );
		glTexCoord2f(tcMax, tcMin); glVertex3f( -size/2,  size/2, -size/2 );
		glEnd();

		
		// Render the right quad
		glBindTexture(GL_TEXTURE_2D, _textureMap[0]);
		glBegin(GL_QUADS);
		glTexCoord2f(tcMax, tcMax); glVertex3f(  size/2, -size/2,  size/2 );
		glTexCoord2f(tcMin, tcMax); glVertex3f(  size/2, -size/2, -size/2 );
		glTexCoord2f(tcMin, tcMin); glVertex3f(  size/2,  size/2, -size/2 );
		glTexCoord2f(tcMax, tcMin); glVertex3f(  size/2,  size/2,  size/2 );
		glEnd();


		// Render the top quad
		glBindTexture(GL_TEXTURE_2D, _textureMap[2]);
		glBegin(GL_QUADS);
		glTexCoord2f(tcMin, tcMax); glVertex3f( -size/2,  size/2, -size/2 );
		glTexCoord2f(tcMin, tcMin); glVertex3f( -size/2,  size/2,  size/2 );
		glTexCoord2f(tcMax, tcMin); glVertex3f(  size/2,  size/2,  size/2 );
		glTexCoord2f(tcMax, tcMax); glVertex3f(  size/2,  size/2, -size/2 );
		glEnd();

		// Render the bottom quad
		glBindTexture(GL_TEXTURE_2D, _textureMap[3]);
		glBegin(GL_QUADS);
		glTexCoord2f(tcMin, tcMin); glVertex3f( -size/2, -size/2, -size/2 );
		glTexCoord2f(tcMin, tcMax); glVertex3f( -size/2, -size/2,  size/2 );
		glTexCoord2f(tcMax, tcMax); glVertex3f(  size/2, -size/2,  size/2 );
		glTexCoord2f(tcMax, tcMin); glVertex3f(  size/2, -size/2, -size/2 );
		glEnd();

		// Render the front quad
		glBindTexture(GL_TEXTURE_2D, _textureMap[4]);
		glBegin(GL_QUADS);
		glTexCoord2f(tcMax, tcMax); glVertex3f(  size/2, -size/2, -size/2 );
		glTexCoord2f(tcMin, tcMax); glVertex3f( -size/2, -size/2, -size/2 );
		glTexCoord2f(tcMin, tcMin); glVertex3f( -size/2,  size/2, -size/2 );
		glTexCoord2f(tcMax, tcMin); glVertex3f(  size/2,  size/2, -size/2 );
		glEnd();


		// Render the back quad
		glBindTexture(GL_TEXTURE_2D, _textureMap[5]);
		glBegin(GL_QUADS);
		glTexCoord2f(tcMax, tcMax); glVertex3f( -size/2, -size/2,  size/2 );
		glTexCoord2f(tcMin, tcMax); glVertex3f(  size/2, -size/2,  size/2 );
		glTexCoord2f(tcMin, tcMin); glVertex3f(  size/2,  size/2,  size/2 );
		glTexCoord2f(tcMax, tcMin); glVertex3f( -size/2,  size/2,  size/2 );

		glEnd();




		// Restore enable bits and matrix
		glPopAttrib();
	}
	glPopMatrix();
}

skybox::~skybox(void)
{
}
