 // SUNSPOT PASS 4 FS
 
 uniform sampler2D textureToBlur;
 uniform float surfaceWidth;
 uniform float surfaceHeight;
  
 void main()
 {	
 	vec4 sample[5];
    float pixelSizeX = 1.0 / surfaceWidth;
	float pixelSizeY = 1.0 / surfaceHeight;
	vec2 screenXY = vec2(gl_FragCoord.s / surfaceWidth, gl_FragCoord.t / surfaceHeight);
	
	sample[0] = vec4(texture2D(textureToBlur, screenXY));
	//sample[0] = vec4(texture2D(textureToBlur, vec2(screenXY.s, screenXY.t)));
	
	// left
	sample[1] = vec4(texture2D(textureToBlur, vec2(screenXY.s-pixelSizeX, screenXY.t)));
	
	// right
	sample[2] = vec4(texture2D(textureToBlur, vec2(screenXY.s+pixelSizeX, screenXY.t)));
	
	// above
	sample[3] = vec4(texture2D(textureToBlur, vec2(screenXY.s, screenXY.t+pixelSizeY)));
	
	// below
	sample[4] = vec4(texture2D(textureToBlur, vec2(screenXY.s, screenXY.t-pixelSizeY)));

	//gl_FragColor = (sample[0] + sample[1] + sample[2] + sample[3] +sample[4])/5.0;
	gl_FragColor = sample[0];
	//gl_FragColor = vec4(1,1,1,1);
 }
 