#pragma once

//#ifndef __CAMERA_H
//#define __CAMERA_H

#ifdef __WATCOMC__
#pragma library("objects.lib")
#endif

#ifdef __cplusplus
extern "C" {
#endif
//---------------------------------------------------------------------------//
#include "vmath/vector.h"
#include "vmath/matrix.h"
#include "misc/spline.h"
#include "objects/object.h"
#include "formats/v3o.h"


typedef enum
{
  CAMERAFLAG_VISABLE = 1 << 0,
  CAMERAFLAG_ANGLE = 1 << 1,
	CAMERAFLAG_OBJTARGET = 1 << 2,
  CAMERAFLAG_ACTIVE = 1 << 3,
	CAMERAFLAG_POSTARGET = 1 << 4
} CAMERAFLAGS;


typedef struct s_CAMERA CAMERA;
struct s_CAMERA
{
	CAMERAFLAGS flags;
	VECTOR target,upv;
	MATRIX rm;
	ANIM *anim;
	OBJECT *obj_target;
	int angleadd[3],num_target;
	float focus;
	V3O *object;
};


CAMERA *camera_create (void);
void camera_dispose (CAMERA *);
void camera_setfocus (CAMERA *, float);
void camera_settarget (CAMERA *, VECTOR *);
void camera_setupv (CAMERA *,VECTOR *);

//---------------------------------------------------------------------------//
#ifdef __cplusplus
}
#endif
//#endif
