#pragma once

#ifdef __WATCOMC__
#pragma library("render16.lib")
#endif

#ifdef __cplusplus
extern "C" {
#endif
//---------------------------------------------------------------------------//

#include "formats/v3d.h"
#include "formats/v3o.h"
#include "objects/camera.h"
#include "objects/object.h"
#include "drivers/drv16.h"
#include "vmath/vector.h"
#include "vmath/matrix.h"

typedef struct s_RNDDRV RNDDRV;

struct s_RNDDRV
{
	char *name;
	BUFF *buff;
	CAMERA *camera;
	float scale;

	void (* setviewport)(BUFF *, CAMERA *);
	void (* prepare)(V3D *);
	void (* render)(V3D *);
	void (* putobject)(OBJECT *);
	void (* putobject_pos)(OBJECT *, VECTOR *);
	void (* putobject_ang)(OBJECT *, int, int, int);
	void (* putobject_mat)(OBJECT *, MATRIX *);
	void (* putobject_pos_ang) (OBJECT *, VECTOR *, int, int, int);
	void (* putobject_pos_mat) (OBJECT *, VECTOR *, MATRIX *);
};

//---------------------------------------------------------------------------//
#ifdef __cplusplus
}
#endif
//#endif
