#pragma once

//#ifndef __OBJECT_H
//#define __OBJECT_H

#ifdef __WATCOMC__
#pragma library("objects.lib")
#endif

#ifdef __cplusplus
extern "C" {
#endif
//---------------------------------------------------------------------------//
#include "formats/vio.h"    // image object
#include "formats/v3o.h"
#include "objects/light.h"   // light object
#include "vmath/vector.h"
#include "vmath/matrix.h"
#include "misc/spline.h"

//#include "formats/vcam.h"		// camera object
//#include "formats/vsnd.h"		// sound object

//#include "anim.h"						// Animation structure

#define T_V3O  1
#define T_VIO  2
#define T_VCAM 3
#define T_VSND 4
#define T_VLGH 5
#define T_NULL 6

typedef struct s_OBJECT OBJECT;

typedef enum
{
	OBJFLAG_BOUNDINGSPHERE = 1 << 0,
	OBJFLAG_DRAW = 1 << 1,
	OBJFLAG_VECROT = 1 << 2		// If rotation defined with vectors instead of angles...
} OBJFLAGS;

struct s_OBJECT
{
  int type;
	OBJFLAGS flags;						  // lite flaggor...

	OBJECT *prev,*next,*parent; // Alla objekt kan ha ett annat objekt attachat!!
  float radius;               // Bounding sphere radius...

  ANIM *anim;                 // Alla objekt kan vara animerade
	MATRIX rm;									// Rotations matris...

  VECTOR calcpos;              // Nyberknad position
  float calcradius;           // Nyberknad radie

  int angleadd[3],num_parent;            //
  union object
  {
    V3O *v3o;
//    VSND *vsnd;
    VLGH *vlgh;
    VIO *vio;
//		VCAM *vcam;
  };
};

void object_boundingsphere (OBJECT *obj);
OBJECT *object_create (void);
void object_dispose (OBJECT *);
OBJECT *object_load (OBJECT *,char *filename, char *imagepath);
char *object_geterror (void);

//---------------------------------------------------------------------------//
#ifdef __cplusplus
}
#endif
//#endif
