#pragma once

//#ifndef __DRV16_H
//#define __DRV16_H

#ifdef __WATCOMC__
#pragma library("drivers.lib")
#endif

#ifdef __cplusplus
extern "C" {
#endif
//---------------------------------------------------------------------------//
#include "system/xstddef.h"
#include "misc/col.h"

typedef struct s_XYZ XYZ;
typedef struct s_DRV DRV;
typedef enum
{
	DRVCFG_ZBUFFER = 1 << 0,
  DRVCFG_NOMOUSE = 1 << 1,
	DRVCFG_15BITS  = 1 << 2,
	DRVCFG_16BITS  = 1 << 3,
	DRVCFG_24BITS  = 1 << 4,
	DRVCFG_32BITS  = 1 << 5
} DRVCFG;
typedef struct s_BUFF BUFF;
typedef struct s_DRVMODE DRVMODE;
typedef enum
{
	DRVMOUSE_MOVED = 1 << 0,
	DRVMOUSE_LBPRESSED = 1 << 1,
	DRVMOUSE_LBRELEASED = 1 << 2,
	DRVMOUSE_RBPRESSED = 1 << 3,
	DRVMOUSE_RBRELEASED = 1 << 4,
	DRVMOUSE_MBPRESSED = 1 << 5,
	DRVMOUSE_MBRELEASED = 1 << 6
} DRVMOUSE;
struct s_XYZ
{
	float x,y,z;
	float tx,ty;
  float l;
};
struct s_DRVMODE
{
	int width,height;
	int bpp;
};


struct s_DRV
{
	char *name;

	int modes;
	DRVMODE *modelist;

	int width,height;
	int minx,maxx;
	int miny,maxy;
	int aspectx,aspecty;

	DRVCFG config;

	RGB *palette;

	BUFF *activebuff;

	int ( *setup)( void);
	int ( *init)(int width, int height, DRVCFG config);
	int ( *reinit)(int width, int height);
	void ( *exit)();

	void ( *setpalette)( RGB *palette);
	void ( *vsync)();

  void ( *clearscr)( RGBA clrcol);

	/* Buffer functions */

	BUFF *( *createbuff)( int width, int height);
	void ( *destroybuff)( BUFF *buffer);
	void ( *setbuff)( BUFF *buff);

  void ( *xcopybuff) (int , int , int , int , BYTE*);
  void ( *xmovebuff) (int , int , int , int , RGBA);
  void ( *copybuff)( int x, int y);
  void ( *clearbuff)( RGBA clrcol);
  void ( *movebuff)( int x, int y, RGBA clrcol);

  void ( *plot)( XYZ p, RGBA col);
  void ( *line)( XYZ p1, XYZ p2, RGBA col);
  void ( *poly)( XYZ p1, XYZ p2, XYZ p3, RGBA col );
  void ( *tpoly)( XYZ p1, XYZ p2, XYZ p3, BYTE *image );
  void ( *blit)( XYZ p, RGBA *image, int *zimage, int width, int height);

	/* Mouse functions */

  int ( *mouseinit)( int minx, int miny, int maxx, int maxy);
	int ( *mousecallback)( void( *callback)( DRVMOUSE change));
  void ( *getmousepos)( signed int *x, signed int *y);
  void ( *setmousepos)( signed int x, signed int y);
  void ( *getmousediff)( signed int *x, signed int *y);

	/* Keyboard functions */

	int ( *kbhit)();
	char ( *getkey)();

	/* Error handling */

	char *( *geterror)();
};

struct s_BUFF
{
	int width,height;
	int xorigo,yorigo;
 	int minx,maxx,miny,maxy;

	DRV *drv;
	BYTE *lighttab;

	BYTE *transtab;

	RGBA *image;
  int *zbuffer;

	int *ytab;
};

//---------------------------------------------------------------------------//
#ifdef __cplusplus
}
#endif
//#endif
