/*--------------------------------------------------------------------------
 * File: ex2.c
 * Written by: Gnilk
 * Description:
 *    Small example for SAGA.
 *    Drawing of a filled cube on the screen...
 *    Using matrix and vector libraries....
 *    Its a classic...
 *
 *
 * Note:
 *		Get rid of all comments to make the code look less complicated....
 *
 -------------------------------------------------------------------------------*/

#include "system/xmath.h"
#include "vmath/vmath.h"
#include "vmath/matrix.h"
#include "vmath/vector.h"
#include "system/xstdio.h"
#include "drivers/drv16.h"

/*
 * Define the driver as an external...
 */
extern DRV vesa16DRV;
static DRV *drv = &vesa16DRV;
static BUFF *virtual_buffer;


/*
 * Define The Cube!!!!!!!
 */
static VECTOR cube_vertex[8]={-80,80,80, 80,80,80, 80,-80,80, -80,-80,80,
											 -80,80,-80, 80,80,-80, 80,-80,-80, -80,-80,-80};
static VECTOR rot_vertex[8];
static int surftable[6][4]={{0,1,2,3},{7,6,5,4},{0,3,7,4},{5,1,0,4},{6,2,1,5},{3,2,6,7}};
static RGBA surface_col[6]={192,0,0,0, 0,142,0,0, 0,0,142,0, 142,0,142,0, 142,142,0,0, 0,142,142,0};
static int xv,yv,zv,xva,yva,zva;


/*
 *  Just two local routines to make it look nicer....
 */
static void my_project (VECTOR *v, float xo, float yo, float zo, float d)
{
	float t;
	v->z += zo;

	t = d - v->z;
	t = d/t;

	v->x = (xo+v->x) * t;
	v->y = (yo+v->y) * t;
}
static int hidden (int s)
{
	float x1,x2,y1,y2,f;
	int v1,v2,v3;

	v1 = surftable[s][0];
	v2 = surftable[s][1];
	v3 = surftable[s][2];


	x1=rot_vertex[v2].x - rot_vertex[v1].x;
	y1=rot_vertex[v2].y - rot_vertex[v1].y;

	x2=rot_vertex[v3].x - rot_vertex[v1].x;
	y2=rot_vertex[v3].y - rot_vertex[v1].y;

	f=(x1*y2-y1*x2);

	if (f>0) return 0;

	return 1;

}
/*
 * docube...   Draws a cube using our polyfillers (which are VERY temporary!)
 */
static void docube (void)
{
	MATRIX m;
	/*
	 * This struct is used to minimize argument list for various drawing functions
	 */
	XYZ pts[4];
	int i,j;

	/*
	 * Update..   SINESIZE is defined in VMATH.H
	 */
	xv = (xv + xva) & (SINESIZE -1);
	yv = (yv + yva) & (SINESIZE -1);
	zv = (zv + zva) & (SINESIZE -1);

	/*
	 * Build the rotation matrix according to the angles...
	 */
	buildrotationmatrix (xv,yv,zv, &m);

	/*
	 * Simply rotate by multplying the coords with the matrix...
	 * Use a simple projection routine...    than add origo...
	 */
	for (i=0;i<8;i++)
	{
		vecmul (&m,&cube_vertex[i],&rot_vertex[i]);
		my_project (&rot_vertex[i],0,0,800,400);
		rot_vertex[i].x += virtual_buffer->xorigo;
		rot_vertex[i].y += virtual_buffer->yorigo;
	}

	/*
	 *  draw only 5 sides of cube...   to show the Zbuffer in a simple matter..
	 */

	for (i=0;i<5;i++)
	{
		/*
		 * Fill the XYZ structures with info... (this is not good for speed)
		 */
		for (j=0;j<4;j++)
		{
			pts[j].x = rot_vertex[surftable[i][j]].x;
			pts[j].y = rot_vertex[surftable[i][j]].y;
			pts[j].z = rot_vertex[surftable[i][j]].z;
			pts[j].l = 32;	/* we are NOT using any lightshadeing...*/
		}

	 /* restore this to skip some polys... */

 //		if (!hidden (i))
		{
			/*
			 * Draw two triangles...  with a certain color...
			 */
			drv->poly (pts[0],pts[1],pts[2],surface_col[i]);
			drv->poly (pts[0],pts[2],pts[3],surface_col[i]);
		}
	}
}

/* ######################################################################### */
/* ######################################################################### */
void init_driver (void)
{
	int i;
	/*
	 * Setup driver
	 * If this call isnt done the drv->init call does it for you...
	 * Setup checks for videomodes and such..
	 *
	 */
  if (!drv->setup())
	{
		printf("Driver setup failed(%s)\n", drv->geterror());
		exit( 1);
	}
	else
	{
		printf ("Available modes:\n");
		for(i=0; i<drv->modes; i++)
			printf ("%dx%d\n", drv->modelist[i].width, drv->modelist[i].height);
	}

	/*
	 * Init graphics driver with 16 bits output and Zbuffer
	 */
	if( !drv->init(640,480, DRVCFG_ZBUFFER | DRVCFG_16BITS))
	{
		printf("Unable to initilize %s.(%s)\n", drv->name, drv->geterror());
		exit(0);
	}

}

int main (void)
{
	RGBA RGBA_black = {0,0,0,0};
	/*
	 * Setup some variables...
	 */
	 xv=yv=zv=0;
	 xva=32;
	 yva=-29;
	 zva=31;

	/*
	 * Init matrix & vector functions...
	 * DONT forget this one... it sets up some tables!!!
	 */

	mathinit ();


	// init system...
	init_driver ();

	// Create a virtual buffer..
	if ((virtual_buffer = drv->createbuff (320,240))==NULL)
	{
		drv->exit ();
		printf ("Unable to create virtual screen buffer\n");
		exit (1);
	}
	// Set the buffer as active buffer...
	drv->setbuff (virtual_buffer);
	// Clear it...
	drv->clearbuff (RGBA_black);


	while(!drv->kbhit())
	{
		// Wait for vertical retrace sync!
		drv->vsync ();
		// Swap and clear current buffer (this also clears the current ZBUFFER!)
		drv->movebuff (0,0,RGBA_black);
		docube ();
	}

	// Destroy virtual_buffer and exit driver...
	drv->destroybuff (virtual_buffer);
	drv->exit ();

	return (0);
}
