
/*
     
     
     PlayStation GsSprite sample source
     Released by HITMEN PSX DIVISION 1997

     This source code does *only* compile on the original Psy-Q/SN-Systems
     compiler & the appropriate libraries (Release 3.4 and up).

     This is, however, a VERY VERY basic example of the Playstation and
     all its capabilities. We are just releasing this because we think
     that to many people got scared away by the insufficient documentation
     of the sources that have been spread yet. 

     We strictly recommend you to browse through the library reference (.pdf)
     files before coming up with questions email wise.
     

     HITMEN PSX DIVISION, 1997



*/

#include <sys/types.h>
#include <libetc.h>
#include <libgte.h>
#include <libgpu.h>
#include <libgs.h>
#include <libcd.h>
#include <kernel.h>

/* I DONT CARE if all of these are necessary thou */


#define OT_LENGTH  10  
GsOT WorldOT[2];
GsOT_TAG OTTags[2][1<<OT_LENGTH]; 

#define PACKETMAX 300             
PACKET GpuPacketArea[2][PACKETMAX*24];

#define SPRITEMAX 300             /* This should be more than enough */     
GsSPRITE Sprites[SPRITEMAX];           

#define TEX_ADDR   0x80140000    /* load your TIM to this adress */      
GsIMAGE TexInfo;                       

u_long PadData;                                                 

/* 
   'ONE' is a defined volatile constant and equates 4096 or 0x1000.
   It is used for fixpoint notation (rotation angle, scale percentage)
*/
   

main()
{
                PadInit(0);
                PadData=0 ;
                
                SetVideoMode(1);     /* 0=NTSC, 1=PAL */
                ResetGraph (0) ;
                GsInitGraph(320,240,0,0,0);
                GsDefDispBuff(0,0,0,240);
                
                WorldOT[0].length=OT_LENGTH;
                WorldOT[0].org=OTTags[0];
                WorldOT[1].length=OT_LENGTH;
                WorldOT[1].org=OTTags[1];
                
                GsInit3D(); 

                initTexture(TEX_ADDR);
                
                initSprite();
                

                /* main loop */
                
                while  ((PadData & PADselect)==0) 
                {
                moveSprite(); 
                drawAll();
                }
                  
                  ResetGraph(0);
                  PadStop();
                  return(0);

}



drawAll()
{
                int i;
                int activeBuff;
                
                
                
                activeBuff=GsGetActiveBuff();
                
                GsSetWorkBase((PACKET*)GpuPacketArea[activeBuff]);

                GsClearOt(0, 0, &WorldOT[activeBuff]);

                for(i = 0; i < SPRITEMAX; i++) {
                                GsSortSprite(&Sprites[i], &WorldOT[activeBuff], i+1);
                }
                /* This function registers the sprite drawing commands into
                   the Ordering Table (OT). The OT is the 'stack' that 
                   contains all the object that have to be drawn in the
                   next frame */
                                
                PadData = PadRead(0);  


                VSync(0);     /* waits for vertical retrace */

                GsSwapDispBuff();                               
                
                GsSortClear(0, 0, 0, &WorldOT[activeBuff]);
                
                /* registers a CLEARSCREEN command into the OT */
                
                
                GsDrawOt(&WorldOT[activeBuff]);
}


moveSprite()
{
                
                if((PadData & PADRup)>0 & Sprites[1].scalex > ONE - 100*32 ){   
                                              Sprites[1].scalex -= 32;
                                              Sprites[1].scaley -= 32;
                                        }
                
                if((PadData & PADRdown)>0 & Sprites[1].scalex < ONE + 70*32 ){   
                                              Sprites[1].scalex += 32;
                                              Sprites[1].scaley += 32;
                                        }
                
                if((PadData & PADRleft)>0) Sprites[1].rotate -= ONE*3;
                
                if((PadData & PADRright)>0) Sprites[1].rotate += ONE*3;
                                                
              

                if((PadData & PADLright)>0) Sprites[1].x +=2;

                if((PadData & PADLleft)>0) Sprites[1].x -=2;
              

            

                if((PadData & PADLup)>0) Sprites[1].y -=2;

                if((PadData & PADLdown)>0) Sprites[1].y +=2;
              


}


initTexture(addr)
u_long *addr;

{               RECT rect1;
                
                addr++;

                GsGetTimInfo(addr, &TexInfo);
                
                rect1.x=TexInfo.px;
                rect1.y=TexInfo.py;
                rect1.w=TexInfo.pw;
                rect1.h=TexInfo.ph;

                LoadImage(&rect1,TexInfo.pixel);  
                /* dma xfer from memory to videoram */

}

initSprite()
{
                int i;
                u_long colorMode;
                u_short tPage;

                colorMode = TexInfo.pmode&0x03;
                
                tPage = GetTPage(0,0,TexInfo.px, TexInfo.py);
                       

                Sprites[1].attribute = (colorMode<<24);
                Sprites[1].w = 255;              
                Sprites[1].h = 155;
                
                Sprites[1].x = 0;
                Sprites[1].y = 0;
                
                Sprites[1].mx = 128;       /* center f. rotation/scaling */
                Sprites[1].my = 78;
                
                Sprites[1].tpage = tPage;
                
                
                Sprites[1].u = 0;        /* offset of the sprite INSIDE */
                Sprites[1].v = 0;        /* the 255X255 pixel TIM picture */
                
                
                Sprites[1].cx = TexInfo.cx;
                Sprites[1].cy = TexInfo.cy;
                
                Sprites[1].r = 0x80;
                Sprites[1].g = 0x80;
                Sprites[1].b = 0x80;
                
                Sprites[1].rotate = ONE*0;
                Sprites[1].scalex = ONE;
                Sprites[1].scaley = ONE;
                                
}
