/*
 * Header file for 'morphdemo' program
 *
 */

#ifndef __MORPHDEMO_H__
#define __MORPHDEMO_H__
#include <ultra64.h>
#include "math.h"

// Configuration defines that probably don't work anymore
#define DO_LIGHTING
#define DOTEX
#define DOMM
#define DOZBUF

/* Stacksize in bytes */
#define STACKSIZE 0x2000

/*
 * Define RSP segment numbers
 * These definitions are required both by the 'spec' file, and by the
 * code in 'morphdemo.c' which sets up the RSP segment table.
 */
#define STATIC_SEG  1
#define DYNAMIC_SEG 2

/*
 * Define screensize.
 */
#define SCREEN_HT 240
#define SCREEN_WD 320

/* Message queue lengths */
#define PI_MSGQUEUE_SIZE   8 /* Not sure what the 'correct' value is.  Should
                                at least roughtly match possible count of
								outstanding PI requests */
#define DMA_MSGQUEUE_SIZE     1
#define RDPDONE_MSGQUEUE_SIZE 1
#define RETRACE_MSGQUEUE_SIZE 1

// Size of the display lists in the display list array (intialized by mkvert and doesn't change)
#define MTGLISTSIZE (386)
// Size of the display list in the dynamic data structure
// (is rebuilt every frame and contains references to the display list array)
#define GLIST_SIZE 2048*4

// Maximum number of letters on screen at the same time
#define MAX_ENTITIES 40

/* 
 * Dynamic data structure. Contains all the data that changes per frame
 * and that's used by the RSP to draw the screen. It needs to be double-buffered.
 */
typedef struct {
  Mtx projection;
  Mtx modeling_translate[MAX_ENTITIES];
  Mtx modeling_rotate[MAX_ENTITIES][3];
  Mtx viewing;  /* Currently unused           */
  Mtx identity; /* Currently unset and unused */
  Gfx glist[GLIST_SIZE];
} dynamic_stuff;

/*
 * All information about the status of the scroller
 *
 * Just keep it together in one structure so it's easier to look at.
 */
typedef struct {
	char	*ptr;
	int		time;
	int		speed;
	int		speed_target;
	int		spacing;
} scrollinf_t;

extern u64 rspdrambuf1[];
extern unsigned short hs_logo[];

/*
 * This macro is useful for debugging. If the program is crashing and you want to find out
 * where exactly, insert this macro in your program and if it gets to the BREAK safely the
 * program will stop and the screen will start flashing on and off.
 *
 * So then you know that at least up to there your program works. It's pretty lame but alas
 * there is no debugger for use with V64.
 */
#define stop for (;;) { osViBlack(TRUE); osViBlack(FALSE); }
#define BREAK for (;;) { osViBlack(TRUE); osViBlack(FALSE); }

#endif
