
;
;                            N64 INTRO-TRAINER #1
;              BY TITANIK/CRAZYNATION! - titanik@infomaniak.ch
;

;
; CONSTANTES
;

;--- position en RAM des differentes Procedures / Variables importantes.
osCreateMesgQueue:   equ $803225a0
osEventTable:        equ $80364ba0        ; cf osSetEvent
osContInit:          equ $80323cc0
osContStartReadData: equ $80323a60
osRecvMesg:          equ $80322800
osContGetReadData:   equ $80323b24


NB_OPTIONS:          equ 4

;
; CODE
;

        org  $80001000                 ; position en RAM de l'intro-trainer

mainproc:

        sub     sp,40
        sw      s0,0(sp)
        sw      s1,4(sp)
        sw      s2,8(sp)
        sw      s3,12(sp)
        sw      s4,16(sp)
        sw      s5,20(sp)
        sw      s6,24(sp)
        sw      s7,28(sp)
        sw      v0,32(sp)
        sw      t0,36(sp)

        sub     sp,$30

;------ init le joypad ! -------
        la      a0, SerialMesgQueue   ; variable de queue
        la      a1, SerialBuffer      ; buffer des messages
        li      t0,osCreateMesgQueue
        jalr    t0                    ; cree la message queue
        li      a2, 1                 ; 1 message max

        li      t0,osEventTable+8*5 ; = offset du vecteur d'int. serial
        lw      t1,0(t0)
        sw      t1,40(sp)           ; backup l'ancienne interruption
        lw      t1,4(t0)
        sw      t1,44(sp)

        la      a1, SerialMesgQueue   ; variable de queue
        sw      a1,0(t0)         ; associe l'interrupt serial a la queue
        sw      zero,4(t0)       ; message

        la      a0,SerialMesgQueue
        la      a1,ContConnected
        la      a2,ContStatus
        li      t0,osContInit
        jalr    t0
        nop
;-------------------------------

;--- lignes
        lw      a0,$78(sp)        ; parametre du osViSwapBuffer dans t0
        add     a0,2*320*18
        bgezal  zero,line
        nop
        lw      a0,$78(sp)        ; parametre du osViSwapBuffer dans t0
        add     a0,2*320*141
;        la      a0,ScreenBuffer+2*320*140
        bgezal  zero,line
        nop
        lw      a0,$78(sp)        ; parametre du osViSwapBuffer dans t0
        add     a0,2*320*207
;        la      a0,ScreenBuffer+2*320*208
        bgezal  zero,line
        nop
        lw      a0,$78(sp)        ; parametre du osViSwapBuffer dans t0
        add     a0,2*320*228
;        la      a0,ScreenBuffer+2*320*227
        bgezal  zero,line
        nop
;------

;-- dbut de l'effet

        bgezal  zero,displayoptions
        nop
        la      a3,1
        lw      a1,$78(sp)        ; parametre du osViSwapBuffer dans t0
        add     a1,2*320*149+16*7
        la      a0,title
        bgezal  zero,printit
        la      a2,24


        X: equr t0                ; now X = t0   (equr = equivalent register)
        Y: equr t1                ; Y=t1, etc...
        COUL: equr t2             ; c'est + facile a s'en rapeler que
        SOURCE: equr t3           ; t0, t1, t2, t3, etc.. hehe..
        DEST: equr t4
        BUFF: equr t5
        BOUCLE: equr t7
        SINBUFF_: equr t8
        _320: equr s0
        INCREM: equr s1
        SINBUFF: equr s2
        BUFF_: equr s3
        ECRAN: equr s4
        NOLETTRE: equr s5
        COLSCROLL: equr s6
        _16: equr s7
        SINBUFF2: equr s8


        li _320,640-2
        li _16,14
        or INCREM,zero,zero        ; INCREM=0
        la SINBUFF, sintab640
        la SINBUFF2, sintab2
        li NOLETTRE,0

;-- loop principale
loop3:

        la      BUFF,cznlogo+320*60           ; adresse du logo dans t2 (source)
        lw      ECRAN,$78(sp)        ; parametre du osViSwapBuffer dans t0
        add     ECRAN,320*40
        li      BOUCLE,320*120-1      ; nombre de pixels a copier dans t0
        or      X,zero,zero           ; x, y=0
        or      Y,zero,zero
loop2:
;-- logo deformant
        add     SINBUFF_,INCREM,X
        andi    SINBUFF_,512-1
        add     SINBUFF_,SINBUFF_,SINBUFF
        lh      t2,0(SINBUFF_)

        sub     SINBUFF_,Y,INCREM
        andi    SINBUFF_,512-1
        add     SINBUFF_,SINBUFF_,SINBUFF2
        lh      SINBUFF_,0(SINBUFF_)
        add     SINBUFF_,t2

        add     BUFF_,BUFF,SINBUFF_

        lh      COUL,0(BUFF_)           ; lit 2 pixel du logo (copie par 64-bits)
        bne     X,_320, notx320
        add     X,2                    ; incrmente de 4 les deux adresses mmoire
        or      X,zero,zero           ; x, y=0
        add     Y,2
notx320:
        sh      COUL,0(ECRAN)          ; les affiche sur l'cran
        add     ECRAN,2                ; incrmente de 4 les deux adresses mmoire
        add     BUFF,2
        bne     BOUCLE,zero,loop2  ; branch si t0<>0
        subu    BOUCLE,1           ; dcrmente le compteur de pixels

        add     INCREM, 2
;        andi    INCREM, $1ff       ; INCREM va de 0 a 1FF

; -- scroll

        lui     t0,$a440         ; attend la fin du retracage vertical
        li      t2,$200
VSync:  bne     t1,t2,VSync
        lw      t1,$0010(t0)

        lw      ECRAN,$78(sp)        ; parametre du osViSwapBuffer dans t0
        add     ECRAN,2*320*210
;        la      ECRAN, ScreenBuffer+2*320*210
        move    t2,ECRAN     ; sauvegarde ECRAN dans t2 (ne pas toucher t2!)

        li      t0,320*16-2       ; fait scroller le scroll
scroll: lw      t1,4(ECRAN)
        sw      t1,0(ECRAN)
        addiu   ECRAN,4
        bne     t0,zero,scroll
        subu    t0,2

aff:    la      t0,texte
        add     t0,t0,NOLETTRE    ; dans t0 position en memoire de la lettre
                                  ; a afficher
        lbu     t0,0(t0)          ; t0=lettre a afficher
        li      t9,' '
        bne     t0,t9,no_
        nop
        li      t0,95             ; espace = 91
no_     li      t9,'#'
        bne     t0,t9,nofin
        nop
        li      t0,91             ; espace juste cette ligne
        or      NOLETTRE,zero,zero

nofin:  subu    t0,65             ; A=0, B=1, etc
        sll     t3,t0,9
        la      t1,lettres
        add     t1,t1,t3

        add     t0,t1,COLSCROLL   ; quelle colonne dans la lettre afficheton?
        add     t0,t0,COLSCROLL
        li      t1,16
y_loop:
        add     t2,320*2       ; t2=position de l'cran
        lw      t3,0(t0)
        sw      t3,0(t2)      ; affiche la collone de la lettre en question
        add     t0,32
        bne     t1,zero,y_loop
        subu    t1,1


        bne     COLSCROLL,_16,nope   ; prochaine lettre ?
        add     COLSCROLL,2
nextletter:                          ; oui...
        or      COLSCROLL,zero,zero
        add     NOLETTRE,1
nope:



;------ lit le joypad ----------
        la      a0,SerialMesgQueue
        li      t0,osContStartReadData ; demande des info au controller
        jalr    t0
        nop

        la      a0,SerialMesgQueue
        li      a2,1
        li      t0,osRecvMesg          ; lit ces infos
        jalr    t0
        or      a1,zero,zero

        la      a0,ContBuffer          ; buffer ou on stoque la pos du joypad
        li      t0,osContGetReadData   ; transfere les infos dans ContBuffer
        jalr    t0
        nop
;-------------------------------

        la      t0,ContBuffer
        lhu     t0,0(t0)             ; t0=key
        bne     t0,zero,keypress
        nop
        la      t1,nokey
        li      t2,1
        sw      t2,0(t1)
keypress:
        la      t1,nokey
        lw      t2,0(t1)
        beq     t2,zero, noreadkey

        andi    t1,t0,$E300             ; right,left,A,B,Z
        beq     t1,zero,not_left
        nop
        la      t2,SelectOption
        lw      t1,0(t2)
        sll     t1,2
        la      t2,opt1on
        add     t2,t1
        lbu     t1,0(t2)
        xori    t1,1
        sb      t1,0(t2)
        la      t1,nokey
        sw      zero,0(t1)
        bgezal  zero,displayoptions
        nop
not_left:
        andi    t1,t0,$0400             ; down
        beq     t1,zero,not_down
        nop
        la      t2,SelectOption
        lw      t1,0(t2)
        add     t1,1
        li      t3,NB_OPTIONS
        beq     t1,t3,not_down
        nop
        sw      t1,0(t2)
        la      t1,nokey
        sw      zero,0(t1)
        bgezal  zero,displayoptions
        nop
not_down:

        andi    t1,t0,$0800             ; up
        beq     t1,zero,not_up
        nop
        la      t2,SelectOption
        lw      t1,0(t2)
        beq     t1,zero,not_up
        sub     t1,1
        sw      t1,0(t2)
        la      t1,nokey
        sw      zero,0(t1)
        bgezal  zero,displayoptions
        nop
not_up:

        andi    t1,t0,$1000             ; start ?
        bne     t1,zero,end_intro
        nop


noreadkey:

        beq     zero,zero,loop3    ; recommence la boucle
        nop

; -- fin de l'effet

; -- fin de l'intro

end_intro:

;------- patching!!!

        la      s0,opt1on

        lw      t0,0(s0)
        beq     t0,zero,no_1
        nop
        lui     t0,$8025
        li      t1,$240b0004
        sw      t1,$9ca4(t0)
        li      t1,$240f0004
        sw      t1,$9f78(t0)
        li      t1,$24190004
        sw      t1,$9dc0(t0)
        sw      t1,$9d34(t0)
no_1:
        lw      t0,4(s0)
        beq     t0,zero,no_2
        nop
        lui     t0,$8025
        li      t1,$240bffff
        sw      t1,$460c+0(t0)
        li      t1,$a54b0026
        sw      t1,$460c+4(t0)
        li      t1,$240d0880
        sw      t1,$460c+8(t0)
        li      t1,$3c098034
        sw      t1,$460c+12(t0)
        li      t1,$a52db21e
        sw      t1,$460c+16(t0)
        li      t1,$10000009
        sw      t1,$460c+20(t0)
        sw      zero,$460c+24(t0)
no_2:
        lw      t0,8(s0)
        beq     t0,zero,no_3
        nop
        li      t0,$80254408
        sw      zero,0(t0)
        sw      zero,4(t0)
        li      t1,$35ef0008
        sw      t1,8(t0)
        li      t1,$adcf0004
        sw      t1,12(t0)
        sw      zero,16(t0)
no_3:
        lw      t0,12(s0)
        beq     t0,zero,no_4
        nop
        li      t0,$80248154
        sw      zero,0(t0)
no_4:

;------- efface l'cran (fader)

        li      t0,8*5
        li      s1,1
        li      s2,%1111011110111100
fader:

        li      t1,320*240
        lw      t2,$78(sp)        ; parametre du osViSwapBuffer dans t0
fadloop:
        lh      t3,-2(t2)
        lh      t4,+2(t2)
        lh      t5,-640(t2)
        lh      t6,+640(t2)
        and     t3,s2
        and     t4,s2
        add     t3,t4

        and     t5,s2
        and     t6,s2
        add     t5,t6
        srl     t3,1
        srl     t5,1
        and     t3,s2
        and     t5,s2
        add     t3,t5
        srl     t3,1

        or      t3,s1
        sh      t3,0(t2)
        add     t2,2
        bne     t1,zero,fadloop
        sub     t1,1

        lui     t3,$a440         ; attend la fin du retracage vertical
        li      t2,$200
VSync2: bne     t1,t2,VSync2
        lw      t1,$0010(t3)

        bne     t0,zero,fader
        sub     t0,1

;------- jump au vrai jeu

        li      t0,$80364bc8
        lw      t1,40(sp)
        sw      t1,0(t0)
        lw      t1,44(sp)
        sw      t1,4(t0)

        add     sp,$30

        lw      s0,0(sp)
        lw      s1,4(sp)
        lw      s2,8(sp)
        lw      s3,12(sp)
        lw      s4,16(sp)
        lw      s5,20(sp)
        lw      s6,24(sp)
        lw      s7,28(sp)
        lw      v0,32(sp)
        lw      t0,36(sp)
        jr      t0
        add     sp,40


;
;  Display Options
;

displayoptions:
        move    v0,ra
        la      v1,posstr

        li      t7,NB_OPTIONS-1   ; loop de nb options
        lw      a1,$78(sp)        ; parametre du osViSwapBuffer dans t0
        add     a1,2*320*164+16*7
        la      a0,optstr1
        sw      a0,0(v1)
        la      a0,opt1on
        sw      a0,4(v1)
        sw      zero,8(v1)
loopdisp2:
        li      a3,1
        lw      t0,8(v1)
        la      t1,SelectOption
        lw      t1,0(t1)
        bne     t0,t1,not_select
        add     t0,1
        li      a3,$7001

not_select:
        sw      t0,8(v1)
        lw      a0,0(v1)
        bgezal  zero,printit
        li      a2,20
        add     a0,21
        sw      a0,0(v1)

        lw      t0,4(v1)
        lbu     t1,0(t0)
        add     t0,4
        sw      t0,4(v1)
        beq     t1,zero, off1
        nop

        la      a0,yesstr
        bgezal  zero,printit
        li      a2,3
        beq     zero,zero,end1
        nop
off1:
        la      a0,nostr
        bgezal  zero,printit
        li      a2,3
end1:
        add     a1,2*320*8+120*2
        bne     t7,zero,loopdisp2
        sub     t7,1

        move    ra,v0
        jr      ra
        nop

posstr:   dcb     4,0
posonoff: dcb     4,0
optdisp:  dcb     4,0

;SelectOption:    dcb 4,0

;
;  Line
;

line:   li      t0,$015e015e
        li      t1,159
linelp: sw      t0,0(a0)
        add     a0,4
        bne     t1,zero,linelp
        sub     t1,1
        jr      ra
        nop

;
;  Printit
;

printit:
        PRINTX: equr t8
        PRINTY: equr t9
        POSECRAN: equr a1

        li       t5,1
        or       t0,zero,zero      ; t0=no lettre
loopdisp:

        add     t1,a0,t0
        lbu     t1,0(t1)          ; t1=lettre a afficher

        li      t6,' '
        bne     t1,t6,l_no_
        nop
        beq     zero,zero,displetter
        li      t1,26
l_no_:

        li      t6,':'
        bne     t1,t6,l_no_double
        nop
        beq     zero,zero,displetter
        li      t1,37
l_no_double:

        li      t6,'+'
        bne     t1,t6,l_no_plus
        nop
        beq     zero,zero,displetter
        li      t1,38
l_no_plus:

        li      t6,'0'
        bltu    t1,t6,l_no_number
        li      t6,'9'
        bgtu    t1,t6,l_no_number
        nop
        beq     zero,zero,displetter
        sub     t1,'0'-27
l_no_number:


        subu    t1,65             ; A=0, B=1, etc


displetter:
        sll     t2,t1,7
        la      t1,lettres8x8
        add     t1,t1,t2

        li      PRINTY,7
_yloop:
        li      PRINTX,7
_xloop:
        lhu     t3,0(t1)
        bne     t3,t5,notcol0
        nop
        move    t3,a3
notcol0:
        sh      t3,0(POSECRAN)
        add     POSECRAN,2
        add     t1,2

        bne     PRINTX,zero,_xloop
        subu    PRINTX,1

        add     POSECRAN,(320-8)*2

        bne     PRINTY,zero,_yloop
        subu    PRINTY,1

        sub     POSECRAN,320*8*2-16

        add     t0,1
        bne     a2, zero, loopdisp
        subu    a2,1

        jr      ra
        nop

;

;
; VARIABLES
;

SerialMesgQueue: dcb 24,0
SerialBuffer:    dcb 4,0
ContConnected:   dcb 4,0
ContStatus:      dcb 16,0
ContBuffer:      dcb 24,0

nokey:           dcb 4,0

opt1on:          dcb 4,0
                 dcb 4,0
                 dcb 4,0
                 dcb 4,0
                 dcb 4,0
                 dcb 4,0
                 dcb 4,0
                 dcb 4,0

SelectOption:    dcb 4,0        ; Quelle option est choisie

;
; INCLUDES, CONSTANTES, etc
;

cznlogo:      ;dcb     320*240,$ff
                   incbin  czn25.raw     ; logo de crazynation!
sintab2:      incbin  sintab2        ; tableau de sinus
sintab640:    incbin  sintab64       ; tableau de sinus

lettres:      incbin  let4.rgb      ; lettres!
lettres8x8:   incbin  let8x8.rgb      ; lettres!

                                       ;ON
optstr1       db " UNLIMITED LIVES     "
              db " UNTOUCHABLE         "
              db " FLYING MARIO        "
              db " HI SPEED            "
;              db "                     "
;              db "                     "
;              db "                     "
;              db "                     "
title         db "      MARIO 64 US +4     "
yesstr        db "YES "
nostr         db "NO  "
texte         db "         CRAZY NATION GIVES YOU THE WORLDS FIRST NINTENDO SIXTYFOUR TRAINER EVER\\\\"
              db "                MARIO PLUS FOUR                     CREDITS^  TRAINER INTRO CODE AND FONTS BY TITANIK           "
              db "    CRAZYNATION LOGO BY CURSE                 HARDWARE AND MORAL SUPPORT^ LOOM AND WILDFIRE                        "
              db "    THIS TRAINER WAS CODED HUNDRED PERCENT IN ASSEMBLER` WITHOUT ANY LIBRARY                  "
              db "    GREETINGS GO TO ANTHROX` BLACKBAG` ELMEX` THE SECRET FORCE` DEXTROSE` SNEAKERS\           "
              db "    PERSONNALS TO NAGRA[BB]` RENE[TSF]` SUPERDOC[BB]` SILO[BB]` FRACTAL[BB]` TWK[ATX]` PAN[ATX]` XAD[NFL]` POPCORN[NFL]` MUMBLY[ASGARD]` UXORIOUS` ENNEY` MUTRONIX` SON DOOBIE` KING RASTA` LEM` TRILILI` AND EVERY CODER OUT THERE\\             "
              db "                          SEE YA` IN ANOTHER CZN PRODUCTION\                              "

              db "#    "                    ; fin du texte=# (pour mon scroll)

;
