
   #ifndef MODE7_H
   #define MODE7_H

   #include <mygba.h>

   #define smokeMax              32
   #define heroShootMax          18
   #define badMax                32
   #define badShootMax           24
   #define bonusMax              8

   #define badSlot1Max           18
   #define badSlot2Max           7
   #define badSlot3Max           1  // killer
   #define badSlot4Max           1  // planed
   #define badSlot5Max           1  // killer2
   #define badSlot6Max           1  // jet
   #define badSlot7Max           1  // bigl
   #define badSlot8Max           1  // bigr
   #define badSlot9Max           1  // bigr
   #define badSlot10Max          3  // rot
   #define badSlot11Max          1  // rot

   #define shipSlotMax           9
   #define sateliteSlotMax       1
   #define heroShootSlotMax      1
   #define enemyShootSlotMax     1

   // smokes //
   #define smokeSlotMax          6
   #define explosionSlotMax      8
   #define scrapSlotMax          8

   #define bonusSlotMax          3


   typedef struct {
      u16 mark;
      u16 enemy;
      u16 time;
      u16 ratio;
   } Tevent;


   typedef struct {
      const unsigned char *ts_src;
      u16   size_u16;
      const unsigned char  *mf_src;
   } Tintropic;

      
   typedef struct {
      u32 bkg2X, bkg3X;
      s32 Y, Yold;
      u32 waveCurMark;
      u32 waveMarkPlace;
      u32 waveSlot;
      u32 waveTime;
      u32 waveRatio;
   } Tbkg;

   typedef struct {
      u16 shipSlot[shipSlotMax];
      u16 sateliteSlot[sateliteSlotMax];
      u16 shootSlot[heroShootSlotMax];
      u16 enemyshootSlot[enemyShootSlotMax];
      // bad slots
      u16 badSlot1[badSlot1Max];
      u16 badSlot2[badSlot2Max];
      u16 badSlot3[badSlot3Max];
      u16 badSlot4[badSlot4Max];
      u16 badSlot5[badSlot5Max];
      u16 badSlot6[badSlot6Max];
      u16 badSlot7[badSlot7Max];
      u16 badSlot8[badSlot8Max];
      u16 badSlot9[badSlot9Max];
      u16 badSlot10[badSlot10Max];
      u16 badSlot11[badSlot11Max];
      // smoke //
      u16 smokeSlot[smokeSlotMax];
      u16 explosionSlot[explosionSlotMax];
      u16 scrapSlot[scrapSlotMax];
      u16 bonusSlot[bonusSlotMax];
   } Tfactory;

   typedef struct {
      u8 hitCnt;
      u8 X, Y;
      s8 speedX, speedY;
      u8 speedMax, speedRes;
      s8 frame, frameOld;
      u8 sprite;
      u8 shootPower, shootType, shootDamage;
      u8 sateliteSpriteU, sateliteSpriteD;
      u8 sateliteCnt;
      void (*pheroShootF)(void);
      bool fireB; // if fire b is pressed/hold
      u8 shootCnt;
      u8 introsprite;
      u16 introzoom;
      u8 bonusCnt;
   } Theroship;

   typedef struct {
      bool exist;
      s16 X, Y;
      s8 dX, dY;
      u8 frame;
      u8 sprite;
   } Tshoot;
   
   typedef struct {
      bool exist;
      s16 X, Y;
      s8 dX, dY;
      u8 frame, frameOld, frameNo, framePs, framePsCnt;
      u8 sprite;
      u8 palNo;
      u8 spriteSize, spriteShape;
      u16 *pSpriteSlot;
   } Tsmoke;

   typedef struct TbadTag{
      bool exist;
      bool visible;
      s16 life;
      s16 X, Y;   // pos
      s16 bX, bY; // base pos
      s8 dX, dY;  // delta pos
      u8 frame, frameOld, frameNo, framePs, framePsCnt, frameCnt;
      u8 sprite;
      u8 palNo;  // color mode
      u8 sizeX, sizeY, spriteSize, spriteShape;
      u16 *pSpriteSlot;
      void (*pBadAnimF)(struct TbadTag *obj);
      u8 berserk;
      u8 boss;
   } Tbad;

   typedef struct {
      s16 X, Y;   // pos
      u8 rX, rY;  // +random pos
      s8 dX, dY;  // delta pos
      u8 frameNo, framePs;
      u8 sizeX, sizeY, spriteShape, spriteSize;
      s16 life;
      u8 boss;
      u8 palNo;  // color mode
      u16 *pSpriteSlot;
      void (*pBadAnimF)( Tbad *obj );
   } TbadFactory;

   typedef struct {
      u8 rX, rY;  // +random pos
      s8 dX, dY;
      u8 frameNo, framePs;
      u8 spriteSize, spriteShape;
      u8 palNo;
      u16 *pSpriteSlot;
   } TsmokeFactory;

   extern u8 g_FrameCnt;
   extern Tbkg bkg;
   extern Tfactory factory;
   extern Theroship heroship;
   extern Tshoot heroshoot[];
   extern Tshoot badshoot[];
   extern Tbad bad[];
   extern Tsmoke smoke[];
   extern Tshoot bonus[];
   extern u16 rnd[];

   // background - mode 7 //
   extern void mode7Scroll(void) MEM_FUNC_IN_IWRAM;
   extern void hblGameFunc(void) MEM_FUNC_IN_IWRAM;
   extern void mode7main(void);
   extern void paletteInit(u8 no);

   extern void picShow( u8 pic, u8 bg);
   extern void picInit(u8 no);
   extern void picDeInit(u8 no);

   extern void dummyFunc(void);
   extern inline void mode7ScrollUpdate(void);
   extern void bkgInit(void);
   // global //
   extern void factoryInit(void);
   // hero //
   extern void heroShipInit(void);
   extern void heroShipElapse(void);
   // hero shots //
   extern void heroShootInit(void);
   extern void heroShootElapse(void);
   extern void heroShootSetType( u8 type );
   extern void heroShootPowerUp(void);
   extern void heroHomingCreate( s16 X, s16 Y );
   extern void heroHomingElapse(void);

   extern void badShootElapse(void);
   extern void bonusElapse(void);
   extern bool eventFactory();
   // smoke //
   extern void smokeFactory( s16 X, s16 Y, u8 Slot );
   extern void smokeElapse(void);

   // intro //
   void shipIntroInit(void);
   void shipIntroDeInit(void);
   u8 shipIntroElapse(void);
   void heroShipPreInit(void);

   // bad //
   extern void badFactory( u16 slot );
   extern void badFactoryAt( u16 slot, s16 X, s16 Y );
   extern void badElapse(void);
   extern void badHit( Tbad *pBad );
   extern void badAnimDelta( Tbad *pBad );
   extern void badAnimDeltaAbi( Tbad *pBad );
   extern void badAnimDeltaSlow( Tbad *pBad );
   extern void badAnimDeltaSlowMaker( Tbad *pBad );
   extern void badAnimFloatX( Tbad *pBad );
   extern void badAnimFloatY( Tbad *pBad );
   extern void badAnimFloatYShoot( Tbad *pBad );
   extern void badAnimFlyDown( Tbad *pBad );
   extern void badAnimKiller( Tbad *pBad );
   extern void badAnimKillerShoot( Tbad *pBad );

   #endif

   /* END OF FILE */
   
   
   
   
   
   
   
   
   
   
   
   
