# SEGA Genesis VGM player
# Mic, 2009

#m68k-elf-as -m68000 --register-prefix-optional --bitwise-or -o sega_gcc.o sega_gcc.s
#m68k-elf-as -m68000 --register-prefix-optional --bitwise-or -o charset.o charset.s
#m68k-elf-as -m68000 --register-prefix-optional --bitwise-or -o vgmplay.o vgmplay2.s
#m68k-elf-as -m68000 --register-prefix-optional --bitwise-or -o music.o music.s
#m68k-elf-ld -Tmd.ld --oformat binary -o musicdsk.bin sega_gcc.o charset.o vgmplay.o music.o 


#################################################
#                                               #
#                 RAM DATA                      #
#                                               #
#################################################
.globl music_data
.globl vgmloop

.data
.globl htimer
.globl vtimer
.globl rand_num

vgmloop:
read_cmd:
	move.b		#0x40,0xA10002
	move.w		0xA10002,d0
	and.b		#0x20,d0
	bne		not_pad_c
	move.b		padc,d1
	eor.b		d0,d1
	bne		next_song
not_pad_c:
	move.b		d0,padc

	move.b		(a4)+,d0		/* Read one byte from the VGM data */

	cmp.b		#0x70,d0
	bmi		below_0x70
	cmp.b		#0x80,d0
	bmi		wait_n_short
	
	cmp.b		#0x90,d0
	bmi		pcm_write
	cmp.b 		#0xB0,d0
	bmi		pcm_write_pack1
	cmp.b 		#0xD0,d0
	bmi		pcm_write_pack4
	cmp.b		#0xE0,d0
	beq		pcm_seek
below_0x70:
	cmp.b		#0x4C,d0
	beq		pcm_seek_0
	cmp.b		#0x4D,d0
	beq		pcm_write_pack3
	cmp.b		#0x4E,d0
	beq		pcm_write_pack2
	cmp.b		#0x4F,d0
	beq		pan
	cmp.b		#0x50,d0
	beq		psg_write
	cmp.b		#0x52,d0
	beq		ym2612_write_low
	cmp.b		#0x53,d0
	beq		ym2612_write_high
	cmp.b		#0x61,d0
	beq		wait_n
	cmp.b		#0x62,d0
	beq		wait_735
	cmp.b		#0x63,d0
	beq		wait_882
	cmp.b		#0x66,d0
	beq		data_end
	cmp.b		#0x67,d0
	beq		data_block

	bra		read_cmd	
pan:
	move.b		(a4)+,d0
	bra		read_cmd
psg_write:
	move.b		(a4)+,d0
	move.b		d0,0xc00011
	move.b		d0,d1
	bra		read_cmd
ym2612_write_low:
	move.b		(a4)+,d0
	move.b		d0,0xa04000
	move.b		d0,d2
	nop
	move.b		(a4)+,d1
	move.b		d1,0xa04001
	bra		read_cmd
ym2612_write_high:
	move.b		(a4)+,d0
	move.b		d0,0xa04002
	move.b		d0,d2
	nop
	move.b		(a4)+,d1
	move.b		d1,0xa04003
	bra		read_cmd
wait_n_short:
	and.l		#15,d0
	addq.l		#1,d0
	jsr		delay_n_samples_short
	bra		read_cmd
wait_n:
	move.b		(a4)+,d0
	lsl.w		#8,d0
	move.b		(a4)+,d0
	rol.w		#8,d0
sub.l #24,d5	
	jsr		delay_n_samples2
	bra		read_cmd
wait_735:
	move.w		#735,d0
	jsr		delay_n_samples2
	bra		read_cmd
wait_882:
	move.w		#882,d0
	jsr		delay_n_samples2
	bra		read_cmd
pcm_write:
	move.b		(a3)+,d1
	move.b		#0x2a,0xa04000
	move.b		d1,0xa04001
	sub.l	#136,d5
	and.l		#15,d0
	beq		read_cmd
#	jsr		delay_n_samples_short2
#	bra		read_cmd
lea read_cmd,a1
bra delay_n_samples_short2


pcm_write_pack1:
	move.b		(a4)+,d3
	and.l #0xFF,d3
	addq.l		#1,d3
	move.l		d0,d4
sub.l #80,d5
pcm_write_pack1_loop:
	cmp.l		#0,d3
	beq		read_cmd
	move.b		(a3)+,d1
	move.b		#0x2a,0xa04000
	move.b		d1,0xa04001
	subq.l		#1,d3
	move.l		d4,d0
	sub.l #112,d5
	and.l		#15,d0
	beq		pcm_write_pack1_loop
#	jsr		delay_n_samples_short2
lea pcm_write_pack1_loop,a1
bra delay_n_samples_short2
#	bra		pcm_write_pack1_loop

pcm_write_pack2:
	move.b		(a4)+,d3
	and.l #0xFF,d3	
	add.l		d3,d3
sub.l #80,d5
pcm_write_pack2_loop:
	cmp.l		#0,d3
	beq		read_cmd
	move.b		(a3)+,d1
	move.b		#0x2a,0xa04000
	move.b		d1,0xa04001
	subq.l		#1,d3
	btst		#0,d3
	beq		pcm_write_pack2_shift
	move.b		(a4)+,d4
pcm_write_pack2_shift:
	move.l		d4,d0
	lsr.b		#4,d4
	sub.l #150,d5
	and.l		#15,d0
	beq		pcm_write_pack2_loop
#	jsr		delay_n_samples_short2
lea pcm_write_pack2_loop,a1
bra delay_n_samples_short2
#	bra		pcm_write_pack2_loop

pcm_write_pack3:
	move.b		(a4)+,d4
pcm_write_pack5:
	move.b		(a4)+,d3
	and.l #0xFF,d3
	and.l #0xFF,d4
	addq.l		#1,d4
sub.l #80,d5
pcm_write_pack3_loop:
	cmp.l		#0,d4
	beq		read_cmd
	move.l		d7,a0
	add.l		d3,a0
	move.b		(a0),d0
	move.b		(a3)+,d1
	move.b		#0x2a,0xa04000
	move.b		d1,0xa04001
	subq.l		#1,d4
	add.b		#1,d3
	sub.l #128,d5
	and.l		#15,d0
	beq		pcm_write_pack3_loop
#	jsr		delay_n_samples_short2
lea pcm_write_pack3_loop,a1
bra delay_n_samples_short2
#	bra		pcm_write_pack3_loop

pcm_write_pack4:
	move.l	d0,d4
	and.l	#15,d4
	bra	pcm_write_pack5
	
pcm_seek_0:
	move.l	a6,a3
	bra	read_cmd
	
pcm_seek:
	move.b		(a4)+,d0
	lsl.l		#8,d0
	move.b		(a4)+,d1
	or.b		d1,d0
	lsl.l		#8,d0
	move.b		(a4)+,d1
	or.b		d1,d0
	lsl.l		#8,d0
	move.b		(a4)+,d1
	or.b		d1,d0
	rol.w		#8,d0
	swap.w		d0
	rol.w		#8,d0
	move.l		a6,a3
	add.l		d0,a3
	bra		read_cmd
	
data_block:
	move.b		(a4)+,d0
	cmp.b		#0x66,d0
	bne		read_cmd
	move.b		(a4)+,d0
	cmp.b		#0x01,d0
	beq		read_dict
	cmp.b		#0x00,d0
	bne		read_cmd
	move.b		(a4)+,d0
	lsl.l		#8,d0

	move.b		(a4)+,d1
	or.b		d1,d0
	lsl.l		#8,d0
	move.b		(a4)+,d1
	or.b		d1,d0
	lsl.l		#8,d0
	move.b		(a4)+,d1
	or.b		d1,d0
	rol.w		#8,d0

	swap.w		d0
	rol.w		#8,d0
	move.l		a4,a6
	move.l		a6,a3
	move.l		d0,d6
	add.l		d0,a4
	bra		read_cmd
read_dict:
	move.l		a4,d7
	add.l		#4,d7
	add.l		#260,a4
	bra		read_cmd
	
data_end:
	move.l		a5,a4
	bra		read_cmd

next_song:
	move.b		#0,padc
	move.l		currSong,d0
#	move.l		_num_songs,d1
move.l _bin_size,d1
	addq.l		#1,d0
	cmp.l		d1,d0
	bmi		songNumOk
	move.l		#0,d0
songNumOk:
	move.l		d0,currSong
	jmp		new_song
	

delay_n_samples_short2:
	subq.l	#1,d0
	add.w	d0,d0
	add.w	d0,d0
	move.l	#shortwaits2,a0
	add.l	d0,a0
	add.l	(a0),d5
	sub.l 	#56,d5
	delay_loop2:
	sub.l	#34,d5  
	bpl	delay_loop2
#	rts
	jmp	(a1)

delay_n_samples_short3:
	subq.l	#1,d0
	add.w	d0,d0
	add.w	d0,d0
	move.l	#shortwaits,a0
	add.l	d0,a0
	add.l	(a0),d5
	sub.l 	#56,d5
	delay_loop3:
	sub.l	#34,d5  
	bpl	delay_loop3
#	rts
	jmp	(a1)
	
delay_n_samples_short:
#	move.l		d0,d1
#	lsl.w		#4,d0
#	add.w		d1,d0
#	add.w		d1,d0
#	add.w		d1,d0
#	lsr.w		#1,d0
#	lsr.w		d7,d0
#	sub.l		#4,d0
#	bmi		delay_done
#	beq		delay_done

#move.l d0,d1
#lsl.w #4,d0
#add.w d1,d0
#add.w d1,d0
#add.w d1,d0
#lsr.w #1,d0
#sub.w #24,d0
#bmi		delay_done
#beq		delay_done

lsl.l #2,d0
move.l d0,d1	/* d1 = n*4 */
add.l d0,d0	/* d0 = n*8 */
add.l d0,d1	/* d1 = n*12 */
lsl.l #2,d0	/* d0 = n*32 */
add.l d0,d1	/* d1 = n*44 */
lsl.l #2,d0	/* d0 = n*128 */
add.l d0,d1	/* d1 = n*172 */
lsr.l #7,d0	
lsr.l #2,d0	/* d0 = n/4 */
add.l d0,d1	/* d1 = n*172.25 */
add.l d1,d5
sub.l #112,d5
	delay_loop:
		sub.l	#29,d5  /* 26,52 */
		bpl	delay_loop
	rts
	

	
/* Delay n/44100 s using YM2612 Timer A */
delay_n_samples2:
	cmp.w		#0,d0
	beq		delay_done
	
	/* Multiply by 1.2 (approximated as 77/64) */
	move.l		d0,d1
	move.l		d0,d2
	lsl.l		#6,d0
	lsl.l		#4,d1
	sub.l		d2,d1
	sub.l		d2,d1
	sub.l		d2,d1
#lsl.l #3,d1
#add.l d2,d1
#add.l d2,d1
#add.l d2,d1
	add.l		d1,d0
	lsr.l		#6,d0
	move.l		d0,d2
	
	delay_again:
	move.l		d2,d0
	and.l		#0xFFF00,d0
	beq		low_left
	move.l		#256,d0
	bra		okdelay
	low_left:
	move.l		d2,d0
	and.w		#255,d0
	okdelay:
	eor.w		#0x3ff,d0
	addq.l		#1,d0
	move.l		d0,d1
	lsr		#2,d0
	and.w		#3,d1
	move.b		#0x24,0xa04000
	nop
	nop
	move.b		d0,0xa04001
	nop
	move.b		#0x25,0xa04000
	nop
	nop
	move.b		d1,0xa04001
	nop
	nop
	move.b		#0x27,0xa04000
	nop
	nop
	move.b		#0x15,0xa04001
	nop
	check_timer:
		move.b	0xa04000,d0
		and.b	#1,d0
		beq	check_timer
	sub.l		#256,d2
	bpl		delay_again
	delay_done:
	rts
vgmloop_end:

.bss
htimer:		.long 0
vtimer:		.long 0
rand_num:	.long 0
temp:		.long 0
vol0:		.byte 0
vol1:		.byte 0
vol2:		.byte 0
vol3:		.byte 0
vol4:		.byte 0
vol5:		.byte 0
vol6:		.byte 0
vol7:		.byte 0
vol8:		.byte 0
vol9:		.byte 0
vdpstatus:	.byte 0
padc:		.byte 0
counter1:	.long 0
counter2:	.long 0
loopPoint:	.long 0
currSong:	.long 0
.align 2
songPtr:	.long 0


.text
.globl main


.include "genvdp.inc"


.macro PUTSXY immstr x y
	lea	1$,a1
	move.l	\x,d0
	move.l	\y,d1
	move.l	#256,d2
	jsr	puts
	bra 2$
1$:	.ascii "\immstr"
	dc.b 0
	.even
2$:
.endm


##################################################
#                                                #
#               MAIN PROGRAM                     #
#                                                #
##################################################
 
main:
	
	/* Initialize VDP */
	jsr 		init_gfx

	/* Wait a few frames */	
	jsr		wait_vsync
	jsr		wait_vsync
	jsr		wait_vsync
	
	/* Load font tiles */
	move.l		#0x0000,a3
	move.l 		#charset,a4
	move.l		#64,d4
	jsr		load_tiles
	move.l		#0x0800,a3
	move.l 		#(charset+0x0c00),a4
	move.l		#32,d4
	jsr		load_tiles

	/* Set the first two colors of palette 0 */
	move.l		#0x0000,a3
	move.l 		#palette,a4
	move.l		#2,d4
	jsr		load_colors

	jsr		wait_vsync

	/* Clear map A */
	move.l		#0xe000,a0
	moveq.l		#0,d0
	jsr		clear_map
	
	jsr		wait_vsync

	/* Clear map B */
	move.l		#0xc000,a0
	moveq.l		#0,d0
	jsr		clear_map
	
	jsr		wait_vsync

	/* Print some text on Map A */
	PUTSXY		"Genesis VGM Player",#11,#2
	
#	PUTSXY		"Game:",#2,#5
#	PUTSXY		"Song:",#2,#6
#	PUTSXY		"Author:",#2,#7
	
	/* Clear sprite data */
	move.l 		#GFXCNTL,a3
	VRAM_ADDR 	d0,0xfc00
	move.l 		d0,(a3)
	move.l 		#GFXDATA,a3
	moveq.l		#0,d0	
	move.l		#19,d1
clear_sprites:
	move.w		d0,(a3) /*(a5)+*/
	dbra 		d1,clear_sprites

	/* Clear scroll data */
	move.l 		#GFXCNTL,a3
	VRAM_ADDR 	d0,0x6000
	move.l 		d0,(a3)
	move.l 		#GFXDATA,a3
	moveq.l		#0,d0	
	move.l		#239,d1
clear_scroll:
	move.w		d0,(a3) 
	dbra 		d1,clear_scroll
	
	move.l		#vol0,a0
	move.b		#15,(a0)+
	move.b		#15,(a0)+
	move.b		#15,(a0)+
	move.b		#15,(a0)+
	move.b		#15,(a0)+
	move.b		#15,(a0)+
	move.b		#15,(a0)+
	move.b		#15,(a0)+
	move.b		#15,(a0)+
	move.b		#15,(a0)+
	
	move.b		#0,vdpstatus
	
	move.l		#0,currSong

	move.b		#0x20,padc

	move.l		#_data_lma,a0
	move.l		#vgmloop_end-vgmloop,d1
	move.l		#vgmloop,a2
copy_to_ram:
	move.b		(a0)+,d0
	move.b		d0,(a2)
	add.l		#1,a2
	subq.l		#1,d1
	bne		copy_to_ram
	
new_song:
	/* Turn all YM2612 channels off	*/
	move.b		#0xB4,0xa04000
	move.b		#0,0xa04001
	move.b		#0xB5,0xa04000
	move.b		#0,0xa04001
	move.b		#0xB6,0xa04000
	move.b		#0,0xa04001
	move.b		#0xB4,0xa04002
	move.b		#0,0xa04003
	move.b		#0xB5,0xa04002
	move.b		#0,0xa04003
	move.b		#0xB6,0xa04002
	move.b		#0,0xa04003
	
	jsr		wait_vsync
	move.l		#0xe000,a0
	moveq.l		#0,d0
	jsr		clear_map
	PUTSXY		"Genesis VGM Player",#11,#2
	PUTSXY		"C = Next song",#2,#9
	PUTSXY		"Game:",#2,#5
	PUTSXY		"Song:",#2,#6
	PUTSXY		"Author:",#2,#7

	move.l		currSong,d0
#	move.l		#_song_table,a1
move.l #_bin_size+4,a1
	lsl.l		#2,d0
	add.l		d0,a1
	move.l		(a1),a0
	move.l		a0,songPtr
	move.l		a0,a1
	add.l		#32,a1
	move.l		0x14(a0),d0
	cmp.l		#0,d0
	beq		no_gd3
	rol.w		#8,d0
	swap.w		d0
	rol.w		#8,d0
	add.l		d0,a1
	move.l		a1,a2
	

	/* Show song name */

	move.l		#10,d0
	move.l		#6,d1
	move.l		#28,d2
	jsr		puts_wide

	move.l		#1,d1	
__1:
	move.b		(a2)+,d0
	addq.l		#1,a2
	cmp.b		#0,d0
	bne		__1
	dbra		d1,__1

	/* Show game title */
	move.l		a2,a1
	move.l		#10,d0
	move.l		#5,d1
	move.l		#28,d2
	jsr		puts_wide

	move.l		#3,d1	
__2:
	move.b		(a2)+,d0
	addq.l		#1,a2
	cmp.b		#0,d0
	bne		__2
	dbra		d1,__2

	/* Show author name */
	move.l		a2,a1
	move.l		#10,d0
	move.l		#7,d1
	move.l		#28,d2
	jsr		puts_wide
	
	bra		get_vgm_loop

no_gd3:
	PUTSXY		"Unknown",10,5
	PUTSXY		"Unknown",10,6
	PUTSXY		"Unknown",10,7
	
get_vgm_loop:
	moveq.l		#0,d0
	move.l 		0x1c(a0),d0		/* Get loop offset */
	cmp.w 		#0,d0
	beq 		no_loop
	rol.w		#8,d0

	swap.w		d0
	rol.w 		#8,d0			/* Convert to big-endian */
	add.w 		#0x1c,d0
	bra 		got_loop
	no_loop:
	move.w 		#0x40,d0		/* No loop offset - use the start of the song */
	got_loop:
	move.l		songPtr,a5
	add.l		d0,a5

	move.l		songPtr,a4
	add.l		#0x40,a4

	/* Allow the 68k to access the FM chip */
        move.w  	#0x100,0xa11100
	move.w  	#0x100,0xa11200

	move.l		#0,d5
	
	move.l		songPtr,a0
	add.l		#0x2c,a0
	move.l		(a0),d7
	rol.w		#8,d7
	swap.w		d7
	rol.w		#8,d7
	cmp.l		#0x00720000,d7
	bmi		normal_clock
	move.l		#1,d7
	bra		vgmloop2
	normal_clock:
	move.l		#0,d7
	bra		vgmloop2
	
vgmloop2:
	move.l		#vgmloop,a0
	jmp		(a0)
	
/* Main loop */



	
#################################################
#                                               #
#         Initialize VDP registers              #
#                                               #
#################################################

init_gfx:
	move.l 		#GFXCNTL,a3
	write_vdp_reg 	0,(VDP0_E_HBI + VDP0_E_DISPLAY + VDP0_PLTT_FULL)
	write_vdp_reg 	1,(VDP1_E_VBI + VDP1_E_DISPLAY + VDP1_E_DMA + VDP1_PAL + VDP1_RESERVED)
	write_vdp_reg 	2,(0xe000 >> 10)	/* Screen map A adress */
	write_vdp_reg 	3,(0xc000 >> 10)	/* Window address */
	write_vdp_reg 	4,(0xc000 >> 13)	/* Screen map B address */
	write_vdp_reg 	5,(0xfc00 >>  9)	/* Sprite address */
	write_vdp_reg 	6,0	
	write_vdp_reg	7,0			/* Border color */
	write_vdp_reg	8,1			/* Unused (?) */
	write_vdp_reg	9,1			/* Unused (?) */
	write_vdp_reg	10,1			/* Lines per hblank interrupt */
	write_vdp_reg	11,4			/* 2-cell vertical scrolling */
	write_vdp_reg	12,(VDP12_SCREEN_V224 + VDP12_SCREEN_H320 + VDP12_PROGRESSIVE)
	write_vdp_reg	13,(0x6000 >> 10)	/* Horizontal scroll address */
	write_vdp_reg	15,2
	write_vdp_reg	16,(VDP16_MAP_V32 + VDP16_MAP_H64)
	write_vdp_reg	17,0
	write_vdp_reg	18,0xff
	rts



#################################################
#                                               #
#        Put a string on screen map A           #
#                                               #
# Parameters:                                   #
#  a1: String pointer (ASCIIZ)                  # 
#  d0: X coordinate                             #
#  d1: Y coordinate                             #
#  d2: Max chars                                #
#                                               #
#################################################

puts:
	lsl.l		#7,d1
	add.l		d0,d1
	add.l		d0,d1
	add.l		#0xe000,d1
	VRAM_ADDR_var	d0,d1
	move.l 		#GFXCNTL,a4
	move.l		d0,(a4)
	move.l 		#GFXDATA,a4
	moveq.l		#0,d0
_puts:
	move.b		(a1)+,d0
	beq		_puts_done
	sub.b		#32,d0
	move.w		d0,(a4)
	subq.l		#1,d2
	beq		_puts_done
	bra		_puts
_puts_done:
	rts

	

puts_wide:
	lsl.l		#7,d1
	add.l		d0,d1
	add.l		d0,d1
	add.l		#0xe000,d1
	VRAM_ADDR_var	d0,d1
	move.l 		#GFXCNTL,a4
	move.l		d0,(a4)
	move.l 		#GFXDATA,a4
	moveq.l		#0,d0
_puts_wide:
	move.b		(a1)+,d0
	beq		_puts_wide_done
	sub.b		#32,d0
	move.w		d0,(a4)
	addq.l		#1,a1
	subq.l		#1,d2
	beq		_puts_wide_done
	bra		_puts_wide
_puts_wide_done:
	rts
	
#################################################
#                                               #
#        Load tile data from ROM                #
#                                               #
# Parameters:                                   #
#  a3: VRAM base                                # 
#  a4: pattern address                          #
#  d4: number of tiles to load                  #
#                                               #
#################################################

load_tiles:
	move.l 		#GFXCNTL,a2
	VRAM_ADDR_var 	d0,a3
	move.l 		d0,(a2)
	lsl		#3,d4
	
	move.l 		#GFXDATA,a3
	subq.w 		#1,d4		/* DBRA stops at -1, so subtract 1 from the counter first */
_copy_tile_data:
	move.l 		(a4)+,(a3)
	dbra 		d4,_copy_tile_data
	rts


#################################################
#                                               #
#        Clear one of the screen maps           #
#                                               #
# Parameters:                                   #
#  a0: Map address                              # 
#  d0: Data to write to each map entry          #
#                                               #
#################################################

clear_map:
	move.l 		#GFXCNTL,a4
	VRAM_ADDR_var	d1,a0
	move.l 		d1,(a4)
	move.l 		#GFXDATA,a3
	move.w		#1023,d1	/* Loop counter */
_clear_map_loop:
	move.w		d0,(a3)
	move.w		d0,(a3)
	dbra		d1,_clear_map_loop
	rts
	

#################################################
#                                               #
#        Load color data from ROM               #
#                                               #
# Parameters:                                   #
#  a3: CRAM base                                # 
#  a4: color list address                       #
#  d4: number of colors to load                 #
#                                               #
#################################################

load_colors:
	move.l 		#GFXCNTL,a2
	CRAM_ADDR_var 	d0,a3
	move.l 		d0,(a2)

	move.l 		#GFXDATA,a3
	subq.w		#1,d4
_copy_color_data:
	move.w		(a4)+,(a3)
	dbra		d4,_copy_color_data

	rts


	
#################################################
#                                               #
#       Wait for next VBlank interrupt          #
#                                               #
#################################################

wait_vsync:
	movea.l		#vtimer,a0
	move.l		(a0),a1
_wait_change:
	cmp.l		(a0),a1
	beq		_wait_change
	rts


#################################################
#                                               #
#                 ROM DATA                      #
#                                               #
#################################################

.align 4
shortwaits:
	dc.l 172,345,517,689,862,1034,1206,1379,1551,1723,1896,2068,2240,2413,2585,2757
shortwaits2:
	dc.l 120,296,517,689,862,1034,1206,1379,1551,1723,1896,2068,2240,2413,2585,2757,0

palette:
	dc.w 0x0000,0x0cc0	

.align 2
music_data:

.end






