	/*********************************************/
	/*	    " ULOM VA DE PASEO "             */
	/*                                           */
	/* Por: Juan Manuel Snchez Cervantes.       */
	/*                                           */
	/* Programa demostracin de las aplicaciones */
	/* bsicas de los mdulos:  .pantalla.cpp    */
	/*			    .imagen.cpp      */
	/*			    .video.cpp       */
	/*			    .memoria.cpp     */
	/*********************************************/

#include "pantalla.h"
#include "video.h"
#include "imagen.h"
#include "memoria.h"

pantalla320200256 Pantalla;  //Pantalla virtual.
paleta256 Paleta;	     //Paleta de colores.
multiImagen256 Ulom;         //"Ulom" ser la secuencia de imagenes de
			     // nuestro cerdo. (ver mdulo "imagen.h").

/**************************************************************************/
// Este simple procedimiento ilustra una pequea animacin en pantalla.
// Partiremos de un objeto 'multiImagen256' que no es ms que una secuencia
// de imgenes, en este caso 17.
// Las 8 primeras imagenes (bloques grficos) son las posiciones de Ulom
// andando en direccin izquierda-derecha (0-7 inclusives).
// Las 8 siguientes (8-15) son las posiciones de Ulom en sentido contrario.
// La imagen 16 es una foto de Ulom que ilustrar el fondo de la animacin.
/**************************************************************************/
void Ulom_Anda(void){
 int dx, dy;   //tamao de la imagen a dibujar.
 int i,j, incr;  //contador de la posicin de Ulom andando.
 int sig=2; //positivo

 i=incr=0;
 j=84;
 while(inportb(96)!=1){
   Pantalla.cls(0);        //borrar pantalla completa.

   Ulom.darDimensiones(16, &dx, &dy);                //dibujar foto de Ulom.
   Pantalla.dImagen(80,45,dx,dy,Ulom.devolver(16));  // (bloque n 16)

   Ulom.darDimensiones(i+incr, &dx, &dy);            //dibujar Ulom andando.
   Pantalla.dImagenMasc(j+=sig,98,dx,dy,Ulom.devolver(i+incr));

   Pantalla.volcar();    //volcar la pantalla virtual a Video RAM.
   delay(80);            //variar el retardo segn la capacidad de PC.


   i = (i+1)%8;
   if(j==220 || j==60) {
	incr = (incr+8)%16;
	sig*=-1;
   }
 };
};

/**************************************************************************/
/* M A I N
/**************************************************************************/
void main(void){

  Modo320200256();		   //inicializar modo 320x200 a 256 colores.

  Paleta.cargar("paleta.pal",0);
  Paleta.actualizarDAC();	   //el DAC se actualiza con nuestra paleta.


  Pantalla.inicializar();          //reservar memoria para la pantalla.
  Pantalla.cls(0);		   //borrar la pantalla con el color 0.

  Ulom.cargarMig("ulom.mig");

  Ulom_Anda();                     //Procedimiento principal del programa.

  ModoTexto();
};