/***************************************************************************/
/* Ŀ */
/*  NOMBRE DEL FICHERO: PANTALLA.CPP                                     */
/*  DESCRIPCION:        Implementacin de mtodos para las clases de     */
/*                      pantallas grficas virtuales.                    */
/*  CONTENIDO:          .Definicin de variables locales al mdulo.      */
/*                      .metodos de la clase pantalla640400256.          */
/*                      .metodos de la clase pantalla640480256.          */
/*                                                                       */
/*  LLAMADO POR:        ---                                              */
/*  LLAMA A:            PANTALLA.H: Fichero cabecera. Definiciones.      */
/*  PROGRAMADO POR:     Juan Manuel Snchez Cervantes.                   */
/*  FECHA:              07/03/1995                                       */
/*  ACTUALIZACIONES:    ---                                              */
/*  */
/***************************************************************************/
#include "pantalla.h"

/*** DEFINICION DE VARIABLES LOCALES AL MODULO *****************************/
/***************************************************************************/
extern int desplazaV;      //Desplazamiento ventana de acceso VESA.
			   //(variable definida en 'VIDEO.CPP').

/***************************************************************************/
/*   CLASE PANTALLA320200256: IMPLEMENTACION DE METODOS                    */
/***************************************************************************/
pantalla320200256::pantalla320200256(void){
   B = NULL;
};
/***************************************************************************/
char pantalla320200256::inicializar(void){
   int i;
   char far *result;

   B = result = new char[64000];

   if(result) return(1);
   else return(0);
};
/***************************************************************************/
void pantalla320200256::cls(char color){
   int i;
   char far *b;

   b = B;
   for(i=0; i<4; i++){
      asm { mov ah,color
	    mov al,color
	    les di, b
	    mov cx,32000
	    rep stosw
      };
   };
};
/***************************************************************************/
void pantalla320200256::
     dImagen(int x,int y,int tx,int ty,imagen256 *imag){
   int i;
   unsigned int offset;
   char far *b;
   char far *filao, *filad;

   if(x<0) x=0;                      //"Recortado" con la ventana grfica.
   if(y<0) y=0;
   if((x+tx)>319) tx=(320-x);
   if((y+ty)>199) ty=(200-y);

   if((tx>0)&(ty>0)){
      offset=(320*y)+x;
      b = B;

      for(i=0; i<ty; i++){           //Bucle de dibujo de la imagen.
	 filao=imag->imagen[i];
	 filad=b+offset;
	 asm{ les di, filad
	      lds si, filao
	      mov cx,tx
	      rep movsb
	 };
	 offset=(offset+320);
      };
   };
};
/***************************************************************************/
void pantalla320200256::
     cImagen(int x,int y,int tx,int ty,imagen256 *imag){
   int i;
   unsigned int offset;
   char far *b;
   char far *filao, *filad;

   if(x<0) x=0;                      //"Recortado" con la ventana grfica.
   if(y<0) y=0;
   if((x+tx)>319) tx=(320-x);
   if((y+ty)>199) ty=(200-y);

   if((tx>0)&(ty>0)){
      offset=(320*y)+x;
      b = B;

      for(i=0; i<ty; i++){           //Bucle de captura de la imagen.
	 filao=b+offset;
	 filad=imag->imagen[i];
	 asm{ les di, filad
	      lds si, filao
	      mov cx,tx
	      rep movsb
	 };
	 offset=(offset+320);
      };
   };
};
/***************************************************************************/
void pantalla320200256::
     dImagenMasc(int x,int y,int tx,int ty,imagen256 *imag){
   int i;
   unsigned int offset;
   char far *b;
   char far *filao, *filad;

   if(x<0) x=0;                      //"Recortado" con al ventana grfica.
   if(y<0) y=0;
   if((x+tx)>319) tx=(320-x);
   if((y+ty)>199) ty=(200-y);

   if((tx>0)&(ty>0)){
      offset=(320*y)+x;
      b = B;

      for(i=0; i<ty; i++){           //Bucle de dibujo de la imagen.
	 filao=imag->imagen[i];
	 filad=b+offset;
	       asm{ push ds
		    push es
		    les di, filad     // ES:DI contiene Destino
		    lds si, filao     // DS:SI contiene Origen
		    mov cx, tx        // CX contiene tx.
	       }
	 bucl: asm{ cmp byte ptr ds:[si], 0    // Comparar el byte con 0
		    jne mover         // Si no son iguales lo transfiero.
		    inc di            // Si no, incrementa DI.
		    inc si            //        incrementa SI
		    jmp fin           // Biburca a fin.
	       }
	 mover:asm{ movsb             // Mueve un elemento de SI a DI.
	       }
	 fin:  asm{ loop bucl         // CX=CX-1 y biburca si CX!=0.
		    pop es
		    pop ds
	       }
	 offset=(offset+320);
      };
   };
};
/***************************************************************************/
void pantalla320200256::dPunto(int x,int y,char color){
   unsigned int offset;     //Offset dentro del buffer.

   if(x<0) goto FIN;
   if(x>319) goto FIN;
   if(y<0) goto FIN;
   if(y>199) goto FIN;

   offset=(320*y)+x;

   B[offset]=color;
   FIN:
};
/***************************************************************************/
void pantalla320200256::cPunto(int x,int y,char *color){
   unsigned int offset;     //Offset dentro del buffer.

   if(x<0) goto FIN;
   if(x>319) goto FIN;
   if(y<0) goto FIN;
   if(y>199) goto FIN;

   offset=(320*y)+x;

   *color=B[offset];
   FIN:
};
/***************************************************************************/
void pantalla320200256::dLinea(int x1,int y1,int x2,int y2, char color){
   int i, temp;            //Variables para el algoritmo de BRESENHAM.
   int incX, incY, s1, s2;
   int intercambio, error;
   unsigned int offset;    //Offset dentro del buffer (para dibujo del punto).

   if(x1<0) goto FIN;   if(y1<0) goto FIN;
   if(x2<0) goto FIN;   if(y2<0) goto FIN;
   if(x1>319) goto FIN; if(y1>199) goto FIN;
   if(x2>319) goto FIN; if(y2>199) goto FIN;

   incX = abs(x2-x1);          //Algoritmo de BRESENHAM.
   incY = abs(y2-y1);
   if(x1<x2) s1 = 1;
   else s1 = -1;
   if(y1<y2) s2 = 1;
   else s2 = -1;

   if(incY>incX){ temp=incX; incX=incY; incY=temp; intercambio=1; }
   else intercambio=0;

   error = (2*incY)-incX;
   for(i=1; i<=incX; i++){
      offset=(320*y1)+x1;
      B[offset]=color;

      while(error>=0){
	 if(intercambio) x1=x1+s1;
	 else y1=y1+s2;
	 error=error-(2*incX);
      };
      if(intercambio) y1=y1+s2;
      else x1=x1+s1;
      error=error+(2*incY);
   };
   FIN:
};
/***************************************************************************/
void pantalla320200256::
     dRectangulo(int x1,int y1,int x2,int y2, char color, char solido){
   int i, j, aux;
   unsigned int offset;

   if(x1<0) goto FIN;   if(y1<0) goto FIN;
   if(x2<0) goto FIN;   if(y2<0) goto FIN;
   if(x1>319) goto FIN; if(y1>199) goto FIN;
   if(x2>319) goto FIN; if(y2>199) goto FIN;

   if(x2<x1){ aux=x2; x2=x1; x1=aux; };   //Intercambio de coordenadas.
   if(y2<y1){ aux=y2; y2=y1; y1=aux; };

   offset=(320*y1);

   for(i=x1; i<=x2; i++) B[offset+i]=color;    //Dibujo linea superior.

   for(i=y1+1; i<=y2; i++){
      offset=(offset+320);
      if(!solido){                             //Dibujo lineas laterales o...
	 B[offset+x1]=color;
	 B[offset+x2]=color;
      }
      else
	 if(solido) for(j=x1; j<=x2; j++) B[offset+j]=color;     //..Relleno.
   };

   for(i=x1; i<=x2; i++) B[offset+i]=color;    //Dibujo linea inferior.
   FIN:
};
/***************************************************************************/
void pantalla320200256::volcar(void){
   char far *b;

   b=B;
      asm{ push ds
	   push es
	   cld

	   mov dx,0a000h    //VOLCADO DE b A RAM.
	   mov es,dx
	   xor di,di
	   lds si, b
	   mov cx,32000
	   rep movsw

	   pop es
	   pop ds
      };
};
/***************************************************************************/
void pantalla320200256::liberarRAM(void){
   delete B;
};
/***************************************************************************/
pantalla320200256::~pantalla320200256(void){
   delete B;
};


/***************************************************************************/
/*   CLASE PANTALLA640400256: IMPLEMENTACION DE METODOS                    */
/***************************************************************************/
pantalla640400256::pantalla640400256(void){
   B = NULL;
};
/***************************************************************************/
char pantalla640400256::inicializar(void){
   int i;
   char far *result;

   B = new char* [4];
   for(i=0; i<4; i++) B[i] = result = new char[64000];

   if(result) return(1);
   else return(0);
};
/***************************************************************************/
void pantalla640400256::cls(char color){
   char far *b;
   int i;

   for(i=0; i<4; i++){
      b = B[i];
      asm { mov ah,color
	    mov al,color
	    les di, b
	    mov cx,32000
	    rep stosw
      };
   };
};
/***************************************************************************/
void pantalla640400256::
     dImagen(int x,int y,int tx,int ty,imagen256 *imag){
   int i;
   char nb;
   unsigned int offset;
   char far *b;
   char far *filao, *filad;

   if(x<0) x=0;                      //"Recortado" con la ventana grfica.
   if(y<0) y=0;
   if((x+tx)>639) tx=(640-x);
   if((y+ty)>399) ty=(400-y);

   if((tx>0)&(ty>0)){
      nb=y/100;                      //Inicializacin nmero buffer y offset.
      offset=(640*(y-(100*nb)))+x;
      b=B[nb];

      for(i=0; i<ty; i++){           //Bucle de dibujo de la imagen.
	 filao=imag->imagen[i];
	 filad=b+offset;
	 asm{ les di, filad
	      lds si, filao
	      mov cx,tx
	      rep movsb
	 };
	 offset=(offset+640);
	 if(offset>63999){ offset=offset-64000;
			   b=B[++nb];
	 };
      };
   };
};
/***************************************************************************/
void pantalla640400256::
     cImagen(int x,int y,int tx,int ty,imagen256 *imag){
   int i;
   char nb;
   unsigned int offset;
   char far *b;
   char far *filao, *filad;

   if(x<0) x=0;                      //"Recortado" con la ventana grfica.
   if(y<0) y=0;
   if((x+tx)>639) tx=(640-x);
   if((y+ty)>399) ty=(400-y);

   if((tx>0)&(ty>0)){
      nb=y/100;                      //Inicializacin nmero buffer y offset.
      offset=(640*(y-(100*nb)))+x;
      b=B[nb];

      for(i=0; i<ty; i++){           //Bucle de captura de la imagen.
	 filao=b+offset;
	 filad=imag->imagen[i];
	 asm{ les di, filad
	      lds si, filao
	      mov cx,tx
	      rep movsb
	 };
	 offset=(offset+640);
	 if(offset>63999){ offset=offset-64000;
			   b=B[++nb];
	 };
      };
   };
};
/***************************************************************************/
void pantalla640400256::
     dImagenMasc(int x,int y,int tx,int ty,imagen256 *imag){
   int i;
   char nb;
   unsigned int offset;
   char far *b;
   char far *filao, *filad;

   if(x<0) x=0;                      //"Recortado" con al ventana grfica.
   if(y<0) y=0;
   if((x+tx)>639) tx=(640-x);
   if((y+ty)>399) ty=(400-y);

   if((tx>0)&(ty>0)){
      nb=y/100;                      //Inicializacin nmero buffer y offset.
      offset=(640*(y-(100*nb)))+x;
      b=B[nb];

      for(i=0; i<ty; i++){           //Bucle de dibujo de la imagen.
	 filao=imag->imagen[i];
	 filad=b+offset;
	       asm{ push ds
		    push es
		    les di, filad     // ES:DI contiene Destino
		    lds si, filao     // DS:SI contiene Origen
		    mov cx, tx        // CX contiene tx.
	       }
	 bucl: asm{ cmp byte ptr ds:[si], 0    // Comparar el byte con 0
		    jne mover         // Si no son iguales lo transfiero.
		    inc di            // Si no, incrementa DI.
		    inc si            //        incrementa SI
		    jmp fin           // Biburca a fin.
	       }
	 mover:asm{ movsb             // Mueve un elemento de SI a DI.
	       }
	 fin:  asm{ loop bucl         // CX=CX-1 y biburca si CX!=0.
		    pop es
		    pop ds
	       }
	 offset=(offset+640);
	 if(offset>63999){ offset=offset-64000;
			   b=B[++nb];
	 };
      };
   };
};
/***************************************************************************/
void pantalla640400256::dPunto(int x,int y,char color){
   char nb;                 //Nmero buffer actual.
   unsigned int offset;     //Offset dentro del buffer.
   char far *b;             //Puntero al buffer actual.

   if(x<0) goto FIN;
   if(x>639) goto FIN;
   if(y<0) goto FIN;
   if(y>399) goto FIN;

   nb=y/100;                          //Clculo del buffer y offset inicial.
   offset=(640*(y-(100*nb)))+x;
   b=B[nb];

   b[offset]=color;
   FIN:
};
/***************************************************************************/
void pantalla640400256::cPunto(int x,int y,char *color){
   char nb;                 //Nmero buffer actual.
   unsigned int offset;     //Offset dentro del buffer.
   char far *b;             //Puntero al buffer actual.

   if(x<0) goto FIN;
   if(x>639) goto FIN;
   if(y<0) goto FIN;
   if(y>399) goto FIN;

   nb=y/100;                          //Clculo del buffer y offset inicial.
   offset=(640*(y-(100*nb)))+x;
   b=B[nb];

   *color=b[offset];
   FIN:
};
/***************************************************************************/
void pantalla640400256::dLinea(int x1,int y1,int x2,int y2, char color){
   int i, temp;            //Variables para el algoritmo de BRESENHAM.
   int incX, incY, s1, s2;
   int intercambio, error;
   char nb;                //Nmero buffer actual (para dibujo del punto).
   unsigned int offset;    //Offset dentro del buffer (para dibujo del punto).
   char far *b;            //Puntero al buffer actual (para dibujo del punto).

   if(x1<0) goto FIN;   if(y1<0) goto FIN;
   if(x2<0) goto FIN;   if(y2<0) goto FIN;
   if(x1>639) goto FIN; if(y1>399) goto FIN;
   if(x2>639) goto FIN; if(y2>399) goto FIN;

   incX = abs(x2-x1);          //Algoritmo de BRESENHAM.
   incY = abs(y2-y1);
   if(x1<x2) s1 = 1;
   else s1 = -1;
   if(y1<y2) s2 = 1;
   else s2 = -1;

   if(incY>incX){ temp=incX; incX=incY; incY=temp; intercambio=1; }
   else intercambio=0;

   error = (2*incY)-incX;
   for(i=1; i<=incX; i++){
      nb=y1/100;                      //Dibujo del punto (x1,y1).
      offset=(640*(y1-(100*nb)))+x1;
      b=B[nb];
      b[offset]=color;

      while(error>=0){
	 if(intercambio) x1=x1+s1;
	 else y1=y1+s2;
	 error=error-(2*incX);
      };
      if(intercambio) y1=y1+s2;
      else x1=x1+s1;
      error=error+(2*incY);
   };
   FIN:
};
/***************************************************************************/
void pantalla640400256::
     dRectangulo(int x1,int y1,int x2,int y2, char color, char solido){
   int i, j, aux;
   char nb;
   unsigned int offset;
   char far *b;

   if(x1<0) goto FIN;   if(y1<0) goto FIN;
   if(x2<0) goto FIN;   if(y2<0) goto FIN;
   if(x1>639) goto FIN; if(y1>399) goto FIN;
   if(x2>639) goto FIN; if(y2>399) goto FIN;

   if(x2<x1){ aux=x2; x2=x1; x1=aux; };   //Intercambio de coordenadas.
   if(y2<y1){ aux=y2; y2=y1; y1=aux; };

   nb=y1/100;                          //Clculo del buffer y offset inicial.
   offset=(640*(y1-(100*nb)));
   b=B[nb];

   for(i=x1; i<=x2; i++) b[offset+i]=color;    //Dibujo linea superior.

   for(i=y1+1; i<=y2; i++){
      offset=(offset+640);
      if(offset>63999){ offset=offset-64000; b=B[++nb]; };
      if(!solido){                             //Dibujo lineas laterales o...
	 b[offset+x1]=color;
	 b[offset+x2]=color;
      }
      else
	 if(solido) for(j=x1; j<=x2; j++) b[offset+j]=color;     //..Relleno.
   };

   for(i=x1; i<=x2; i++) b[offset+i]=color;    //Dibujo linea inferior.
   FIN:
};
/***************************************************************************/
void pantalla640400256::volcar(void){
   char far *b0, *b1, *b2, *b3;

   b0=B[0]; b1=B[1]; b2=B[2]; b3=B[3];
      asm{ push ds
	   push es
	   cld

	   mov AH, 4Fh      //DESPLAZAMIENTO DE LA VENTANA DE ACCESO A VIDEO.
	   mov AL, 05h      //EN CERO UNIDADES. VENTANA 0.
	   mov BH, 00h
	   mov BL, 00h
	   mov DX, 0
	   int 10h

	   mov dx,0a000h    //VOLCADO DE B0 A VENTANA 0.
	   mov es,dx
	   xor di,di
	   lds si, b0
	   mov cx,32000
	   rep movsw
	   lds si, b1       //VOLCADO DE PARTE DE B1 A VENTANA 0.
	   mov cx,768
	   rep movsw

	   mov AH, 4Fh      //DESPLAZAMIENTO DE LA VENTANA DE ACCESO A VIDEO.
	   mov AL, 05h      //EN UNA UNIDAD (64K). VENTANA 1
	   mov BH, 00h
	   mov BL, 00h
	   mov DX, 1
	   int 10h

	   mov dx,0a000h    //VOLCADO DEL RESTO B1 A VENTANA 1.
	   mov es,dx
	   xor di,di
	   lds si, b1
	   add si,1536
	   mov cx,31232
	   rep movsw
	   lds si, b2       //VOLCADO DE PARTE DE B2 A VENTANA 1.
	   mov cx,1536
	   rep movsw

	   mov AH, 4Fh      //DESPLAZAMIENTO DE LA VENTANA DE ACCESO A VIDEO.
	   mov AL, 05h      //EN UNA UNIDAD (128K). VENTANA 2
	   mov BH, 00h
	   mov BL, 00h
	   mov DX, 2
	   int 10h

	   mov dx,0a000h    //VOLCADO DEL RESTO B2 A VENTANA 2.
	   mov es,dx
	   xor di,di
	   lds si, b2
	   add si,3072
	   mov cx,30464
	   rep movsw
	   lds si, b3       //VOLCADO DE PARTE DE B3 A VENTANA 2.
	   mov cx,2304
	   rep movsw

	   mov AH, 4Fh      //DESPLAZAMIENTO DE LA VENTANA DE ACCESO A VIDEO.
	   mov AL, 05h      //EN UNA UNIDAD (192K). VENTANA 3
	   mov BH, 00h
	   mov BL, 00h
	   mov DX, 3
	   int 10h

	   mov dx,0a000h    //VOLCADO DEL RESTO B3 A VENTANA 3.
	   mov es,dx
	   xor di,di
	   lds si, b3
	   add si,4608
	   mov cx,29696
	   rep movsw

	   pop es
	   pop ds
      };
};
/***************************************************************************/
void pantalla640400256::liberarRAM(void){
   delete B[0],B[1],B[2],B[3];
};
/***************************************************************************/
pantalla640400256::~pantalla640400256(void){
   delete B[0],B[1],B[2],B[3];
};


/***************************************************************************/
/*   CLASE PANTALLA640480256: IMPLEMENTACION DE METODOS                    */
/***************************************************************************/
pantalla640480256::pantalla640480256(void){
   char i;

   B = NULL;
};
/***************************************************************************/
char pantalla640480256::inicializar(void){
   char i;
   char far *result;

   B = new char* [6];
   for(i=0; i<6; i++) B[i] = result = new char[51200];

   if(result) return(1);
   else return(0);
};
/***************************************************************************/
void pantalla640480256::cls(char color){
   char far *b;
   int i;

   for(i=0; i<6; i++){
      b = B[i];
      asm { mov ah,color
	    mov al,color
	    les di, b
	    mov cx,25600
	    rep stosw
      };
   };
};
/***************************************************************************/
void pantalla640480256::
     dImagen(int x,int y,int tx,int ty,imagen256 *imag){
   int i;
   char nb;
   unsigned int offset;
   char far *b;
   char far *filao, *filad;

   if(x<0) x=0;                      //"Recortado" con al ventana grfica.
   if(y<0) y=0;
   if((x+tx)>639) tx=(640-x);
   if((y+ty)>479) ty=(480-y);

   if((tx>0)&(ty>0)){
      nb=y/80;                       //1 buffer = 80 lineas de 640 pixels.
      offset=(640*(y-(80*nb)))+x;
      b=B[nb];

      for(i=0; i<ty; i++){           //Bucle de dibujo de la imagen.
	 filao=imag->imagen[i];
	 filad=b+offset;
	 asm{ les di, filad
	      lds si, filao
	      mov cx,tx
	      rep movsb
	 };
	 offset=(offset+640);
	 if(offset>51199){ offset=offset-51200; b=B[++nb]; };
      };
   };
};
/***************************************************************************/
void pantalla640480256::
     cImagen(int x,int y,int tx,int ty,imagen256 *imag){
   int i;
   char nb;
   unsigned int offset;
   char far *b;
   char far *filao, *filad;

   if(x<0) x=0;                       //"Recortado" con la ventana grfica.
   if(y<0) y=0;
   if((x+tx)>639) tx=(640-x);
   if((y+ty)>479) ty=(480-y);

   if((tx>0)&(ty>0)){
      nb=y/80;                        //1 buffer = 80 lineas de 640 pixels.
      offset=(640*(y-(80*nb)))+x;
      b=B[nb];

      for(i=0; i<ty; i++){            //Bucle de captura de la imagen.
	 filao=b+offset;
	 filad=imag->imagen[i];
	 asm{ les di, filad
	      lds si, filao
	      mov cx,tx
	      rep movsb
	 };
	 offset=(offset+640);
	 if(offset>51199){ offset=offset-51200; b=B[++nb]; };
      };
   };
};
/***************************************************************************/
void pantalla640480256::
     dImagenMasc(int x,int y,int tx,int ty,imagen256 *imag){
   int i;
   char nb;
   unsigned int offset;
   char far *b;
   char far *filao, *filad;

   if(x<0) x=0;                       //"Recortado" la ventana grfica.
   if(y<0) y=0;
   if((x+tx)>639) tx=(640-x);
   if((y+ty)>479) ty=(480-y);

   if((tx>0)&(ty>0)){
      nb=y/80;                        //1 buffer = 80 lineas de 640 pixels.
      offset=(640*(y-(80*nb)))+x;
      b=B[nb];

      for(i=0; i<ty; i++){            //Bucle de dibujo de la imagen.
	 filao=imag->imagen[i];
	 filad=b+offset;
	       asm{ push ds
		    push es
		    les di, filad     // ES:DI contiene Destino
		    lds si, filao     // DS:SI contiene Origen
		    mov cx, tx        // CX contiene tx.
	       }
	 bucl: asm{ cmp byte ptr ds:[si], 0    // Comparar el byte con 0
		    jne mover         // Si no son iguales lo transfiero.
		    inc di            // Si no, incrementa DI.
		    inc si            //        incrementa SI
		    jmp fin           // Biburca a fin.
	       }
	 mover:asm{ movsb             // Mueve un elemento de SI a DI.
	       }
	 fin:  asm{ loop bucl         // CX=CX-1 y biburca si CX!=0.
		    pop es
		    pop ds
	       }
	 offset=(offset+640);
	 if(offset>51199){ offset=offset-51200; b=B[++nb]; };
      };
   };
};
/***************************************************************************/
void pantalla640480256::dPunto(int x,int y,char color){
   char nb;                 //Nmero buffer actual.
   unsigned int offset;     //Offset dentro del buffer.
   char far *b;             //Puntero al buffer actual.

   if(x<0) goto FIN;
   if(x>639) goto FIN;
   if(y<0) goto FIN;
   if(y>479) goto FIN;

   nb=y/80;                           //Clculo del buffer y offset inicial.
   offset=(640*(y-(80*nb)))+x;
   b=B[nb];

   b[offset]=color;
   FIN:
};
/***************************************************************************/
void pantalla640480256::cPunto(int x,int y,char *color){
   char nb;                 //Nmero buffer actual.
   unsigned int offset;     //Offset dentro del buffer.
   char far *b;             //Puntero al buffer actual.

   if(x<0) goto FIN;
   if(x>639) goto FIN;
   if(y<0) goto FIN;
   if(y>479) goto FIN;

   nb=y/80;                           //Clculo del buffer y offset inicial.
   offset=(640*(y-(80*nb)))+x;
   b=B[nb];

   *color=b[offset];
   FIN:
};
/***************************************************************************/
void pantalla640480256::dLinea(int x1,int y1,int x2,int y2, char color){
   int i, temp;            //Variables para el algoritmo de BRESENHAM.
   int incX, incY, s1, s2;
   int intercambio, error;
   char nb;                //Nmero buffer actual (para dibujo del punto).
   unsigned int offset;    //Offset dentro del buffer (para dibujo del punto).
   char far *b;            //Puntero al buffer actual (para dibujo del punto).

   if(x1<0) goto FIN;   if(y1<0) goto FIN;
   if(x2<0) goto FIN;   if(y2<0) goto FIN;
   if(x1>639) goto FIN; if(y1>479) goto FIN;
   if(x2>639) goto FIN; if(y2>479) goto FIN;

   incX = abs(x2-x1);          //Algoritmo de BRESENHAM.
   incY = abs(y2-y1);
   if(x1<x2) s1 = 1;
   else s1 = -1;
   if(y1<y2) s2 = 1;
   else s2 = -1;

   if(incY>incX){ temp=incX; incX=incY; incY=temp; intercambio=1; }
   else intercambio=0;

   error = (2*incY)-incX;
   for(i=1; i<=incX; i++){
      nb=y1/80;                      //Dibujo del punto (x1,y1).
      offset=(640*(y1-(80*nb)))+x1;
      b=B[nb];
      b[offset]=color;

      while(error>=0){
	 if(intercambio) x1=x1+s1;
	 else y1=y1+s2;
	 error=error-(2*incX);
      };
      if(intercambio) y1=y1+s2;
      else x1=x1+s1;
      error=error+(2*incY);
   };
   FIN:
};

/***************************************************************************/
void pantalla640480256::
     dRectangulo(int x1,int y1,int x2,int y2, char color, char solido){
   int i, j, aux;
   char nb;
   unsigned int offset;
   char far *b;

   if(x1<0) goto FIN;   if(y1<0) goto FIN;
   if(x2<0) goto FIN;   if(y2<0) goto FIN;
   if(x1>639) goto FIN; if(y1>479) goto FIN;
   if(x2>639) goto FIN; if(y2>479) goto FIN;

   if(x2<x1){ aux=x2; x2=x1; x1=aux; };   //Intercambio de coordenadas.
   if(y2<y1){ aux=y2; y2=y1; y1=aux; };

   nb=y1/80;                           //Clculo del buffer y offset inicial.
   offset=(640*(y1-(80*nb)));
   b=B[nb];

   for(i=x1; i<=x2; i++) b[offset+i]=color;    //Dibujo linea superior.

   for(i=y1+1; i<=y2; i++){
      offset=(offset+640);
      if(offset>51199){ offset=offset-51200; b=B[++nb]; };
      if(!solido){                             //Dibujo lineas laterales o...
	 b[offset+x1]=color;
	 b[offset+x2]=color;
      }
      else
	 if(solido) for(j=x1; j<=x2; j++) b[offset+j]=color;     //..Relleno.
   };

   for(i=x1; i<=x2; i++) b[offset+i]=color;    //Dibujo linea inferior.
   FIN:
};
/***************************************************************************/
void pantalla640480256::volcar(void){
   char far *b0, *b1, *b2, *b3, *b4, *b5;
   int despl;

   b0=B[0]; b1=B[1]; b2=B[2];
   b3=B[3]; b4=B[4]; b5=B[5];
   despl=desplazaV;
      asm{ push ds
	   push es
	   cld

	   mov DX, 0
	   mov AH, 4Fh      //DESPLAZAMIENTO DE LA VENTANA DE ACCESO A VIDEO.
	   mov AL, 05h      //EN CERO UNIDADES. VENTANA 0.
	   mov BH, 00h
	   mov BL, 00h
	   int 10h

	   mov dx,0a000h    //VOLCADO DE B0 A VENTANA 0.
	   mov es,dx
	   xor di,di
	   lds si, b0
	   mov cx,25600
	   rep movsw
	   lds si, b1       //VOLCADO DE PARTE DE B1 A VENTANA 0.
	   mov cx,7168
	   rep movsw

	   mov DX, despl
	   mov AH, 4Fh      //DESPLAZAMIENTO DE LA VENTANA DE ACCESO A VIDEO.
	   mov AL, 05h      //EN UNA UNIDAD (64K). VENTANA 1
	   mov BH, 00h
	   mov BL, 00h
	   int 10h

	   mov dx,0a000h    //VOLCADO DEL RESTO B1 A VENTANA 1.
	   mov es,dx
	   xor di,di
	   lds si, b1
	   add si,14336
	   mov cx,18432
	   rep movsw
	   lds si, b2       //VOLCADO DE PARTE DE B2 A VENTANA 1.
	   mov cx,14336
	   rep movsw

	   mov AX, despl;
	   mov CX, 2
	   mul CX
	   mov DX, AX
	   mov AH, 4Fh      //DESPLAZAMIENTO DE LA VENTANA DE ACCESO A VIDEO.
	   mov AL, 05h      //EN UNA UNIDAD (128K). VENTANA 2
	   mov BH, 00h
	   mov BL, 00h
	   int 10h

	   mov dx,0a000h    //VOLCADO DEL RESTO B2 A VENTANA 2.
	   mov es,dx
	   xor di,di
	   lds si, b2
	   add si,28672
	   mov cx,11264
	   rep movsw
	   lds si, b3       //VOLCADO DE PARTE DE B3 A VENTANA 2.
	   mov cx,21504
	   rep movsw

	   mov AX, despl;
	   mov CX, 3
	   mul CX
	   mov DX, AX
	   mov AH, 4Fh      //DESPLAZAMIENTO DE LA VENTANA DE ACCESO A VIDEO.
	   mov AL, 05h      //EN UNA UNIDAD (192K). VENTANA 3
	   mov BH, 00h
	   mov BL, 00h
	   int 10h

	   mov dx,0a000h    //VOLCADO DEL RESTO B3 A VENTANA 3.
	   mov es,dx
	   xor di,di
	   lds si, b3
	   add si,43008
	   mov cx,4096
	   rep movsw
	   lds si, b4       //VOLCADO DE TODO B4 A VENTANA 3.
	   mov cx,25600
	   rep movsw
	   lds si, b5       //VOLCADO DE PARTE DE B5 A VENTANA 3.
	   mov cx,3072
	   rep movsw

	   mov AX, despl;
	   mov CX, 4
	   mul CX
	   mov DX, AX
	   mov AH, 4Fh      //DESPLAZAMIENTO DE LA VENTANA DE ACCESO A VIDEO.
	   mov AL, 05h      //EN UNA UNIDAD (256K). VENTANA 4
	   mov BH, 00h
	   mov BL, 00h
	   int 10h

	   mov dx,0a000h    //VOLCADO DEL RESTO B5 A VENTANA 4.
	   mov es,dx
	   xor di,di
	   lds si, b5
	   add si,6144
	   mov cx,22528
	   rep movsw

	   pop es
	   pop ds
      };
};
/***************************************************************************/
void pantalla640480256::liberarRAM(void){
   delete B[0],B[1],B[2],B[3],B[4],B[5];
};
/***************************************************************************/
pantalla640480256::~pantalla640480256(void){
   delete B[0],B[1],B[2],B[3],B[4],B[5];
};
