/***************************************************************************/
/* Ŀ */
/*  NOMBRE DEL FICHERO: IMAGEN.H                                         */
/*  DESCRIPCION:        Estructura de clases para la representacion y    */
/*                      manejo de imagenes.                              */
/*  CONTENIDO:          .class imagen256.                                */
/*                      .class multiImagen256.                           */
/*                                                                       */
/*  LLAMADO POR:        IMAGEN.CPP : Implementacin de los metodos de    */
/*                                   las clases construidas.             */
/*  LLAMA A:      (PRJ) MEMORIA.H: Manejo memoria XMS.                   */
/*                      IO.H: Funciones de Entrada/Salida de ficheros    */
/*                            tipo UNIX, para DOS.                       */
/*                      STDIO.H: Funciones de Entrada/Salida de ficheros */
/*                               standar ANSI. Definicin de 'FILE'      */
/*                      FCNTL.H: Definicin de valores de flags para las */
/*                               funciones 'open' y '_open'.             */
/*                      MEM.H: Manejo dinmico de memoria.               */
/*                             Definicin de 'NULL'.                     */
/*                                                                       */
/*  PROGRAMADO POR:     Juan Manuel Snchez Cervantes.                   */
/*  FECHA:              07/03/1995                                       */
/*  ACTUALIZACIONES:    ---                                              */
/*                                                                       */
/*  NOTAS: Respecto a los mdulos a los que se llama: el comentario aa- */
/*         dido tras el nombre de estos corresponde a las principales    */
/*         funciones que se toman de estos ficheros, y no a todas las    */
/*         que ofrecen (muchas ms).                                     */
/*  */
/***************************************************************************/
#ifndef IMAGEN          //Evitar recompilado.

#define IMAGEN 1        //IMAGEN == 1  -->  Mdulo ya compilado.
#include "memoria.h"
#include <io.h>
#include <stdio.h>
#include <fcntl.h>
#include <mem.h>

class imagen256{
/***************************************************************************/
/* DESCRIPCION:   Clase para la instanciacin de objetos para el control de*/
/*                imagenes de 256 niveles de gris (colores).               */
/* HERENCIA:      ---                                                      */
/* MIEMBROS PRIV: .int ancho: variable que contiene la anchura en pixels de*/
/*                            la imagen.                                   */
/*                .int alto: variable que contiene la altura en pixels de  */
/*                           la imagen.                                    */
/*                .unsigned int handle: variable que contiene el handle de */
/*                                      de ubicacin del EMB que contiene  */
/*                                      la imagen en XMS.                  */
/* MIEMBROS PUBL: .char far* far *imagen: puntero a una lista de punteros  */
/*                                        (tantos como la altura de la     */
/*                                        imagen) que a su vez apuntan cada*/
/*                                        uno a una secuencia de bytes     */
/*                                        (tantos como la anchura de la    */
/*                                        imagen).                         */
/*                .imagen256(void).                                        */
/*                .char inicializar(int, int).                             */
/*                .char cargarImg(char far *).                             */
/*                .char salvarImg(char far *).                             */
/*                .void cls(char).                                         */
/*                .void darDimensiones(int *, int *).                      */
/*                .char getPixel(int, int).                                */
/*                .void putPixel(int, int, char).                          */
/*                .char ubicarEnXMS(void).                                 */
/*                .char ubicarEnRAM(void).                                 */
/*                .char enXMS(void).                                       */
/*                .void borrar(void).                                      */
/*                .~imagen256(void).                                       */
/*                                                                         */
/* NOTAS: El tamao mximo permitido en la imagen es de ( 2^15 x 2^15 )    */
/*        pixels, pero esto no es factible pues la memoria necesaria para  */
/*        ello no se encontrar disponible normalmente.                    */
/*        2^15 = 32768.                                                    */
/*                                                                         */
/*        El puntero imagen debera ser privado por su condicin de varia- */
/*        ble de instancia de la clase. La razn de que se defina en la    */
/*        parte pblica es facilitar la rpida transferencia de datos entre*/
/*        el objeto y cualquier agente externo. No hay que olvidar que en  */
/*        el tratamiento de imgenes la velocidad de transferencia es algo */
/*        importante, tanto como para sacrificar algo de encapsulamiento.  */
/*                                                                         */
/*        XMS: Extended Memory Specification.                              */
/*        Existen mtodos para alojar la imagen en memoria extendida.      */
/***************************************************************************/
    int ancho, alto;
    unsigned int handle;

 public:
    char far* far *imagen;

    imagen256(void);
    /***********************************************************************/
    /* ENTRADA:  ---                                                       */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Contructor del objeto. Reserva memoria para las variables */
    /*           de instancia y las inicializa a 0.                        */
    /* REQUIERE: ---                                                       */
    /* NOTAS:    ---                                                       */
    /***********************************************************************/

    char inicializar(int anchura, int altura);
    /***********************************************************************/
    /* ENTRADA:  Dos nmeros de tipo entero que especifican la anchura y la*/
    /*           altura de la imagen.                                      */
    /* SALIDA:   1 si la inicializacin ha sido correcta.                  */
    /*           0 si no hay memoria libre.                                */
    /* EFECTO:   Da valores a las variables del objeto, ancho y alto.      */
    /*           Adems reserva la memoria necesaria (ancho x alto bytes)  */
    /*           apuntada por la estructura de punteros "**imagen" en el   */
    /*           rea de memoria convencional de la RAM (0 a 640K).        */
    /* REQUIERE: Los parmetros deben pertenecer al rango (0..2^15).       */
    /* NOTAS:    Recordar que imagen es un puntero que apunta a una lista  */
    /*           de punteros (tantos como filas en la imagen).             */
    /***********************************************************************/

    char cargarImg(char far *fichero);
    /***********************************************************************/
    /* ENTRADA:  Puntero al nombre del fichero origen.                     */
    /* SALIDA:   1 si la operacin ha terminado con exito.                 */
    /*           0 si ha habido un fallo al leer (p.ej. se intentan leer   */
    /*             ms datos de los que hay en el fichero).                */
    /*          -1 si ha habido un fallo al abrir (p.ej. el fichero no     */
    /*             existe o el disco no se encuentra en la unidad).        */
    /* EFECTO:   Se transfiere la informacin de un fichero IMG del direc- */
    /*           torio actual a la memoria del objeto imagen256.           */
    /* REQUIERE: Para que la operacin sea vlida el fichero debe existir  */
    /*           y no tener un tamao menor en bytes a (ancho x alto).     */
    /*           Adems la imagen debe residir en RAM convencional.        */
    /* NOTAS:    Recordar que un fichero IMG contiene la informacin de una*/
    /*           imagen a 256 niveles (o 256 colores) como una secuencia   */
    /*           de bytes, sin especificar el ancho y alto de esta, ni la  */
    /*           paleta necesaria para visualizarla correctamente.         */
    /***********************************************************************/

    char salvarImg(char far *fichero);
    /***********************************************************************/
    /* ENTRADA:  Puntero al nombre del fichero destino.                    */
    /* SALIDA:   1 si la operacin ha terminado con exito.                 */
    /*           0 si ha habido un fallo al escribir (p.ej. se saca el     */
    /*             disco destino a mitad de la transferencia).             */
    /*          -1 si ha habido un fallo al crear el fichero (p.ej. el     */
    /*             disco no se encuentra en la unidad).                    */
    /* EFECTO:   Se transfiere la informacin de la imagen256 a un fichero */
    /*           en el directorio actual.                                  */
    /* REQUIERE: La imagen debe residir en RAM convencional.               */
    /* NOTAS:    Recordar que un fichero IMG contiene la informacin de una*/
    /*           imagen a 256 niveles (o 256 colores) como una secuencia   */
    /*           de bytes, sin especificar el ancho y alto de esta, ni la  */
    /*           paleta necesaria para visualizarla correctamente.         */
    /***********************************************************************/

    void cls(char color);
    /***********************************************************************/
    /* ENTRADA:  Nmero entero con rango 0-255 que especifica en nmero de */
    /*           color con el que se cubrir toda la imagen.               */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   La imagen toma en todos sus pixels en valor "color".      */
    /* REQUIERE: La imagen debe residir en RAM convencional.               */
    /* NOTAS:    ---                                                       */
    /***********************************************************************/

    void darDimensiones(int *anchura, int *altura);
    /***********************************************************************/
    /* ENTRADA:  Dos punteros a enteros.                                   */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Introduce en la direccin apuntada por "anchura" el valor */
    /*           de la variable de instancia "ancho" y en la apuntada por  */
    /*           "altura" el valor de "alto".                              */
    /* REQUIERE: ---                                                       */
    /* NOTAS:    ---                                                       */
    /***********************************************************************/

    char getPixel(int x, int y);
    /***********************************************************************/
    /* ENTRADA:  Dos enteros, coordenadas en la imagen.                    */
    /* SALIDA:   El nmero de color (0..255) del pixel (x,y). Si cualquiera*/
    /*           de las coordenadas excede el tamao de la imagen se       */
    /*           recorta sta modulo la dimensin correspondiente.         */
    /* EFECTO:   ---                                                       */
    /* REQUIERE: La imagen debe residir en RAM convencional.               */
    /* NOTAS:    ---                                                       */
    /***********************************************************************/

    void putPixel(int x, int y, char color);
    /***********************************************************************/
    /* ENTRADA:  Dos nmeros de tipo int y un tercero de tipo char. Dos    */
    /*           coordenadas en la imagen y un nmero de color (0..255).   */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   El pixel (x,y) toma el valor "color". Si cualquiera de las*/
    /*           coordenadas excede el tamao de la imagen se recorta sta */
    /*           modulo la dimensin correspondiente.                      */
    /* REQUIERE: La imagen debe residir en RAM convencional.               */
    /* NOTAS:    ---                                                       */
    /***********************************************************************/

    char ubicarEnXMS(void);
    /***********************************************************************/
    /* ENTRADA:  ---                                                       */
    /* SALIDA:   0 si no hay un EMB libre suficiente grande en XMS.        */
    /*           1 si la operacin se ha realizado con exito.              */
    /*          -1 si se ha producido un error en la copia de datos.       */
    /* EFECTO:   Transfiere toda la memoria retenida por la estructura de  */
    /*           punteros 'imagen' a un EMB en XMS direccionado por un     */
    /*           handle que se guarda en la variable 'handle'. La memoria  */
    /*           convencional se libera.                                   */
    /* REQUIERE: La imagen debe residir en RAM convencional.               */
    /* NOTAS:    EMB: Extended Memory Block.                               */
    /*           XMS: Extended Memory Specification.                       */
    /***********************************************************************/

    char ubicarEnRAM(void);
    /***********************************************************************/
    /* ENTRADA:  ---                                                       */
    /* SALIDA:   0 si no hay suficiente RAM convencional libre.            */
    /*           1 si la operacin se ha realizado con exito.              */
    /*          -1 si se ha producido un error en la copia de datos.       */
    /* EFECTO:   Transfiere toda la memoria retenida en un EMB de la XMS   */
    /*           a RAM convencional y la variable 'handle' toma el valor 0.*/
    /*           La memoria XMS se libera.                                 */
    /* REQUIERE: La imagen debe residir en XMS.                            */
    /* NOTAS:    EMB: Extended Memory Block.                               */
    /*           XMS: Extended Memory Specification.                       */
    /***********************************************************************/

    char enXMS(void);
    /***********************************************************************/
    /* ENTRADA:  ---                                                       */
    /* SALIDA:   0 si la imagen se encuentra en RAM convencional.          */
    /*           1 si la imagen se encuentra en XMS.                       */
    /* EFECTO:   ---                                                       */
    /* REQUIERE: ---                                                       */
    /* NOTAS:    XMS: Extended Memory Specification.                       */
    /***********************************************************************/

    void borrar(void);
   /************************************************************************/
   /* ENTRADA:  ---                                                        */
   /* SALIDA:   ---                                                        */
   /* EFECTO:   Libera la memoria retenida por la estructura **imagen.     */
   /*           Las variables 'ancho' y 'alto' pasan a valer 0.            */
   /* REQUIERE: ---                                                        */
   /* NOTAS:    Se lleva a cabo tanto si reside en XMS como si no.         */
   /************************************************************************/

    ~imagen256(void);
    /***********************************************************************/
    /* ENTRADA:  ---                                                       */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Destructor del objeto. Libera la memoria retenida para el */
    /*           mantenimiento de la imagen, ya resida esta en RAM o XMS.  */
    /* REQUIERE: ---                                                       */
    /* NOTAS:    XMS: Extended Memory Specification.                       */
    /***********************************************************************/

    imagen256& operator=(const imagen256 &A);
    /***********************************************************************/
    /* ENTRADA:  Un objeto imagen.                                         */
    /* SALIDA:   Una copia del objeto imagen.                              */
    /* EFECTO:   El objeto copia para si los valores de la imagen que se   */
    /*           asigna a l. Tras la copia la imgen se encuentra en RAM. */
    /* REQUIERE: La imagen a asignar (A) debe residir en RAM convencional. */
    /* NOTAS:    ---                                                       */
    /***********************************************************************/
};

class multiImagen256{
/***************************************************************************/
/* DESCRIPCION:   Clase para el control de una secuencia de imagenes del   */
/*                tipo imagen256.                                          */
/* MIEMBROS PRIV: .int n: variable que contiene el nmero de imagenes      */
/*                        existentes en la MultiImagen.                    */
/*                .int nmax: variable que contiene el nmero mximo de im-*/
/*                           genes que pueden ser ubicadas en la MultiImag.*/
/*                .imagen256 *Multi: puntero a un objeto imagen256 que     */
/*                                   apuntar a un array de imagenes de    */
/*                                   'nmax' celdas.                        */
/* MIEMBROS PUBL: .multiImagen256(void).                                   */
/*                .void inicializar(int).                                  */
/*                .void insertar(int, imagen256*).                         */
/*                .void borrar(int pos).                                   */
/*                .imagen256* devolver(int).                               */
/*                .char cargarMig(char far *).                             */
/*                .char salvarMig(char far *).                             */
/*                .int darN(void).                                         */
/*                .void darDimensiones(int, int*, int*).                   */
/*                .char ubicarEnXMS(int).                                  */
/*                .char ubicarEnRAM(int).                                  */
/*                .char enXMS(int).                                        */
/*                .~multiImagen256(void).                                  */
/*                                                                         */
/* NOTAS: Ver notas en la clase imagen256.                                 */
/***************************************************************************/
   int n, nmax;
   unsigned int handle;
   imagen256 *Multi;

 public:
    multiImagen256(void);
    /***********************************************************************/
    /* ENTRADA:  ---                                                       */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Constructor del objeto. Reserva memoria para las variables*/
    /*           de instancia del objeto 'multiImagen256' y las inicia a 0.*/
    /* REQUIERE: ---                                                       */
    /* NOTAS:    ---                                                       */
    /***********************************************************************/

    void inicializar(int numImag);
    /***********************************************************************/
    /* ENTRADA:  Un entero que especifica el nmero mximo de imagenes que */
    /*           podr ubicar la 'multiImagen'.'                            */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   La variable de instancia 'nmax' toma el valor de numImag. */
    /* REQUIERE: La entrada debe pertenecer al rango del tipo int.         */
    /* NOTAS:    ---                                                       */
    /***********************************************************************/

    void insertar(int pos, imagen256 *imag);
    /***********************************************************************/
    /* ENTRADA:  Un entero que especifica una posicin dentro del array de */
    /*           imagenes, y un puntero a una imagen256.                   */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Si la posicin especificada no pertenece al rango 0..nmax,*/
    /*           no se hace nada.                                          */
    /*           Si es as, en el caso en que sta sea menor que n (nmero */
    /*           de imagenes hasta el momento) se copia la imagen dada como*/
    /*           parmetro en la posicin requerida, y se corren todas las */
    /*           imagenes de posiciones mayores a una posicin superior. Si*/
    /*           se especifica una posicin mayor o igual a n, la copia se */
    /*           har sobre la casilla nmero n.                           */
    /*           Si ha habido copia, n se incrementa en una unidad.        */
    /* REQUIERE: ---                                                       */
    /* NOTAS:    Todas las imagenes corridas de posicin, si las hubiese,  */
    /*           y la nueva imagen insertada residirn en RAM convencional.*/
    /***********************************************************************/

    void borrar(int pos);
    /***********************************************************************/
    /* ENTRADA:  Un entero que especifica una posicin dentro del array de */
    /*           imagenes.                                                 */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Si la posicin especificada no pertenece al rango 0..n-1, */
    /*           no se hace nada.                                          */
    /*           Si es as, se corren todas las imagenes ubicadas en posi- */
    /*           ciones mayores que pos a una posicin menor, con lo que se*/
    /*           pierde la informacin de la imagen ubicada en pos. Poste- */
    /*           riormente se borra la imagen de la casilla n-1 ya que     */
    /*           estar duplicada.                                         */
    /*           Si ha habido borrado, n se decrementa en una unidad.      */
    /* REQUIERE: ---                                                       */
    /* NOTAS:    Todas las imagenes corridas de posicin, si las hubiese,  */
    /*           residirn en RAM convencional.                            */
    /***********************************************************************/

    imagen256* devolver(int pos);
    /***********************************************************************/
    /* ENTRADA:  Un entero que especifica una posicin dentro del array de */
    /*           imagenes.                                                 */
    /* SALIDA:   Un puntero a la imagen posicionada en 'pos'.              */
    /* EFECTO:   ---                                                       */
    /* REQUIERE: La imagen debe residir en RAM convencional.               */
    /* NOTAS:    ---                                                       */
    /***********************************************************************/

    char cargarMig(char far *fichero); // HA VARIADO !!!!!!!!!
    /***********************************************************************/
    /* ENTRADA:  Un puntero al nombre del fichero origen.                  */
    /* SALIDA:   1 si la operacin ha terminado con exito.                 */
    /*           0 si ha habido un fallo al leer (p.ej. se ha retirado el  */
    /*             disco de la unidad.                                     */
    /*          -1 si ha habido un fallo al abrir (p.ej. el fichero no     */
    /*             existe o el disco no se encuentra en la unidad).        */
    /* EFECTO:   Se transfiere la informacin de un fichero MIG del direc- */
    /*           torio actual a la memoria del objeto 'multiImagen256'.    */
    /* REQUIERE: Para que la operacin sea vlida el fichero debe existir  */
    /*           y la MultiImagen debe estar inicializada a un nmero de   */
    /*           imagenes no inferior a las del fichero.                   */
    /* NOTAS:    Recordar que un fichero MIG contiene la informacin de una*/
    /*           secuencia de imagenes a 256 colores con el siguiente for- */
    /*           mato: ancho0(2 bytes), alto0(2 bytes), imagen0,           */
    /*                 ancho1, alto1, imagen1, ancho2, alto2, imagen2, ... */
    /***********************************************************************/

    char salvarMig(char far *fichero); // HA VARIADO !!!!!!!!
    /***********************************************************************/
    /* ENTRADA:  Un puntero al nombre del fichero destino.                 */
    /* SALIDA:   1 si la operacin ha terminado con exito.                 */
    /*           0 si ha habido un fallo al escribir (p.ej. se saca el     */
    /*             disco destino a mitad de la transferencia).             */
    /*          -1 si ha habido un fallo al crear el fichero (p.ej. el     */
    /*             disco no se encuentra en la unidad).                    */
    /* EFECTO:   Se transfiere la informacin de una 'multiImagen256' a un */
    /*           fichero en el directorio actual con extensin .MIG.       */
    /* REQUIERE: ---                                                       */
    /* NOTAS:    Recordar que un fichero MIG contiene la informacin de una*/
    /*           secuencia de imagenes a 256 colores con el siguiente for- */
    /*           mato: ancho0(2 bytes), alto0(2 bytes), imagen0,           */
    /*                 ancho1, alto1, imagen1, ancho2, alto2, imagen2, ... */
    /***********************************************************************/

    int darN(void);
    /***********************************************************************/
    /* ENTRADA:  ---                                                       */
    /* SALIDA:   Un entero que representa el nmero de imagenes existentes.*/
    /* EFECTO:   ---                                                       */
    /* REQUIERE: ---                                                       */
    /* NOTAS:    ---                                                       */
    /***********************************************************************/

    void darDimensiones(int pos, int *anchura, int *altura);
    /***********************************************************************/
    /* ENTRADA:  Un entero que especifica una posicin en el array de ima- */
    /*           genes, y dos punteros a enteros.                          */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Se introduce en las posiciones apuntadas por los dos par-*/
    /*           metros dados el ancho y alto correspondientes a la imagen */
    /*           que ocupa la posicin "pos".                              */
    /* REQUIERE: ---                                                       */
    /* NOTAS:    ---                                                       */
    /***********************************************************************/

    char ubicarEnXMS(void);
    /***********************************************************************/
    /* ENTRADA:  Un entero que especifica una posicin en el array de      */
    /*           imagenes.                                                 */
    /* SALIDA:   0 si no hay un EMB libre suficiente grande en XMS.        */
    /*           1 si la operacin se ha realizado con exito.              */
    /*          -1 si se ha producido un error en la copia de datos.       */
    /* EFECTO:   Transfiere toda la memoria retenida por la imagen que ocu-*/
    /*           pa la posicin "pos" a un EMB en XMS mediante una llamada */
    /*           por parte de dicha imagen a su metodo ubicarEnXMS(void).  */
    /*           La memoria en RAM convencional se libera.                 */
    /* REQUIERE: La imagen debe residir en RAM convencional.               */
    /* NOTAS:    EMB: Extended Memory Block.                               */
    /*           XMS: Extended Memory Specification.                       */
    /*           Ver documentacin adjunta al metodo ubicarEnXMS(void) de  */
    /*           la clase imagen256.                                       */
    /***********************************************************************/

    char ubicarEnRAM(void);
    /***********************************************************************/
    /* ENTRADA:  Un entero que especifica una posicin en el array de      */
    /*           imagenes.                                                 */
    /* SALIDA:   0 si no hay suficiente RAM convencional libre.            */
    /*           1 si la operacin se ha realizado con exito.              */
    /*          -1 si se ha producido un error en la copia de datos.       */
    /* EFECTO:   Transfiere toda la memoria retenida en un EMB de la XMS   */
    /*           a RAM convencional para la imagen de la posicin "pos"    */
    /*           llamando sta a su metodo ubicarEnRAM(void).
    /*           La memoria XMS se libera.                                 */
    /* REQUIERE: La imagen debe residir en XMS.                            */
    /* NOTAS:    EMB: Extended Memory Block.                               */
    /*           XMS: Extended Memory Specification.                       */
    /*           Ver documentacin adjunta al metodo ubicarEnRAM(void) de  */
    /*           la clase imagen256.                                       */
    /***********************************************************************/

    char enXMS(void);
    /***********************************************************************/
    /* ENTRADA:  Un entero que especifica una posicin en el array de      */
    /*           imagenes.                                                 */
    /* SALIDA:   1 si la imgen de dicha posicin reside en XMS.           */
    /*           0 si la imgen de dicha posicin reside en RAM convenc.   */
    /* EFECTO:   ---                                                       */
    /* REQUIERE: ---                                                       */
    /* NOTAS:    ---                                                       */
    /***********************************************************************/

    ~multiImagen256(void);
    /***********************************************************************/
    /* ENTRADA:  ---                                                       */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Destructor del objeto 'multiImagen256'. Hace un borrado de*/
    /*           todas las imagenes para liberar la memoria retenida por   */
    /*           stas, y libera tambin la retenida por el puntero privado*/
    /*           Multi.                                                    */
    /* REQUIERE: ---                                                       */
    /* NOTAS:    ---                                                       */
    /***********************************************************************/
};

#endif;