UNIT SB;
{
  Soporte de SB, SB 2.0, SB Pro y SB 16.
  Por Luis Crespo, FidoNet 2:343/108.21, Internet d8089110@est.fib.upc.es
}

INTERFACE

USES
  Hardware;

  FUNCTION SBDetect:Boolean;
  PROCEDURE SBSendByte(b:Byte);
  PROCEDURE SBWrite(b:Byte);
  FUNCTION SBRead:Byte;
  PROCEDURE SBPlayBuf(pBuffer:Pointer; BufferSize:Word; VAR Frec:Word; BufProc:TBufProc);
  PROCEDURE SBStopBuf;


VAR
  DSPVerMajor,
  DSPVerMinor  : Byte;      {Version del DSP}
  SBIRQ,                    {IRQ de la SB}
  SB8DMA,                   {DMA de 8 bits}
  SB16DMA      : Byte;      {DMA de 16 bits}
  TimeConst    : Byte;      {Constante de tiempo del DSP}
  SBVector     : Byte;      {Nmero de vector de interrupcin de la SB}
  OldISR       : Pointer;   {Puntero a la antigua ISR}
  SBReadError,              {Error de lectura en el DSP}
  SBWriteError : Boolean;   {Error de escritura en el DSP}


CONST

  {Puertos de la SB}
  SBBase    : Word = $210;  {Puerto base}
  SBMixAddr : Word = $214;  {Registro de direcciones del mixer}
  SBMixData : Word = $215;  {Registro de datos del mixer}
  SBReset   : Word = $216;  {Puerto de reset}
  SBReadp   : Word = $21A;  {Puerto de lectura del DSP}
  SBWritep  : Word = $21C;  {Puerto de escritura del DSP}
  SBRStat   : Word = $21E;  {Puerto de estado de lectura del DSP}

  {Comandos del DSP}
  cmDirectDAC  = $10;  {Modo directo, 8 bits}
  cmDirectADC  = $20;
  cmSingleDAC  = $14;  {DMA de ciclo nico, 8 bits}
  cmSingleADC  = $24;
  cmAutoDAC    = $1C;  {DMA auto inicializado, 8 bits}
  cmAutoADC    = $2C;
  cmSetTimeCt  = $40;  {Constante de tiempo}
  cmSetSize    = $48;  {Tamao del buffer}
  cmHiSpdDAC   = $90;  {DMA auto inicializado, modo high-speed, 8 bits}
  cmHiSpdADC   = $98;
  cmSB16DAC16  = $B6;  {SB 16, DMA de 16 bits}
  cmSB16ADC16  = $BE;
  cmSB16DAC8   = $C6;  {SB 16, DMA de 8 bits}
  cmSB16ADC8   = $CE;
  cmStopDMA    = $D0;  {Para el DMA}
  cmSpeakerOn  = $D1;  {Control de la salida del DAC}
  cmSpeakerOff = $D3;
  cmGetDSPVer  = $E1;  {Consulta de versin del DSP}

  {Modos de DMA de la SB 16}
  mdUnsigned   = $00;
  mdSigned     = $10;
  mdMono       = $00;
  mdStereo     = $20;



IMPLEMENTATION


USES
  DOS,CRT;

CONST

  Ready : byte = $0AA;  {Indicacin de reset correcto}
  RWCount      = $FFFF; {Nmero mximo de consultas a los puertos de estado}

VAR
  BufSize:Word;
  Ack:Byte;
  NextBuffer:TBufProc;


  {-------------------- Operaciones bsicas de I/O -------------------------}

  FUNCTION SBRead:Byte;
  VAR
    Ct:Word;
  BEGIN
    SBReadError:=TRUE;
    Ct:=RWCount;
    WHILE (Ct>0) AND SBReadError DO
    BEGIN
      IF (Port[SBRStat] AND $80)<>0 THEN
      BEGIN
        {Cuando el bit 7 est a 1, se puede leer}
        SBRead:=Port[SBReadp];
        SBReadError:=FALSE;
      END;
      Dec(Ct);
    END;
  END;

  PROCEDURE SBWrite(b:Byte);
  VAR
    Ct:Word;
  BEGIN
    SBWriteError:=TRUE;
    Ct:=RWCount;
    WHILE (Ct>0) AND SBWriteError DO
    BEGIN
      IF (Port[SBWritep] AND $80)=0 THEN
      {Cuando el bit 7 est a 0, se puede escribir}
      BEGIN
        Port[SBWritep]:=b;
        SBWriteError:=FALSE;
      END;
      Dec(Ct);
    END;
  END;

  PROCEDURE SBSendByte(b:Byte);
  BEGIN
    SBWrite(cmDirectDAC);
    SBWrite(b);
  END;

  FUNCTION SBReadMixer(Addr:Byte):Byte;
  BEGIN
    Port[SBMixAddr]:=Addr;
    SBReadMixer:=Port[SBMixData];
  END;

  PROCEDURE SBWriteMixer(Addr,b:Byte);
  BEGIN
    Port[SBMixAddr]:=Addr;
    Port[SBMixData]:=b;
  END;



  {-------------------- Deteccin e inicializacin -------------------------}

  FUNCTION ReadSB16IRQ:Byte;
  VAR
    IRQSetup:Byte;
  BEGIN
    IRQSetup:=SBReadMixer($80);   {Interrupt setup register}
    ReadSB16IRQ:=0;
    IF (IRQSetup AND 1)=1 THEN ReadSB16IRQ:=2
    ELSE IF (IRQSetup AND 2)=2 THEN ReadSB16IRQ:=5
    ELSE IF (IRQSetup AND 4)=4 THEN ReadSB16IRQ:=7
    ELSE IF (IRQSetup AND 8)=8 THEN ReadSB16IRQ:=10;
  END;

  PROCEDURE ReadSB16DMA(VAR DMA8,DMA16:Byte);
  VAR
    DMASetup:Byte;
  BEGIN
    DMA8:=0;
    DMA16:=0;
    DMASetup:=SBReadMixer($81);   {DMA Setup register}
    IF (DMASetup AND 1)=1 THEN DMA8:=0
    ELSE IF (DMASetup AND 2)=2 THEN DMA8:=1
    ELSE IF (DMASetup AND 8)=8 THEN DMA8:=3;
    IF (DMASetup AND $20)=$20 THEN DMA16:=5
    ELSE IF (DMASetup AND $40)=$40 THEN DMA16:=6
    ELSE IF (DMASetup AND $80)=$80 THEN DMA16:=7;
  END;

  PROCEDURE PruebaIRQ2; INTERRUPT;
  BEGIN
    SBIRQ:=2;
    EOI;
  END;

  PROCEDURE PruebaIRQ3; INTERRUPT;
  BEGIN
    SBIRQ:=3;
    EOI;
  END;

  PROCEDURE PruebaIRQ5; INTERRUPT;
  BEGIN
    SBIRQ:=5;
    EOI;
  END;

  PROCEDURE PruebaIRQ7; INTERRUPT;
  BEGIN
    SBIRQ:=7;
    EOI;
  END;

  PROCEDURE PruebaIRQ10; INTERRUPT;
  BEGIN
    SBIRQ:=10;
    EOISlave;
    EOI;
  END;

  PROCEDURE DeterminaIRQyDMA;
  CONST
    TablaDMA:ARRAY[1..3] OF Byte=(0,1,3);
  VAR
    IMR,IMRSlave:Byte;
    Old2,Old3,Old5,Old7,Old10:Pointer;
    Algo,DMACt:Byte;
  BEGIN
    IF DSPVerMajor>=4 THEN
    BEGIN {La deteccin en la SB 16 es mucho ms sencilla}
      SBIRQ:=ReadSB16IRQ;
      ReadSB16DMA(SB8DMA,SB16DMA);
    END
    ELSE BEGIN
      {Deteccin por fuerza bruta: arriesgada pero efectiva}
      SB16DMA:=0;
      SBIRQ:=0;
      GetIntVec(8+2,Old2); SetIntVec(8+2,@PruebaIRQ2);
      GetIntVec(8+3,Old3); SetIntVec(8+3,@PruebaIRQ3);
      GetIntVec(8+5,Old5); SetIntVec(8+5,@PruebaIRQ5);
      GetIntVec(8+7,Old7); SetIntVec(8+7,@PruebaIRQ7);
      GetIntVec(104+10,Old10); SetIntVec(104+10,@PruebaIRQ10);
      ASM CLI END;
      IMR:=Port[$21];       {Guarda mscaras de interrupciones}
      IMRSlave:=Port[$A1];
      Port[$21]:=IMR AND $53;  {Habilita todas posible IRQ's de la SB}
      Port[$A1]:=IMRSlave AND $FB;
      ASM STI END;

      Algo:=128;
      DMACt:=1;
      SBWrite(cmSetTimeCt);
      SBWrite(206);           {20 KHz}
      SBWrite(cmSingleDAC);
      SBWrite(0); SBWrite(0); {1 byte}
      REPEAT
        SB8DMA:=TablaDMA[DMACt];
        ProgKDMA(SB8DMA,@Algo,1,FALSE,TRUE);
        Delay(1);             {Espera a que termine la mini-transferencia}
        StopDMA(SB8DMA);
        Inc(DMACt);
      UNTIL (SBIRQ<>0) OR (DMACt>3);
      Algo:=SBRead;           {Ack a la SB}

      ASM CLI END;
      Port[$21]:=IMR;
      Port[$A1]:=IMRSlave;
      ASM STI END;
      SetIntVec(8+2,Old2);
      SetIntVec(8+3,Old3);
      SetIntVec(8+5,Old5);
      SetIntVec(8+7,Old7);
      SetIntVec(104+10,Old10);
    END;
  END;

  FUNCTION SBDetect:Boolean;
  VAR
    Status:Byte;
  BEGIN
    EOISlave; {Se limpian posibles interrupciones pendientes}
    EOI;
    SBReadError:=FALSE;
    SBWriteError:=FALSE;
    REPEAT
      Port[SBReset]:=1;
      Delay(1);                   {Espera un tiempo prudencial para el reset}
      Port[SBReset]:=0;
      Status:=SBRead;
      IF SBReadError THEN Status:=0;
      IF Status<>Ready THEN
      BEGIN
        Inc(SBBase,$10);          {Si no detecta...}
        Inc(SBMixAddr,$10);       {...prueba con otro puerto base}
        Inc(SBMixData,$10);
        Inc(SBReset,$10);
        Inc(SBReadp,$10);
        Inc(SBWritep,$10);
        Inc(SBRStat,$10);
      END;
    UNTIL (Status=Ready) OR (SBBase=$290);
    SBDetect:=FALSE;
    IF SBBase<>$290 THEN
    BEGIN
      SBDetect:=TRUE;
      SBWrite(cmGetDSPVer);  {Averigua la versin del DSP}
      DSPVerMajor:=SBRead;
      DSPVerMinor:=SBRead;
      SBWrite(cmSpeakerOff);
      DeterminaIRQyDMA;
    END;
  END;


  {------------------ Generacin de sonido via DMA -----------------------}

  PROCEDURE DMAISR; INTERRUPT;
  BEGIN
    IF DSPVerMajor=1 THEN
    BEGIN
      SBWrite(cmSingleDAC);
      SBWrite(Lo(BufSize));
      SBWrite(Hi(BufSize));
    END;
    Ack:=Port[SBRStat];
    IF SBIRQ>7 THEN EOISlave;
    EOI;
    ASM STI END;
    NextBuffer;
  END;

  PROCEDURE ProgDSP;
  BEGIN
    CASE DSPVerMajor OF
      1: BEGIN
        SBWrite(cmSingleDAC);
        SBWrite(Lo(BufSize));
        SBWrite(Hi(BufSize));
      END;
      2: BEGIN
        SBWrite(cmSetSize);
        SBWrite(Lo(BufSize));
        SBWrite(Hi(BufSize));
        IF DSPVerMinor=0 THEN SBWrite(cmAutoDAC)
        ELSE SBWrite(cmHiSpdDAC);
      END;
      3 : BEGIN
        SBWrite(cmSetSize);
        SBWrite(Lo(BufSize));
        SBWrite(Hi(BufSize));
        SBWrite(cmHiSpdDAC);
      END;
      ELSE BEGIN {SB 16 o superior}
        SBWrite(cmSB16DAC8);
        SBWrite(mdMono+mdUnsigned);
        SBWrite(Lo(BufSize));
        SBWrite(Hi(BufSize));
      END;
    END;
  END;

  PROCEDURE SBPlayBuf(pBuffer:Pointer; BufferSize:Word; VAR Frec:Word; BufProc:TBufProc);
  BEGIN
    BufSize:=BufferSize-1;
    NextBuffer:=BufProc;
    TimeConst:=256-(1000000 DIV Frec);
    Frec:=1000000 DIV (256-TimeConst);
    SBWrite(cmSetTimeCt);
    SBWrite(TimeConst);
    IF SBIRQ<8 THEN SBVector:=8+SBIRQ ELSE SBVector:=104+SBIRQ;
    GetIntVec(SBVector,OldISR);
    SetIntVec(SBVector,@DMAISR);
    HabilitaIRQ(SBIRQ);
    ProgKDMA(SB8DMA,pBuffer,BufferSize*2,TRUE,TRUE);
    SBWrite(cmSpeakerOn);   {Habilita la salida digital}
    ProgDSP;
  END;

  PROCEDURE SBStopBuf;
  BEGIN
    SBWrite(cmStopDMA);
    DesHabilitaIRQ(SBIRQ);
    SetIntVec(SBVector,OldISR);
    StopDMA(SB8DMA);
    SBWrite(cmSpeakerOff);   {Deshabilita la salida digital}
  END;


END.