{$G+} { //-- Generar cdigo 286  }

program Karate;

uses crt,dos;
const
masc1=0;
velocscrol=-2;
relampa=true;
incre=4;
amp=11;
tamax=8*amp;
tamay=10*amp;
maxelem=1;

type
   
   PALETA=ARRAY [1..768] OF BYTE;                    {Buffer paleta}
   Graficodef=Array [1..tamay,1..tamax] of byte;     {Sprites tamayx50}
   pantalla=Array[0..199,0..219] of byte;            {Una pantalla}
   pantalla_virtual=^pantalla;
   grafico=^Graficodef;


   elemento=record
              x,y:word;
              izq:boolean;
              anim:byte;
              fot:byte;
            end;
   fichero=file;
{ //---------------------------------------------------------------------- }

var
TEC:byte;
T:ARRAY[0..255] OF BOOLEAN;

izq:boolean;
vaddr:pantalla_virtual;
fondo:pantalla_virtual;

pata1,pata2,MONIGOTE,Punetazo,MONIGOTE3:grafico;
Mpata1,Mpata2,MMONIGOTE,MPunetazo,MMONIGOTE3:grafico;
x,y:integer;
i,j:word;
posiciones:array [1..maxelem] of elemento;
DESC,palette,subdesc,numb:STRING;
COLORES:^PALETA;        {Puntero a la paleta}
contapant:integer;      {Puntero de posicion scroll}
vidab,vidam:byte;       {Vida bueno y malo}
{---------------------------------------------------------------------------}

PROCEDURE TECLA;
begin                            {Tec:=scan code}
  ASM
   IN AL,60H
   MOV byte ptr [TEC],AL
   MOV AH,0CH
   INT 21H
   IN AL,61H
   OR AL,128
   OUT 61H,AL
   AND AL,127
   OUT 61H,AL
   MOV AH,0CH
   INT 21H

  END;
  if (tec and 128)<>0 then t[tec and 127]:= false
  else t[tec]:= true;
end;

{---------------------------------------------------------------------------}

Procedure retrazo;  assembler;

{Espera al fin del retrazo vert. de la pant.}

asm
        MOV DX,03DAH

  @RETR:IN AL,DX
        AND AL,8
        JNZ @RETR

  @RETR2:IN AL,DX
         and al,8
         JZ @RETR2
end;
{--------------------------------------------------------------------------}
procedure SETREGISTERS; assembler;{paleta:=colores}

{ Palrec is any string of 768 bytes containing the RGB data. }

  asm
   mov ah,$10               { BIOS color register function }
   mov al,$12               { Subfunction }
   mov es,word ptr [colores+2]       { Address of palette info. }
   mov dx,word ptr [colores]
   mov bx,0                 { First register to change }
   mov cx,$100              { Number of registers to change }
   int $10                 { Call BIOS }
  end;


{---------------------------------------------------------------------------}
function FileExists(FileName: string)
                                : Boolean;
{ Returns True if file exists; otherwise,
  it returns False. Closes the file if
  it exists. }
var
  f: file;
begin
  {$I-}
  Assign(f, FileName);
  Reset(f);
  Close(f);
  {$I+}
  FileExists := (IOResult = 0) and
   (FileName <> '');
end;  { FileExists }
{-------------------------------------------------------------------------}
procedure cargar_dibujo(nombre:string);
{carga una pantalla 320x200 scr en memoria de video}
  
var i:word;
    dato:byte;
    F:file;
begin

  if FileExists(NOMBRE) then
    { Get file name from command line }
    begin
           {carga}
   
       Assign(f,nombre);               {Abro el fichero}
       Reset(f,1);
       BlockRead(f,COLORES^,768);    {Lee paleta}
       BlockRead(f,fondo^,64000);    {Lee imagen}
       Close(f);
       setregisters;                 {activa la paleta}
     end
  else
    WriteLn('File not found');
end;
{}
Procedure SetVga256;  { Para inicializar el modo 320x200 256 colores }
BEGIN
  asm
     mov        ax,0013h
     int        10h
  end;
END;

{}

Procedure SetUpVirtual;
   { Inicializa un pantalla virtual }
BEGIN
  GetMem (fondo,64000);                      {Memoria para pantalla fondo}
  GetMem (vaddr,64000);                      {Memoria para pantalla virtual}
  GetMem (monigote,sizeof(graficodef));      {Memoria para bueno anda1}
  GetMem (Punetazo,sizeof(graficodef));      {Memoria para Puetazo bueno}
  GetMem (monigote3,sizeof(graficodef));     {Memoria para bueno anda2}
  GetMem (pata1,sizeof(graficodef));         {Memoria para Protegido bueno}
  GetMem (pata2,sizeof(graficodef));         {Memoria para Patada bueno}
  GetMem (mmonigote,sizeof(graficodef));     {Memoria para malo anda1}
  GetMem (mPunetazo,sizeof(graficodef));     {Memoria para malo puo}
  GetMem (mmonigote3,sizeof(graficodef));    {Memoria para malo anda2}
  GetMem (mpata1,sizeof(graficodef));        {Memoria para malo protegido}
  GetMem (mpata2,sizeof(graficodef));        {Memoria para malo patada}
  GetMem (colores,sizeof(paleta));           {Memoria para paleta}


END;

{}
procedure flip(source:pantalla_virtual); assembler;
  { Copia la pantalla que le indiquemos, al destino que querramos }
  { por ejemplo, para visualizar una pantalla virtual }


  asm
    push    ds
    push    ax
    push    cx
    push    di
    push    si

    mov     ax, $A000
    mov     es, ax
    mov     ax, word ptr [Source+2]
    mov     ds, ax
    mov     si, word ptr [Source]
    xor     di, di
    mov     cx, 32000
    rep     movsw

    pop     si
    pop     di
    pop     cx
    pop     ax
    pop     ds
  end;




{}
procedure CopFondEnVirt(source,dest:pantalla_virtual;conta:word); assembler;
  { Copia la pantalla que le indiquemos, al destino que querramos }
  { por ejemplo, para visualizar una pantalla virtual }




  asm
    push    ds
    push    ax
    push    cx
    push    di
    push    si

    
    mov     ax, word ptr [dest+2]
    mov     es, ax
    mov     ax, word ptr [Source+2]
    mov     ds, ax
    mov     si, word ptr [Source]
    mov     di, word ptr [dest]
    add     di, word ptr [conta]
    mov     cx, 64000
    sub     cx,word ptr [conta]
    rep     movsb

    mov     cx, 320
@mas:mov bx,cx
    mov  byte ptr es:[bx-1],0
    loop @mas
    pop     si
    pop     di
    pop     cx
    pop     ax
    pop     ds
  end;




{}
Procedure ShutDown;
    { libera la memoria que se ocupa en el Heap}
BEGIN
  FreeMem (vaddr,64000);
  FreeMem (fondo,64000);
  FreeMem (monigote,sizeof(graficodef));
  FreeMem (Punetazo,sizeof(graficodef));
  FreeMem (monigote3,sizeof(graficodef));
  FreeMem (pata1,sizeof(graficodef));
  FreeMem(pata2,sizeof(graficodef));
  FreeMem (mmonigote,sizeof(graficodef));
  FreeMem (mPunetazo,sizeof(graficodef));
  FreeMem (mmonigote3,sizeof(graficodef));
  FreeMem (mpata1,sizeof(graficodef));
  FreeMem(mpata2,sizeof(graficodef));
  FreeMem (colores,sizeof(paleta));


END;
{}


{//-------------------------------------------------------------------------}
Procedure Cls (Where:pantalla_virtual;Col : Byte);assembler;
   { Borra la pantalla que le indiquemos, con el color que queramos }

     asm
        push    ds
        push    ax
        push    cx
        push    di
        push    si
        push    es
        mov     cx, 32000;
        mov     ax,word ptr [where+2]
        mov     es,ax      {bingo, segmento y desplazamiento al que
                            apunta where}
        mov     di,word ptr [where]
        mov     al,[col]
        mov     ah,al
        rep     stosw
        pop     es
        pop     si
        pop     di
        pop     cx
        pop     ax
        pop     ds


     End;

{//-------------------------------------------------------------------------}

Procedure poner_cuadro(x,y:word;tx,ty:word;lugar:pantalla_virtual;color:byte); assembler;

{Sintaxis pone un sprite de tamao tx*ty en una pantalla virtual}

Asm
    push ds

    mov     cx,[ty]

@otro: mov     ax,word ptr [lugar+2]
    mov     es,ax


    mov     bx,[X]
    mov     dx,[Y]
    mov     di,bx
    mov     bx, dx             {     ; bx = dx     }
    shl     dx, 8
    shl     bx, 6
    add     dx, bx              {    ; dx = dx + bx (ie y*320)   }
    add     di, dx               {   ; finalise location}
 
    add     di, word ptr [lugar]{+sy*320}
    mov     ax,320
    mov     bx,cx
    dec     bx
    mul     bx
    add     di,ax

    push cx
        mov cx,[tx]

 @otro2:mov al,byte ptr [color]
        mov es:[di],al
        inc di
@siguiente:loop @otro2


    pop  cx
    loop @otro

    pop ds
 @fin:
 End;


{//-------------------------------------------------------------------------}


Procedure poner_sprite(x,y:word;tx,ty:word;origen:Grafico;lugar:pantalla_virtual); assembler;

{Sintaxis pone un sprite de tamao tx*ty en una pantalla virtual}

Asm
    push ds

    mov     cx,[ty]

@otro: mov     ax,word ptr [lugar+2]
    mov     es,ax
    mov     ax,word ptr [origen+2]
    mov     ds,ax

    

    mov     bx,[X]
    mov     dx,[Y]
    mov     di,bx
    mov     bx, dx             {     ; bx = dx     }
    shl     dx, 8
    shl     bx, 6
    add     dx, bx              {    ; dx = dx + bx (ie y*320)   }
    add     di, dx               {   ; finalise location}
 
    mov     si,word ptr [origen]
    mov     ax,[tx]
    mov     bx,cx
    dec     bx
    mul     bx
    add     si,ax

    add     di, word ptr [lugar]{+sy*320}
    mov     ax,320
    mov     bx,cx
    dec     bx
    mul     bx
    add     di,ax

    push cx
       mov cx,[tx]
 @otro2:cmp byte ptr ds:[si],0
        je  @transp
        movsb
        jmp @siguiente
@transp:inc si  {Pasamos de el por ser transparente}
        inc di
@siguiente:loop @otro2


    pop  cx
    loop @otro

    pop ds
 @fin:
 End;


{---------------------------------------------------------------------------}
Procedure poner_sprite_inv(x,y:word;tx,ty:word;origen:Grafico;lugar:pantalla_virtual); assembler;

{Sintaxis pone un sprite de tamao
tx*ty en una pantalla virtual invertido izq-der}

Asm
    push ds

    mov     cx,[ty]

@otro: mov     ax,word ptr [lugar+2]
    mov     es,ax
    mov     ax,word ptr [origen+2]
    mov     ds,ax

    

    mov     bx,[X]
    mov     dx,[Y]
    mov     di,bx
    mov     bx, dx             {     ; bx = dx     }
    shl     dx, 8
    shl     bx, 6
    add     dx, bx              {    ; dx = dx + bx (ie y*320)   }
    add     di, dx               {   ; finalise location}
 
    mov     si,word ptr [origen]
    mov     ax,[tx]
    mov     bx,cx
    dec     bx
    mul     bx
    add     si,ax

    add     di, word ptr [lugar]{+sy*320}
    mov     ax,320
    mov     bx,cx
    dec     bx
    mul     bx
    add     di,ax
    add     di,tamax
    push cx
       mov cx,[tx]
 @otro2:cmp byte ptr ds:[si],0
        je  @transp
        mov dl,[si]
        mov es:[di],dl
        inc si
        dec di

        jmp @siguiente
@transp:inc si  {Pasamos de el por ser transparente}
        dec di
@siguiente:loop @otro2


    pop  cx
    loop @otro

    pop ds
 @fin:
 End;



{---------------------------------------------------------------------------}
Procedure Rayo;
var ax,ay,sx,sy,i,j:word;
Begin
ax:=random(320);
  ay:=0;

  for j:=1 to 2 do
  begin
    sx:=ax;
    sy:=ay;
    for i:=1 to random(43)+1 {Nivel} do
    Begin
       sx:=sx+random(3)-1;
       poner_cuadro(sx,sy+i*4,1,4,vaddr,64+random(10));

       sx:=sx+random(3)-1;
       poner_cuadro(sx,sy+i*4,1,4,vaddr,64+random(10));


    End;
    sx:=ax;
    sy:=ay;
    
    for i:=1 to random(43)+1 {Nivel} do
    Begin
       sx:=sx+random(3)-1;
       poner_cuadro(sx,sy+i*4,1,4,vaddr,64+random(10));

       sx:=sx+random(3)-1;
       poner_cuadro(sx,sy+i*4,1,4,vaddr,64+random(10));

       
    End;
   end;
end;
{--------------------------------------------------------------------------}
procedure ACTUALIZA; { //... Actualiza la pantalla }

var
sx,sy:integer;
conta,conta2:word;
color:byte;
grafaux:grafico;
origen:longint;
suceso:byte;

procedure  Evaluar_interacciones;
var i,j:byte;
    ax,ay:word;
begin

 suceso:=RANDOM(20);
 while posiciones[1].x<x do
       if random(2)=0 then inc(posiciones[1].x) else dec(x);

                             {No se tocan}
                        {-------Bueno--------}

  if random(2)=1 then grafaux:=monigote        {tio normal}
  else grafaux:=monigote3;

  if (t[49]) then
      grafaux:=pata1;        {tio da patada}

  if (t[51]) then
             grafaux:=pata2 ;        {tio da patada}


  if (t[50]) then
     grafaux:=Punetazo ;        {tio da patada}

  if (((suceso=1) or (suceso=3)) and (x>posiciones[1].x-40)) then
  Begin
    grafaux:=pata2;  {Le han golpeado malo a bueno}
    vidab:=vidab-5;
  End;

  if izq then poner_sprite_inv(x,y,tamax,tamay,grafaux,vaddr)
  else
  if not(izq) then poner_sprite(x,y,tamax,tamay,grafaux,vaddr);


                        {-------Malo--------}

    CASE (RANDOM(2)) OF
     0:grafaux:=mmonigote;          {tio normal}
     1:grafaux:=mmonigote3;        {tio da puetazo}
    END;

 
    CASE suceso OF
     0:grafaux:=mmonigote3;        {anda}
     1:grafaux:=mpata1;            {protegido o ini-patada}
     2:grafaux:=mpata2;            {tio da patada}
     3:grafaux:=mpunetazo;            {tio da patada}

    END;


  if ((t[49]) or (t[50])) and ((x>posiciones[1].x-40)) and not(suceso=1) then
  begin
     vidam:=vidam-5;
     grafaux:=mpata2;  {Le han golpeado bueno a malo}
  end;


  if izq=true then
      poner_sprite(posiciones[1].x,posiciones[1].y,tamax,tamay,grafaux,vaddr)
     else
      poner_sprite_inv(posiciones[1].x,posiciones[1].y,tamax,tamay,grafaux,vaddr);

                        {Marcadores}

   poner_sprite(1,1,tamax,254 div 7,monigote,vaddr);
   poner_sprite_inv(230,1,tamax,254 div 7,mmonigote,vaddr);

   
   poner_cuadro(0,36,52,7,vaddr,54);
   poner_cuadro(1,37,vidab div 5,5,vaddr,random(255));

   poner_cuadro(268,36,52,7,vaddr,54);
   poner_cuadro(269,37,vidam div 5,5,vaddr,random(255));

                     {Efecto de lluvia}
  for i:=0 to 100 do
  Begin
    sx:=random(320);
    sy:=random(190);
    poner_cuadro(sx,sy,1,4,vaddr,255);
    poner_cuadro(sx-1,sy+4,1,4,vaddr,255);
  End;


  Rayo;              {Pone un rayo aleatorio en la pantalla}


end;
{--------------------------------------------------}


begin
  color:=7;
  if t[2] then CopFondEnVirt(fondo,vaddr,0)
    else CopFondEnVirt(fondo,vaddr,contapant);
   {posicionx,la y,tamao x, y,donde ponerlo,origen}
  contapant:=contapant+velocscrol;
  if contapant=-1 then
  begin
   contapant:=319;
   if relampa then Cls (vaddr,7);
  end;
  if (random(30)=1) and (relampa) then Cls (vaddr,7);

  Evaluar_interacciones;            {Evalua interacciones y posiciona}
 
  retrazo;
  flip (vaddr);
  {Copia pantalla virtual a pantalla real}
  
end;
{//-------------------------------------------------------------------------}

PROCEDURE INICIA;
begin
 setupvirtual;
end;
{//-------------------------------------------------------------------------}

Procedure InicializaMalos;
var i:word;
Begin
 for i:=1 to maxelem do
 begin
    posiciones[i].x:=160;
    posiciones[i].y:=80{random(30)+160};
    if random(2)=1 then posiciones[i].izq:=true
    else posiciones[i].izq:=false;
 end;
end;
{//-------------------------------------------------------------------------}
Procedure Leer_Sprite(var f:fichero;sp:grafico);
var i:word;
    ampli:word;
    tx,ty:byte;
    contax,contay:word;
Begin
        BlockRead(f,tx,1);
        BlockRead(f,ty,1);
        contay:=0;
        repeat
           inc(contay);

           if (contay<=ty+1) then
           begin
                 BlockRead(f,sp^[contay,1],tx+1);
                 for i:=tx+2 to tamax do sp^[contay,i]:=0;
           end
           else         for i:=1 to tamax do sp^[contay,i]:=0;
        until contay=tamay;

end;
{//-------------------------------------------------------------------------}
Procedure  Modificamalo(masc:byte);
            {Modifico al malo}
var i,j:word;
Begin
  for i:=1 to tamax do
    for j:=1 to tamay do if monigote^[j,i]<>0 then
     mmonigote^[j,i]:=monigote^[j,i] + masc;

  for i:=1 to tamax do
     for j:=1 to tamay do if monigote3^[j,i]<>0 then
     mmonigote3^[j,i]:=monigote3^[j,i] +  masc;

  for i:=1 to tamax do
     for j:=1 to tamay do if punetazo^[j,i]<>0 then
      mpunetazo^[j,i]:=punetazo^[j,i] + masc;

  for i:=1 to tamax do
     for j:=1 to tamay do if pata1^[j,i]<>0 then
      mpata1^[j,i]:=pata1^[j,i] + masc;

  for i:=1 to tamax do
     for j:=1 to tamay do if pata2^[j,i]<>0 then
      mpata2^[j,i]:=pata2^[j,i] + masc;
End;
{//-------------------------------------------------------------------------}
Procedure CargaGraficos;
var i,j:word;
    ampli:word;
    f:fichero;
    tx,ty:byte;
    contax,contay:word;

begin
   {  ampli:=(tamax div tamaxs); }              {Carga los graficos en monigote(i)}

     {for i:=1 to tamax do for j:=1 to tamay do Monigote^[j,i]:=graf1[((j-1) div ampli)+1,((i-1) div ampli)+1];
     for i:=1 to tamax do for j:=1 to tamay do Monigote2^[j,i]:=graf2[((j-1) div ampli)+1,((i-1) div ampli)+1];
     for i:=1 to tamax do for j:=1 to tamay do Monigote3^[j,i]:=graf3[((j-1) div ampli)+1,((i-1) div ampli)+1];}
{     for i:=1 to tamax do for j:=1 to tamay do sprihierv^[j,i]:=hierva[((j-1) div ampli)+1,((i-1) div ampli)+1];
     for i:=1 to tamax do for j:=1 to tamay do sprimuro^[j,i]:=muro[((j-1) div ampli)+1, ((i-1) div ampli)+1];}

                          {Cargar bueno}

     if FileExists('.\tio.ani') then
     begin
        assign(f,'.\tio.ani');           {Asigno la animacion}
        reset(f,1);                      {La reseteo}
        Leer_Sprite(f,monigote);         {cargo un sprite}
        Leer_Sprite(f,monigote3);        {cargo otro}
        Leer_Sprite(f,Punetazo);        {cargo el tercero}
        close(f);
      end;

     if FileExists('.\tio2.ani') then
     begin
        assign(f,'.\tio2.ani');           {Asigno la animacion}
        reset(f,1);                      {La reseteo}
        Leer_Sprite(f,pata1);         {cargo un sprite}
        Leer_Sprite(f,pata2);         {cargo otro}
        close(f);
      end;
                        {Cargar malo}

    if FileExists('.\mtio.ani') then
     begin
        assign(f,'.\mtio.ani');           {Asigno la animacion}
        reset(f,1);                      {La reseteo}
        Leer_Sprite(f,mmonigote);         {cargo un sprite}
        Leer_Sprite(f,mmonigote3);        {cargo otro}
        Leer_Sprite(f,mPunetazo);        {cargo el tercero}
        close(f);
      end;

     if FileExists('.\mtio2.ani') then
     begin
        assign(f,'.\mtio2.ani');           {Asigno la animacion}
        reset(f,1);                      {La reseteo}
        Leer_Sprite(f,mpata1);         {cargo un sprite}
        Leer_Sprite(f,mpata2);         {cargo otro}
        close(f);
      end;
      Modificamalo(masc1);

end;
{//-------------------------------------------------------------------------}
PROCEDURE MODOTEXTO;
begin
  asm
    mov ax,3
    int 10h
  end;
end;
{//-------------------------------------------------------------------------}

Var
    h0,m0,s0,c0:word;
    h1,m1,s1,c1:word;
    p:word;
    con:byte;
begin
for i:=0 to 255 do t[i]:=false; {Ini teclas}
setvga256;
inicia;
Cargar_dibujo('.\vga-000.scr');  {carga una pantalla 320x200 scr en memoria}

izq:=false;       {flag mirando a izq}
posiciones[1].izq:=true;
x:=0;             {x,y del bueno}
y:=80;
vidab:=254;
vidam:=254;
contapant:=319;
InicializaMalos; {Da posiciones aleatorias a los malos}
CargaGraficos;   {a las variables monigote}
con:=0;
repeat
     tecla;

             {Movemos el bueno}
      if t[25] then
      begin
        x:=x+incre;
      end;

      if t[24] then
      begin
        x:=x-incre;
      end;
              {Compruebo que este en la pantalla}

{     if y>199-tamay then y:=199-tamay;}
     if x>319-tamax then x:=319-tamax;
{     if y<0 then y:=0;                  }
     if x<0 then x:=0;

               {Igual con los malos}
     for i:=1 to maxelem do
      begin
         if posiciones[i].x>305-tamax then posiciones[i].x:=305-tamax;
         if posiciones[i].x<5 then posiciones[i].x:=5;
         posiciones[i].x:=posiciones[i].x+(random(incre*2+1)-(incre));
         if random(2)=1 then dec(posiciones[i].x);
      end;


      {Vemos el numero de fotogramas}
     
     actualiza;

    if t[25] and t[24] then
    begin
      t[25]:=false;
      t[24]:=false;
    end;

    {for p:=1 to 768 do if (p mod 3)=0 then colores^[p]:=colores^[p]+1;
    setregisters;}{Efecto de modificacion de los colores de la paleta}
    if t[23] then
    begin
       inc(con);
       modificamalo(con);
    end;
    if t[22] then
    begin
       dec(con);
       modificamalo(con);
    end;
until t[1] or (vidam<10) or (vidab<10);

shutdown;                         {Libera memoria}
modotexto;
writeln('--------Juan Jos Ruiz Rajas-------');
writeln('      * -----Alias--Titan----- *');
writeln('--------Virtual--------Zone--------');
end.
