

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

// ==== Additional Includes ====
#include "CHARS.INC"   // FIXME-add comments describing each of these
#include "CONSTS.INC"
#include "METALS.INC"
#include "SHAPES.INC"
#include "SHAPES2.INC"
#include "SHAPESQ.INC"
#include "SKIES.INC"
#include "STONES.INC"
#include "STONEold.INC"
#include "STONES2.INC"
#include "WOODMAPS.INC"
#include "WOODS.INC"
#include "GOLDS.INC"
#include "textures.inc"
camera{
       location //<0, 5, 0>
				<0.5, 0.9, -4>
				//<0, -1.5, -2>
				
	   look_at<0, -.5, 0>
}
light_source{<100,150,-200> color red 1 blue 1 green 1}
sky_sphere {
	   	pigment { //Blue }
         gradient y
        pigment_map {
            [0.01 Pink ] // horizon
            [0.40 red .7]
            [0.60 Pink]
        }}
}

/*********************************************************************/
#declare Lata=union{
	cylinder{
		-1*y,  1.5*y,  1.2
		open
		texture{
			pigment{ Red
				/*******************
				image_map { tga "rotulo.tga" map_type 2 }
				scale <2.5,2.5,2.5>
				translate -1*y
				rotate 90*y
				*******************/
			}
		}
	}
	torus{	1.15, 0.05 translate 1.5*y }
	cone{
  		(1.54)*y,  1.18,
  		1.7*y,     1
		open
	}
	intersection{
		difference{
			torus{	1.05 , 0.05 }
			torus{	1.05 , 0.04999}
		}
		plane{ y 0}
		cylinder{ -.05*y, 2*y, 1.017 open}
		translate 1.72244*y
	}
	cylinder{ 1.7*y, 1.85*y,  1	open }
/**********************
	torus{ 1, 0.03
		scale <1, 3, 1>
		translate 1.85*y
	}
************************/
	union{
		torus{ 1, 0.035 translate 0.05*y }
		torus{ 1, 0.035 translate -0.05*y }
		cylinder{ 0.05*y, -0.05*y, 1.035 open}
		cylinder{ 0.05*y, -0.2*y, 1-0.035 open}
		intersection{
			difference{
				torus{ .96, .04 }
				torus{ .96, .03999 }
			}
			plane{ y 0 }
			translate -0.2*y
		}
		cone{
  			-0.2*y,  .92,
  			-0.1*y,  .87
			open
		}
		torus{ .83, .04 translate -0.1*y}
		difference{
			disc
			{
				<0, -0.055, 0>  // center position
				y,         // normal vector
				.83,       // outer radius
			}
			disc
			{
				<0, -0.06, 0>  // center position
				y,         // normal vector
				.83,       // outer radius
			}
			cylinder{ <0.35, 1, 0>, <.35, -1, 0>, .25}
			cylinder{ <0.1, 1, 0>, <.1, -1, 0>, .13 scale <1.7, 0, 1.4>}
		}
		translate 1.85*y
	}
/******************************************/
	torus{ 1.15, 0.05 translate -1*y}


	texture{ T_Brass_5E
			//pigment { Red }
	}
	rotate 225*y
}
object{ Lata 
	rotate 130*y
	rotate -90*z
	rotate 45*y
}
plane{ -y 1.2
	texture{
		pigment{ Blue}
		finish{ reflection 0.3 } 
	}
}
#declare StrengthVal = 1.0 
#declare RadiusVal   = 1.0 
blob
{
  threshold 0.6
  sphere { <-0.7, 0.7, 0>, StrengthVal, RadiusVal }
  sphere { <-0.7, -0.7, 0>, StrengthVal, RadiusVal }
  sphere { <0.7, 0.7, 0>, StrengthVal, RadiusVal }
  sphere { <.5, 0, 0>, StrengthVal, RadiusVal }
  sphere { <0, .8, 0>, StrengthVal, RadiusVal }
  sphere { <-1, 0, 0>, StrengthVal, RadiusVal }
  sphere { <0, 1, 0>, StrengthVal, RadiusVal }
  sphere { <0, -1, 0>, StrengthVal, RadiusVal }
  sphere { <.3, -.5, 0>, StrengthVal, RadiusVal }
  sphere { <-1, 1.3, 0>, StrengthVal, RadiusVal }

	rotate 90*x
	scale <2, .4, 2>
texture {
    pigment{ color  red .5 blue .1 transmit .4} 
    normal {
        ripples 0.75
        frequency 10
    }
    finish {
        reflection 0.3
        refraction 0.5
        ior 1.33
    }
}
	translate -1.1*y  
	translate <1.5, 0, .30>
}
